/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticalVersionInfo","./BatchResponseCollector","./odata4analytics","sap/base/Log","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/TreeAutoExpandMode","sap/ui/model/TreeBinding","sap/ui/model/odata/CountMode","sap/ui/model/odata/ODataUtils"],function(A,B,a,L,d,b,c,f,u,C,F,t,v,w,S,T,x,y,O){"use strict";var D="sap.ui.model.analytics.AnalyticalBinding",I=0,E=L.getLogger(D);function G(o){var e,g,s,h,i,j,m,n,p,k=new a.QueryResultRequest(o.oAnalyticalQueryResult),l=o.mParameters.select.split(","),q=J(l,o.sPath);k.setAggregationLevel(o.aMaxAggregationLevel);k.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(r){h=o.oDimensionDetailsSet[r];k.includeDimensionKeyTextAttributes(r,true,h.textPropertyName!==undefined,h.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(r){m=o.oMeasureDetailsSet[r];k.includeMeasureRawFormattedValueUnit(r,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=k.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=l.indexOf(p);if(j<0){e=o.mAnalyticalInfoByProperty[p];if(!e||(!e.visible&&!e.inResult)){continue;}E.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath);q=true;}else{l.splice(j,1);}}}for(i=0,n=l.length;i<n;i++){p=l[i];h=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(h&&o.oDimensionDetailsSet[h.getName()]===undefined){H(o.sPath,p,h);q=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){H(o.sPath,p,m);q=true;}}return q?[]:l;}function H(p,s,o){var e=o instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(o.getName()===s){E.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p);}else{E.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+o.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p);}}function J(s,p){var e,g=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){E.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p);s.splice(i,1);g=true;}}return g;}var K=x.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){x.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;I+=1;this._iId=I;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==y.None){E.fatal("requested count mode is ignored; OData requests will include"+" $inlinecount options");}else if(P&&(P.countMode==y.Request||P.countMode==y.Both)){E.warning("default count mode is ignored; OData requests will include"+" $inlinecount options");}else if(this.oModel.sDefaultCountMode==y.Request){E.warning("default count mode is ignored; OData requests will include"+" $inlinecount options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){E.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});function M(o,e){return function(){if(!o.__supportUID){o.__supportUID=u();}return{type:D,analyticalError:e,analyticalBindingId:o.__supportUID};};}K.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();r=this.getResolvedPath();if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};K.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};K.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};K.prototype.getRootContexts=function(p,l,n,i){if(typeof p!=="object"){p={length:l,numberOfExpandedLevels:n,startIndex:p,threshold:i};}if(this.isInitial()){return[];}var e=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(K._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(e<=1){if(e==1){this._considerRequestGrouping([R,this._getRequestId(K._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var g=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);g.push(R);this._considerRequestGrouping(g);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){E.fatal("assertion failed: grand total represented by a single entry");}return r;};K.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,e,n,g;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;e=p.level;n=p.numberOfExpandedLevels;g=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];e=arguments[4];n=arguments[5];g=arguments[6];}var h=this._getContextsForParentContext(o,s,l,i,e,n,g);return h;};K.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};K.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return K.prototype.ContextsAvailabilityStatus.ALL;}else{return K.prototype.ContextsAvailabilityStatus.SOME;}}else{return K.prototype.ContextsAvailabilityStatus.NONE;}};K.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};K.prototype.getCount=function(){return this.iTotalSize>=0?this.iTotalSize:undefined;};K.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){E.fatal("total size of result explicitly turned off, but getter invoked");}return this.iTotalSize;};K.prototype.hasChildren=function(o,p){p=p||{level:1};if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1;};K.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};K.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};K.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};K.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};K.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};K.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};K.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};K.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};K.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};K.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};K.prototype.isMeasure=function(p){return this.aMeasureName&&this.aMeasureName.indexOf(p)!==-1;};K.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==w.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};K.prototype.getFilterInfo=function(i){var o=v.combineFilters(this.aControlFilter,this.aApplicationFilter);if(o){return o.getAST(i);}return null;};K.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};K.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],e=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),s,h,i,j,k,m,n,q;if(e&&this.oDimensionDetailsSet[g].textPropertyName){k=e.getTextProperty();}if(k){m=k.name;q=this.mAnalyticalInfoByProperty[m]&&this.mAnalyticalInfoByProperty[m].formatter;n=o.getProperty(m);s=V?V(p,n):p;h=q?q(n,p):n;}else{s=V?V(p):p;}j=e.getLabelText&&e.getLabelText();i=(j?j+': ':'')+s;if(h){i+=' - '+h;}return i;};K.prototype.updateAnalyticalInfo=function(e,g){var h,o,k,l,m=this;function n(W){var X=W.level,Y=W.name;l=l||k.getAllHierarchyPropertyNames();l.forEach(function(Z){var $=m.oAnalyticalQueryResult.findDimensionByPropertyName(Z).getHierarchy(),_=null,a1=$.getNodeIDProperty().name,b1;if(a1===Y){_=p($);}else{b1=$.getNodeExternalKeyProperty();if(b1&&b1.name===Y){_=p($);_.nodeExternalKeyName=Y;}else{b1=k.getTextPropertyOfProperty(a1);if(b1&&b1.name===Y){_=p($);_.nodeTextName=Y;}}}if(_&&"level"in W){if(typeof X==="number"){if("level"in _&&_.level!==X){throw new Error("Multiple different level filter for hierarchy '"+a1+"' defined");}_.level=X;_.grouped=!!W.grouped;}else{throw new Error("The level of '"+a1+"' has to be an integer value");}}});}function p(W){var X=W.getNodeIDProperty().name,Y,Z=m.mHierarchyDetailsByName[X];if(!Z){Y=W.getNodeLevelProperty();Z={dimensionName:W.getNodeValueProperty().name,nodeIDName:X,nodeLevelName:Y&&Y.name};m.mHierarchyDetailsByName[X]=Z;}return Z;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}h=a.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(W){m.mAnalyticalInfoByProperty[W.name].formatter=W.formatter;});if(h){this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=c({},e[j]);}}if(h<2){if(g||h){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}var P=this.oDimensionDetailsSet||{},q=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};k=this.oAnalyticalQueryResult.getEntityType();for(var i=0;i<e.length;i++){var r=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(r&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=r.getName();o=this.oDimensionDetailsSet[r.getName()];if(!o){o={};o.name=r.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[r.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(r.getName())==-1){E.fatal("property "+r.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(r.getName()==e[i].name){o.keyPropertyName=e[i].name;}var s=r.getTextProperty();if(s&&s.name==e[i].name){o.textPropertyName=e[i].name;}if(r.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var z=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(z&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=z.getName();var N=this.oMeasureDetailsSet[z.getName()];if(!N){N={};N.name=z.getName();this.oMeasureDetailsSet[z.getName()]=N;this.aMeasureName.push(N.name);}if(z.getRawValueProperty().name==e[i].name){N.rawValuePropertyName=e[i].name;}var Q=z.getFormattedValueProperty();if(Q&&Q.name==e[i].name){N.formattedValuePropertyName=e[i].name;}N.analyticalInfo=e[i];}if(!r&&!z){n(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(W){var X=m.mHierarchyDetailsByName[W];if(!("level"in X)){delete m.mHierarchyDetailsByName[W];if(E.isLoggable(L.Level.INFO)){E.info("No level specified for hierarchy node '"+W+"'; ignoring hierarchy","");}}else if(!m.oDimensionDetailsSet[W]){m.oDimensionDetailsSet[W]={aAttributeName:[],grouped:X.grouped,isHierarchyDimension:true,name:W};m.aMaxAggregationLevel.push(W);if(X.grouped){m.aAggregationLevel.push(W);}}});for(var R in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(R).getUnitProperty();if(U){this.oMeasureDetailsSet[R].unitPropertyName=U.name;}}var V=Object.keys(P).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(V){this.iTotalSize=-1;}if(V||Object.keys(q).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=G(this);}if(g){this._fireChange({reason:C.Change});}};K.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};K.prototype.loadGroups=function(g){var e=[];for(var s in g){e.push(s);this._resetData(s);var h=g[s];for(var i=0;i<h.length;i++){var o=h[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,k;(k=e[++j])!==undefined;){r.push(this._getRequestId(K._requestType.groupMembersQuery,{groupId:k}));}this._considerRequestGrouping(r);}};K.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};K._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};K._artificialRootContextGroupId="artificialRootContext";K._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,t.EQ,g.level);});};K.prototype._getContextsForParentContext=function(p,s,l,i,e,n,g){if(p===undefined){return[];}if(p&&p.getPath()=="/"+K._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,e);return this._getContextsForParentGroupId(P,s,l,i,n,g);};K.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){E.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){E.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){E.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],k,o,m,q;var r=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[r]){this.aMultiUnitLoadFactor[r]=1;}var z=n>0&&p!=null;if(z){var N=this._getGroupIdLevel(p);var P=N+n;var Q=true;if(!g){m=this._calculateRequiredGroupExpansion(p,P,s,l+e);Q=m.groupId_Missing==null;Q=Q||m.groupId_Missing.length<p.length||m.groupId_Missing.substring(0,p.length)!=p;}if(Q){h=this._getLoadedContextsForGroup(p,s,l);}else{q=l+e;}k=!Q;q=Math.ceil(q*this.aMultiUnitLoadFactor[r]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);k=false;if(!g){if(this._oWatermark&&p===this._oWatermark.groupID){e=10000;}o=this._calculateRequiredGroupSection(p,s,l,e);var R=o.length>0&&l<o.length;k=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||R;o.length=Math.ceil(o.length*this.aMultiUnitLoadFactor[r]);}}if(!k){this._cleanupGroupingForCompletedRequest(this._getRequestId(K._requestType.groupMembersQuery,{groupId:p}));}var U=false;if(this.oModel.getServiceMetadata()){if(k){var V=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(K._requestType.totalSizeQuery));U=true;var W;if(this.bUseBatchRequests){if(z){W=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,X;(X=W[++i])!==undefined;){if(this._isRequestPending(X)){U=false;break;}}if(U){this.aBatchRequestQueue.push([K._requestType.groupMembersAutoExpansionQuery,p,m,q,n]);}}else{U=o.length&&!this._isRequestPending(this._getRequestId(K._requestType.groupMembersQuery,{groupId:p}));if(U){this.aBatchRequestQueue.push([K._requestType.groupMembersQuery,p,o.startIndex,o.length]);W=[this._getRequestId(K._requestType.groupMembersQuery,{groupId:p})];}}if(U&&V){W.push(this._getRequestId(K._requestType.totalSizeQuery));this._considerRequestGrouping(W);this.aBatchRequestQueue.push([K._requestType.totalSizeQuery]);}if(U){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(K.prototype._processRequestQueue.bind(this));}}else{var Y;if(z){W=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,Z;(Z=W[++j])!==undefined;){if(this._isRequestPending(Z)){U=false;break;}}if(U){Y=this._prepareGroupMembersAutoExpansionQueryRequest(K._requestType.groupMembersAutoExpansionQuery,p,m,q,n);}}else{U=o.length&&!this._isRequestPending(this._getRequestId(K._requestType.groupMembersQuery,{groupId:p}));if(U){Y=this._prepareGroupMembersQueryRequest(K._requestType.groupMembersQuery,p,o.startIndex,o.length);W=[Y.sRequestId];}}if(U){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(Y);if(V&&!Y.bIsFlatListRequest){W.push(this._getRequestId(K._requestType.totalSizeQuery));this._considerRequestGrouping(W);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(K._requestType.totalSizeQuery));}}}}}return h;};K.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,e=[],i=this;if(g===null){return e;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){E.error("Hierarchy cannot be requested for members of a group",g);return e;}h.forEach(function(s){var j=i.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(j.dimensionName,!!j.nodeExternalKeyName,!!j.nodeTextName);e.push({propertyName:j.nodeLevelName,level:j.level});});return e;};K.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(s){return!g.oDimensionDetailsSet[s].isHierarchyDimension;});};K.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==K._requestType.groupMembersQuery){o=K.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case K._requestType.groupMembersQuery:continue;case K._requestType.totalSizeQuery:if(!e){o=K.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case K._requestType.groupMembersAutoExpansionQuery:o=K.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case K._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:E.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};K.prototype._prepareGroupMembersQueryRequest=function(r,g,s,e){var h=[],m=[],o;var p=new a.QueryResultRequest(this.oAnalyticalQueryResult);p.setResourcePath(this._getResourcePath());p.getSortExpression().clear();var q=0,z=-1;if(g){h=this._getGroupIdComponents(g);q=z=h.length;var U=0;for(var j=0,N=0;j<q;N++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[N]].grouped==false){++U;}else{++j;}}q=z=q+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[z]].grouped==false){if(++z==this.aMaxAggregationLevel.length){break;}}}}var P=z>=this.aMaxAggregationLevel.length-1;o=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(p,g);var Q=this.aMaxAggregationLevel.slice(0,z+1);var R=this._getNonHierarchyDimensions(Q);p.setAggregationLevel(R);for(var i=0;i<R.length;i++){var V=this.oDimensionDetailsSet[R[i]];var W=(V.textPropertyName!=undefined);p.includeDimensionKeyTextAttributes(V.name,true,W,V.aAttributeName);if(V.grouped){m.push({sPath:R[i],bDescending:false});}}var X=p.getFilterExpression();X.clear();if(this.aApplicationFilter){X.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){X.addUI5FilterConditions(this.aControlFilter);}if(q>=1){for(var k=0,l=h.length;k<l;k++){X.removeConditions(this.aAggregationLevel[k]);X.addCondition(this.aAggregationLevel[k],t.EQ,h[k]);}}K._addHierarchyLevelFilters(o,X);var Y;var Z;var $;var _;var a1=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){p.setMeasures(this.aMeasureName);for(var b1 in this.oMeasureDetailsSet){_=this.oMeasureDetailsSet[b1];if(!P&&this._isSkippingTotalForMeasure(b1)){Y=false;Z=false;$=false;}else{Y=(_.rawValuePropertyName!=undefined);Z=(_.formattedValuePropertyName!=undefined);$=(_.unitPropertyName!=undefined);if($){if(a1.indexOf(_.unitPropertyName)==-1){a1.push(_.unitPropertyName);}}}p.includeMeasureRawFormattedValueUnit(_.name,Y,Z,$);}for(var n in R){var c1;if((c1=a1.indexOf(R[n]))!=-1){a1.splice(c1,1);}}}if(g){this._addSorters(p.getSortExpression(),m);}if(e==0){E.fatal("unhandled case: load 0 entities of sub group");}var d1=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){p.setResultPageBoundaries(d1.iServiceKeyIndex+1,d1.iServiceKeyIndex+e);}p.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(K._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:p,sGroupId:g,aSelectedUnitPropertyName:a1,aAggregationLevel:Q,bIsFlatListRequest:P&&q==0,bIsLeafGroupsRequest:P,iStartIndex:s,iLength:e,oKeyIndexMapping:d1};};K.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}K._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(K._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};K.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,o,e,n){var h=this;var p=function(o,s){var P=[];if(o.groupId_Missing==null){E.fatal("missing group Id not present");return P;}var z=h._getGroupIdComponents(o.groupId_Missing);var N=z.length;if(N>s){E.fatal("the given group ID is too deep for requested level for auto expansion");return P;}var k=[];for(var i=0;i<N;i++){var l=h.aAggregationLevel[i];var b1=z[i];var c1=h._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,c1,b1);}var d1=null;if(o.startIndex_Missing>0){var e1=h._getKey(o.groupId_Missing,o.startIndex_Missing-1);var f1=h.oModel.getObject("/"+e1);var g1=h.aAggregationLevel[N];var h1=f1[g1];d1=new F(g1,h._getFilterOperatorMatchingPropertySortOrder(g1,false),h1);}for(var U=0;U<s;U++){var i1=[];var j1=Math.min(N,U+1);for(var k1=0;k1<j1;k1++){var l1=[];var m1=Math.min(N,k1+1);var n1=o.startIndex_Missing>0;for(var o1=0;o1<m1;o1++){var p1=new F("x",t.EQ,"x");p1=d(p1,k[o1]);if(m1>1&&o1<m1-1){p1.sOperator=t.EQ;}if(o1==N-1&&U>N-1&&!n1){if(p1.sOperator==t.GT){p1.sOperator=t.GE;}else{p1.sOperator=t.LE;}}l1.push(p1);}if(l1.length>0){i1.push(new F(l1,true));if(U>N-1&&k1==N-1&&n1){var q1=[];for(var j=0;j<l1.length;j++){var r1=new F("x",t.EQ,"x");r1=d(r1,l1[j]);q1.push(r1);}q1[N-1].sOperator=t.EQ;q1.push(d1);i1.push(new F(q1,true));break;}}}if(i1.length>0){P[U]=new F(i1,false);}else{P[U]=null;}}return P;};var m=function(r,g,U,b1,V,e,c1,d1){var e1;var f1=new a.QueryResultRequest(h.oAnalyticalQueryResult);f1.setResourcePath(h._getResourcePath());f1.getSortExpression().clear();var g1=0,h1=-1;g1=h1=U-1;var i1=0;for(var i=0,j1=0;i<g1;j1++){if(h.oDimensionDetailsSet[h.aMaxAggregationLevel[j1]].grouped==false){++i1;}else{++i;}}g1=h1=g1+i1;if(h.aMaxAggregationLevel.length>0){while(h.aMaxAggregationLevel[h1]&&h.oDimensionDetailsSet[h.aMaxAggregationLevel[h1]].grouped==false){if(++h1==h.aMaxAggregationLevel.length){break;}}}var k1=h1>=h.aMaxAggregationLevel.length-1;e1=h._getHierarchyLevelFiltersAndAddRecursiveHierarchy(f1,g);var l1=h.aMaxAggregationLevel.slice(0,h1+1);f1.setAggregationLevel(l1);for(var l=0;l<l1.length;l++){var m1=h.oDimensionDetailsSet[l1[l]];var n1=(m1.textPropertyName!=undefined);f1.includeDimensionKeyTextAttributes(m1.name,true,n1,m1.aAttributeName);if(m1.grouped){f1.getSortExpression().addSorter(l1[l],a.SortOrder.Ascending);}}var o1=f1.getFilterExpression();o1.clear();if(h.aApplicationFilter){o1.addUI5FilterConditions(h.aApplicationFilter);}if(h.aControlFilter){o1.addUI5FilterConditions(h.aControlFilter);}if(b1){o1.addUI5FilterConditions([b1]);}K._addHierarchyLevelFilters(e1,o1);var p1;var q1;var r1;var s1;var t1=[];f1.setMeasures(h.aMeasureName);for(var u1 in h.oMeasureDetailsSet){s1=h.oMeasureDetailsSet[u1];if(!k1&&h._isSkippingTotalForMeasure(u1)){p1=false;q1=false;r1=false;}else{p1=(s1.rawValuePropertyName!=undefined);q1=(s1.formattedValuePropertyName!=undefined);r1=(s1.unitPropertyName!=undefined);if(r1){if(t1.indexOf(s1.unitPropertyName)==-1){t1.push(s1.unitPropertyName);}}}f1.includeMeasureRawFormattedValueUnit(s1.name,p1,q1,r1);}for(var j in l1){var v1;if((v1=t1.indexOf(l1[j]))!=-1){t1.splice(v1,1);}}var w1=f1.getSortExpression();for(var k=0;k<h.aSorter.length;k++){if(h.aSorter[k]){w1.addSorter(h.aSorter[k].sPath,h.aSorter[k].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);}}if(e==0){E.fatal("unhandled case: load 0 entities of sub group");}var x1=V;if(!d1){x1=0;}else{var y1=0;for(var z1 in h.mServiceKey){if(z1.split("/").length===U+1){y1+=h.mServiceKey[z1].length;}}x1=Math.max(x1,y1);}if(!h.bNoPaging){f1.setResultPageBoundaries(x1+1,x1+e);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:f1,iLevel:U,aSelectedUnitPropertyName:t1,aAggregationLevel:l1,bIsFlatListRequest:k1,bIsLeafGroupsRequest:k1,iStartIndex:V,iLength:e,bAvoidLengthUpdate:c1};};var q=[];var R=[];if(!o){E.fatal("no first missing group member specified");}var s=this._getGroupIdLevel(g)+n+1;var z=h._getGroupIdComponents(o.groupId_Missing);var N=z.length;var P=p(o,s);var Q;for(var U=1;U<=s;U++){var V;if(U>=N+2){V=0;Q=undefined;}else if(U==N+1){V=o.startIndex_Missing;Q=o.groupId_Missing;}else if(N>0){if(U==N){Q=o.groupId_Missing;}else{Q=this._getGroupIdAncestors(o.groupId_Missing,-(N-U))[0];}var W=this._getGroupIdAncestors(o.groupId_Missing,-(N-U+1))[0];if(!W){E.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+U);}V=this._findKeyIndex(W,this.mEntityKey[Q]);if(V==-1){E.fatal("failed to determine position of value "+Q+" in group "+W);}Q=W;V++;}var X=e>U?Math.ceil((e-U)/(s-U+1)):e;var Y=P[U-1];if(this.bUseAcceleratedAutoExpand){var Z=m(K._requestType.levelMembersQuery,g,U,Y,V,X,false,Y==null?true:false);Z.sGroupId_Missing_AtLevel=Q;Z.sRequestId=this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:U});q.push(Z);R.push(Z.sRequestId);}else if(Y&&Y.aFilters.length>0){if(!Y._bMultiFilter||Y.bAnd){E.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<Y.aFilters.length;i++){var $=Y.aFilters[i];var _=m(K._requestType.levelMembersQuery,g,U,$,V,X,false,Y==null?true:false);_.sGroupId_Missing_AtLevel=Q;_.sRequestId=this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:U,tupleIndex:i});q.push(_);R.push(_.sRequestId);}}else{var a1=m(K._requestType.levelMembersQuery,g,U,null,V,X,false,Y==null?true:false);a1.sGroupId_Missing_AtLevel=Q;a1.sRequestId=this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:U});q.push(a1);R.push(a1.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:q,sGroupId:g,iLength:e};};K.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var h=g.bIsLeafGroupsRequest;var k=o.getFilterExpression();k.clear();if(this.aApplicationFilter){k.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){k.addUI5FilterConditions(this.aControlFilter);}var l=[];for(var i=0;i<e.length;i++){var n=new F(e[i],t.EQ,m.oEntry[e[i]]);l.push(n);}k.addUI5FilterConditions(l);var p;var q;var s;var z;var N=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var P in this.oMeasureDetailsSet){z=this.oMeasureDetailsSet[P];if(!m.aReloadMeasurePropertyName||m.aReloadMeasurePropertyName.indexOf(z.name)==-1){continue;}if(!h&&this._isSkippingTotalForMeasure(P)){p=false;q=false;s=false;}else{p=(z.rawValuePropertyName!=undefined);q=(z.formattedValuePropertyName!=undefined);s=(z.unitPropertyName!=undefined);if(s){if(N.indexOf(z.unitPropertyName)==-1){N.push(z.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(z.name,p,q,s);}for(var j in e){var Q;if((Q=N.indexOf(e[j]))!=-1){N.splice(Q,1);}}return{iRequestType:r,sRequestId:this._getRequestId(K._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:N,aAggregationLevel:e,oMultiUnitRepresentative:m};};K.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(K._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};K.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){E.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var j=o.getURIQueryOptionValue("$orderby");var k=o.getURIQueryOptionValue("$skip");var l=o.getURIQueryOptionValue("$top");var m=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(j!==null){P.push("$orderby="+j);}if(k!==null){P.push("$skip="+k);}if(l!==null){P.push("$top="+l);}if(m!==null){P.push("$inlinecount="+m);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};K.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],l=[];function m(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function n(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var p=0;p<r.length;p++){var q=r[p];if(q.aAggregationLevel&&q.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,z;(z=r[++i])!==undefined;){var N=z.oAnalyticalQueryRequest,P=z.sGroupId;if(N.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});P=null;this.mServiceLength[P]=this.mLength[P]=1;this.mServiceFinalLength[P]=true;this._setServiceKey(this._getKeyIndexMapping(P,0),K._artificialRootContextGroupId);setTimeout(m);this.bArtificalRootContext=true;continue;}var Q=N.getURIToQueryResultEntries();if(!this.oContext&&Q[0]!=="/"){Q="/"+Q;}if(!this._isRequestPending(z.sRequestId)){this._registerNewRequest(z.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(Q.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(N,z.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var V=this.oModel.read(Q.replace(/\ /g,"%20"),{success:s,error:n,context:this.oContext,urlParameters:U});h.push(V);}l.push(z);}}if(h.length>0){E.debug("AnalyticalBinding: executing batch request with "+l.length+" operations");var W;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);W=this.oModel.submitBatch(X,Y,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{W={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:l,binding:this,success:X,error:Y});}this._registerNewRequestHandle(R,W);}function X(Z,$){g._deregisterHandleOfCompletedRequest(R);if(l.length!=Z.__batchResponses.length){E.fatal("assertion failed: received "+Z.__batchResponses.length+" responses for "+l.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<l.length;j++){var _=l[j].sRequestId;if(_!==undefined){g._deregisterCompletedRequest(_);g._cleanupGroupingForCompletedRequest(_);}}g.fireDataReceived({data:[]});return;}var a1=0;for(var k=0;k<Z.__batchResponses.length;k++){if(Z.__batchResponses[k].data!=undefined){if(Z.__batchResponses[k].data.results.length==0){a1++;}switch(l[k].iRequestType){case K._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(l[k],Z.__batchResponses[k].data);break;case K._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(l[k],Z.__batchResponses[k].data);break;case K._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(l[k],Z.__batchResponses[k].data);break;case K._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(l[k],Z.__batchResponses[k].data);break;default:E.fatal("invalid request type "+l[k].iRequestType);continue;}}g._deregisterCompletedRequest(l[k].sRequestId);g._cleanupGroupingForCompletedRequest(l[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(a1==Z.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var b1=true;var c1;g.fireDataReceived({data:Z});var d1={};if(g.iModelVersion===A.V1){c1=g.oModel._getBatchErrors(Z);if(c1.length>0){b1=false;d1=g.oModel._handleError(c1[0]);}g.oModel.fireRequestCompleted({url:$.requestUri,type:"POST",async:true,info:"",infoObject:{},success:b1,errorobject:b1?{}:d1});if(b1){g.oModel.checkUpdate();}}}function Y(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,Z;(Z=l[++j])!==undefined;){g._deregisterCompletedRequest(Z.sRequestId);g._cleanupGroupingForCompletedRequest(Z.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var $=k;if(g.iModelVersion===A.V1){$=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:$});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed($);}g.fireDataReceived();}};K.prototype._executeQueryRequest=function(r){if(r.iRequestType==K._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,s=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});s=null;this.mServiceLength[s]=this.mLength[s]=1;this.mServiceFinalLength[s]=true;this._setServiceKey(this._getKeyIndexMapping(s,0),K._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}E.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,l,n,false,U,m);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p.replace(/ /g,"%20"),{success:l,error:n,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function l(q){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case K._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,q);break;case K._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,q);break;case K._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,q);break;case K._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,q);break;default:E.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){m(q);}}function m(q){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:q});}}function n(q){if(q&&q.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};K.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};K.prototype._processGroupMembersQueryResponse=function(R,e){var s,n=R.sGroupId,z=this.aSorter.length>0,N=R.aSelectedUnitPropertyName,P=R.aAggregationLevel,Q=R.oKeyIndexMapping.iIndex,U=R.oKeyIndexMapping.iServiceKeyIndex,V=R.iLength,W=R.oKeyIndexMapping,X=n==null?0:this._getGroupIdLevel(n)+1,Y=(N.length>0),Z,$,_,a1=0,b1,c1,d1=[];var e1=e.results.length;if(n===null&&e1>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(z?"binding is refreshed":undefined);if(z){setTimeout(this.refresh.bind(this),0);return;}}var f1=this._getServiceKeys(n,W.iIndex-1);Z=undefined;if(f1&&f1.length>0){for(var i=0,g1=f1.length;i<g1;i++){e.results[i-g1]=this.oModel.getObject("/"+f1[i]);}var h1=e.results[-f1.length];Z="";for(var j=0;j<P.length;j++){Z+=h1[P[j]]+"|";}}b1=f1&&f1.length==1;for(var h=0;h<e1;h++){var i1=e.results[h];if(Y){$="";for(var g=0;g<P.length;g++){$+=i1[P[g]]+"|";}if(Z==$){this._warnNoSortingOfGroups();if(_===undefined){if(h==0){_=-f1.length;W.iServiceKeyIndex-=f1.length-1;}else{_=h-1;}}var j1=-1,k1=e.results[h-1];for(var k=0;k<N.length;k++){if(k1[N[k]]!=i1[N[k]]){j1=k;break;}}if(j1==-1){E.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,M(this,"NO_DEVIATING_UNITS"));}}if((Z!=$||h==e1-1)&&_!==undefined){var l1=[];for(var l=_;l<h;l++){l1.push(e.results[l]);}if(Z==$){l1.push(e.results[h]);}var m1=[];for(var m=0;m<N.length;m++){var n1=N[m];for(var o=1;o<l1.length;o++){if(l1[o-1][n1]!=l1[o][n1]){m1.push(n1);break;}}}var o1=this._createMultiUnitRepresentativeEntry(n,e.results[_],N,m1,R.bIsFlatListRequest);if(o1.aReloadMeasurePropertyName.length>0){c1=this._prepareReloadMeasurePropertiesQueryRequest(K._requestType.reloadMeasuresQuery,R,o1);if(c1.oAnalyticalQueryRequest&&c1.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){d1.push(c1);}}var p1=this._setAdjacentMultiUnitKeys(W,o1,l1);var q1;if(o1.bIsNewEntry){q1=l1.length-1;}else{q1=p1;}if(b1){b1=false;}if(q1<0){E.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}a1+=q1;var r1=this.oModel._getKey(o1.oEntry);var s1=this.oModel.getContext('/'+r1);this._getGroupIdFromContext(s1,X);this.mEntityKey[s]=r1;_=undefined;if(Z!=$){b1=this._setServiceKey(W,this.oModel._getKey(i1));}}else if(Z!=$){b1=this._setServiceKey(W,this.oModel._getKey(i1));}Z=$;}else{this._setServiceKey(W,this.oModel._getKey(i1));}if(!R.bIsLeafGroupsRequest){var t1=this._getKey(n,W.iIndex-1);s=this._getGroupIdFromContext(this.oModel.getContext('/'+t1),X);this.mEntityKey[s]=t1;}}var u1=[];if(this.bReloadSingleUnitMeasures&&d1.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([K._requestType.reloadMeasuresQuery,d1]);Promise.resolve().then(K.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<d1.length;q++){var v1=d1[q];this._executeQueryRequest(v1);}}for(var p=0;p<d1.length;p++){var w1=d1[p];u1.push(w1.sRequestId);}this._considerRequestGrouping(u1);}if(f1&&f1.length>0){for(var r=0,x1=f1.length;r<x1;r++){delete e.results[r-x1];}}if(Y){a1+=this._mergeLoadedKeyIndexWithSubsequentIndexes(W,P,N,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var y1=false;if(e.__count){this.mServiceLength[n]=parseInt(e.__count);this.mLength[n]=this.mServiceLength[n]-a1;this.mFinalLength[n]=true;if(R.bIsFlatListRequest){this.iTotalSize=this.mServiceLength[n];}y1=true;}if(!(n in this.mServiceLength)||this.mServiceLength[n]<U+e1){this.mServiceLength[n]=U+e1;this.mLength[n]=Q+e1-a1;this.mFinalLength[n]=false;}if(e1<V||V===undefined){this.mServiceLength[n]=U+e1;this.mLength[n]=Q+W.iIndex-Q;this.mFinalLength[n]=true;y1=true;}if(e1==0){this.mLength[n]=this.mServiceLength[n]=0;this.mFinalLength[n]=true;y1=true;}if(!y1&&this.mLength[n]!==undefined&&a1>0){this.mLength[n]-=a1;}}this.bNeedsUpdate=true;if(a1>0){if(e.results.length-a1>0){this.aMultiUnitLoadFactor[P.length]=e.results.length/(e.results.length-a1);}if(this.aMultiUnitLoadFactor[P.length]<1.5){this.aMultiUnitLoadFactor[P.length]=2;}}E.info("MultiUnit Situation in Group ("+n+"), discarded: "+a1+", load-factor is now: "+this.aMultiUnitLoadFactor[P.length]);};K.prototype._processTotalSizeQueryResponse=function(r,o){if(o.__count==undefined){E.fatal("missing entity count in query result");return;}this.iTotalSize=parseInt(o.__count);};K.prototype._processLevelMembersQueryResponse=function(r,o){var e=this;var p,P;var g=function(h,l){var m={iRequestType:K._requestType.groupMembersQuery,sRequestId:e._getRequestId(K._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=m.sGroupId||e._getKeys(m.sGroupId)===undefined)){var s=e._getParentGroupId(m.sGroupId);var n=e._findKeyIndex(s,e.mEntityKey[m.sGroupId]);if(n<0){E.fatal("assertion failed: failed to determine position of "+m.sGroupId+" in group "+s);}else if(!n){e.mFinalLength[r.sGroupId_Missing_AtLevel]=true;}else if(e._getKey(s,n-1)!==undefined){var q=e._getKey(s,n-1);var z=e._getGroupIdFromContext(e.oModel.getContext('/'+q),e._getGroupIdLevel(m.sGroupId));e.mFinalLength[z]=true;m.iStartIndex=0;}}if(l){m.iLength=P.length;}m.oKeyIndexMapping=e._getKeyIndexMapping(m.sGroupId,m.iStartIndex);var N=d({},o);N.results=P;e._processGroupMembersQueryResponse(m,N);};if(o.results.length==0){this.bNeedsUpdate=true;return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(o.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<o.results.length;i++){var j=o.results[i];var k=this.oModel.getContext("/"+this.oModel._getKey(o.results[i]));var s=this._getGroupIdFromContext(k,r.iLevel-1);if(p==s){P.push(j);if(i<o.results.length-1){continue;}}g(h,o.results.length==r.iLength&&i==o.results.length-1);h=false;if(p!=s){P=[j];}p=s;}if(o.results.length>1&&P.length==1){g(h,o.results.length==r.iLength);}};K.prototype._processReloadMeasurePropertiesQueryResponse=function(r,o){var m=r.oMultiUnitRepresentative;var s=this.oModel.getKey(m.oEntry);if(o.results.length!=1){E.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+s);return;}var R=o.results[0];var e=this.oModel.getObject("/"+s);if(!e){E.fatal("assertion failed: no entity found with key "+s);return;}var g=m.aReloadMeasurePropertyName;for(var i=0;i<g.length;i++){e[g[i]]=R[g[i]];}};K.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),j;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;j=k(i);while(j){o=this.oModel.getContext('/'+j);h.push(o);i++;j=k(i);}return h;}for(i=s;i<s+l;i++){j=k(i);if(!j){break;}o=this.oModel.getContext('/'+j);h.push(o);}return h;};K.prototype._calculateRequiredGroupSection=function(g,s,l,i){var e=this.mKeyIndex[g]||[],h=this.mFinalLength[g]?this.mLength[g]:undefined,j=O._getReadIntervals(e,s,l,i,h),o=O._mergeIntervals(j);if(o){return{startIndex:o.start,length:o.end-o.start};}return{startIndex:0,length:Math.min(0,l)};};K.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var k=h._getGroupIdLevel(g);if(k==e){var N=h._getLoadedContextsForGroup(g,s,l);var Q=s+N.length-1;if(N.length>=l){return n;}else if(h.mFinalLength[g]){if(N.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-N.length};}else{return{groupId_Missing:g,startIndex_Missing:Q+1,length_Missing:l-N.length};}}else{return{groupId_Missing:g,startIndex_Missing:Q+1,length_Missing:l-N.length};}}var R=h._getLoadedContextsForGroup(g,s,l);var m=l,U=s+R.length-1;for(var i=-1,V;(V=R[++i])!==undefined;){m--;var p=j(h._getGroupIdFromContext(V,k+1),e,0,m);if(p.groupId_Missing==null){if(p.length_Missing==0){return p;}else{m=p.length_Missing;}}else{return p;}if(m==0){break;}}if(h.mFinalLength[g]||m==0){return{groupId_Missing:null,length_Missing:m};}else{return{groupId_Missing:g,startIndex_Missing:U+1,length_Missing:m};}};var k=this._getGroupIdLevel(g);if(k==e+1){g=this._getParentGroupId(g);--k;}if(g==null||k>e){return n;}var m=l,o=s;while(g!=null){var p=j(g,e,o,m);if(p.groupId_Missing!=null){return p;}else if(p.length_Missing==0){return p;}else{var q=false;while(!q){var P=this._getParentGroupId(g);if(P==null){g=P;--k;break;}var r=this.mEntityKey[g];if(!r){return n;}var z=this._findKeyIndex(P,r);if(z==-1){return n;}if(z==this._getKeyCount(P)-1){if(this.mFinalLength[P]){g=P;--k;continue;}else{return{groupId_Missing:P,startIndex_Missing:z+1,length_Missing:m};}}else{r=this._getKey(P,z+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+r),k);q=true;}}o=0;m=p.length_Missing;}}return{groupId_Missing:null,length_Missing:m};};K.prototype._getResourcePath=function(){return this.isRelative()?this.getResolvedPath():this.sPath;};K.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};K.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending;}}return null;};K.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case a.SortOrder.Ascending:if(W){s=t.GE;}else{s=t.GT;}break;case a.SortOrder.Descending:if(W){s=t.LE;}else{s=t.LT;}break;default:s=t.GT;}return s;};K.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var g=sap.ui.require("sap/ui/model/odata/Filter");if(typeof g==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof g){e[i]=e[i].convert();}}}return e;};K.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var s=null;if(l>this.aAggregationLevel.length){E.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){s=o.getProperty(this.aAggregationLevel[i]);if(s!=null){if(s.__edmType==="Edm.Time"){s=s.ms;}g+=encodeURIComponent(s)+"/";}else{g+="@/";}}return g;};K.prototype._getGroupIdLevel=function(g){if(g==null){E.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};K.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var e=g.split("/");var h=[];for(var i=1;i<e.length-1;i++){if(e[i]=="@"){h[i-1]=null;}else{h[i-1]=decodeURIComponent(e[i]);}}return h;};K.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){E.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{E.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var e=g.split("/");var h=[],s="";var k=0,l=e.length-3;if(n>0){if(n-1>l){E.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{l=n-1;}}else if(-(n+1)>l){E.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=l+1+n;for(var i=0;i<k;i++){s+=e[i]+"/";}}for(var j=k;j<=l;j++){s+=e[j]+"/";h.push(s);}return h;};K.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};K.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};K.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};K.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){E.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};K.prototype._deregisterHandleOfCompletedRequest=function(r){if(f(this.oPendingRequestHandle)){E.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){E.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};K.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};K.prototype._getRequestId=function(r,p){switch(r){case K._requestType.groupMembersQuery:if(p.groupId===undefined){E.fatal("missing group ID");}return K._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case K._requestType.levelMembersQuery:if(p.level===undefined){E.fatal("missing level");}if(p.groupId===undefined){E.fatal("missing groupId");}return""+K._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case K._requestType.totalSizeQuery:return K._requestType.totalSizeQuery;case K._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){E.fatal("missing multi unit entry key");}return K._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:E.fatal("invalid request type "+r);return-1;}};K.prototype._registerNewRequest=function(r){if(r==undefined||r==""){E.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};K.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};K.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};K.prototype._deregisterCompletedRequest=function(r){if(f(this.oPendingRequests)){E.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){E.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};K.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var s in R){if(s!=r){this._cleanupGroupingForCompletedRequest(s);}}}return g;};K.prototype._getKeyIndexMapping=function(g,s){var i,l,e,k=this.mKeyIndex[g],o={sGroupId:g,iIndex:s,iServiceKeyIndex:s},h=this.mServiceKey[g];if(k!==undefined){if(k[s]!==undefined){o.iServiceKeyIndex=k[s]==="ZERO"?0:Math.abs(k[s]);return o;}l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}if(l==0){e=0;}else{if(k[l]>=0){e=k[l];}else if(k[l+1]===undefined){e=-k[l];while(h[e+1]!==undefined){++e;}}else{e=Math.abs(k[l+1])-1;}if(h[e]===undefined){E.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+e);}}i=s-l;o.iServiceKeyIndex=e+i;}return o;};K.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};K.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){E.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){E.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};K.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};K.prototype._getServiceKeys=function(g,e){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],h=k[e];if(h===undefined){return undefined;}if(h>=0){return[s[h]];}var j=[];if(k[e+1]===undefined){h=k[e]=="ZERO"?0:-k[e];while(s[h]!==undefined){j.push(s[h++]);}}else{h=k[e]=="ZERO"?0:-k[e];for(var i=h,n=Math.abs(k[e+1]);i<n;i++){j.push(s[i]);}}return j;};K.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};K.prototype._findKeyIndex=function(g,k){var e=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(e[i]<0||e[i]==="ZERO"){if(m[i]==k){return i;}}else if(s[e[i]]==k){return i;}}return-1;};K.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};K.prototype._setAdjacentMultiUnitKeys=function(k,m,e){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<e.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(e[i]);}return n;};K.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,g){var h=this.mKeyIndex[k.sGroupId],j=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],l=0,n=k.iServiceKeyIndex,o=k.iIndex;var p,q;if(h===undefined){return l;}var N=false;var P=j[n-1],r=j[n];if(r===undefined){return l;}if(P===undefined){E.fatal("assertion failed: missing expected entry before given key index");return l;}var z=this.oModel.getObject("/"+P);var Q=this.oModel.getObject("/"+r);var R="",U="";for(var i=0;i<e.length;i++){R+=z[e[i]]+"|";U+=Q[e[i]]+"|";}N=R==U;var V=o;if(V>=this.mLength[k.sGroupId]){E.fatal("assertion failed: service key exists,but no corresponding key index found");return l;}while(h[V]===undefined||Math.abs(h[V])<n){++V;}if(N){if(Math.abs(h[V])==n&&h[V]<0){if(V>o){if(h[o-1]<0){m[V]=undefined;h.splice(o,V-o+1);m.splice(o,V-o+1);}else{h[o-1]=-h[o-1];m[o-1]=m[V];m[V]=undefined;h.splice(o,V-o+1);m.splice(o,V-o+1);l=1;}}}else if(Math.abs(h[V])>n){var W=V-1;if(h[W]>0){p=this._createMultiUnitRepresentativeEntry(k.sGroupId,z,s,undefined,g);q=this.oModel._getKey(p.oEntry);h[W]=-h[W];m[W]=q;if(W>o){h.splice(o,W-o);m.splice(o,W-o);}if(p.bIsNewEntry){l=1;}else{l=0;}}else if(h[o-1]<0){if(V>o){m[W]=undefined;h.splice(o,W-o+1);m.splice(o,W-o+1);}}else{h[o-1]=-h[o-1];m[o-1]=m[W];m[W]=undefined;h.splice(o,W-o+1);m.splice(o,W-o+1);}}else if(h[V]==n){if(V>o){if(h[o-1]<0){h.splice(o,V-o+1);m.splice(o,V-o+1);l=1;}else{p=this._createMultiUnitRepresentativeEntry(k.sGroupId,z,s,undefined,g);q=this.oModel._getKey(p.oEntry);if(!p.bIsNewEntry){E.fatal("assertion failed: multi-unit entry already existed before");}h[o-1]=-h[o-1];m[o-1]=q;h.splice(o,V-o+1);m.splice(o,V-o+1);l=1;}}}else{E.fatal("assertion failed: uncovered case detected");return l;}}else if(h[V]>n){E.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(V-o>0){h.splice(o,V-o);m.splice(o,V-o);}return l;};K.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,e,i){var m=d({},r);var R=[];for(var h in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[h];if(!i&&this._isSkippingTotalForMeasure(h)){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(e){if(!o.unitPropertyName||e.indexOf(o.unitPropertyName)==-1){R.push(o.rawValuePropertyName||o.name);}}}for(var k=0;k<s.length;k++){if(e.indexOf(s[k])!=-1){m[s[k]]="*";}}var j="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var n=m[this.aAllDimensionSortedByName[l]];var p=n===""?'""':n;p=p===undefined?"":p;j+=(encodeURIComponent(p)+",");}j+="-multiple-units-not-dereferencable|"+this._iId;var q;if(this.mMultiUnitKey[g]&&(q=this.mMultiUnitKey[g].indexOf(j))!=-1){return{oEntry:this.oModel.getObject("/"+j),bIsNewEntry:false,iIndex:q,aReloadMeasurePropertyName:R};}m.__metadata.uri=j;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var z=this.oModel._getKey(m);this.oModel.getContext('/'+z)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};K.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};K.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};K.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};K.prototype.refresh=function(e){K.prototype._refresh.apply(this,arguments);};K.prototype._refresh=function(e,m,g){var h=false;if(!e){if(g){var r=this.getResolvedPath();var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in g)){h=true;}}if(m&&!h){b(this.mServiceKey,function(i,n){b(n,function(i,k){if(k in m){h=true;return false;}return true;});if(h){return false;}return true;});}if(!m&&!g){h=true;}}if(e||h){this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};K.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{b(this.mServiceKey,function(i,n){b(n,function(i,k){if(k in m){g=true;return false;}return true;});if(g){return false;}return true;});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};K.prototype.getDownloadUrl=function(s){var e,p,z;var o=new a.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var n in this.oDimensionDetailsSet){g.push(n);}o.setAggregationLevel(g);for(var q in this.oDimensionDetailsSet){var r=this.oDimensionDetailsSet[q];var N=(r.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(r.name,true,N,r.aAttributeName);}for(var P in this.oMeasureDetailsSet){h.push(P);}o.setMeasures(h);for(var Q in this.oMeasureDetailsSet){var R=this.oMeasureDetailsSet[Q];var U=(R.rawValuePropertyName!=undefined);var V=(R.formattedValuePropertyName!=undefined);var W=(R.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(R.name,U,V,W);}var X=o.getSortExpression();X.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){X.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);}}var Y=o.getFilterExpression();Y.clear();if(this.aApplicationFilter){Y.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){Y.addUI5FilterConditions(this.aControlFilter);}var Z=o.getURIToQueryResultEntitySet();var $=this._getQueryODataRequestOptions(o,true);if(!$){return undefined;}var _=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var a1=this.aAnalyticalInfo[k];if((a1.visible||a1.inResult)&&a1.name!==""&&a1.name!==_[_.length-1]){_.push(a1.name);if(this.oMeasureDetailsSet[a1.name]!=undefined&&this.oMeasureDetailsSet[a1.name].unitPropertyName!=undefined){_.push(this.oMeasureDetailsSet[a1.name].unitPropertyName);}}}for(var j=0,l=$.length;j<l;j++){if(/^\$select/i.test($[j])){if(this.mParameters.select){e=$[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(_.indexOf(p)===-1){_.push(p);}}}$[j]="$select="+_.join(",");break;}}if(s){$.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){$.push(this.sCustomParams);}if(Z){return this.oModel._createRequestUrl(Z,null,$).replace(/ /g,"%20");}return undefined;};K.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?a.SortOrder.Descending:a.SortOrder.Ascending);});};K.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==T.Sequential){E.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath);}this.sLastAutoExpandMode=s;}return s===T.Sequential;}return false;};K.prototype._warnNoSortingOfGroups=function(s){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(s){m+="; "+s;}E.warning(m,this.sPath);}this.bApplySortersToGroups=false;};K.prototype._isSkippingTotalForMeasure=function(m){var o=this.mAnalyticalInfoByProperty[m];return!!o&&o.total==false;};K.Logger=E;return K;});
