/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CountMode","./ODataUtils","sap/base/assert","sap/base/Log","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/merge","sap/base/util/array/diff","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/Sorter","sap/ui/model/odata/Filter"],function(C,O,a,L,d,e,m,b,c,F,f,g,h,S,k){"use strict";var l=h.extend("sap.ui.model.odata.ODataListBinding",{constructor:function(M,p,o,s,i,P){h.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.bPendingChange=false;this.aKeys=[];this.bInitial=true;this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.oCombinedFilter=null;this.oModel.checkFilterOperation(this.aApplicationFilters);if(!this.oModel.getServiceMetadata()){var t=this,j=function(E){t.bInitial=false;t._initSortersFilters();t.oModel.detachMetadataLoaded(j);};this.oModel.attachMetadataLoaded(this,j);}else{this.bInitial=false;this._initSortersFilters();}var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!s&&!i){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this.bDataAvailable=true;}else if(r===null&&this.oModel.resolve(this.sPath,this.oContext)){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true;}else if(this.oModel.getServiceMetadata()){this.resetData();}}});l.prototype.getContexts=function(s,j,t){if(this.bInitial){return[];}this.iLastLength=j;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0;}if(!j){j=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<j){j=this.iLength;}}if(!t){t=0;}var n=true,o=this._getContexts(s,j),p={},q;q=this.calculateSection(s,j,t,o);n=o.length!=j&&!(this.bLengthFinal&&o.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&q.length>0&&(n||j<q.length)){this.loadData(q.startIndex,q.length);o.dataRequested=true;}}if(this.bRefresh){if(this.bLengthFinal&&this.iLength==0){this.loadData(q.startIndex,q.length,true);o.dataRequested=true;}this.bRefresh=false;}else{for(var i=0;i<o.length;i++){p[o[i].getPath()]=o[i].getObject();}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){var r=this;var D=b(this.aLastContexts,o,function(u,N){return d(u&&r.oLastContextData&&r.oLastContextData[u.getPath()],N&&p&&p[N.getPath()]);});o.diff=D;}}this.iLastEndIndex=s+j;this.aLastContexts=o.slice(0);this.oLastContextData=m({},p);}return o;};l.prototype.getCurrentContexts=function(){return this.aLastContexts||[];};l.prototype._getContexts=function(s,j){var n=[],o,K;if(!s){s=0;}if(!j){j=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<j){j=this.iLength;}}for(var i=s;i<s+j;i++){K=this.aKeys[i];if(!K){break;}o=this.oModel.getContext('/'+K);n.push(o);}return n;};l.prototype.calculateSection=function(s,n,t,o){var p,q,P,r,R,u={},K;q=s;p=0;for(var i=s;i>=Math.max(s-t,0);i--){K=this.aKeys[i];if(!K){r=i+1;break;}}for(var j=s+n;j<s+n+t;j++){K=this.aKeys[j];if(!K){P=j;break;}}R=s-r;if(r&&s>t&&R<t){if(o.length!=n){q=s-t;}else{q=r-t;}p=t;}q=Math.max(q,0);if(q==s){q+=o.length;}if(o.length!=n){p+=n-o.length;}R=P-s-n;if(R==0){p+=t;}if(P&&R<t&&R>0){if(q>s){q=P;p+=t;}}if(this.bLengthFinal&&this.iLength<(p+q)){p=this.iLength-q;}u.startIndex=q;u.length=p;return u;};l.prototype.setContext=function(o){if(this.oContext!=o){this.oContext=o;if(this.isRelative()){this._initSortersFilters();if(!this.bInitial){var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!this.aSorters.length>0&&!this.aFilters.length>0){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this._fireChange({reason:c.Context});}else if(!this.oModel.resolve(this.sPath,this.oContext)||r===null){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:c.Context});}else{this.refresh();}}}}};l.prototype.getDownloadUrl=function(s){var p=[],P;if(s){p.push("$format="+encodeURIComponent(s));}if(this.sSortParams){p.push(this.sSortParams);}if(this.sFilterParams){p.push(this.sFilterParams);}if(this.sCustomParams){p.push(this.sCustomParams);}P=this.oModel.resolve(this.sPath,this.oContext);return P&&this.oModel._createRequestUrl(P,null,p);};l.prototype.loadData=function(s,j,p){var t=this,I=false;if(s||j){this.sRangeParams="$skip="+s+"&$top="+j;this.iStartIndex=s;}else{s=this.iStartIndex;}var P=[];if(this.sRangeParams){P.push(this.sRangeParams);}if(this.sSortParams){P.push(this.sSortParams);}if(this.sFilterParams){P.push(this.sFilterParams);}if(this.sCustomParams){P.push(this.sCustomParams);}if(!this.bLengthFinal&&(this.sCountMode==C.Inline||this.sCountMode==C.Both)){P.push("$inlinecount=allpages");I=true;}function n(D){e(D.results,function(i,v){t.aKeys[s+i]=t.oModel._getKey(v);});if(I&&D.__count){t.iLength=parseInt(D.__count);t.bLengthFinal=true;}if(t.iLength<s+D.results.length){t.iLength=s+D.results.length;t.bLengthFinal=false;}if(D.results.length<j||j===undefined){t.iLength=s+D.results.length;t.bLengthFinal=true;}if(s==0&&D.results.length==0){t.iLength=0;t.bLengthFinal=true;}t.oRequestHandle=null;t.bPendingRequest=false;t.bNeedsUpdate=true;t.bIgnoreSuspend=true;}function o(D){t.fireDataReceived({data:D});}function E(i,A){t.oRequestHandle=null;t.bPendingRequest=false;if(!A){t.aKeys=[];t.iLength=0;t.bLengthFinal=true;t.bDataAvailable=true;t._fireChange({reason:c.Change});}t.fireDataReceived();}function u(H){t.oRequestHandle=H;}var q=this.sPath,r=this.oContext;if(this.isRelative()){q=this.oModel.resolve(q,r);}if(q){if(p){var U=this.oModel._createRequestUrl(q,null,P);this.fireDataRequested();this.oModel.fireRequestSent({url:U,method:"GET",async:true});setTimeout(function(){t.bNeedsUpdate=true;t.checkUpdate();t.oModel.fireRequestCompleted({url:U,method:"GET",async:true,success:true});t.fireDataReceived({data:{}});},0);}else{this.bPendingRequest=true;this.fireDataRequested();this.oModel._loadData(q,P,n,E,false,u,o);}}};l.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength;}else{var A=this.iLastThreshold||this.iLastLength||10;return this.iLength+A;}};l.prototype.isLengthFinal=function(){return this.bLengthFinal;};l.prototype._getLength=function(){var t=this;var p=[];if(this.sFilterParams){p.push(this.sFilterParams);}if(this.mParameters&&this.mParameters.custom){var o={custom:{}};e(this.mParameters.custom,function(s,v){o.custom[s]=v;});p.push(this.oModel.createCustomParams(o));}function _(D){t.iLength=parseInt(D);t.bLengthFinal=true;}function i(E){var s="Request for $count failed: "+E.message;if(E.response){s+=", "+E.response.statusCode+", "+E.response.statusText+", "+E.response.body;}L.warning(s);}var P=this.oModel.resolve(this.sPath,this.oContext);if(P){var u=this.oModel._createRequestUrl(P+"/$count",null,p);var r=this.oModel._createRequest(u,"GET",false);r.headers["Accept"]="text/plain, */*;q=0.5";this.oModel._request(r,_,i,undefined,undefined,this.oModel.getServiceMetadata());}};l.prototype.refresh=function(j,n,E){var o=false;if(!j){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var p=this.oModel.oMetadata._getEntityTypeByPath(r);if(p&&(p.entityType in E)){o=true;}}if(n&&!o){e(this.aKeys,function(i,K){if(K in n){o=true;return false;}return true;});}if(!n&&!E){o=true;}}if(j||o){this.abortPendingRequest();this.resetData();this._fireRefresh({reason:c.Refresh});}};l.prototype._fireRefresh=function(p){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",p);}};l.prototype.initialize=function(){if(this.oModel.oMetadata.isLoaded()){if(this.bDataAvailable){this._fireChange({reason:c.Change});}else{this._fireRefresh({reason:c.Refresh});}}};l.prototype.checkUpdate=function(j,n){var s=this.sChangeReason?this.sChangeReason:c.Change,o=false,p,q,t=this,r,R;if(this.bSuspended&&!this.bIgnoreSuspend){return;}if(!j&&!this.bNeedsUpdate){r=this.oModel._getObject(this.sPath,this.oContext);R=Array.isArray(r)&&!d(r,this.aExpandRefs);this.aExpandRefs=r;if(R){if(this.aSorters.length>0||this.aFilters.length>0){this.refresh();return;}else{this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;o=true;}}else if(n){e(this.aKeys,function(i,K){if(K in n){o=true;return false;}return true;});}else{o=true;}if(o&&this.aLastContexts){o=false;var u=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!=u.length){o=true;}else{e(this.aLastContexts,function(i,v){p=t.oLastContextData[v.getPath()];q=u[i].getObject();if(!d(p,q,true)){o=true;return false;}return true;});}}}if(j||o||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:s});}this.sChangeReason=undefined;this.bIgnoreSuspend=false;};l.prototype.resetData=function(){this.aKeys=[];this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;if(this.oModel.isCountSupported()&&(this.sCountMode==C.Request||this.sCountMode==C.Both)){this._getLength();}};l.prototype.abortPendingRequest=function(){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false;}};l.prototype.sort=function(s,r){var i=false;if(!s){s=[];}if(s instanceof S){s=[s];}this.aSorters=s;this.createSortParams(s);if(!this.bInitial){this.aKeys=[];this.abortPendingRequest();this.sChangeReason=c.Sort;this._fireRefresh({reason:this.sChangeReason});this._fireSort({sorter:s});i=true;}if(r){return i;}else{return this;}};l.prototype.createSortParams=function(s){this.sSortParams=O.createSortParams(s);};l.prototype.filter=function(i,s,r){var j=false;if(!i){i=[];}if(i instanceof F){i=[i];}this.oModel.checkFilterOperation(i);if(s==g.Application){this.aApplicationFilters=i;}else{this.aFilters=i;}if(!i||!Array.isArray(i)||i.length==0){this.aFilters=[];}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)||this.aApplicationFilters.length===0){this.aApplicationFilters=[];}this.convertFilters();this.oCombinedFilter=f.combineFilters(this.aFilters,this.aApplicationFilters);this.createFilterParams(this.oCombinedFilter);if(!this.bInitial){this.resetData();this.abortPendingRequest();this.sChangeReason=c.Filter;this._fireRefresh({reason:this.sChangeReason});if(s==g.Application){this._fireFilter({filters:this.aApplicationFilters});}else{this._fireFilter({filters:this.aFilters});}j=true;}if(r){return j;}else{return this;}};l.prototype.convertFilters=function(){this.aFilters=this.aFilters.map(function(o){return o instanceof k?o.convert():o;});this.aApplicationFilters=this.aApplicationFilters.map(function(o){return o instanceof k?o.convert():o;});};l.prototype.createFilterParams=function(o){this.sFilterParams=O.createFilterParams(o,this.oModel.oMetadata,this.oEntityType);};l.prototype._initSortersFilters=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oEntityType=this._getEntityType();this.convertFilters();this.oCombinedFilter=f.combineFilters(this.aFilters,this.aApplicationFilters);this.createSortParams(this.aSorters);this.createFilterParams(this.oCombinedFilter);};l.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var E=this.oModel.oMetadata._getEntityTypeByPath(r);a(E,"EntityType for path "+r+" could not be found!");return E;}return undefined;};l.prototype.resume=function(){this.bIgnoreSuspend=false;h.prototype.resume.apply(this,arguments);};return l;});
