/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/assert","sap/base/Log","sap/base/security/encodeURL","sap/base/util/each","sap/ui/core/CalendarType","sap/ui/core/format/DateFormat","sap/ui/model/FilterProcessor","sap/ui/model/Sorter"],function(a,L,e,b,C,D,F,S){"use strict";var d,o,c,r=/^([-+]?)0*(\d+)(\.\d+|)$/,t,f=/\.$/,g=/0+$/;function s(){if(!d){d=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''",calendarType:C.Gregorian});o=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss.SSS''",calendarType:C.Gregorian});c=D.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''",calendarType:C.Gregorian});t=D.getTimeInstance({pattern:"'time''PT'HH'H'mm'M'ss'S'''",calendarType:C.Gregorian});}}var O=function(){};O.createSortParams=function(n){var y;if(!n||n.length==0){return undefined;}y="$orderby=";for(var i=0;i<n.length;i++){var z=n[i];if(z instanceof S){y+=z.sPath;y+=z.bDescending?"%20desc":"%20asc";y+=",";}else{L.error("Trying to use "+z+" as a Sorter, but it is a "+typeof z);}}y=y.slice(0,-1);return y;};function h(i){if(i&&typeof i.convert==="function"){i=i.convert();}return i;}O.createFilterParams=function(i,M,E){var n;if(Array.isArray(i)){i=i.map(h);n=F.groupFilters(i);}else{n=h(i);}if(!n){return undefined;}return"$filter="+this._createFilterParams(n,M,E);};O._createFilterParams=function(n,M,E){var y=this,z=Array.isArray(n)?F.groupFilters(n):n;function A(z,i){z=h(z);if(z.aFilters){return B(z,i);}return y._createFilterSegment(z.sPath,M,E,z.sOperator,z.oValue1,z.oValue2,z.bCaseSensitive);}function B(G,H){var I=G.aFilters,J=!!G.bAnd,K="";if(I.length===0){return J?"true":"false";}if(I.length===1){if(I[0]._bMultiFilter){return A(I[0]);}return A(I[0],true);}if(!H){K+="(";}K+=A(I[0]);for(var i=1;i<I.length;i++){K+=J?"%20and%20":"%20or%20";K+=A(I[i]);}if(!H){K+=")";}return K;}if(!z){return undefined;}return A(z,true);};O._createUrlParamsArray=function(P){var U,T=typeof P,i;if(Array.isArray(P)){return P;}U=[];if(T==="string"||P instanceof String){if(P){U.push(P);}}else if(T==="object"){i=this._encodeURLParameters(P);if(i){U.push(i);}}return U;};O._encodeURLParameters=function(P){if(!P){return"";}var U=[];b(P,function(n,V){if(typeof V==="string"||V instanceof String){V=encodeURIComponent(V);}n=n.startsWith('$')?n:encodeURIComponent(n);U.push(n+"="+V);});return U.join("&");};O.setOrigin=function(i,P){var n,y,z;if(!i||!P||i.indexOf(";mo")>0){return i;}if(typeof P=="string"){n=P;}else{n=P.alias;if(!n){y=P.system;z=P.client;if(!y||!z){L.warning("ODataUtils.setOrigin: No Client or System ID given for Origin");return i;}n="sid("+y+"."+z+")";}}var U=i.split("?");var B=U[0];var A=U[1]?"?"+U[1]:"";var T="";if(B[B.length-1]==="/"){B=B.substring(0,B.length-1);T="/";}var E=/(\/[^\/]+)$/g;var G=/(;o=[^\/;]+)/g;var H=B.match(E)[0];var I=H.match(G);var J=I?I[0]:null;if(J){if(P.force){var K=H.replace(J,";o="+n);B=B.replace(H,K);return B+T+A;}return i;}B=B+";o="+n+T;return B+A;};O.setAnnotationOrigin=function(A,P){var i;var n=A.indexOf("/Annotations(");var H=P&&P.preOriginBaseUri?P.preOriginBaseUri.indexOf(".xsodata"):-1;if(n===-1){n=A.indexOf("/Annotations%28");}if(n>=0){if(A.indexOf("/$value",n)===-1){L.warning("ODataUtils.setAnnotationOrigin: Annotation url is missing $value segment.");i=A;}else{var y=A.substring(0,n);var z=A.substring(n,A.length);var B=O.setOrigin(y,P);i=B+z;}}else if(H>=0){i=O.setOrigin(A,P);}else{i=A.replace(P.preOriginBaseUri,P.postOriginBaseUri);}return i;};O._resolveMultiFilter=function(M,n,E){var y=this,z=M.aFilters,A="";if(z){A+="(";b(z,function(i,B){if(B._bMultiFilter){A+=y._resolveMultiFilter(B,n,E);}else if(B.sPath){A+=y._createFilterSegment(B.sPath,n,E,B.sOperator,B.oValue1,B.oValue2,"",B.bCaseSensitive);}if(i<(z.length-1)){if(M.bAnd){A+="%20and%20";}else{A+="%20or%20";}}});A+=")";}return A;};O._createFilterSegment=function(P,M,E,i,V,n,y){var z,T;if(y===undefined){y=true;}if(E){z=M._getPropertyMetadata(E,P);T=z&&z.type;a(z,"PropertyType for property "+P+" of EntityType "+E.name+" not found!");}if(T){V=this.formatValue(V,T,y);n=(n!=null)?this.formatValue(n,T,y):null;}else{a(null,"Type for filter property could not be found in metadata!");}if(V){V=e(String(V));}if(n){n=e(String(n));}if(!y&&T==="Edm.String"){P="toupper("+P+")";}switch(i){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":return P+"%20"+i.toLowerCase()+"%20"+V;case"BT":return"("+P+"%20ge%20"+V+"%20and%20"+P+"%20le%20"+n+")";case"NB":return"not%20("+P+"%20ge%20"+V+"%20and%20"+P+"%20le%20"+n+")";case"Contains":return"substringof("+V+","+P+")";case"NotContains":return"not%20substringof("+V+","+P+")";case"StartsWith":return"startswith("+P+","+V+")";case"NotStartsWith":return"not%20startswith("+P+","+V+")";case"EndsWith":return"endswith("+P+","+V+")";case"NotEndsWith":return"not%20endswith("+P+","+V+")";default:L.error("ODataUtils :: Unknown filter operator "+i);return"true";}};O.formatValue=function(V,T,i){var n,y;if(i===undefined){i=true;}if(V===null||V===undefined){return"null";}s();switch(T){case"Edm.String":V=i?V:V.toUpperCase();y="'"+String(V).replace(/'/g,"''")+"'";break;case"Edm.Time":if(typeof V==="object"){y=t.format(new Date(V.ms),true);}else{y="time'"+V+"'";}break;case"Edm.DateTime":n=V instanceof Date?V:new Date(V);if(n.getMilliseconds()>0){y=o.format(n,true);}else{y=d.format(n,true);}break;case"Edm.DateTimeOffset":n=V instanceof Date?V:new Date(V);y=c.format(n,true);break;case"Edm.Guid":y="guid'"+V+"'";break;case"Edm.Decimal":y=V+"m";break;case"Edm.Int64":y=V+"l";break;case"Edm.Double":y=V+"d";break;case"Edm.Float":case"Edm.Single":y=V+"f";break;case"Edm.Binary":y="binary'"+V+"'";break;default:y=String(V);break;}return y;};O.parseValue=function(V){var i=V[0],n=V[V.length-1];s();if(i==="'"){return V.slice(1,-1).replace(/''/g,"'");}else if(V.startsWith("time'")){return{__edmType:"Edm.Time",ms:t.parse(V,true).getTime()};}else if(V.startsWith("datetime'")){if(V.indexOf(".")===-1){return d.parse(V,true);}else{return o.parse(V,true);}}else if(V.startsWith("datetimeoffset'")){return c.parse(V,true);}else if(V.startsWith("guid'")){return V.slice(5,-1);}else if(V==="null"){return null;}else if(n==="m"||n==="l"||n==="d"||n==="f"){return V.slice(0,-1);}else if(!isNaN(i)||i==="-"){return parseInt(V);}else if(V==="true"||V==="false"){return V==="true";}else if(V.startsWith("binary'")){return V.slice(7,-1);}throw new Error("Cannot parse value '"+V+"', no Edm type found");};function j(V,i){if(V===i){return 0;}if(V===null||i===null||V===undefined||i===undefined){return NaN;}return V>i?1:-1;}function p(V){var M;if(typeof V!=="string"){return undefined;}M=r.exec(V);if(!M){return undefined;}return{sign:M[1]==="-"?-1:1,integerLength:M[2].length,abs:M[2]+M[3].replace(g,"").replace(f,"")};}function k(V,i){var n,y,R;if(V===i){return 0;}n=p(V);y=p(i);if(!n||!y){return NaN;}if(n.sign!==y.sign){return n.sign>y.sign?1:-1;}R=j(n.integerLength,y.integerLength)||j(n.abs,y.abs);return n.sign*R;}var l=/^PT(\d\d)H(\d\d)M(\d\d)S$/;function m(V){if(typeof V==="string"&&l.test(V)){V=parseInt(RegExp.$1)*3600000+parseInt(RegExp.$2)*60000+parseInt(RegExp.$3)*1000;}if(V instanceof Date){return V.getTime();}if(V&&V.__edmType==="Edm.Time"){return V.ms;}return V;}O.compare=function(V,i,A){return A?k(V,i):j(m(V),m(i));};O.getComparator=function(E){switch(E){case"Edm.Date":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":return O.compare;case"Edm.Decimal":case"Edm.Int64":return k;default:return j;}};var q=/([(=,])('.*?')([,)])/g,u=/[MLDF](?=[,)](?:[^']*'[^']*')*[^']*$)/g,v=/([(=,])(X')/g,N=function(i,n,y,z){return n+encodeURIComponent(decodeURIComponent(y))+z;},w=function(i){return i.toLowerCase();},x=function(i,n){return n+"binary'";};O._normalizeKey=function(K){return K.replace(q,N).replace(u,w).replace(v,x);};O._mergeIntervals=function(i){if(i.length){return{start:i[0].start,end:i[i.length-1].end};}return undefined;};O._getReadIntervals=function(E,y,z,P,A){var i,B,n,G=-1,I=[],R=O._getReadRange(E,y,z,P);if(A===undefined){A=Infinity;}B=Math.min(R.start+R.length,A);n=Math.min(B,Math.max(R.start,E.length)+1);for(i=R.start;i<n;i+=1){if(E[i]!==undefined){if(G>=0){I.push({start:G,end:i});G=-1;}}else if(G<0){G=i;}}if(G>=0){I.push({start:G,end:B});}return I;};O._getReadRange=function(E,n,y,P){function z(n,A){var i;for(i=n;i<A;i+=1){if(E[i]===undefined){return true;}}return false;}if(z(n+y,n+y+P/2)){y+=P;}if(z(Math.max(n-P/2,0),n)){y+=P;n-=P;if(n<0){y+=n;if(isNaN(y)){y=Infinity;}n=0;}}return{length:y,start:n};};return O;},true);
