/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_AnnotationHelperBasics","sap/base/Log","sap/ui/base/BindingParser","sap/ui/base/ManagedObject","sap/ui/core/CalendarType","sap/ui/core/format/DateFormat","sap/ui/model/odata/ODataUtils","sap/ui/performance/Measurement"],function(B,L,a,M,C,D,O,b){'use strict';var A="sap.ui.model.odata.AnnotationHelper",d,o,s="\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])",c="[-+]?\\d+(?:\\.\\d+)?",m="9007199254740991",f="-"+m,p=[A],P=A+"/getExpression",t,T="(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d(\\.\\d{1,12})?)?",E={Bool:/^true$|^false$/i,Float:new RegExp("^"+c+"(?:[eE][-+]?\\d+)?$|^NaN$|^-INF$|^INF$"),Date:new RegExp("^"+s+"$"),DateTimeOffset:new RegExp("^"+s+"T"+T+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i"),Decimal:new RegExp("^"+c+"$"),Guid:/^[A-F0-9]{8}-(?:[A-F0-9]{4}-){3}[A-F0-9]{12}$/i,Int:/^[-+]?\d{1,19}$/,TimeOfDay:new RegExp("^"+T+"$")},g,r=/^\{@i18n>[^\\\{\}:]+\}$/,h=/^\d+$/,j={And:"&&",Eq:"===",Ge:">=",Gt:">",Le:"<=",Lt:"<",Ne:"!==",Not:"!",Or:"||"},k=/^(\/dataServices\/schema\/\d+)(?:\/|$)/,l={"Edm.Boolean":"boolean","Edm.Byte":"number","Edm.Date":"date","Edm.DateTime":"datetime","Edm.DateTimeOffset":"datetime","Edm.Decimal":"decimal","Edm.Double":"number","Edm.Float":"number","Edm.Guid":"string","Edm.Int16":"number","Edm.Int32":"number","Edm.Int64":"decimal","Edm.SByte":"number","Edm.Single":"number","Edm.String":"string","Edm.Time":"time","Edm.TimeOfDay":"time"},n={Bool:"Edm.Boolean",Float:"Edm.Double",Date:"Edm.Date",DateTimeOffset:"Edm.DateTimeOffset",Decimal:"Edm.Decimal",Guid:"Edm.Guid",Int:"Edm.Int64",String:"Edm.String",TimeOfDay:"Edm.TimeOfDay"},q={"boolean":false,"date":true,"datetime":true,"decimal":true,"number":false,"string":false,"time":true};g={_setDateTimeFormatter:function(){d=D.getDateInstance({calendarType:C.Gregorian,pattern:"yyyy-MM-dd",strictParsing:true,UTC:true});o=D.getDateTimeInstance({calendarType:C.Gregorian,pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX",strictParsing:true});t=D.getTimeInstance({calendarType:C.Gregorian,pattern:"HH:mm:ss.SSS",strictParsing:true,UTC:true});},adjustOperands:function(e,i){if(e.result!=="constant"&&e.category==="number"&&i.result==="constant"&&i.type==="Edm.Int64"){i.category="number";}if(e.result!=="constant"&&e.category==="decimal"&&i.result==="constant"&&i.type==="Edm.Int32"){i.category="decimal";i.type=e.type;}if(e.result==="constant"&&e.category==="date"&&i.result!=="constant"&&i.category==="datetime"){i.category="date";}},apply:function(i,e){var N=B.descend(e,"Name","string"),u=B.descend(e,"Parameters");switch(N.value){case"odata.concat":return g.concat(i,u);case"odata.fillUriTemplate":return g.fillUriTemplate(i,u);case"odata.uriEncode":return g.uriEncode(i,u);default:B.error(N,"unknown function: "+N.value);return undefined;}},concat:function(I,e){var u=e.asExpression,v=[],R,w=[];B.expectType(e,"array");e.value.forEach(function(_,i){R=g.parameter(I,e,i);u=u||R.result==="expression";w.push(R);});w.forEach(function(R){if(u){g.wrapExpression(R);}if(R.type!=='edm:Null'){v.push(B.resultToString(R,u,e.withType));}});R=u?{result:"expression",value:v.join("+")}:{result:"composite",value:v.join("")};R.type="Edm.String";return R;},conditional:function(i,e){var u=g.parameter(i,e,0,"Edm.Boolean"),v=g.parameter(i,e,1),w=g.parameter(i,e,2),x=v.type,W=e.withType;if(v.type==="edm:Null"){x=w.type;}else if(w.type!=="edm:Null"&&v.type!==w.type){B.error(e,"Expected same type for second and third parameter, types are '"+v.type+"' and '"+w.type+"'");}return{result:"expression",type:x,value:B.resultToString(g.wrapExpression(u),true,false)+"?"+B.resultToString(g.wrapExpression(v),true,W)+":"+B.resultToString(g.wrapExpression(w),true,W)};},constant:function(i,e,u){var v=e.value;B.expectType(e,"string");if(u==="String"){if(r.test(v)){return{ignoreTypeInPath:true,result:"binding",type:"Edm.String",value:v.slice(1,-1)};}else if(i.getSetting&&i.getSetting("bindTexts")){return{result:"binding",type:"Edm.String",ignoreTypeInPath:true,value:"/##"+g.replaceIndexes(i.getModel(),e.path)};}u="Edm.String";}else if(!E[u].test(v)){B.error(e,"Expected "+u+" value but instead saw '"+v+"'");}else{u=n[u];if(u==="Edm.Int64"&&O.compare(v,f,true)>=0&&O.compare(v,m,true)<=0){u="Edm.Int32";}}return{result:"constant",type:u,value:v};},expression:function(i,e){var R=e.value,S,u;B.expectType(e,"object");if(R.hasOwnProperty("Type")){u=B.property(e,"Type","string");S=B.descend(e,"Value");}else{["And","Apply","Bool","Date","DateTimeOffset","Decimal","Float","Eq","Ge","Gt","Guid","If","Int","Le","Lt","Ne","Not","Null","Or","Path","PropertyPath","String","TimeOfDay"].forEach(function(v){if(R.hasOwnProperty(v)){u=v;S=B.descend(e,v);}});}switch(u){case"Apply":return g.apply(i,S);case"If":return g.conditional(i,S);case"Path":case"PropertyPath":return g.path(i,S);case"Bool":case"Date":case"DateTimeOffset":case"Decimal":case"Float":case"Guid":case"Int":case"String":case"TimeOfDay":return g.constant(i,S,u);case"And":case"Eq":case"Ge":case"Gt":case"Le":case"Lt":case"Ne":case"Or":return g.operator(i,S,u);case"Not":return g.not(i,S);case"Null":return{result:"constant",value:"null",type:"edm:Null"};default:B.error(e,"Unsupported OData expression");return undefined;}},formatOperand:function(e,i,R,w){var u;if(R.result==="constant"){switch(R.category){case"boolean":case"number":return R.value;case"date":u=g.parseDate(R.value);if(!u){B.error(B.descend(e,i),"Invalid Date "+R.value);}return String(u.getTime());case"datetime":u=g.parseDateTimeOffset(R.value);if(!u){B.error(B.descend(e,i),"Invalid DateTime "+R.value);}return String(u.getTime());case"time":return String(g.parseTimeOfDay(R.value).getTime());}}if(w){g.wrapExpression(R);}return B.resultToString(R,true);},getExpression:function(i,R,w){var u;if(R===undefined){return undefined;}b.average(P,"",p);if(!g.simpleParserWarningLogged&&M.bindingParser===a.simpleParser){L.warning("Complex binding syntax not active",null,A);g.simpleParserWarningLogged=true;}try{u=g.expression(i,{asExpression:false,path:i.getPath(),value:R,withType:w});b.end(P);return B.resultToString(u,false,w);}catch(e){b.end(P);if(e instanceof SyntaxError){return"Unsupported: "+a.complexParser.escape(B.toErrorString(R));}throw e;}},fillUriTemplate:function(I,e){var i,N,u=[],v="",w,x=e.value,R,y=g.parameter(I,e,0,"Edm.String");u.push('odata.fillUriTemplate(',B.resultToString(y,true),',{');for(i=1;i<x.length;i+=1){w=B.descend(e,i,"object");N=B.property(w,"Name","string");R=g.expression(I,B.descend(w,"Value"),true);u.push(v,B.toJSON(N),":",B.resultToString(R,true));v=",";}u.push("})");return{result:"expression",value:u.join(""),type:"Edm.String"};},not:function(i,e){var u;e.asExpression=true;u=g.expression(i,e);return{result:"expression",value:"!"+B.resultToString(g.wrapExpression(u),true),type:"Edm.Boolean"};},operator:function(i,e,u){var v=u==="And"||u==="Or"?"Edm.Boolean":undefined,w=g.parameter(i,e,0,v),x=g.parameter(i,e,1,v),y,N,V,z;if(w.type!=="edm:Null"&&x.type!=="edm:Null"){w.category=l[w.type];x.category=l[x.type];g.adjustOperands(w,x);g.adjustOperands(x,w);if(w.category!==x.category){B.error(e,"Expected two comparable parameters but instead saw "+w.type+" and "+x.type);}y=w.category==="decimal"?",true":"";N=q[w.category];}V=g.formatOperand(e,0,w,!N);z=g.formatOperand(e,1,x,!N);return{result:"expression",value:N?"odata.compare("+V+","+z+y+")"+j[u]+"0":V+j[u]+z,type:"Edm.Boolean"};},parameter:function(i,e,I,u){var v=B.descend(e,I),R;v.asExpression=true;R=g.expression(i,v);if(u&&u!==R.type){B.error(v,"Expected "+u+" but instead saw "+R.type);}return R;},parseDate:function(v){return d.parse(v);},parseDateTimeOffset:function(v){var e=E.DateTimeOffset.exec(v);if(e&&e[1]&&e[1].length>4){v=v.replace(e[1],e[1].slice(0,4));}return o.parse(v.toUpperCase());},parseTimeOfDay:function(v){if(v.length>12){v=v.slice(0,12);}return t.parse(v);},path:function(i,e){var u=e.value,v={},w,I,x,y=i.getModel(),z={getModel:function(){return y;},getPath:function(){return e.path;}},F,R={result:"binding",value:u},G;B.expectType(e,"string");G=B.followPath(z,{"Path":u});if(G&&G.resolvedPath){F=y.getProperty(G.resolvedPath);R.type=F.type;switch(F.type){case"Edm.DateTime":v.displayFormat=F["sap:display-format"];break;case"Edm.Decimal":if(F.precision){v.precision=F.precision;}if(F.scale){v.scale=F.scale;}x=F["Org.OData.Validation.V1.Minimum"];if(x&&(x.Decimal||x.String)){v.minimum=x.Decimal||x.String;w=x["Org.OData.Validation.V1.Exclusive"];if(w){v.minimumExclusive=w.Bool||"true";}}x=F["Org.OData.Validation.V1.Maximum"];if(x&&(x.Decimal||x.String)){v.maximum=x.Decimal||x.String;w=x["Org.OData.Validation.V1.Exclusive"];if(w){v.maximumExclusive=w.Bool||"true";}}break;case"Edm.String":v.maxLength=F.maxLength;I=F["com.sap.vocabularies.Common.v1.IsDigitSequence"];if(I){v.isDigitSequence=I.Bool||"true";}break;}if(F.nullable==="false"){v.nullable="false";}R.constraints=v;}else{L.warning("Could not find property '"+u+"' starting from '"+e.path+"'",null,A);}return R;},replaceIndexes:function(e,u){var v,w=u.split('/'),x,R;function y(z,i){var F=e.getProperty(x+"/"+z);if(typeof F==="string"){w[i]="[${"+z+"}==="+B.toJSON(F)+"]";return true;}return false;}v=k.exec(u);if(!v){return u;}x=v[1];if(!y("namespace",3)){return u;}for(var i=4;i<w.length;i+=1){x=x+"/"+w[i];if(h.test(w[i])&&!y("name",i)){R=e.getProperty(x+"/RecordType");if(R){if(R==="com.sap.vocabularies.UI.v1.DataFieldForAction"){y("Action/String",i);}else if(R==="com.sap.vocabularies.UI.v1.DataFieldForAnnotation"){y("Target/AnnotationPath",i);}else if(R.indexOf("com.sap.vocabularies.UI.v1.DataField")===0){y("Value/Path",i);}}}}return w.join('/');},simpleParserWarningLogged:false,uriEncode:function(i,e){var R=g.parameter(i,e,0);if(R.result==="constant"){if(R.type==="Edm.Date"){R.type="Edm.DateTime";R.value=R.value+"T00:00:00Z";}else if(R.type==="Edm.TimeOfDay"){R.type="Edm.Time";R.value="PT"+R.value.slice(0,2)+"H"+R.value.slice(3,5)+"M"+R.value.slice(6,8)+"S";}}return{result:"expression",value:'odata.uriEncode('+B.resultToString(R,true)+","+B.toJSON(R.type)+")",type:"Edm.String"};},wrapExpression:function(R){if(R.result==="expression"){R.value="("+R.value+")";}return R;}};g._setDateTimeFormatter();return g;});
