/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/format/DateFormat','sap/ui/model/CompositeType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException',"sap/base/util/isEmptyObject"],function(D,C,F,P,V,i){"use strict";var a=C.extend("sap.ui.model.type.DateInterval",{constructor:function(){C.apply(this,arguments);this.sName="DateInterval";this.bUseInternalValues=true;}});a.prototype.formatValue=function(v,I){if(!Array.isArray(v)){throw new F("Cannot format date interval: "+v+" is expected as an Array but given the wrong format");}switch(this.getPrimitiveType(I)){case"string":case"any":if(!v[0]||(!v[1]&&!this.oFormatOptions.singleIntervalValue)){return"";}if(this.oInputFormat){v=v.slice(0,2);v.forEach(function(o,b){if(this.oFormatOptions.source.pattern=="timestamp"){if(typeof(o)!="number"){if(isNaN(o)){throw new F("Cannot format date: "+o+" is not a valid Timestamp");}else{o=parseInt(o);}}o=new Date(o);}else{o=this.oInputFormat.parse(o);if(o==null){throw new F("Cannot format date: "+o+" has the wrong format");}}v[b]=o;}.bind(this));}return this.oOutputFormat.format(v);default:throw new F("Don't know how to format Date to "+I);}};a.prototype.parseValue=function(v,I){var d;function t(n){var b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText(n+".Invalid"));}switch(this.getPrimitiveType(I)){case"string":if(v===""){return[null,null];}d=this.oOutputFormat.parse(v);if(!d[0]||(!d[1]&&!this.oFormatOptions.singleIntervalValue)){t(this.sName);}if(this.oInputFormat){d.forEach(function(o,b){if(this.oFormatOptions.source.pattern=="timestamp"){o=o.getTime();}else{o=this.oInputFormat.format(o);}d[b]=o;}.bind(this));}return d;default:throw new P("Don't know how to parse Date from "+I);}};a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[];if(this.oInputFormat&&this.oFormatOptions.source.pattern!="timestamp"){v=v.slice(0,2);v.forEach(function(o,d){o=this.oInputFormat.parse(o);v[d]=o;}.bind(this));}Object.keys(this.oConstraints).forEach(function(k){var o=this.oConstraints[k];var d=true;switch(k){case"minimum":if(this.oFormatOptions.singleIntervalValue&&v[1]===null){if(v[0]<o){d=false;}}else if(v[0]<o||v[1]<o){d=false;}if(d===false){c.push("minimum");m.push(b.getText("Date.Minimum",[o]));}break;case"maximum":if(this.oFormatOptions.singleIntervalValue&&v[1]===null){if(v[0]>o){d=false;}}else if(v[0]>o||v[1]>o){d=false;}if(d===false){c.push("maximum");m.push(b.getText("Date.Maximum",[o]));}break;default:break;}}.bind(this));if(c.length>0){throw new V(this.combineMessages(m),c);}}};a.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._createFormats();};a.prototype._handleLocalizationChange=function(){this._createFormats();};a.prototype._createFormats=function(){var s=this.oFormatOptions.source;this.oFormatOptions.interval=true;this.oOutputFormat=D.getDateInstance(this.oFormatOptions);if(s){if(i(s)){s={pattern:"yyyy-MM-dd"};}this.oInputFormat=D.getDateInstance(s);}};return a;});
