/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/performance/Measurement","sap/ui/performance/XHRInterceptor","sap/base/util/LoaderExtensions","sap/base/util/now","sap/base/util/uid","sap/base/Log","sap/ui/thirdparty/URI"],function(M,X,L,a,u,b,U){"use strict";var H=window.location.host,I="INTERACTION",c=false,d=[],p=f(),C={"application/zip":true,"application/vnd.rar":true,"application/gzip":true,"application/x-tar":true,"application/java-archive":true,"image/jpeg":true,"application/pdf":true},s="zip,rar,arj,z,gz,tar,lzh,cab,hqx,ace,jar,ear,war,jpg,jpeg,pdf,gzip";function e(i){var l=new U(i).host();return l&&l!==H;}function h(V){var i=V.toString();var l='';for(var n=0;n<i.length;n+=2){l+=String.fromCharCode(parseInt(i.substr(n,2),16));}return l.trim();}function f(T){return{event:"startup",trigger:"undetermined",component:"undetermined",appVersion:"undetermined",start:T||window.performance.timing.fetchStart,end:0,navigation:0,roundtrip:0,processing:0,duration:0,requests:[],measurements:[],sapStatistics:[],requestTime:0,networkTime:0,bytesSent:0,bytesReceived:0,requestCompression:"X",busyDuration:0,id:u(),passportAction:"undetermined_startup_0"};}function g(i){if(i.start>p.start&&i.end<p.end){return i;}}function j(R){var i=R.startTime>0&&R.startTime<=R.requestStart&&R.requestStart<=R.responseEnd;return i&&R.initiatorType==="xmlhttprequest";}function k(R){this.end=R.responseEnd>this.end?R.responseEnd:this.end;p.requestTime+=(R.responseEnd-R.startTime);if(this.roundtripHigherLimit<=R.startTime){p.navigation+=(this.navigationHigherLimit-this.navigationLowerLimit);p.roundtrip+=(this.roundtripHigherLimit-this.roundtripLowerLimit);this.navigationLowerLimit=R.startTime;this.roundtripLowerLimit=R.startTime;}if(R.responseEnd>this.roundtripHigherLimit){this.roundtripHigherLimit=R.responseEnd;}if(R.requestStart>this.navigationHigherLimit){this.navigationHigherLimit=R.requestStart;}}function m(R){var T={start:R[0].startTime,end:R[0].responseEnd,navigationLowerLimit:R[0].startTime,navigationHigherLimit:R[0].requestStart,roundtripLowerLimit:R[0].startTime,roundtripHigherLimit:R[0].responseEnd};R.forEach(k,T);p.navigation+=(T.navigationHigherLimit-T.navigationLowerLimit);p.roundtrip+=(T.roundtripHigherLimit-T.roundtripLowerLimit);if(p.networkTime){var i=p.requestTime-p.networkTime;p.networkTime=i/R.length;}else{p.networkTime=0;}if(p.processing===0){var l=p.start-window.performance.timing.fetchStart;p.duration=T.end-l;p.processing=T.start-l;}}function o(T){if(p){var i=window.performance.getEntriesByType("resource");p.end=T;p.duration=p.processing;p.requests=i.filter(j);p.completeRoundtrips=0;p.measurements=M.filterMeasurements(g,true);if(p.requests.length>0){m(p.requests);}p.completeRoundtrips=p.requests.length;var P=p.processing-p.navigation-p.roundtrip;p.processing=P>-1?P:0;p.completed=true;Object.freeze(p);if(p.duration!==0||p.requests.length>0||c){d.push(p);var l=d[d.length-1];if(J.onInteractionFinished&&l){J.onInteractionFinished(l);}if(b.isLoggable()){b.debug("Interaction step finished: trigger: "+p.trigger+"; duration: "+p.duration+"; requests: "+p.requests.length,"Interaction.js");}}p=null;v=null;c=false;w=false;}}function q(i){var l,V;if(i){var n,K;n=sap.ui.require("sap/ui/core/Component");if(n){while(i&&i.getParent){K=n.getOwnerComponentFor(i);if(K||i instanceof n){K=K||i;var N=K.getManifestEntry("sap.app");l=N&&N.id||K.getMetadata().getName();V=N&&N.applicationVersion&&N.applicationVersion.version;}i=i.getParent();}}}return{id:l?l:"undetermined",version:V?V:""};}var r=false,t=false,v,B,w=false,x,y=false,S=false,z=0,A=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");function D(){Object.defineProperty(HTMLScriptElement.prototype,"src",{set:function(i){var l;if(!this.dataset.sapUiCoreInteractionHandled){l=J.notifyAsyncStep();this.addEventListener("load",function(){l();});this.addEventListener("error",function(){l();});this.dataset.sapUiCoreInteractionHandled="true";}A.set.call(this,i);},get:A.get});}function E(){X.register(I,"send",function(){if(this.pendingInteraction){this.pendingInteraction.bytesSent+=arguments[0]?arguments[0].length:0;}});X.register(I,"setRequestHeader",function(i,V){if(!this.requestHeaderLength){this.requestHeaderLength=0;}this.requestHeaderLength+=(i+"").length+(V+"").length;});X.register(I,"open",function(){var i,l,R;function n(K){if(this.readyState===4){K();}}if(p){if(!e(arguments[1])){i=J.passportHeader.get(this);if(i&&i.length>=370){l=h(i.substring(150,230));if(parseInt(i.substring(8,10),16)>2){R=i.substring(372,404);}}if(!i||l&&R&&p.passportAction.endsWith(l)){this.addEventListener("readystatechange",G.bind(this,p.id));}}this.addEventListener("readystatechange",n.bind(this,J.notifyAsyncStep()));this.pendingInteraction=p;}});}function F(i,l,n,K){var N=i.split('.').pop().split(/\#|\?/)[0];if(l==='gzip'||l==='br'||n in C||(N&&s.indexOf(N)!==-1)||K<1024){return true;}else{return false;}}function G(i){if(this.readyState===4){if(this.pendingInteraction&&!this.pendingInteraction.completed&&p.id===i){var l=this.getResponseHeader("content-length"),n=F(this.responseURL,this.getResponseHeader("content-encoding"),this.getResponseHeader("content-type"),l),K=this.getResponseHeader("sap-perf-fesrec");this.pendingInteraction.bytesReceived+=l?parseInt(l):0;this.pendingInteraction.bytesReceived+=this.getAllResponseHeaders().length;this.pendingInteraction.bytesSent+=this.requestHeaderLength||0;this.pendingInteraction.requestCompression=n&&(this.pendingInteraction.requestCompression!==false);this.pendingInteraction.networkTime+=K?Math.round(parseFloat(K,10)/1000):0;var N=this.getResponseHeader("sap-statistics");if(N){var T=window.performance.getEntriesByType("resource");this.pendingInteraction.sapStatistics.push({url:this.responseURL,statistics:N,timing:T?T[T.length-1]:undefined});}delete this.requestHeaderLength;delete this.pendingInteraction;}}}var J={getAll:function(i){if(i){J.end(true);}return d;},filter:function(n){var K=[];if(n){for(var i=0,l=d.length;i<l;i++){if(n(d[i])){K.push(d[i]);}}}return K;},getPending:function(){return p;},clear:function(){d=[];},start:function(T,i){var l=a();if(p){o(l);}if(x){clearTimeout(x);}z=0;if(window.performance.clearResourceTimings){window.performance.clearResourceTimings();}var n=q(i);p=f(l);p.event=T;p.component=n.id;p.appVersion=n.version;p.start=l;if(i&&i.getId){p.trigger=i.getId();}if(b.isLoggable(null,"sap.ui.Performance")){console.time("INTERACTION: "+p.trigger+" - "+p.event);}if(b.isLoggable()){b.debug("Interaction step started: trigger: "+p.trigger+"; type: "+p.event,"Interaction.js");}},end:function(i){if(p){if(i){if(b.isLoggable(null,"sap.ui.Performance")){console.timeEnd("INTERACTION: "+p.trigger+" - "+p.event);}o(p.preliminaryEnd||a());if(b.isLoggable()){b.debug("Interaction ended...");}}else{p.preliminaryEnd=a();p.processing=p.preliminaryEnd-p.start;}}},getActive:function(){return r;},setActive:function(i){if(i&&!r){E();D();L.notifyResourceLoading=J.notifyAsyncStep;}r=i;},notifyNavigation:function(){c=true;},notifyShowBusyIndicator:function(i){i._sapui_fesr_fDelayedStartTime=a()+i.getBusyIndicatorDelay();},notifyHideBusyIndicator:function(i){if(i._sapui_fesr_fDelayedStartTime){var l=a()-i._sapui_fesr_fDelayedStartTime;J.addBusyDuration((l>0)?l:0);delete i._sapui_fesr_fDelayedStartTime;}},notifyStepStart:function(i,l,n){if(r){if((!p&&v&&!t)||n){var T;if(n){T="startup";}else{T=i;}J.start(T,l);p=J.getPending();if(p&&!p.completed&&J.onInteractionStarted){p.passportAction=J.onInteractionStarted(p,n);}if(v){B=v.srcControl;}if(l&&l.getId&&B&&l.getId()===B.getId()){w=true;}v=null;t=true;c=false;setTimeout(function(){v=null;t=false;},0);}else if(p&&B&&!w){var K=B;if(K&&l.getId()===K.getId()){p.trigger=l.getId();p.event=i;w=true;}else{while(K&&K.getParent()){K=K.getParent();if(l.getId()===K.getId()){p.trigger=l.getId();p.event=i;break;}}}}}},notifyAsyncStep:function(i){if(p){if(b.isLoggable(null,"sap.ui.Performance")&&i){console.time(i);}var l=p.id;J.notifyAsyncStepStart();return function(){J.notifyAsyncStepEnd(l);if(b.isLoggable(null,"sap.ui.Performance")&&i){console.timeEnd(i);}};}else{return function(){};}},notifyAsyncStepStart:function(){if(p){z++;clearTimeout(x);y=false;if(b.isLoggable()){b.debug("Interaction relevant step started - Number of pending steps: "+z);}}},notifyAsyncStepEnd:function(i){if(p&&i===p.id){z--;J.notifyStepEnd(true);if(b.isLoggable()){b.debug("Interaction relevant step stopped - Number of pending steps: "+z);}}},notifyStepEnd:function(i){if(r&&!S){if(z===0||!i){if(y||!i){J.end(true);if(b.isLoggable()){b.debug("Interaction stopped");}y=false;}else{J.end();y=true;if(x){clearTimeout(x);}x=setTimeout(J.notifyStepEnd,250);if(b.isLoggable()){b.debug("Interaction check for idle time - Number of pending steps: "+z);}}}}},notifyEventStart:function(i){v=r?i:null;},notifyScrollEvent:function(i){},notifyEventEnd:function(){if(v){if(v.type.match(/^(mousedown|touchstart|keydown)$/)){J.end(true);}}},onInteractionStarted:null,onInteractionFinished:null,setStepComponent:function(i){if(r&&p&&i&&!p.stepComponent){p.stepComponent=i;}},addBusyDuration:function(i){if(r&&p){if(!p.busyDuration){p.busyDuration=0;}p.busyDuration+=i;}}};return J;});
