/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Element','sap/ui/core/Control','sap/ui/core/Core'],function(E,C){"use strict";if(typeof QUnit==="undefined"){sap.ui.requireSync("sap/ui/qunit/qunit-css");sap.ui.requireSync("sap/ui/thirdparty/qunit");sap.ui.requireSync("sap/ui/qunit/qunit-junit");sap.ui.requireSync("sap/ui/qunit/qunit-coverage");}QUnit.config.reorder=false;var M={};function g(){return E.registry.all();}var f=function(c){var p=c.getMetadata().getAllProperties();for(var P in p){if(c.isPropertyInitial(P)){var o=p[P];try{c[o._sMutator]("dummyValueForMemLeakTest");}catch(e){}}}if(!c.getTooltip()){c.setTooltip("test");}};var _=function(c,a,s,b){QUnit.test("Control "+c+" should not have any memory leaks",function(h){var o=a();h.ok(o,"calling fnControlFactory() should return something (a control)");h.ok(o instanceof C,"calling fnControlFactory() should return something that is really instanceof sap.ui.core.Control");if(o.placeAt&&!b){try{o.getMetadata().getRenderer();}catch(e){h.ok(false,"Error: control does not have a renderer. If this is known, please set the 'bControlCannotRender' flag when calling MemoryLeakCheck.checkControl");}}f(o);if(o.placeAt&&!b){try{o.placeAt("qunit-fixture");sap.ui.getCore().applyChanges();}catch(e){h.ok(false,"Error: control has a renderer, but could not be rendered. If this is known, please set the 'bControlCannotRender' flag when calling MemoryLeakCheck.checkControl");throw e;}}if(s){s(o);sap.ui.getCore().applyChanges();}o.destroy();sap.ui.getCore().applyChanges();var p=g(),i=a();f(i);if(i.placeAt&&!b){i.placeAt("qunit-fixture");sap.ui.getCore().applyChanges();i.rerender();sap.ui.getCore().applyChanges();}if(s){s(i);sap.ui.getCore().applyChanges();}i.destroy();sap.ui.getCore().applyChanges();var P=g();d(h,P,p,"Memory leak check should not find any leftover controls after creating two instances and rendering twice"+(s?"\n(and calling fnSomeAdditionalFunction)":""));});};var d=function(a,A,e,m){var u=[];for(var I in A){if(!e[I]){u.push(A[I]);}}for(var i=0;i<u.length;i++){if(typeof u[i].getText==="function"){u[i]+=" (text: '"+u[i].getText()+"')";}}m=m+(u.length>0?". LEFTOVERS: "+u.join(", "):"");a.equal(u.length,0,m);};M.checkControl=function(c,a,s,b){if(typeof c!=="string"){b=s;s=a;a=c;c="[some control, id: "+Math.random()+" - please update your test to also pass the control name]";}if(s===true||s===false){b=s;s=undefined;}var o;QUnit.module("MemoryLeakCheck.checkControl: "+c,{beforeEach:function(){o=g();},afterEach:function(e){E.registry.forEach(function(h,i){if(!o[i]){e.ok(h.getMetadata().getName(),"Cleanup of id: "+i+", control: "+h.getMetadata().getName());h.destroy();}});}});QUnit.test("MemoryLeakCheck.checkControl(fnControlFactory) should receive a control factory",function(e){e.equal(typeof a,"function","MemoryLeakCheck should have received a control factory");e.ok(document.getElementById("qunit-fixture"),"the test page HTML should contain an element with ID 'qunit-fixture'");});_(c,a,s,b);};return M;},true);
