/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/strings/capitalize","sap/base/util/UriParameters","sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/core/BusyIndicator","sap/ui/dt/DesignTime","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/events/KeyCodes","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/apply/api/SmartVariantManagementApplyAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/library","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/command/BaseCommand","sap/ui/rta/command/LREPSerializer","sap/ui/rta/command/Stack","sap/ui/rta/service/index","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/FioriLike","sap/ui/rta/toolbar/Personalization","sap/ui/rta/toolbar/Standalone","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/rta/util/PluginManager","sap/ui/rta/util/PopupManager","sap/ui/rta/util/ServiceEventBus","sap/ui/rta/util/validateFlexEnabled","sap/ui/rta/Utils","sap/ui/Device"],function(c,U,L,M,a,q,b,B,D,d,E,O,e,f,K,F,S,g,P,R,V,h,i,j,k,J,l,m,n,o,C,p,r,s,t,u,v,w,x,y,z,A,G){"use strict";var H="STARTING";var I="STARTED";var N="STOPPED";var Q="FAILED";var T="SERVICE_STARTING";var W="SERVICE_STARTED";var X="SERVICE_FAILED";var Y=b.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},flexSettings:{type:"object",defaultValue:{layer:h.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:N,_bHasSwitchedToNavigationMode:false,constructor:function(){b.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this._mUShellServices={};this._pElementModified=Promise.resolve();this.addDependent(new w(),"pluginManager");this.addDependent(new x(),"popupManager");if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);this.addDependent(new v(),"changeVisualization");}if(window.parent!==window){this.startService("receiver");}if(this._shouldValidateFlexEnabled()){this.attachEvent("start",z.bind(null,this));}this._loadUShellServicesPromise=k.getUShellServices(["URLParsing","AppLifeCycle","CrossApplicationNavigation"]).then(function(c1){this._mUShellServices=c1;}.bind(this));},_RELOAD:{NOT_NEEDED:"NO_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION",RELOAD_PAGE:"HARD_RELOAD"}});Y.prototype._shouldValidateFlexEnabled=function(){var c1=document.location.hostname;var d1=c1.endsWith(".sap"+".corp")||c1==="localhost";if(d1){var e1=U.fromQuery(window.location.search).get("sap-ui-rta-skip-flex-validation");d1=e1!=="true";}return d1;};Y.prototype.addDependent=function(c1,d1,e1){e1=typeof e1==="undefined"?true:!!e1;if(!(d1 in this._dependents)){if(d1&&e1){this["get"+c(d1,0)]=this.getDependent.bind(this,d1);}this._dependents[d1||c1.getId()]=c1;}else{throw f.createError("RuntimeAuthoring#addDependent",f.printf("Can't add dependency with same key '{0}'",d1),"sap.ui.rta");}};Y.prototype.getDependent=function(c1){return this._dependents[c1];};Y.prototype.getDependents=function(){return this._dependents;};Y.prototype.removeDependent=function(c1){delete this._dependents[c1];};Y.prototype.onPopupOpen=function(c1){var d1=c1.getParameters().getSource();if(d1.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};Y.prototype.onPopupClose=function(c1){if(c1.getParameters().isA("sap.m.Dialog")){this.getToolbar().setColor();}};Y.prototype.setPlugins=function(c1){if(this._sStatus!==N){throw new Error("Cannot replace plugins: runtime authoring already started");}this.getPluginManager().setPlugins(c1);};Y.prototype.getPlugins=function(){return this.getPluginManager&&this.getPluginManager()&&this.getPluginManager().getPlugins();};Y.prototype.getDefaultPlugins=function(){return this.getPluginManager().getDefaultPlugins(this.getFlexSettings());};Y.prototype.setFlexSettings=function(c1){var d1=U.fromQuery(window.location.search);var e1=d1.get("sap-ui-layer");c1=q.extend({},this.getFlexSettings(),c1);if(e1){c1.layer=e1.toUpperCase();}if(c1.scenario||c1.baseId){var f1=k.buildLrepRootNamespace(c1.baseId,c1.scenario,c1.projectId);c1.rootNamespace=f1;c1.namespace=f1+"changes/";}A.setRtaStyleClassName(c1.layer);this.setProperty("flexSettings",c1);};Y.prototype.getLayer=function(){return this.getFlexSettings().layer;};Y.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};Y.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};Y.prototype._setVersionsModel=function(c1){this._oVersionsModel=c1;};Y.prototype._initVersioning=function(){return V.initialize({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(this._setVersionsModel.bind(this));};function Z(c1,d1){if(c1.isA("sap.ui.core.UIComponent")){c1=c1.getRootControl();}if(c1){c1[d1?"addStyleClass":"removeStyleClass"]("sapUiRtaRoot");}}Y.prototype.start=function(){var c1;var d1;if(this._sStatus===N){this._sStatus=H;var e1=this.getRootControlInstance();if(!e1){d1=new Error("Root control not found");L.error(d1);return Promise.reject(d1);}return this._loadUShellServicesPromise.then(this._initVersioning.bind(this)).then(this._determineReload.bind(this)).then(function(f1){if(f1){return Promise.reject("Reload triggered");}this._oSerializer=new o({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});this.getPluginManager().preparePlugins(this.getFlexSettings(),this._handleElementModified.bind(this),this.getCommandStack());var g1=this.getPluginManager().getPluginList();c1=new Promise(function(h1,i1){l.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:g1});Z(this.getRootControlInstance(),true);this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()===h.USER){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(j1){this.fireSelectionChange({selection:j1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){h1();l.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(j1){i1(j1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);return undefined;}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getToolbarButtonsVisibility().then(this._createToolsMenu.bind(this));}return undefined;}.bind(this)).then(this._onStackModified.bind(this)).then(function(){O.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidth",d.getScrollbarWidth()+"px");O.getOverlayContainer().get(0).style.setProperty("--sap-ui-rta-scrollbar-scrollWidthPlusTwo",d.getScrollbarWidth()+2+"px");return c1;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}return undefined;}.bind(this)).then(function(){if(G.browser.name==="ff"){q(document).on("contextmenu",_);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);}.bind(this)).then(function(){this._sStatus=I;this.fireStart({editablePluginsCount:this.getPluginManager().getEditableOverlaysCount()});}.bind(this)).catch(function(d1){if(d1!=="Reload triggered"){this._sStatus=Q;this.fireFailed(d1);}if(d1){this.destroy();return Promise.reject(d1);}return undefined;}.bind(this));}return undefined;};function _(){return false;}Y.prototype._getToolbarButtonsVisibility=function(){return g.isPublishAvailable().then(function(c1){return m.isSaveAsAvailable(this.getRootControlInstance(),this.getLayer(),this._oSerializer).then(function(d1){return{publishAvailable:c1,saveAsAvailable:c1&&d1};});}.bind(this));};Y.prototype._isOldVersionDisplayed=function(){return V.isOldVersionDisplayed({selector:this.getRootControlInstance(),layer:this.getLayer()});};Y.prototype._isDraftAvailable=function(){return V.isDraftAvailable({selector:this.getRootControlInstance(),layer:this.getLayer()});};var $=function(c1){B.hide();var d1=c1.userMessage||c1.stack||c1.message||c1.status||c1;var e1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");L.error("Failed to transfer changes",d1);var f1=e1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+e1.getText("MSG_ERROR_REASON",d1);M.error(f1,{styleClass:A.getRtaStyleClassName()});};Y.prototype.setCommandStack=function(c1){var d1=this.getProperty("commandStack");if(d1){d1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var e1=this.setProperty("commandStack",c1);if(c1){c1.attachModified(this._onStackModified,this);}if(this.getPluginManager&&this.getPluginManager()){this.getPluginManager().provideCommandStack("settings",c1);}return e1;};Y.prototype.getCommandStack=function(){var c1=this.getProperty("commandStack");if(!c1){c1=new C();this._oInternalCommandStack=c1;this.setCommandStack(c1);}return c1;};Y.prototype._onStackModified=function(){var c1=this._oVersionsModel.getProperty("/backendDraft");var d1=this._oVersionsModel.getProperty("/displayedVersion")===sap.ui.fl.Versions.Draft;var e1=this.getCommandStack();var f1=e1.canUndo();if(!this.getShowToolbars()||!f1||this._bUserDiscardedDraft||d1||!c1){return this._modifyStack();}return A.showMessageBox("warning","MSG_DRAFT_DISCARD_AND_CREATE_NEW_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_DIALOG",actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK}).then(function(g1){if(g1===M.Action.OK){this._discardDraftConfirmed();}else{this.undo();}}.bind(this));};Y.prototype._discardDraftConfirmed=function(){this._bUserDiscardedDraft=true;this._modifyStack();};Y.prototype._modifyStack=function(){if(this.getShowToolbars()){var c1=this.getCommandStack();var d1=c1.canUndo();var e1=c1.canRedo();this._oVersionsModel.setDirtyChanges(d1);this._oToolbarControlsModel.setProperty("/undoEnabled",d1);this._oToolbarControlsModel.setProperty("/redoEnabled",e1);this._oToolbarControlsModel.setProperty("/publishEnabled",this.bInitialPublishEnabled||d1);this._oToolbarControlsModel.setProperty("/restoreEnabled",this.bInitialResetEnabled||d1);}this.fireUndoRedoStackModified();return Promise.resolve();};Y.prototype._checkToolbarAndExecuteFunction=function(c1,d1){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[c1](d1);}return undefined;};Y.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};function a1(){return Promise.resolve(this._oDesignTime&&this._oDesignTime.waitForBusyPlugins()).then(function(){return this._pElementModified;}.bind(this));}Y.prototype.stop=function(c1,d1){this._checkToolbarAndExecuteFunction("setBusy",true);return a1.call(this).then(this._handleReloadOnExit.bind(this,d1)).then(function(e1){return((c1)?Promise.resolve():this._serializeToLrep(this)).then(this._checkToolbarAndExecuteFunction.bind(this,"hide",c1)).then(function(){this.fireStop();if(e1.reloadMethod&&(e1.reloadMethod!==this._RELOAD.NOT_NEEDED)){e1.deleteMaxLayer=true;e1.onExit=true;e1.triggerHardReload=(e1.reloadMethod===this._RELOAD.RELOAD_PAGE);return this._handleUrlParameterOnExit(e1);}return undefined;}.bind(this));}.bind(this)).catch($).then(function(){this._checkToolbarAndExecuteFunction("setBusy",false);this._sStatus=N;q("body").removeClass("sapUiRtaMode");}.bind(this));};Y.prototype.restore=function(){return this._onRestore();};Y.prototype.transport=function(){return this._onTransport();};Y.prototype.undo=function(){return this._onUndo();};Y.prototype.redo=function(){return this._onRedo();};Y.prototype.canUndo=function(){return this.getCommandStack().canUndo();};Y.prototype.canRedo=function(){return this.getCommandStack().canRedo();};Y.prototype._onKeyDown=function(c1){var d1=G.os.macintosh;var e1=O.getOverlayContainer().get(0).contains(document.activeElement);var f1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var g1=false;q(".sapUiDtContextMenu").each(function(k1,l1){if(l1.contains(document.activeElement)){g1=true;}});var h1=document.body===document.activeElement;var i1=q(document.activeElement).parents(".sapUiRtaEditableField").length>0;if((e1||f1||g1||h1)&&!i1){var j1=d1?c1.metaKey:c1.ctrlKey;if(c1.keyCode===K.Z&&c1.shiftKey===false&&c1.altKey===false&&j1===true){this._onUndo().then(c1.stopPropagation.bind(c1));}else if(((d1&&c1.keyCode===K.Z&&c1.shiftKey===true)||(!d1&&c1.keyCode===K.Y&&c1.shiftKey===false))&&c1.altKey===false&&j1===true){this._onRedo().then(c1.stopPropagation.bind(c1));}}};Y.prototype._onUnload=function(){var c1=this.getCommandStack();var d1=c1.canUndo()||c1.canRedo();if(d1&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES");}window.onbeforeunload=this._oldUnloadHandler;return undefined;};Y.prototype._serializeAndSave=function(){return this._oSerializer.saveCommands(this._oVersionsModel.getProperty("/versioningEnabled"),this.getLayer(),true);};Y.prototype._serializeToLrep=function(){if(!this._bReloadNeeded){return this._oSerializer.needsReload().then(function(c1){this._bReloadNeeded=c1;return this._serializeAndSave();}.bind(this));}return this._serializeAndSave();};Y.prototype._onUndo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().undo();};Y.prototype._onRedo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().redo();};Y.prototype._onActivate=function(c1){var d1=c1.getParameter("versionTitle");if(this._isOldVersionDisplayed()&&this._isDraftAvailable()){return A.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK}).then(function(e1){if(e1===M.Action.OK){this._activate(d1);}}.bind(this));}return this._activate(d1);};Y.prototype._activate=function(c1){var d1=this.getLayer();var e1=this.getRootControlInstance();return V.activate({layer:d1,selector:e1,title:c1}).then(function(){this._showMessageToast("MSG_DRAFT_ACTIVATION_SUCCESS");this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restoreEnabled",true);this.getCommandStack().removeAllCommands();}.bind(this)).catch(function(f1){A.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:f1});});};Y.prototype._handleDiscard=function(){var c1=this.getLayer();var d1={isDraftAvailable:false,layer:c1};Y.enableRestart(c1,this.getRootControlInstance());if(!k.getUshellContainer()){this.getCommandStack().removeAllCommands();return this._triggerHardReload(d1);}var e1=true;this.getCommandStack().removeAllCommands();var f1=this._removeVersionParameterForFLP(d1,k.getParsedURLHash(this._getUShellService("URLParsing")),e1);this._triggerCrossAppNavigation(f1);return this.stop(true,true);};Y.prototype._onDiscardDraft=function(){return A.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK}).then(function(c1){if(c1===M.Action.OK){return V.discardDraft({layer:this.getLayer(),selector:this.getRootControlInstance(),updateState:true}).then(this._handleDiscard.bind(this));}return undefined;}.bind(this));};Y.prototype._onSwitchVersion=function(c1){var d1=c1.getParameter("version");var e1=this._oVersionsModel.getProperty("/displayedVersion");if(d1===e1){return;}if(this.canUndo()){this._sSwitchToVersion=d1;A.showMessageBox("warning","MSG_SWITCH_VERSION_DIALOG",{titleKey:"TIT_SWITCH_VERSION_DIALOG",actions:[M.Action.YES,M.Action.NO,M.Action.CANCEL],emphasizedAction:M.Action.YES}).then(function(f1){if(f1===M.Action.YES){this._serializeToLrep(this).then(this._switchVersion.bind(this,this._sSwitchToVersion));}else if(f1===M.Action.NO){this.getCommandStack().removeAllCommands(true);this._switchVersion(this._sSwitchToVersion);}return undefined;}.bind(this));return;}this._switchVersion(d1);};Y.prototype._switchVersion=function(c1){Y.enableRestart(this.getLayer(),this.getRootControlInstance());if(!k.getUshellContainer()){if(!R.hasVersionParameterWithValue({value:c1},this._getUShellService("URLParsing"))){var d1={versionSwitch:true,version:c1};return this._triggerHardReload(d1);}return this._reloadPage();}var e1=k.getParsedURLHash(this._getUShellService("URLParsing"));V.loadVersionForApplication({selector:this.getRootControlInstance(),layer:this.getLayer(),version:c1});var f1=e1.params[sap.ui.fl.Versions.UrlParameter];if(f1&&f1[0]===c1&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}else{e1.params[sap.ui.fl.Versions.UrlParameter]=c1;this._triggerCrossAppNavigation(e1);}return undefined;};Y.prototype._setUriParameter=function(c1){document.location.search=c1;};Y.prototype._createToolsMenu=function(c1){if(!this.getDependent("toolbar")){var d1=this.getLayer()===h.USER;var e1={rtaInformation:{flexSettings:this.getFlexSettings(),rootControl:this.getRootControlInstance(),commandStack:this.getCommandStack()},textResources:this._getTextResources(),restore:this._onRestore.bind(this),exit:this.stop.bind(this,false,d1)};if(!d1){e1.transport=this._onTransport.bind(this);e1.undo=this._onUndo.bind(this);e1.redo=this._onRedo.bind(this);e1.modeChange=this._onModeChange.bind(this);e1.activate=this._onActivate.bind(this);e1.discardDraft=this._onDiscardDraft.bind(this);e1.switchVersion=this._onSwitchVersion.bind(this);e1.onCommandCategorySelection=this.getChangeVisualization?this.getChangeVisualization().onCommandCategorySelection.bind(this.getChangeVisualization()):function(){};}var f1;if(d1){f1=new t(e1);}else if(A.isOriginalFioriToolbarAccessible()){f1=new r(e1);}else if(A.getFiori2Renderer()){f1=new s(e1);}else{f1=new u(e1);}this.addDependent(f1,"toolbar");return f1.onFragmentLoaded().then(function(){var g1=c1.saveAsAvailable;var h1=g1&&m.isOverviewExtended();var i1=U.fromURL(window.location.href);var j1;if(i1.has("fiori-tools-rta-mode")&&i1.get("fiori-tools-rta-mode")!=="false"){j1=false;}else{j1=true;}this._oToolbarControlsModel=new J({undoEnabled:false,redoEnabled:false,translationVisible:false,translationEnabled:false,publishVisible:c1.publishAvailable,publishEnabled:this.bInitialPublishEnabled,restoreEnabled:this.bInitialResetEnabled,appVariantsOverviewVisible:g1&&h1,appVariantsOverviewEnabled:g1&&h1,saveAsVisible:g1,saveAsEnabled:false,manageAppsVisible:g1&&!h1,manageAppsEnabled:g1&&!h1,modeSwitcher:this.getMode(),visualizationButtonVisible:j1});if(g1){m.isManifestSupported().then(function(k1){this._oToolbarControlsModel.setProperty("/saveAsEnabled",k1);this._oToolbarControlsModel.setProperty("/appVariantsOverviewEnabled",k1);this._oToolbarControlsModel.setProperty("/manageAppsEnabled",k1);}.bind(this));}this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");}.bind(this));}return Promise.resolve();};Y.prototype.destroy=function(){q.map(this._dependents,function(c1,d1){this.removeDependent(d1);c1.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(c1){this.stopService(c1);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);}if(this.getRootControlInstance()){Z(this.getRootControlInstance(),false);}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(G.browser.name==="ff"){q(document).off("contextmenu",_);}window.onbeforeunload=this._oldUnloadHandler;b.prototype.destroy.apply(this,arguments);};Y.prototype._onTransport=function(){this.getPluginManager().handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();var c1=k.isVariantByStartupParameter(this._oRootControl);var d1=S.isApplicationVariant({control:this._oRootControl})&&!c1;return(d1?m.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(e1){var f1=[];if(e1){f1.push(e1);}return P.publish({selector:this.getRootControlInstance(),styleClass:A.getRtaStyleClassName(),layer:this.getLayer(),appVariantDescriptors:f1}).then(function(g1){if(g1!=="Error"&&g1!=="Cancel"){a.show(g1);if(this.getShowToolbars()){P.getResetAndPublishInfo({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(h1){this._oToolbarControlsModel.setProperty("/publishEnabled",h1.isPublishEnabled);this._oToolbarControlsModel.setProperty("/restoreEnabled",h1.isResetEnabled);}.bind(this));}}}.bind(this));}.bind(this));}.bind(this))["catch"]($);};Y.prototype._deleteChanges=function(){var c1=this.getLayer();var d1=k.getAppComponentForControl(this.getRootControlInstance());return P.reset({selector:d1,layer:c1}).then(function(){R.removeInfoSessionStorage(d1);var e1={isDraftAvailable:R.hasVersionParameterWithValue({value:c1},this._getUShellService("URLParsing")),layer:c1,deleteMaxLayer:false,triggerHardReload:true};return this._handleUrlParameterOnExit(e1);}.bind(this)).catch(function(e1){if(e1!=="cancel"){A.showMessageBox("error","MSG_RESTORE_FAILED",{error:e1});}});};Y.prototype._reloadPage=function(){window.location.reload();};Y.prototype._showMessageToast=function(c1,d1){var e1=this._getTextResources().getText(c1);a.show(e1,d1||{});};Y.needsRestart=function(c1){return!!window.sessionStorage.getItem("sap.ui.rta.restart."+c1);};Y.enableRestart=function(c1,d1){var e1=F.getFlexReference({element:d1});var f1=e1||true;window.sessionStorage.setItem("sap.ui.rta.restart."+c1,f1);};Y.disableRestart=function(c1){window.sessionStorage.removeItem("sap.ui.rta.restart."+c1);};Y.prototype._onRestore=function(){var c1=this.getLayer();var d1=c1===h.USER?"FORM_PERS_RESET_MESSAGE_PERSONALIZATION":"FORM_PERS_RESET_MESSAGE";var e1=c1===h.USER?"BTN_RESTORE":"FORM_PERS_RESET_TITLE";this.getPluginManager().handleStopCutPaste();return A.showMessageBox("warning",d1,{titleKey:e1,actions:[M.Action.OK,M.Action.CANCEL],emphasizedAction:M.Action.OK}).then(function(f1){if(f1===M.Action.OK){Y.enableRestart(c1,this.getRootControlInstance());return this._deleteChanges().then(function(){this.getCommandStack().removeAllCommands();}.bind(this));}return undefined;}.bind(this));};Y.prototype._scheduleOnCreated=function(c1,d1){function e1(f1){var g1=f1.getParameter("elementOverlay");if(g1.getElement().getId()===c1){this._oDesignTime.detachEvent("elementOverlayCreated",e1,this);d1(g1);}}this._oDesignTime.attachEvent("elementOverlayCreated",e1,this);};Y.prototype._scheduleOnCreatedAndVisible=function(c1,d1){function e1(g1){var h1=g1.getSource();if(h1.getGeometry()&&h1.getGeometry().visible){h1.detachEvent("geometryChanged",e1);d1(h1);}}function f1(g1){if(!g1.getGeometry()||!g1.getGeometry().visible){g1.attachEvent("geometryChanged",e1);}else{d1(g1);}}this._scheduleOnCreated(c1,function(g1){if(g1.isRendered()){f1(g1);}else{g1.attachEventOnce("afterRendering",function(h1){f1(h1.getSource());});}});};Y.prototype._scheduleRenameOnCreatedContainer=function(c1,d1){var e1=function(f1){f1.setSelected(true);this.getPluginManager().getPlugin("rename").startEdit(f1);}.bind(this);this._scheduleOnCreatedAndVisible(d1,function(f1){var g1=this.getPluginManager().getPlugin("createContainer").getCreatedContainerId(c1,f1.getElement().getId());var h1=e.getOverlay(g1);if(h1){e1(h1);}else{this._scheduleOnCreatedAndVisible(g1,e1);}}.bind(this));};Y.prototype._handleElementModified=function(c1){var d1=c1.getParameter("command");var e1=c1.getParameter("newControlId");var f1=c1.getParameter("action");this._pElementModified=this._pElementModified.then(function(){this.getPluginManager().handleStopCutPaste();if(d1 instanceof n){if(e1){this._scheduleOnCreated(e1,function(g1){var h1=g1.getDesignTimeMetadata();var i1=h1.getData().select;if(typeof i1==="function"){i1(g1.getElement());}});if(f1){this._scheduleRenameOnCreatedContainer(f1,e1);}}return this.getCommandStack().pushAndExecute(d1).catch(function(g1){if(g1&&g1.message&&g1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){A.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:g1});}L.error("sap.ui.rta: "+g1.message);});}}.bind(this));return this._pElementModified;};Y.prototype._buildNavigationArguments=function(c1){return{target:{semanticObject:c1.semanticObject,action:c1.action,context:c1.contextRaw},params:c1.params,appSpecificRoute:c1.appSpecificRoute,writeHistory:false};};Y.prototype._triggerCrossAppNavigation=function(c1){if((this.getLayer()!==h.USER)&&this._getUShellService("CrossApplicationNavigation")){this._getUShellService("CrossApplicationNavigation").toExternal(this._buildNavigationArguments(c1));return true;}return false;};Y.prototype._removeVersionParameterForFLP=function(c1,d1,e1){var f1=this.getLayer();if(f1===h.USER){return d1;}var g1=k.getParameter(j.Versions.UrlParameter,this._getUShellService("URLParsing"));if(g1){delete d1.params[j.Versions.UrlParameter];}else if((this._isDraftAvailable()||e1)&&!c1.hasHigherLayerChanges&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}return d1;};Y.prototype._removeMaxLayerParameterForFLP=function(c1,d1){if(c1.deleteMaxLayer&&c1.hasHigherLayerChanges){delete d1.params[i.FL_MAX_LAYER_PARAM];}return d1;};Y.prototype._handleUrlParameterOnExit=function(c1){if(!k.getUshellContainer()){return this._triggerHardReload(c1);}var d1=k.getParsedURLHash(this._getUShellService("URLParsing"));if(!d1){return undefined;}if(c1.allContexts&&!c1.hasHigherLayerChanges&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}d1=this._removeMaxLayerParameterForFLP(c1,d1);d1=this._removeVersionParameterForFLP(c1,d1,false);this._triggerCrossAppNavigation(d1);if(c1.triggerHardReload){this._reloadPage();}return undefined;};Y.prototype._getReloadMessageOnStart=function(c1){var d1;var e1=c1.layer===h.CUSTOMER;if(c1.hasHigherLayerChanges&&c1.isDraftAvailable){d1=e1?"MSG_VIEWS_OR_PERSONALIZATION_AND_DRAFT_EXISTS":"MSG_HIGHER_LAYER_CHANGES_AND_DRAFT_EXISTS";}else if(c1.hasHigherLayerChanges&&c1.allContexts){d1="MSG_RESTRICTED_CONTEXT_EXIST_AND_PERSONALIZATION";}else if(c1.hasHigherLayerChanges){d1=e1?"MSG_PERSONALIZATION_OR_PUBLIC_VIEWS_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";}else if(c1.isDraftAvailable){d1="MSG_DRAFT_EXISTS";}else if(c1.allContexts){d1="MSG_RESTRICTED_CONTEXT_EXIST";}return d1;};Y.prototype._getReloadMessageOnExit=function(c1){var d1=c1.layer===h.CUSTOMER;if(c1.hasHigherLayerChanges){if(!d1){return"MSG_RELOAD_WITH_ALL_CHANGES";}if(c1.isDraftAvailable){return"MSG_RELOAD_WITH_VIEWS_PERSONALIZATION_AND_WITHOUT_DRAFT";}if(c1.allContexts){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_RESTRICTED_CONTEXT";}return"MSG_RELOAD_WITH_PERSONALIZATION_AND_VIEWS";}if(c1.initialDraftGotActivated){return"MSG_RELOAD_ACTIVATED_DRAFT";}if(c1.isDraftAvailable){return"MSG_RELOAD_WITHOUT_DRAFT";}if(c1.changesNeedReload){return"MSG_RELOAD_NEEDED";}if(c1.allContexts){return"MSG_RELOAD_WITHOUT_ALL_CONTEXT";}return undefined;};Y.prototype._handleReloadMessageBoxOnExit=function(c1){var d1=this._getReloadMessageOnExit(c1);if(d1){return A.showMessageBox("information",d1,{titleKey:"HEADER_RELOAD_NEEDED"});}return Promise.resolve();};Y.prototype._triggerReloadOnStart=function(c1){if(this._getUShellService("CrossApplicationNavigation")){if(c1.isDraftAvailable){V.loadDraftForApplication({selector:c1.selector,layer:c1.layer});}else{V.loadVersionForApplication({selector:c1.selector,layer:c1.layer,allContexts:c1.allContexts});}}var d1=this._getReloadMessageOnStart(c1);if(!d1){return Promise.resolve();}return(this.getFlexSettings().developerMode?Promise.resolve():A.showMessageBox("information",d1)).then(function(){Y.enableRestart(c1.layer,this.getRootControlInstance());if(c1.allContexts&&!c1.hasHigherLayerChanges&&this._getUShellService("AppLifeCycle")){this._getUShellService("AppLifeCycle").reloadCurrentApp();}if(k.getUshellContainer()){var e1=R.handleParametersOnStart(c1);return this._triggerCrossAppNavigation(e1);}return this._triggerHardReload(c1);}.bind(this));};Y.prototype._determineReload=function(){var c1={hasHigherLayerChanges:false,isDraftAvailable:false,layer:this.getLayer(),selector:this.getRootControlInstance(),ignoreMaxLayerParameter:false,includeCtrlVariants:true,URLParsingService:this._getUShellService("URLParsing")};return R.getReloadReasonsForStart(c1).then(function(c1){var d1=P.getResetAndPublishInfoFromSession(c1.selector);this.bInitialResetEnabled=!!d1.isResetEnabled;this.bInitialPublishEnabled=!!d1.isPublishEnabled;if(c1.hasHigherLayerChanges||c1.isDraftAvailable||c1.allContexts){return this._triggerReloadOnStart(c1);}return undefined;}.bind(this));};Y.prototype._triggerHardReload=function(c1){c1.parameters=document.location.search;c1.URLParsingService=this._getUShellService("URLParsing");var d1=R.handleUrlParametersForStandalone(c1);if(document.location.search!==d1){this._setUriParameter(d1);return Promise.resolve();}return this._reloadPage();};Y.prototype._handleReloadOnExit=function(c1){if(c1){return Promise.resolve({reloadMethod:this._RELOAD.NOT_NEEDED});}var d1=this._bReloadNeeded?Promise.resolve(this._bReloadNeeded):this._oSerializer.needsReload();return d1.then(function(e1){var f1={layer:this.getLayer(),selector:this.getRootControlInstance(),changesNeedReload:e1,isDraftAvailable:this._oVersionsModel.getProperty("/draftAvailable"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion"),URLParsingService:this._getUShellService("URLParsing")};f1=R.getReloadMethod(f1);return this._handleReloadMessageBoxOnExit(f1).then(function(){return f1;});}.bind(this));};Y.prototype._onModeChange=function(c1){this.setMode(c1.getParameter("item").getKey());};Y.prototype.setMode=function(c1){var d1=this.getMode();if(d1!==c1){var e1=this.getChangeVisualization&&this.getChangeVisualization();if(c1==="visualization"||d1==="visualization"){e1.triggerModeChange(this.getRootControl(),this.getToolbar());}var f1=this.getPluginManager().getPlugin("tabHandling");var g1=this.getPluginManager().getPlugin("selection");if(d1==="navigation"||c1==="navigation"){this._oDesignTime.setEnabled(c1!=="navigation");f1[(c1==="navigation")?"restoreTabIndex":"removeTabIndex"]();}if(c1==="navigation"&&!this._bHasSwitchedToNavigationMode){this._showMessageToast("MSG_NAVIGATION_MODE_CHANGES_WARNING",{duration:5000});this._bHasSwitchedToNavigationMode=true;}f1[(c1==="adaptation")?"restoreOverlayTabIndex":"removeOverlayTabIndex"]();g1.setIsActive(!(c1==="visualization"));O.getOverlayContainer().toggleClass("sapUiRtaVisualizationMode",(c1==="visualization"));if(c1==="visualization"){q(".sapUiDtOverlayMovable").css("cursor","default");}else{q(".sapUiDtOverlayMovable").css("cursor","move");}this._oToolbarControlsModel.setProperty("/modeSwitcher",c1);this.setProperty("mode",c1);this.fireModeChanged({mode:c1});}};Y.prototype.setMetadataScope=function(c1){if(this._sStatus!==N){L.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty("metadataScope",c1);};function b1(c1){if(p.hasOwnProperty(c1)){return p[c1].replace(/\./g,"/");}return undefined;}Y.prototype.startService=function(c1){if(this._sStatus!==I){return new Promise(function(f1,g1){this.attachEventOnce("start",f1);this.attachEventOnce("failed",g1);}.bind(this)).then(function(){return this.startService(c1);}.bind(this),function(){return Promise.reject(f.createError("RuntimeAuthoring#startService",f.printf("Can't start the service '{0}' while RTA has been failed during a startup",c1),"sap.ui.rta"));});}var d1=b1(c1);var e1;if(!d1){return Promise.reject(f.createError("RuntimeAuthoring#startService",f.printf("Unknown service. Can't find any registered service by name '{0}'",c1),"sap.ui.rta"));}e1=this._mServices[c1];if(e1){switch(e1.status){case W:{return Promise.resolve(e1.exports);}case T:{return e1.initPromise;}case X:{return e1.initPromise;}default:{return Promise.reject(f.createError("RuntimeAuthoring#startService",f.printf("Unknown service status. Service name = '{0}'",c1),"sap.ui.rta"));}}}else{this._mServices[c1]=e1={status:T,location:d1,initPromise:new Promise(function(f1,g1){sap.ui.require([d1],function(h1){e1.factory=h1;if(!this._oServiceEventBus){this._oServiceEventBus=new y();}f.wrapIntoPromise(h1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,c1)).then(function(i1){if(this.bIsDestroyed){throw f.createError("RuntimeAuthoring#startService",f.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",c1),"sap.ui.rta");}if(!q.isPlainObject(i1)){throw f.createError("RuntimeAuthoring#startService",f.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",c1),"sap.ui.rta");}e1.service=i1;e1.exports={};if(Array.isArray(i1.events)&&i1.events.length>0){q.extend(e1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,c1),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,c1),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,c1)});}var j1=i1.exports||{};q.extend(e1.exports,Object.keys(j1).reduce(function(k1,l1){var m1=j1[l1];k1[l1]=typeof m1==="function"?f.waitForSynced(this._oDesignTime,m1):m1;return k1;}.bind(this),{}));e1.status=W;f1(Object.freeze(e1.exports));}.bind(this)).catch(g1);}.bind(this),function(h1){e1.status=X;g1(f.propagateError(h1,"RuntimeAuthoring#startService",f.printf("Can't load service '{0}' by its name: {1}",c1,d1),"sap.ui.rta"));});}.bind(this)).catch(function(f1){e1.status=X;return Promise.reject(f.propagateError(f1,"RuntimeAuthoring#startService",f.printf("Error during service '{0}' initialisation.",c1),"sap.ui.rta"));})};return e1.initPromise;}};Y.prototype.stopService=function(c1){var d1=this._mServices[c1];if(d1){if(d1.status===W){if(typeof d1.service.destroy==="function"){d1.service.destroy();}}delete this._mServices[c1];}else{throw f.createError("RuntimeAuthoring#stopService",f.printf("Can't destroy service: unable to find service with name '{0}'",c1),"sap.ui.rta");}};Y.prototype.getService=function(c1){return this.startService(c1);};Y.prototype._getUShellService=function(c1){return k.getUshellContainer()&&this._mUShellServices[c1];};return Y;});
