/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ColumnMenu","./utils/TableUtils","./library","sap/ui/core/Element","sap/ui/core/Popup","sap/ui/core/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/Type","sap/ui/model/type/String","sap/base/util/ObjectPath","sap/base/util/JSTokenizer","sap/base/util/deepClone","sap/base/Log"],function(C,T,a,E,P,c,F,b,d,S,f,g,O,J,h,L){"use strict";var H=c.HorizontalAlign,j=a.SortOrder,V=c.ValueState;var k={Standard:"Standard",Creation:"Creation"};var _=T.createWeakMapFacade();var m=new window.WeakMap();var n=E.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:H.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false},sortOrder:{type:"sap.ui.table.SortOrder",group:"Appearance",defaultValue:j.Ascending},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},menu:{type:"sap.ui.unified.Menu",multiple:false}},associations:{columnHeaderMenu:{type:"sap.ui.core.IColumnHeaderMenu",multiple:false,visibility:"hidden"}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});n._DEFAULT_FILTER_TYPE=new g();n.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};_(this).oSorter=null;_(this).mCellContentVisibilitySettings=q(this);_(this).bHasDefaultLabel=false;_(this).bHasDefaultTemplate=false;this._initTemplateClonePool();};n.prototype._initTemplateClonePool=function(){this._mTemplateClones=Object.keys(k).reduce(function(t,s){t[s]=[];return t;},{});};n.prototype.exit=function(){this._destroyTemplateClones();};n.prototype.setParent=function(){var R=E.prototype.setParent.apply(this,arguments);var M=this.getAggregation("menu");if(M&&typeof M._updateReferences==="function"){M._updateReferences(this);}return R;};n.prototype.invalidate=function(e){if(e!==this.getTemplate()&&e!==this.getCreationTemplate()&&!T.isA(e,"sap.ui.table.ColumnMenu")){E.prototype.invalidate.apply(this,arguments);}};n.prototype.setLabel=function(l){var e=l;if(typeof l==="string"){if(_(this).bHasDefaultLabel){this.getLabel().setText(l);return this;}e=a.TableHelper.createLabel({text:l});_(this).bHasDefaultLabel=true;}else if(_(this).bHasDefaultLabel){this.destroyLabel();_(this).bHasDefaultLabel=false;}return this.setAggregation("label",e);};n.prototype.setTemplate=function(t){var e=t;var i=this._getTable();var l=this.getTemplate();var N=true;if(typeof t==="string"){if(_(this).bHasDefaulTemplate){this.getTemplate().bindProperty("text",t);N=false;}else{e=a.TableHelper.createTextView().bindProperty("text",t);_(this).bHasDefaulTemplate=true;}}else if(_(this).bHasDefaulTemplate){this.destroyTemplate();_(this).bHasDefaulTemplate=false;}if(N){this.setAggregation("template",e,true);}if(this.getVisible()){this.invalidate();}this._destroyTemplateClones("Standard");if(i&&this.getVisible()){if(e){i.invalidateRowsAggregation();}if(!l||!e){var s=i.getCreationRow();if(s){s._update();}}}return this;};n.prototype.destroyTemplate=function(){this.destroyAggregation("template");this._destroyTemplateClones("Standard");var t=this._getTable();var e=t?t.getCreationRow():null;if(e){e._update();}return this;};n.prototype.setCreationTemplate=function(e){var t=this._getTable();this.setAggregation("creationTemplate",e,true);this._destroyTemplateClones("Creation");if(e&&t&&this.getVisible()){var i=t.getCreationRow();if(i){i._update();}}return this;};n.prototype.getCreationTemplate=function(){return this.getAggregation("creationTemplate");};n.prototype.destroyCreationTemplate=function(){this.destroyAggregation("creationTemplate",true);this._destroyTemplateClones("Creation");return this;};n.prototype.getMenu=function(){var M=this.getAggregation("menu");if(!M){M=this._createMenu();this.setMenu(M);}return M;};n.prototype.invalidateMenu=function(){var M=this.getAggregation("menu");if(this._bMenuIsColumnMenu){M._invalidate();}};n.prototype._menuHasItems=function(){var M=this.getAggregation("menu");var t=this._getTable();var e=(M?M.getItems().length>0:false)||(t?t.getEnableColumnFreeze():false)||(t?t.getShowColumnVisibilityMenu():false)||this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupable();if(e){return true;}return T.Hook.call(t,T.Hook.Keys.Column.MenuItemNotification,this).some(function(i){return i;});};n.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry());};n.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry());};n.prototype.isGroupable=function(){var t=this.getParent();return!!(t&&t.getEnableGrouping&&t.getEnableGrouping()&&this.getSortProperty());};n.prototype.setMenu=function(M){this.setAggregation("menu",M,true);this._bMenuIsColumnMenu=T.isA(M,"sap.ui.table.ColumnMenu");return this;};n.prototype._createMenu=function(){if(!this._defaultMenu){this._defaultMenu=new C(this.getId()+"-menu",{ariaLabelledBy:this});}return this._defaultMenu;};n.prototype.setSortProperty=function(s){this.setProperty("sortProperty",s);this.invalidateMenu();return this;};n.prototype.setSorted=function(e){this.setProperty("sorted",e,true);this._updateIcons();return this;};n.prototype.setSortOrder=function(t){this.setProperty("sortOrder",t,true);this._updateIcons();return this;};n.prototype.setFilterProperty=function(s){this.invalidateMenu();return this.setProperty("filterProperty",s);};n.prototype.setFiltered=function(e){this.setProperty("filtered",e,true);this._updateIcons();return this;};n.prototype.setFilterValue=function(s){this.setProperty("filterValue",s,true);var M=this.getMenu();if(this._bMenuIsColumnMenu){M._setFilterValue(s);}return this;};n.prototype.setFilterOperator=function(s){return this.setProperty("filterOperator",s,true);};n.prototype._openMenu=function(D){var M=this.getMenu();if(!this._menuHasItems()){return false;}var e=this.fireColumnMenuOpen({menu:M});if(e){var i=P.Dock;var l=D;if(!D){D=this.getDomRef();l=this.getFocusDomRef();}M.open(null,l,i.BeginTop,i.BeginBottom,D);return true;}else{return true;}};n.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===j.Ascending);};n.prototype.sort=function(D,A){var t=this.getParent();if(t){t.pushSortedColumn(this,A);var N=D?j.Descending:j.Ascending;var e=t.fireSort({column:this,sortOrder:N,columnAdded:A});if(e){var s=t.getSortedColumns();var u=t.getColumns();for(var i=0,l=u.length;i<l;i++){if(s.indexOf(u[i])<0){u[i].setProperty("sorted",false,true);u[i].setProperty("sortOrder",j.Ascending,true);u[i]._updateIcons(true);delete _(u[i]).oSorter;}}this.setProperty("sorted",true,true);this.setProperty("sortOrder",N,true);_(this).oSorter=new S(this.getSortProperty(),this.getSortOrder()===j.Descending);var w=[];for(var i=0,l=s.length;i<l;i++){s[i]._updateIcons(true);w.push(_(s[i]).oSorter);}t._resetColumnHeaderHeights();t._updateRowHeights(t._collectRowHeights(true),true);var B=t.getBinding();if(B){if(this._updateTableAnalyticalInfo){this._updateTableAnalyticalInfo(true);}B.sort(w);}else{L.warning("Sorting not performed because no binding present",this);}}}return this;};n.prototype._updateIcons=function(s){var t=this.getParent(),e=this.getSorted(),i=this.getFiltered();if(!t||!t.getDomRef()){return;}this.$().parents(".sapUiTableCHT").find('td[data-sap-ui-colindex="'+this.getIndex()+'"]:not([colspan]):not(.sapUiTableHidden):first').toggleClass("sapUiTableColFiltered",i).toggleClass("sapUiTableColSorted",e).toggleClass("sapUiTableColSortedD",e&&this.getSortOrder()===j.Descending);t._getAccExtension().updateAriaStateOfColumn(this);if(!s){t._resetColumnHeaderHeights();t._updateRowHeights(t._collectRowHeights(true),true);}};n.prototype._renderSortIcon=function(){this._updateIcons();};n.prototype._getFilter=function(){var e,s=this.getFilterProperty(),i=this.getFilterValue(),l=this.getFilterOperator(),t,u,w=this.getFilterType()||n._DEFAULT_FILTER_TYPE,I=w instanceof g,B;if(i){if(!l){B=i.match(/(.*)\s*\.\.\s*(.*)/);if(i.indexOf("=")==0){l=b.EQ;t=i.substr(1);}else if(i.indexOf("!=")==0){l=b.NE;t=i.substr(2);}else if(i.indexOf("<=")==0){l=b.LE;t=i.substr(2);}else if(i.indexOf("<")==0){l=b.LT;t=i.substr(1);}else if(i.indexOf(">=")==0){l=b.GE;t=i.substr(2);}else if(i.indexOf(">")==0){l=b.GT;t=i.substr(1);}else if(B){if(B[1]&&B[2]){l=b.BT;t=B[1];u=B[2];}else if(B[1]&&!B[2]){l=b.GE;t=B[1];}else{l=b.LE;t=B[2];}}else if(I&&i.indexOf("*")==0&&i.lastIndexOf("*")==i.length-1){l=b.Contains;t=i.substr(1,i.length-2);}else if(I&&i.indexOf("*")==0){l=b.EndsWith;t=i.substr(1);}else if(I&&i.lastIndexOf("*")==i.length-1){l=b.StartsWith;t=i.substr(0,i.length-1);}else{if(this.getDefaultFilterOperator()){l=this.getDefaultFilterOperator();}else{if(I){l=b.Contains;}else{l=b.EQ;}}t=i.substr(0);}if(!u){e=new F(s,l,this._parseFilterValue(t));}else{e=new F(s,l,this._parseFilterValue(t),this._parseFilterValue(u));}}else{e=new F(s,l,this._parseFilterValue(i));}}return e;};n.prototype.filter=function(s){var t=this.getParent();if(t&&t.isBound("rows")){var u=t.fireFilter({column:this,value:s});if(u){this.setProperty("filtered",!!s,true);this.setProperty("filterValue",s,true);var M=this.getMenu();if(this._bMenuIsColumnMenu){M._setFilterValue(s);}var w=[];var x=t.getColumns();for(var i=0,l=x.length;i<l;i++){var y=x[i],z;M=y.getMenu();try{z=y._getFilter();if(y._bMenuIsColumnMenu){M._setFilterState(V.None);}}catch(e){if(y._bMenuIsColumnMenu){M._setFilterState(V.Error);}continue;}if(z){w.push(z);}}t.getBinding().filter(w,d.Control);this._updateIcons();}}return this;};n.prototype._parseFilterValue=function(s){var e=this.getFilterType();if(e){if(typeof e==="function"){s=e(s);}else{s=e.parseValue(s,"string");}}return s;};n.prototype.shouldRender=function(){return this.getVisible()&&!this.getGrouped()&&this.getTemplate()!=null;};n.prototype.setProperty=function(N,e){var t=this._getTable();var i=t&&this.getProperty(N)!=e;var l=i&&N==="visible";var I=i&&(N==="visible"||N==="headerSpan");var R=E.prototype.setProperty.apply(this,arguments);if(l){t.invalidateRowsAggregation();var s=t.getCreationRow();if(s){s._update();}}if(I){t._invalidateComputedFixedColumnCount();}return R;};n.prototype.setFilterType=function(t){var e=t;if(typeof(t)==="string"){try{var i=J.parseJS(t);if(typeof(i.type)==="string"){var l=O.get(i.type);e=l&&new l(i.formatOptions,i.constraints);}}catch(s){var l=O.get(t);e=l&&new l();}if(!(e instanceof f)){L.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");e=undefined;}}this.setProperty("filterType",e,true);return this;};n.prototype.getIndex=function(){var t=this.getParent();if(t){return t.indexOfColumn(this);}else{return-1;}};n.prototype._getFreeTemplateClone=function(t){var e=this._mTemplateClones[t];var l=null;if(!e){return null;}for(var i=0;i<e.length;i++){if(!e[i]||e[i].bIsDestroyed){e.splice(i,1);i--;}else if(!l&&!e[i].getParent()){l=e[i];}}return l;};n.prototype.getTemplateClone=function(i,s){if(typeof i!=="number"||this.getTemplate()==null){return null;}var t=s==null?"Standard":s;var e=this._getFreeTemplateClone(t);if(!e&&k.hasOwnProperty(t)){var G=this["get"+(t==="Standard"?"":t)+"Template"];var l=G.call(this);if(l){e=l.clone();this._mTemplateClones[t].push(e);}}if(e){m.set(e,this);var u=this.getParent();if(u){u._getAccExtension().addColumnHeaderLabel(this,e);}}return e;};function o(e){for(var i=0;i<e.length;i++){if(e[i]!=null&&!e[i].bIsDestroyed){e[i].destroy();}}}n.prototype._destroyTemplateClones=function(t){if(t==null){for(var s in k){o(this._mTemplateClones[s]);}this._initTemplateClonePool();}else{o(this._mTemplateClones[t]);this._mTemplateClones[t]=[];}};n.prototype._closeMenu=function(){var M=this.getAggregation("menu");if(M){M.close();}};n.prototype._getTable=function(){var e=this.getParent();return T.isA(e,"sap.ui.table.Table")?e:null;};n.prototype._setCellContentVisibilitySettings=function(s){v(s);_(this).mCellContentVisibilitySettings=q(this,s);};n.prototype._getCellContentVisibilitySettings=function(){return _(this).mCellContentVisibilitySettings;};n.prototype.getColumnHeaderMenu=function(){return sap.ui.getCore().byId(this.getAssociation("columnHeaderMenu"));};function v(s){if(s==null){return;}p(s,null,false,["standard","groupHeader","summary"]);p(s.standard,"standard",true);p(s.groupHeader,"groupHeader",true,["nonExpandable","expanded","collapsed"]);p(s.summary,"summary",true,["group","total"]);}function p(e,s,A,i){if(e!=null&&!(A&&typeof e==="boolean"||i&&typeof e==="object")){throw new Error("Invalid value"+(s?" for '"+s+"'":""));}if(i&&e!=null&&typeof e==="object"){Object.keys(e).forEach(function(l){if(i.includes(l)){if(s!=null){p(e[l],s+"."+l,true);}}else{throw new Error("Unsupported setting '"+(s?s+".":"")+l+"'");}});}}function q(e,s){s=s?s:{};return{standard:r(s.standard),groupHeader:{nonExpandable:r(s.groupHeader,"nonExpandable"),expanded:r(s.groupHeader,"expanded"),collapsed:r(s.groupHeader,"collapsed")},summary:{group:r(s.summary,"group"),total:r(s.summary,"total")}};}function r(s,K){if(typeof s==="boolean"){return s;}else if(K&&s){return s[K]!==false;}else{return true;}}n.ofCell=function(e){return m.get(e)||null;};return n;});
