/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/core/Control','./ThingViewerRenderer','./library','./NavigationBar','sap/ui/core/ResizeHandler'],function(q,C,T,l,N,R){"use strict";var a=l.ThingViewerHeaderType;var b=C.extend("sap.ui.ux3.ThingViewer",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},subtitle:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100%'},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:a.Standard}},aggregations:{headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},navBar:{type:"sap.ui.ux3.NavigationBar",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}}}}});b.prototype.init=function(){var t=this;this._oNavBar=new N();this.setAggregation("navBar",this._oNavBar);this._oNavBar.attachSelect(function(c){var i=c.getParameters().item;if(t.fireFacetSelected({id:i.getId(),key:i.getKey(),item:i})){t.setSelectedFacet(i);}else{c.preventDefault();}});};b.prototype.onAfterRendering=function(){this._resize=false;if(this.getActionBar()){this._adjustStyles();}if(this.$().find(".sapUiUx3TVFacetContent").length<=0){return;}this._resizeListenerId=R.register(this.$().find(".sapUiUx3TVFacetContent")[0],q.proxy(this._onresize,this));this._setTriggerValue();this._setHeaderPosition();this._onresize();};b.prototype.onBeforeRendering=function(){if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};b.prototype._setHeaderPosition=function(){if(this.getHeaderType()===a.Standard){var $=this.$().find(".sapUiUx3TVHeaderContainerIdentifier"),c=this.$().find(".sapUiUx3TVHeaderGroupScrollContainer");c.css("top",$.outerHeight());}};b.prototype._onresize=function(e){var w;if(e){w=q(e.target).width();}if(!w){w=q(this.$().find(".sapUiUx3TVFacetContent")[0]).width();}if(w<this._triggerValue&&this._resize==false){var f=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<f.length;i++){q(f[i]).animate({width:"100%"},"fast");}this._resize=true;}else if(w>this._triggerValue&&this._resize==true){var f=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<f.length;i++){q(f[i]).animate({width:"50%"},"fast");}this._resize=false;}if(this.getActionBar()){var m=this.getActionBar().getActionBarMinWidth(),c=m;if(this._bShell){m+=36;c=m+60;}this.$().find(".sapUiUx3TV").css("min-width",c+"px");this.$().find(".sapUiUx3TVContent").css("min-width",m+"px");}};b.prototype.exit=function(){this._oNavBar.destroy();if(this._resizeListenerId){R.deregister(this._resizeListenerId);this._resizeListenerId=null;}};b.prototype._getNavBar=function(){return this._oNavBar;};b.prototype._selectDefault=function(){var n=this._oNavBar.getItems();if(n.length&&!this._oNavBar.getSelectedItem()){if(!this.getSelectedFacet()){this.setSelectedFacet(n[0]);}var i=this._oNavBar.getSelectedItem(),c=sap.ui.getCore().byId(i);this.fireFacetSelected({id:c.getId(),key:c.getKey(),item:c});}};b.prototype._equalColumns=function(){var h=this.$().find(".sapUiUx3TVHeader"),f=this.$().find(".sapUiUx3TVFacets"),s=this.$().find(".sapUiUx3TVContentScrollContainer"),c=s.get(0).scrollHeight;f.height(c);h.height(c);};b.prototype._rerenderHeader=function(){var $=this.$("header");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderHeader(r,this);r.flush($[0]);r.destroy();}};b.prototype._rerenderHeaderContent=function(){var $=this.$("headerContent");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderHeaderContent(r,this);r.flush($[0]);r.destroy();}};b.prototype._rerenderToolbar=function(){var $=this.$("toolbar");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderToolbar(r,this);r.flush($[0]);r.destroy();}};b.prototype._rerenderFacetContent=function(){var $=this.$("facetContent");if($.length>0){var r=sap.ui.getCore().createRenderManager();T.renderFacetContent(r,this);r.flush($[0]);r.destroy();this._resize=false;this._setTriggerValue();this._onresize();}};b.prototype._setTriggerValue=function(){var f,m,$=this.$("facetContent");if($.length>0){f=this.$().find(".sapUiUx3TVFacetThingGroup");m=q(f[0]).css("min-width");if(m){this._triggerValue=parseInt(m)*2;}}};b.prototype.getFacets=function(){return this._oNavBar.getItems();};b.prototype.insertFacet=function(f,i){this._oNavBar.insertItem(f,i);return this;};b.prototype.addFacet=function(f){this._oNavBar.addItem(f);return this;};b.prototype.removeFacet=function(e){return this._oNavBar.removeItem(e);};b.prototype.removeAllFacets=function(){return this._oNavBar.removeAllItems();};b.prototype.destroyFacets=function(){this._oNavBar.destroyItems();return this;};b.prototype.setIcon=function(i){this.setProperty("icon",i);if(this.getActionBar()){this.getActionBar().setThingIconURI(i);}this._rerenderHeader();return this;};b.prototype.insertFacetContent=function(f,i){this.insertAggregation("facetContent",f,i,true);this._rerenderFacetContent();return this;};b.prototype.addFacetContent=function(f){this.addAggregation("facetContent",f,true);this._rerenderFacetContent();return this;};b.prototype.removeFacetContent=function(f){var r=this.removeAggregation("facetContent",f,true);this._rerenderFacetContent();return r;};b.prototype.removeAllFacetContent=function(){var r=this.removeAllAggregation("facetContent",true);this._rerenderFacetContent();return r;};b.prototype.destroyFacetContent=function(){this.destroyAggregation("facetContent",true);this._rerenderFacetContent();return this;};b.prototype.insertHeaderContent=function(h,i){this.insertAggregation("headerContent",h,i,true);this._rerenderHeaderContent();return this;};b.prototype.addHeaderContent=function(h){this.addAggregation("headerContent",h,true);this._rerenderHeaderContent();return this;};b.prototype.removeHeaderContent=function(h){var r=this.removeAggregation("headerContent",h,true);this._rerenderHeaderContent();return r;};b.prototype.removeAllHeaderContent=function(){var r=this.removeAllAggregation("headerContent",true);this._rerenderHeaderContent();return r;};b.prototype.destroyHeaderContent=function(){this.destroyAggregation("headerContent",true);this._rerenderHeaderContent();return this;};b.prototype.setSelectedFacet=function(s){var o=this.getSelectedFacet();this.setAssociation("selectedFacet",s,true);var n=this.getSelectedFacet();if(o!=n){this._oNavBar.setSelectedItem(n);}return this;};b.prototype.setTitle=function(t){this.setProperty("title",t,true);this._rerenderHeader();return this;};b.prototype.setSubtitle=function(t){this.setProperty("subtitle",t,true);this._rerenderHeader();return this;};b.prototype.setActionBar=function(A){this.setAggregation("actionBar",A,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon());}this._rerenderToolbar();this._adjustStyles();return this;};b.prototype._adjustStyles=function(){var $=this.$().find(".sapUiUx3TVHeader"),c=this.$().find(".sapUiUx3TVFacets");if($.length>0){$.addClass("sapUiUx3TVActionBar");$.removeClass("sapUiUx3TVNoActionBar");}if(c.length>0){c.addClass("sapUiUx3TVActionBar");c.removeClass("sapUiUx3TVNoActionBar");}};return b;});
