sap.ui.define(['sap/ui/webc/common/thirdparty/base/renderer/LitRenderer'], function (litRender) { 'use strict';

	const block0 = (context, tags, suffix) => litRender.html`<div class="${litRender.classMap(context.classes.wrapper)}" dir="${litRender.ifDefined(context.effectiveDir)}" role="banner" aria-label="${litRender.ifDefined(context._shellbarText)}" part="root"><div class="ui5-shellbar-overflow-container ui5-shellbar-overflow-container-left">${ context.startButton.length ? block1() : undefined }${ context.hasFocusableLogo ? block2(context) : undefined }${ context.showArrowDown ? block3(context) : undefined }${ context.secondaryTitle ? block6(context) : undefined }</div><div class="ui5-shellbar-overflow-container ui5-shellbar-overflow-container-middle">${ context.showCoPilot ? block7(context) : block10() }</div><div class="ui5-shellbar-overflow-container ui5-shellbar-overflow-container-right"><div class="ui5-shellbar-overflow-container-right-child">${ context.hasSearchField ? block11(context, tags, suffix) : undefined }${ litRender.repeat(context.customItemsInfo, (item, index) => item._id || index, (item, index) => block14(item, index, context, tags, suffix)) }${ context.showNotifications ? block15(context, tags, suffix) : undefined }<${litRender.scopeTag("ui5-button", tags, suffix)} id="${litRender.ifDefined(context._id)}-item-5" style="${litRender.styleMap(context.styles.items.overflow)}" class="${litRender.classMap(context.classes.items.overflow)} ui5-shellbar-button ui5-shellbar-overflow-button-shown ui5-shellbar-overflow-button" icon="sap-icon://overflow" @click="${context._handleOverflowPress}" title="${litRender.ifDefined(context._overflowText)}" ._buttonAccInfo="${litRender.ifDefined(context.accInfo.overflow)}" data-ui5-stable="overflow"></${litRender.scopeTag("ui5-button", tags, suffix)}>${ context.hasProfile ? block16(context, tags, suffix) : undefined }${ context.showProductSwitch ? block17(context, tags, suffix) : undefined }</div></div></div> `;
	const block1 = (context, tags, suffix) => litRender.html`<slot name="startButton"></slot>`;
	const block2 = (context, tags, suffix) => litRender.html`<span class="ui5-shellbar-logo" role="button" aria-label="${litRender.ifDefined(context._logoText)}" title="${litRender.ifDefined(context._logoText)}" @click="${context._logoPress}" @keydown="${context._logoKeydown}" @keyup="${context._logoKeyup}" tabindex="0" data-ui5-stable="logo"><slot name="logo"></slot></span>`;
	const block3 = (context, tags, suffix) => litRender.html`<button tabindex="${litRender.ifDefined(context.menuBtnTabindex)}" class="${litRender.classMap(context.classes.button)}" @click="${context._header.press}" aria-haspopup="${litRender.ifDefined(context.menuBtnHasPopup)}" aria-expanded="${litRender.ifDefined(context.menuPopoverExpanded)}">${ context.hasNonFocusableLogo ? block4(context) : undefined }${ context.primaryTitle ? block5(context) : undefined }<span class="ui5-shellbar-menu-button-arrow"></span></button>`;
	const block4 = (context, tags, suffix) => litRender.html`<span class="ui5-shellbar-logo" aria-label="${litRender.ifDefined(context._logoText)}" title="${litRender.ifDefined(context._logoText)}"><slot name="logo"></slot></span>`;
	const block5 = (context, tags, suffix) => litRender.html`<h1 class="ui5-shellbar-menu-button-title"><bdi class="${litRender.classMap(context.classes.title)}">${litRender.ifDefined(context.primaryTitle)}</bdi></h1>`;
	const block6 = (context, tags, suffix) => litRender.html`<h2 class="ui5-shellbar-secondary-title">${litRender.ifDefined(context.secondaryTitle)}</h2>`;
	const block7 = (context, tags, suffix) => litRender.html`<div class="ui5-shellbar-copilot-wrapper" tabindex="0" aria-label="${litRender.ifDefined(context._copilotText)}" role="button" title="${litRender.ifDefined(context._copilotText)}" @keydown="${context._coPilotKeydown}" @keyup="${context._coPilotKeyup}" ?active="${context.coPilotActive}" data-ui5-stable="copilot"><svg @click="${context._coPilotClick}" focusable="false" width="44" role="presentation" aria-hidden="true" height="44" viewBox="-150 -150 300 300" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="ui5-shellbar-coPilot">${blockSVG1(context)}</svg></div>`;
	const block8 = (context, tags, suffix) => litRender.svg`<animateTransform attributeName="transform" type="rotate" from="54" to="416" dur="15s" repeatCount="indefinite"/>`;
	const block9 = (context, tags, suffix) => litRender.svg`<animateTransform attributeName="transform" type="rotate" from="90" to="450" dur="30s" repeatCount="indefinite"/>`;
	const block10 = (context, tags, suffix) => litRender.html`<span class="ui5-shellbar-co-pilot-placeholder"></span>`;
	const block11 = (context, tags, suffix) => litRender.html`${ context._fullWidthSearch ? block12(context, tags, suffix) : undefined }<div class="ui5-shellbar-search-field" style="${litRender.styleMap(context.styles.searchField)}">${ !context._fullWidthSearch ? block13() : undefined }</div><${litRender.scopeTag("ui5-button", tags, suffix)} id="${litRender.ifDefined(context._id)}-item-1" class="${litRender.classMap(context.classes.items.search)} ui5-shellbar-button ui5-shellbar-search-button" icon="sap-icon://search" data-ui5-text="Search" data-ui5-notifications-count="${litRender.ifDefined(context.notificationsCount)}" @click=${context._handleSearchIconPress} title="${litRender.ifDefined(context._searchText)}" ._buttonAccInfo="${litRender.ifDefined(context.accInfo.search)}"></${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const block12 = (context, tags, suffix) => litRender.html`<div class="ui5-shellbar-search-full-width-wrapper" style="${litRender.styleMap(context.styles.searchField)}"><div class="ui5-shellbar-search-full-field"><slot name="searchField"></slot></div><${litRender.scopeTag("ui5-button", tags, suffix)} @click=${context._handleCancelButtonPress} class="ui5-shellbar-button">Cancel</${litRender.scopeTag("ui5-button", tags, suffix)}></div>`;
	const block13 = (context, tags, suffix) => litRender.html`<slot name="searchField"></slot>`;
	const block14 = (item, index, context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} id="${litRender.ifDefined(item.id)}" style="${litRender.styleMap(item.styles)}" class="${litRender.ifDefined(item.classes)}" icon="${litRender.ifDefined(item.icon)}" title="${litRender.ifDefined(item.title)}" data-count="${litRender.ifDefined(item.count)}" data-ui5-notifications-count="${litRender.ifDefined(context.notificationsCount)}" data-ui5-external-action-item-id="${litRender.ifDefined(item.refItemid)}" data-ui5-stable="${litRender.ifDefined(item.stableDomRef)}" @click=${item.press}></${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const block15 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} id="${litRender.ifDefined(context._id)}-item-2" style="${litRender.styleMap(context.styles.items.notification)}" class="${litRender.classMap(context.classes.items.notification)} ui5-shellbar-button ui5-shellbar-bell-button" icon="sap-icon://bell" data-ui5-text="Notifications" data-ui5-notifications-count="${litRender.ifDefined(context.notificationsCount)}" @click=${context._handleNotificationsPress} title="${litRender.ifDefined(context._notificationsText)}" ._buttonAccInfo="${litRender.ifDefined(context.accInfo.notifications)}" data-ui5-stable="notifications"></${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const block16 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} profile-btn id="${litRender.ifDefined(context._id)}-item-3" @click=${context._handleProfilePress} style="${litRender.styleMap(context.styles.items.profile)}" title="${litRender.ifDefined(context._profileText)}" ._buttonAccInfo="${litRender.ifDefined(context.accInfo.profile)}" class="ui5-shellbar-button ui5-shellbar-image-button" data-ui5-stable="profile"><slot name="profile"></slot></${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const block17 = (context, tags, suffix) => litRender.html`<${litRender.scopeTag("ui5-button", tags, suffix)} id="${litRender.ifDefined(context._id)}-item-4" style="${litRender.styleMap(context.styles.items.product)}" class="${litRender.classMap(context.classes.items.product)} ui5-shellbar-button ui5-shellbar-button-product-switch" icon="sap-icon://grid" data-ui5-text="Product Switch" @click=${context._handleProductSwitchPress} title="${litRender.ifDefined(context._productsText)}" ._buttonAccInfo="${litRender.ifDefined(context.accInfo.products)}" data-ui5-stable="product-switch"></${litRender.scopeTag("ui5-button", tags, suffix)}>`;
	const blockSVG1 = (context, tags, suffix) => litRender.svg`<defs><linearGradient id="f" x1="0%" x2="100%" y1="100%" y2="0%"><stop offset="0%" class="ui5-shellbar-co-pilot-color1 ui5-shellbar-co-pilot-opaicty7"/><stop offset="80%" class="ui5-shellbar-co-pilot-color2 ui5-shellbar-co-pilot-opaicty7"/></linearGradient><linearGradient id="e" x1="0%" x2="100%" y1="100%" y2="0%"><stop offset="0%" class="ui5-shellbar-co-pilot-color1 ui5-shellbar-co-pilot-opaicty36"/><stop offset="80%" class="ui5-shellbar-co-pilot-color2 ui5-shellbar-co-pilot-opaicty36"/></linearGradient><linearGradient id="c" x1="0%" x2="100%" y1="100%" y2="0%"><stop offset="0%" class="ui5-shellbar-co-pilot-color1 ui5-shellbar-co-pilot-opaicty2"/><stop offset="80%" class="ui5-shellbar-co-pilot-color2 ui5-shellbar-co-pilot-opaicty2"/></linearGradient><path id="d" d="M98.158 0c.158 17.395-9.107 31.335-18.609 45.928-9.21 14.153-18.933 25.29-33.377 34.045C31.427 88.918 17.25 94.39 0 94.273c-17.155-.115-30.823-6.582-45.798-14.949-15.216-8.497-27.76-16.77-37.253-31.375C-92.668 33.158-98.487 17.571-97.179 0c1.233-16.978 12.691-29.086 21.044-43.957 8.456-15.059 12.272-32.152 26.873-41.367 14.76-9.322 31.83-7.68 49.262-6.77 16.897.88 31.86 3.06 46.42 11.693 14.452 8.568 23.18 20.866 32.26 34.976C88.05-30.91 98.014-17.277 98.157 0z"><animate attributeName="d" values="${litRender.ifDefined(context.coPilot.animationValues)}" dur="30s" repeatCount="indefinite"/><animateTransform attributeName="transform" type="scale" values="1;1.05;1.05;1.02;1" dur="0.15s" begin="a.mousedown" repeatCount="1" additive="sum"/></path><mask id="b"><circle r="120" fill="#fff"/><circle r="76"/></mask></defs><g mask="url(#b)"><g transform="rotate(54)"><use xlink:href="#d" fill="url(#c)">${ context.coPilot.animated ? block8() : undefined }</use></g><use xlink:href="#d" fill="url(#e)" transform="rotate(74)"/><g transform="rotate(90)"><use xlink:href="#d" fill="url(#f)">${ context.coPilot.animated ? block9() : undefined }</use></g></g><circle cx="0" cy="0" r="76" class="ui5-shellbar-co-pilot-circle" id="a"/>`;

	return block0;

});
