sap.ui.define(["sap/ui/webc/common/thirdparty/base/UI5Element","sap/ui/webc/common/thirdparty/base/types/CSSColor","sap/ui/webc/common/thirdparty/base/Device","sap/ui/webc/common/thirdparty/base/Render","sap/ui/webc/common/thirdparty/base/renderer/LitRenderer","sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/types/Float","sap/ui/webc/common/thirdparty/base/util/ColorConversion","./generated/templates/ColorPickerTemplate.lit","./Input","./Slider","./Label","./generated/themes/ColorPicker.css"],function(e,t,o,r,s,i,a,l,n,h,A,c,d){"use strict";function u(e){return e&&typeof e==="object"&&"default"in e?e["default"]:e}var f=u(e);var g=u(t);var p=u(s);var y=u(i);var b=u(a);const m={tag:"ui5-color-picker",properties:{color:{type:g,defaultValue:"rgba(255, 255, 255, 1)"},hex:{type:String,defaultValue:"ffffff",noAttribute:true},_mainColor:{type:Object},_color:{type:Object},_selectedCoordinates:{type:Object},_alpha:{type:b,defaultValue:1},_hue:{type:y,defaultValue:0},_wrongHEX:{type:Boolean}},slots:{},events:{change:{}}};class C extends f{static get metadata(){return m}static get render(){return p}static get styles(){return d}static get template(){return n}static get dependencies(){return[h,A,c]}constructor(){super();this._selectedCoordinates={x:256-6.5,y:256-6.5};this._mainColor={r:255,g:0,b:0};this.selectedHue=0;this.mouseDown=false}onBeforeRendering(){this._color=l.getRGBColor(this.color);const e=`rgba(${this._color.r}, ${this._color.g}, ${this._color.b}, 1)`;this._setHex();this._setValues();this.style.setProperty("--ui5_Color_Picker_Progress_Container_Color",e)}async onAfterRendering(){if(o.isIE()){await r.renderFinished();this._applySliderStyles()}}_applySliderStyles(){const e=this.getDomRef().querySelector(".ui5-color-picker-hue-slider").shadowRoot,t=this.getDomRef().querySelector(".ui5-color-picker-alpha-slider").shadowRoot;if(e.children.length===0||t.children.length===0){return}const o=e.querySelector(".ui5-slider-progress-container"),r=e.querySelector(".ui5-slider-handle"),s=t.querySelector(".ui5-slider-progress-container"),i=t.querySelector(".ui5-slider-handle");r.style.width="11px";r.style.height="1.25rem";r.style.background="transparent";r.style.marginLeft="-2px";r.style.marginTop="1px";i.style.width="11px";i.style.height="1.25rem";i.style.background="transparent";i.style.marginLeft="-2px";i.style.marginTop="1px";o.style.width="calc(100% + 11px)";o.style.height="18px";o.style.position="absolute";o.style.marginTop="-10px";o.style.borderRadius="0";o.style.border="1px solid #89919a";s.style.width="calc(100% + 11px)";s.style.height="18px";s.style.position="absolute";s.style.marginTop="-10px";s.style.borderRadius="0";s.style.border="1px solid #89919a";o.style.backgroundSize="100%";o.style.backgroundImage="-webkit-linear-gradient(left, #f00, #ff0, #0f0, #0ff, #00f, #f0f, #f00)";o.style.backgroundImage="-moz-linear-gradient(left, #f00, #ff0, #0f0, #0ff, #00f, #f0f, #f00)";o.style.backgroundImage="-ms-linear-gradient(left, #f00, #ff0, #0f0, #0ff, #00f, #f0f, #f00)";o.style.backgroundImage="linear-gradient(left, #f00, #ff0, #0f0, #0ff, #00f, #f0f, #f00)";o.style.backgroundColor="none";s.style.backgroundImage="-webkit-linear-gradient(left, #fff, #979797)";s.style.backgroundImage="-moz-linear-gradient(left, #fff, #979797)";s.style.backgroundImage="-ms-linear-gradient(left, #fff, #979797)";s.style.backgroundImage="linear-gradient(left, #fff, #979797)";s.style.backgroundColor="none";e.querySelector(".ui5-slider-progress").style.background="Transparent";t.querySelector(".ui5-slider-progress").style.background="Transparent"}_handleMouseDown(e){this.mouseDown=true;this.mouseIn=true;this._changeSelectedColor(e.offsetX,e.offsetY)}_handleMouseUp(){this.mouseDown=false}_handleMouseOut(e){if(!this.mouseIn||!this.mouseDown){return}const t=e.offsetX<=0;const o=e.offsetY<=0;const r=e.offsetY>=e.target.offsetHeight;const s=e.offsetX>=e.target.offsetWidth;let i,a;if(t){i=0}else if(s){i=e.offsetWidth}else{i=e.offsetX}if(o){a=0}else if(r){a=e.offsetHeight}else{a=e.offsetY}this._changeSelectedColor(i,a);this.mouseIn=false;this.mouseDown=false}_handleMouseMove(e){if(!this.mouseDown||!this.mouseIn){return}this._changeSelectedColor(e.offsetX,e.offsetY)}_handleAlphaInput(e){this._alpha=parseFloat(e.target.value);this._setColor(this._color)}_handleHueInput(e){this.selectedHue=e.target.value;this._hue=this.selectedHue;this._setMainColor(this._hue);const t=this._calculateColorFromCoordinates(this._selectedCoordinates.x+6.5,this._selectedCoordinates.y+6.5);if(t){this._setColor(l.HSLToRGB(t))}}_handleHEXChange(e){let t=e.target.value.toLowerCase();const o=new RegExp("^[<0-9 abcdef]+$");if(t.length===3){t=`${t[0]}${t[0]}${t[1]}${t[1]}${t[2]}${t[2]}`}this.hex=t;if(t.length!==6||!o.test(t)){this._wrongHEX=true}else{this._wrongHEX=false;this._setColor(l.HEXToRGB(this.hex))}}_handleRGBInputsChange(e){const t=parseInt(e.target.value)||0;let o;switch(e.target.id){case"red":o={...this._color,r:t};break;case"green":o={...this._color,g:t};break;case"blue":o={...this._color,b:t};break;default:o={...this._color}}this._setColor(o)}_setMainColor(e){if(e<=255){this._mainColor={r:255,g:e,b:0}}else if(e<=510){this._mainColor={r:255-(e-255),g:255,b:0}}else if(e<=765){this._mainColor={r:0,g:255,b:e-510}}else if(e<=1020){this._mainColor={r:0,g:765-(e-255),b:255}}else if(e<=1275){this._mainColor={r:e-1020,g:0,b:255}}else{this._mainColor={r:255,g:0,b:1275-(e-255)}}}_handleAlphaChange(e){this._alpha=this._alpha<0?0:this._alpha;this._alpha=this._alpha>1?1:this._alpha}_changeSelectedColor(e,t){this._selectedCoordinates={x:e-6.5,y:t-6.5};const o=this._calculateColorFromCoordinates(e,t);if(o){this._setColor(l.HSLToRGB(o))}}_calculateColorFromCoordinates(e,t){const o=Math.round(this._hue/4.25),r=1-+(Math.round(t/256+"e+2")+"e-2"),s=+(Math.round(e/256+"e+2")+"e-2");if(!r||!s){return}return{h:o,s:r,l:s}}_setColor(e={r:undefined,g:undefined,b:undefined}){this.color=`rgba(${e.r}, ${e.g}, ${e.b}, ${this._alpha})`;this.fireEvent("change")}_setHex(){let e=this._color.r.toString(16),t=this._color.g.toString(16),o=this._color.b.toString(16);if(e.length===1){e=`0${e}`}if(t.length===1){t=`0${t}`}if(o.length===1){o=`0${o}`}this.hex=e+t+o}_setValues(){const e=l.RGBToHSL(this._color);this._selectedCoordinates={x:Math.round(e.l*100)*2.56-6.5,y:256-Math.round(e.s*100)*2.56-6.5};this._hue=this.selectedHue?this.selectedHue:Math.round(e.h*4.25);this._setMainColor(this._hue)}get inputsDisabled(){return this._wrongHEX?true:undefined}get hexInputErrorState(){return this._wrongHEX?"Error":undefined}get styles(){return{mainColor:{"background-color":`rgb(${this._mainColor.r}, ${this._mainColor.g}, ${this._mainColor.b})`},circle:{left:`${this._selectedCoordinates.x}px`,top:`${this._selectedCoordinates.y}px`},progressContainer:{"background-image":`-webkit-linear-gradient(left, rgba(65, 120, 13, 0), ${this._mainColor}, url('data:image/png;base64,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')`},colorSpan:{"background-color":`rgba(${this._color.r}, ${this._color.g}, ${this._color.b}, ${this._alpha})`}}}}C.define();return C});