sap.ui.define(["sap/ui/webc/common/thirdparty/base/types/Integer","sap/ui/webc/common/thirdparty/base/delegate/ResizeHandler","sap/ui/webc/common/thirdparty/base/util/PopupUtils","sap/ui/webc/common/thirdparty/base/util/clamp","./Popup","./types/PopoverPlacementType","./types/PopoverVerticalAlign","./types/PopoverHorizontalAlign","./popup-utils/PopoverRegistry","./generated/templates/PopoverTemplate.lit","./generated/themes/BrowserScrollbar.css","./generated/themes/PopupsCommon.css","./generated/themes/Popover.css"],function(t,e,i,o,h,s,n,r,a,l,p,c,d){"use strict";function u(t){return t&&typeof t==="object"&&"default"in t?t["default"]:t}var g=u(t);var m=u(e);var f=u(o);const w=8;const _={tag:"ui5-popover",properties:{headerText:{type:String},placementType:{type:s,defaultValue:s.Right},horizontalAlign:{type:r,defaultValue:r.Center},verticalAlign:{type:n,defaultValue:n.Center},modal:{type:Boolean},hideBackdrop:{type:Boolean},hideArrow:{type:Boolean},allowTargetOverlap:{type:Boolean},disableScrolling:{type:Boolean},arrowTranslateX:{type:g,defaultValue:0,noAttribute:true},arrowTranslateY:{type:g,defaultValue:0,noAttribute:true},actualPlacementType:{type:s,defaultValue:s.Right},_maxContentHeight:{type:g,noAttribute:true},_maxContentWidth:{type:g,noAttribute:true}},managedSlots:true,slots:{header:{type:HTMLElement},footer:{type:HTMLElement}},events:{}};class y extends h{constructor(){super();this._handleResize=this.handleResize.bind(this)}static get metadata(){return _}static get styles(){return[p,c,d]}static get template(){return l}static get VIEWPORT_MARGIN(){return 10}onEnterDOM(){m.register(this,this._handleResize)}onExitDOM(){m.deregister(this,this._handleResize)}isOpenerClicked(t){const e=t.target;return e===this._opener||e.getFocusDomRef&&e.getFocusDomRef()===this._opener||t.composedPath().indexOf(this._opener)>-1}async showAt(t,e=false){if(!t||this.opened){return}this._opener=t;this._openerRect=t.getBoundingClientRect();await super._open(e)}_addOpenedPopup(){a.addOpenedPopover(this)}_removeOpenedPopup(){a.removeOpenedPopover(this)}shouldCloseDueToOverflow(t,e){const o=32;const h={Right:e.right,Left:e.left,Top:e.top,Bottom:e.bottom};const s=i.getClosedPopupParent(this._opener);let n=false;let r=false;if(s.showAt){const t=s.contentDOM.getBoundingClientRect();n=e.top>t.top+t.height;r=e.top+e.height<t.top}return h[t]<0||h[t]+o>s.innerHeight||n||r}shouldCloseDueToNoOpener(t){return t.top===0&&t.bottom===0&&t.left===0&&t.right===0}handleResize(){if(this.opened){this.reposition()}}reposition(){this._show()}_show(){let t;const e=this.getPopoverSize();if(e.width===0||e.height===0){return}if(this.isOpen()){this._openerRect=this._opener.getBoundingClientRect()}if(this.shouldCloseDueToNoOpener(this._openerRect)&&this.isFocusWithin()){t=this._oldPlacement}else{t=this.calcPlacement(this._openerRect,e)}const i=this.horizontalAlign===r.Stretch;if(this._preventRepositionAndClose){return this.close()}this._oldPlacement=t;this.actualPlacementType=t.placementType;let o=f(this._left,y.VIEWPORT_MARGIN,document.documentElement.clientWidth-e.width-y.VIEWPORT_MARGIN);if(this.actualPlacementType===s.Right){o=Math.max(o,this._left)}let h=f(this._top,y.VIEWPORT_MARGIN,document.documentElement.clientHeight-e.height-y.VIEWPORT_MARGIN);if(this.actualPlacementType===s.Bottom){h=Math.max(h,this._top)}let{arrowX:n,arrowY:a}=t;const l=this.actualPlacementType===s.Top||this.actualPlacementType===s.Bottom;if(l){const t=y.VIEWPORT_MARGIN-this._left;const i=this._left+e.width+y.VIEWPORT_MARGIN-document.documentElement.clientWidth;if(t>0){n-=t}else if(i>0){n+=i}}this.arrowTranslateX=Math.round(n);if(!l){const t=y.VIEWPORT_MARGIN-this._top;const i=this._top+e.height+y.VIEWPORT_MARGIN-document.documentElement.clientHeight;if(t>0){a-=t}else if(i>0){a+=i}}this.arrowTranslateY=Math.round(a);Object.assign(this.style,{top:`${h}px`,left:`${o}px`});super._show();if(i&&this._width){this.style.width=this._width}}getPopoverSize(){if(!this.opened){Object.assign(this.style,{display:"block",top:"-10000px",left:"-10000px"})}const t=this.getBoundingClientRect(),e=t.width,i=t.height;return{width:e,height:i}}get contentDOM(){return this.shadowRoot.querySelector(".ui5-popup-content")}get arrowDOM(){return this.shadowRoot.querySelector(".ui5-popover-arrow")}calcPlacement(t,e){let i=0;let o=0;const h=this.allowTargetOverlap;const a=document.documentElement.clientWidth;const l=document.documentElement.clientHeight;let p=l;let c=a;let d="";let u="";const g=this.getActualPlacementType(t,e);this._preventRepositionAndClose=this.shouldCloseDueToNoOpener(t)||this.shouldCloseDueToOverflow(g,t);const m=g===s.Top||g===s.Bottom;if(this.horizontalAlign===r.Stretch&&m){e.width=t.width;d=`${t.width}px`}else if(this.verticalAlign===n.Stretch&&!m){e.height=t.height;u=`${t.height}px`}this._width=d;this._height=u;const f=this.hideArrow?0:w;switch(g){case s.Top:i=this.getVerticalLeft(t,e);o=Math.max(t.top-e.height-f,0);if(!h){p=t.top-f}break;case s.Bottom:i=this.getVerticalLeft(t,e);if(h){o=Math.max(Math.min(t.bottom+f,l-e.height),0)}else{o=t.bottom+f;p=l-t.bottom-f}break;case s.Left:i=Math.max(t.left-e.width-f,0);o=this.getHorizontalTop(t,e);if(!h){c=t.left-f}break;case s.Right:if(h){i=Math.max(Math.min(t.left+t.width+f,a-e.width),0)}else{i=t.left+t.width+f;c=a-t.right-f}o=this.getHorizontalTop(t,e);break}if(m){if(e.width>a||i<0){i=0}else if(i+e.width>a){i-=i+e.width-a}}else{if(e.height>l||o<0){o=0}else if(o+e.height>l){o-=o+e.height-l}}let _=p;if(this._displayHeader){const t=this.shadowRoot.querySelector(".ui5-popup-header-root")||this.shadowRoot.querySelector(".ui5-popup-header-text");if(t){_=p-t.offsetHeight}}this._maxContentHeight=Math.round(_-y.VIEWPORT_MARGIN);this._maxContentWidth=Math.round(c-y.VIEWPORT_MARGIN);const R=this.getArrowPosition(t,e,i,o,m);if(this._left===undefined||Math.abs(this._left-i)>1.5){this._left=Math.round(i)}if(this._top===undefined||Math.abs(this._top-o)>1.5){this._top=Math.round(o)}return{arrowX:R.x,arrowY:R.y,top:this._top,left:this._left,placementType:g}}getArrowPosition(t,e,i,o,h){let s=this.horizontalAlign===r.Center||this.horizontalAlign===r.Stretch;if(this.horizontalAlign===r.Right&&i<=t.left){s=true}if(this.horizontalAlign===r.Left&&i+e.width>=t.left+t.width){s=true}let n=0;if(h&&s){n=t.left+t.width/2-i-e.width/2}let a=0;if(!h){a=t.top+t.height/2-o-e.height/2}return{x:Math.round(n),y:Math.round(a)}}fallbackPlacement(t,e,i,o){if(i.left>o.width){return s.Left}if(t-i.right>i.left){return s.Right}if(e-i.bottom>o.height){return s.Bottom}if(e-i.bottom<i.top){return s.Top}}getActualPlacementType(t,e){const i=this.placementType;let o=i;const h=document.documentElement.clientWidth;const n=document.documentElement.clientHeight;switch(i){case s.Top:if(t.top<e.height&&t.top<n-t.bottom){o=s.Bottom}break;case s.Bottom:if(n-t.bottom<e.height&&n-t.bottom<t.top){o=s.Top}break;case s.Left:if(t.left<e.width){o=this.fallbackPlacement(h,n,t,e)||i}break;case s.Right:if(h-t.right<e.width){o=this.fallbackPlacement(h,n,t,e)||i}break}return o}getVerticalLeft(t,e){let i;switch(this.horizontalAlign){case r.Center:case r.Stretch:i=t.left-(e.width-t.width)/2;break;case r.Left:i=t.left;break;case r.Right:i=t.right-e.width;break}return i}getHorizontalTop(t,e){let i;switch(this.verticalAlign){case n.Center:case n.Stretch:i=t.top-(e.height-t.height)/2;break;case n.Top:i=t.top;break;case n.Bottom:i=t.bottom-e.height;break}return i}get isModal(){return this.modal}get shouldHideBackdrop(){return this.hideBackdrop}get _ariaLabelledBy(){return this.accessibleName?undefined:"ui5-popup-header"}get _ariaModal(){return true}get styles(){return{...super.styles,content:{"max-height":`${this._maxContentHeight}px`,"max-width":`${this._maxContentWidth}px`},arrow:{transform:`translate(${this.arrowTranslateX}px, ${this.arrowTranslateY}px)`}}}get _displayHeader(){return this.header.length||this.headerText}get _displayFooter(){return true}}y.define();return y});