/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m,e){"use strict";var f=l.Importance;var g=m.ButtonType;var P=m.PlacementType;var h=l.ObjectPageHeaderDesign;var j=m.AvatarShape;var k=m.AvatarColor;function n(i){return typeof i==="function";}var o=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:j.Square},objectImageBackgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:k.Accent6},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:h.Light,deprecated:true},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink",deprecated:true},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"}});o.prototype._iAvailablePercentageForActions=0.3;o.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};o.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs");},aggregation:"links"});o.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};o.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};o.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};o.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};o._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,u,T){return I.createControlByURI({id:this._getParentAugmentedId(i,u),tooltip:T,src:I.getIconURI(u),visible:false});},_getButton:function(i,u,v,T){return new b({id:this._getParentAugmentedId(i,v),tooltip:T,icon:u,type:g.Transparent});},_getParentAugmentedId:function(i,u){return i.getId()+"-"+u;}};o.prototype._lazyLoadInternalAggregation=function(i,S){if(!this.getAggregation(i)){this.setAggregation(i,o._internalAggregationFactory[i](this),S);}return this.getAggregation(i);};o.prototype._applyActionProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};o.prototype._applyObjectImageProperty=function(i,u){var v=u[0];if(this.getProperty(i)!==v){u.unshift(i);this.setProperty.apply(this,u);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};o.prototype._setAggregationTooltip=function(i,T){var u=this.getAggregation(i);if(u){u.setTooltip(T);}return this;};o.prototype._setTitleSelectorTooltip=function(T){if(T===null||T===undefined){T=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP");}this._setAggregationTooltip("_titleArrowIcon",T);this._setAggregationTooltip("_titleArrowIconCont",T);return this;};o.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};o.prototype.setObjectTitle=function(N){var i=this.getParent(),u=this.getProperty("objectTitle"),v=u!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));i&&n(i._updateAriaLabels)&&i._updateAriaLabels();if(v&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":u,"newValue":N});}return this;};var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],r=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape","objectImageBackgroundColor"];var G=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);o.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,i,v);return this;};};var s=function(i){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);o.prototype[u]=function(){var v=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,i,v);return this;};};var t=function(i,S,T){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);S[u]=function(){var v=Array.prototype.slice.call(arguments);v.unshift(i);T.setProperty.apply(T,v);return this.setProperty.apply(this,v);};};p.forEach(G);r.forEach(s);o.prototype._destroyObjectImage=function(){var i="_objectImage",u=this.getAggregation(i);if(u){u.destroy();this.setAggregation(i,null);}};o.prototype.onBeforeRendering=function(){var S=this.getSideContentButton(),i=this;if(S&&!S.getTooltip()){S.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var u=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(u.length>1||this._hasOneButtonShowText(u)){u.forEach(function(v){if(v instanceof b&&!(v instanceof O)){v._bInternalVisible=v.getVisible();v._getInternalVisible=function(){return this._bInternalVisible;};v._setInternalVisible=function(V,x){this.$().toggle(V);if(V!=this._bInternalVisible){this._bInternalVisible=V;if(x){this.invalidate();}}};v.setVisible=function(V){v._setInternalVisible(V,true);b.prototype.setVisible.call(this,V);};v.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}i._resizeIdentifierLineContainer(i.$());};}if(v instanceof b&&v.getVisible()){var w=this._createActionSheetButton(v);this._oActionSheetButtonMap[v.getId()]=w;this._oOverflowActionSheet.addButton(w);t("text",v,w);t("icon",v,w);t("enabled",v,w);t("type",v,w);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};o.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(i){this._oActionSheetButtonMap[i].destroy();}.bind(this));this._oActionSheetButtonMap={};};o.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),type:i.getType(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};o.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),u=this.getParent(),$=u?u.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};o.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};o.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayout();this._clearImageNotFoundHandler();$.on("error",this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};o.prototype._onHeaderResize=function(E){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(E);}};o.prototype._attachDetachActionButtonsHandler=function(i){var u=this.getActions()||[];if(u.length<1){return;}u.forEach(function(v){if(v instanceof b){var w=this._oActionSheetButtonMap[v.getId()];if(i){v.attachEvent("_change",this._adaptLayoutDelayed,this);if(w){w.attachEvent("_change",this._adaptOverflow,this);}}else{v.detachEvent("_change",this._adaptLayoutDelayed,this);if(w){w.detachEvent("_change",this._adaptOverflow,this);}}}},this);};o.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),u=sap.ui.getCore().byId(i.data("originalId"));if(u.firePress){u.firePress({overflowButtonId:this._oOverflowButton.getId(),bInOverflow:true});}this._oOverflowActionSheet.close();};o._actionImportanceMap={"Low":3,"Medium":2,"High":1};o._sortActionsByImportance=function(i,u){var v=(i instanceof O)?i.getImportance():f.High,w=(u instanceof O)?u.getImportance():f.High,x=o._actionImportanceMap[v]-o._actionImportanceMap[w];if(x===0){return i.position-u.position;}return x;};o.prototype._hasOneButtonShowText=function(i){var u=false;if(i.length!==1){return u;}if(i[0]instanceof O){u=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){u=(i[0].getText()!="");}return u;};o.prototype._adaptLayout=function(E){var $=this.$("identifierLine"),i=$.width(),u=this._getActionsWidth(),v=u/i,w=this._iAvailablePercentageForActions*i,x=this._oOverflowButton.$();if(i===0){return;}if(v>this._iAvailablePercentageForActions){this._adaptActions(w);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){this.getActions().forEach(function(F){if(F instanceof b){F.$().css("visibility","visible");}});}var y=this.$("actions");var z=y.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(z.filter(":visible").length===z.length){x.hide();}this._adaptObjectPageHeaderIndentifierLine(this.$());};o.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=setTimeout(function(){this._adaptLayoutTimeout=null;this._adaptLayout();}.bind(this),0);};o.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),u=i.find(".sapUxAPObjectPageHeaderIdentifierTitle");this._adaptObjectPageHeaderTitle(u);this._resizeIdentifierLineContainer($);};o.prototype._resizeIdentifierLineContainer=function($){var i=this._findById($,"identifierLineContainer"),u=this._findById($,"actions"),v=this._findById($,"identifierLine"),w=v.width(),x=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),y=u.width()+x.width();i.width((0.95-(y/w))*100+"%");};o.prototype._adaptObjectPageHeaderTitle=function($){var T=$.width(),u=$.find(".sapUxAPObjectPageHeaderTitleText"),v=u.length,w;for(var i=0;i<v;i++){w=q(u.get(i));w.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",false);if(w.width()>T){w.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",true);}}};o.prototype._adaptActions=function(u){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),w=this.getActions(),x=w.length,y;for(var i=0;i<x;i++){w[i].position=i;}w.sort(o._sortActionsByImportance);w.forEach(function(z){y=this._oActionSheetButtonMap[z.getId()];if(y){v+=z.$().width();if(u>v&&!M){this._setActionButtonVisibility(z,true);$.hide();}else{this._setActionButtonVisibility(z,false);$.show();}}},this);};o.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(u){return u.getVisible();});this._oOverflowButton.$().toggle(H);};o.prototype._setActionButtonVisibility=function(i,v){var u=this._oActionSheetButtonMap[i.getId()];if(u){if(i.getVisible()){i._setInternalVisible(v);u.setVisible(!v);}else{u.setVisible(false);}}};o.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};o.prototype._findById=function($,i){var E;if(!i||!$){return null;}i=this.getId()+'-'+i;E="#"+i.replace(/(:|\.)/g,'\\$1');return $.find(E);};o.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),u=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((u&&u.getLinks().length)?u:null);};o.prototype._notifyParentOfChanges=function(i){var u=this.getParent();if(u&&typeof u._headerTitleChangeHandler==="function"){u._headerTitleChangeHandler(i);}};o.prototype.setTitleSelectorTooltip=function(T){this._setTitleSelectorTooltip(T);this.setAggregation("titleSelectorTooltip",T,true);return this;};o.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this;};o.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._resetActionSheetMap();};o.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};o.prototype._getAdaptableContent=function(){return this.getNavigationBar();};o.prototype.isDynamic=function(){return false;};o.prototype.getCompatibleHeaderContentClass=function(){return d;};o.prototype.supportsToggleHeaderOnTitleClick=function(){return false;};o.prototype.supportsTitleInHeaderContent=function(){return true;};o.prototype.supportsAdaptLayoutForDomElement=function(){return true;};o.prototype.supportsBackgroundDesign=function(){return false;};o.prototype.getTitleText=function(){return this.getObjectTitle();};o.prototype.snap=function(){this._adaptLayout();};o.prototype.unSnap=function(){this._adaptLayout();};o.prototype._toggleExpandButton=function(T){};o.prototype._setShowExpandButton=function(v){};o.prototype._focusExpandButton=function(){};o.prototype._toggleFocusableState=function(F){};return o;});
