/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AscensionChallenge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Golem;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Monk;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.DwarfToken;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityLevel;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ImpSprite;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndImp;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndQuest;
import com.watabou.noosa.Game;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class Imp
extends NPC {
    private boolean seenBefore;

    public Imp() {
        this.spriteClass = ImpSprite.class;
        this.properties.add(Char.Property.IMMOVABLE);
        this.seenBefore = false;
    }

    @Override
    protected boolean act() {
        if (Dungeon.hero.buff(AscensionChallenge.class) != null) {
            this.die(null);
            return true;
        }
        if (!Quest.given && Dungeon.level.visited[this.pos]) {
            if (!this.seenBefore) {
                this.yell(Messages.get(this, "hey", Messages.titleCase(Dungeon.hero.name())));
            }
            Notes.add(Notes.Landmark.IMP);
            this.seenBefore = true;
        } else {
            this.seenBefore = false;
        }
        return super.act();
    }

    @Override
    public int defenseSkill(Char enemy) {
        return INFINITE_EVASION;
    }

    @Override
    public void damage(int dmg, Object src) {
    }

    @Override
    public boolean add(Buff buff) {
        return false;
    }

    @Override
    public boolean reset() {
        return true;
    }

    @Override
    public boolean interact(Char c) {
        this.sprite.turnTo(this.pos, Dungeon.hero.pos);
        if (c != Dungeon.hero) {
            return true;
        }
        if (Quest.given) {
            final DwarfToken tokens = Dungeon.hero.belongings.getItem(DwarfToken.class);
            if (tokens != null && (tokens.quantity() >= 5 || !Quest.alternative && tokens.quantity() >= 4)) {
                Game.runOnRenderThread(new Callback(){

                    @Override
                    public void call() {
                        GameScene.show(new WndImp(Imp.this, tokens));
                    }
                });
            } else {
                this.tell(Quest.alternative ? Messages.get(this, "monks_2", Messages.titleCase(Dungeon.hero.name())) : Messages.get(this, "golems_2", Messages.titleCase(Dungeon.hero.name())));
            }
        } else {
            this.tell(Quest.alternative ? Messages.get(this, "monks_1", new Object[0]) : Messages.get(this, "golems_1", new Object[0]));
            Quest.given = true;
            Quest.completed = false;
            Notes.add(Notes.Landmark.IMP);
        }
        return true;
    }

    private void tell(final String text) {
        Game.runOnRenderThread(new Callback(){

            @Override
            public void call() {
                GameScene.show(new WndQuest(Imp.this, text));
            }
        });
    }

    public void flee() {
        this.yell(Messages.get(this, "cya", Messages.titleCase(Dungeon.hero.name())));
        this.destroy();
        this.sprite.die();
    }

    public static class Quest {
        private static boolean alternative;
        private static boolean spawned;
        private static boolean given;
        private static boolean completed;
        public static Ring reward;
        private static final String NODE = "demon";
        private static final String ALTERNATIVE = "alternative";
        private static final String SPAWNED = "spawned";
        private static final String GIVEN = "given";
        private static final String COMPLETED = "completed";
        private static final String REWARD = "reward";

        public static void reset() {
            spawned = false;
            given = false;
            completed = false;
            reward = null;
        }

        public static void storeInBundle(Bundle bundle) {
            Bundle node = new Bundle();
            node.put(SPAWNED, spawned);
            if (spawned) {
                node.put(ALTERNATIVE, alternative);
                node.put(GIVEN, given);
                node.put(COMPLETED, completed);
                node.put(REWARD, reward);
            }
            bundle.put(NODE, node);
        }

        public static void restoreFromBundle(Bundle bundle) {
            Bundle node = bundle.getBundle(NODE);
            if (!node.isNull() && (spawned = node.getBoolean(SPAWNED))) {
                alternative = node.getBoolean(ALTERNATIVE);
                given = node.getBoolean(GIVEN);
                completed = node.getBoolean(COMPLETED);
                reward = (Ring)node.get(REWARD);
            }
        }

        public static void spawn(CityLevel level) {
            if (!spawned && Dungeon.depth > 16 && Random.Int(20 - Dungeon.depth) == 0) {
                Imp npc = new Imp();
                do {
                    npc.pos = level.randomRespawnCell(npc);
                } while (npc.pos == -1 || level.heaps.get(npc.pos) != null || level.traps.get(npc.pos) != null || level.findMob(npc.pos) != null || !level.passable[npc.pos + PathFinder.CIRCLE4[0]] || !level.passable[npc.pos + PathFinder.CIRCLE4[2]] || !level.passable[npc.pos + PathFinder.CIRCLE4[1]] || !level.passable[npc.pos + PathFinder.CIRCLE4[3]]);
                level.mobs.add(npc);
                spawned = true;
                switch (Dungeon.depth) {
                    default: {
                        alternative = true;
                        break;
                    }
                    case 18: {
                        alternative = Random.Int(2) == 0;
                        break;
                    }
                    case 19: {
                        alternative = false;
                    }
                }
                given = false;
                do {
                    reward = (Ring)Generator.randomUsingDefaults(Generator.Category.RING);
                } while (Quest.reward.cursed);
                reward.upgrade(2);
                Quest.reward.cursed = true;
            }
        }

        public static void process(Mob mob) {
            if (spawned && given && !completed && Dungeon.depth != 20 && (alternative && mob instanceof Monk || !alternative && mob instanceof Golem)) {
                Dungeon.level.drop((Item)new DwarfToken(), (int)mob.pos).sprite.drop();
            }
        }

        public static void complete() {
            reward = null;
            completed = true;
            Statistics.questScores[3] = 4000;
            Notes.remove(Notes.Landmark.IMP);
        }

        public static boolean isCompleted() {
            return completed;
        }
    }
}

