/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AscensionChallenge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.NPC;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ElmoParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ShopkeeperSprite;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTitledMessage;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTradeItem;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import java.util.ArrayList;

public class Shopkeeper
extends NPC {
    public static int MAX_BUYBACK_HISTORY = 3;
    public ArrayList<Item> buybackItems;
    private static WndBag.ItemSelector itemSelector = new WndBag.ItemSelector(){

        @Override
        public String textPrompt() {
            return Messages.get(Shopkeeper.class, "sell", new Object[0]);
        }

        @Override
        public boolean itemSelectable(Item item) {
            return Shopkeeper.canSell(item);
        }

        @Override
        public void onSelect(Item item) {
            if (item != null) {
                WndBag parentWnd = Shopkeeper.sell();
                GameScene.show(new WndTradeItem(item, parentWnd));
            }
        }
    };
    public static String BUYBACK_ITEMS = "buyback_items";

    public Shopkeeper() {
        this.spriteClass = ShopkeeperSprite.class;
        this.properties.add(Char.Property.IMMOVABLE);
        this.buybackItems = new ArrayList();
    }

    @Override
    protected boolean act() {
        if (Dungeon.level.visited[this.pos]) {
            Notes.add(Notes.Landmark.SHOP);
        }
        this.sprite.turnTo(this.pos, Dungeon.hero.pos);
        this.spend(1.0f);
        return super.act();
    }

    @Override
    public void damage(int dmg, Object src) {
        this.flee();
    }

    @Override
    public boolean add(Buff buff) {
        if (super.add(buff)) {
            this.flee();
            return true;
        }
        return false;
    }

    public void flee() {
        this.destroy();
        Notes.remove(Notes.Landmark.SHOP);
        if (this.sprite != null) {
            this.sprite.killAndErase();
            CellEmitter.get(this.pos).burst(ElmoParticle.FACTORY, 6);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Heap heap : Dungeon.level.heaps.valueList()) {
            if (heap.type != Heap.Type.FOR_SALE) continue;
            if (ShatteredPixelDungeon.scene() instanceof GameScene) {
                CellEmitter.get(heap.pos).burst(ElmoParticle.FACTORY, 4);
            }
            if (heap.size() == 1) {
                heap.destroy();
                continue;
            }
            heap.items.remove(heap.size() - 1);
            heap.type = Heap.Type.HEAP;
        }
    }

    @Override
    public boolean reset() {
        return true;
    }

    public static int sellPrice(Item item) {
        return item.value() * 5 * (Dungeon.depth / 5 + 1);
    }

    public static WndBag sell() {
        return GameScene.selectItem(itemSelector);
    }

    public static boolean canSell(Item item) {
        if (item.value() <= 0) {
            return false;
        }
        if (item.unique && !item.stackable) {
            return false;
        }
        if (item instanceof Armor && ((Armor)item).checkSeal() != null) {
            return false;
        }
        return !item.isEquipped(Dungeon.hero) || !item.cursed;
    }

    @Override
    public boolean interact(Char c) {
        if (c != Dungeon.hero) {
            return true;
        }
        Game.runOnRenderThread(new Callback(){

            @Override
            public void call() {
                String[] options = new String[2 + Shopkeeper.this.buybackItems.size()];
                int i = 0;
                options[i++] = Messages.get(Shopkeeper.this, "sell", new Object[0]);
                options[i++] = Messages.get(Shopkeeper.this, "talk", new Object[0]);
                for (Item item : Shopkeeper.this.buybackItems) {
                    options[i] = Messages.get(Heap.class, "for_sale", item.value(), Messages.titleCase(item.title()));
                    if (options[i].length() > 26) {
                        options[i] = options[i].substring(0, 23) + "...";
                    }
                    ++i;
                }
                GameScene.show(new WndOptions(Shopkeeper.this.sprite(), Messages.titleCase(Shopkeeper.this.name()), Shopkeeper.this.description(), options){

                    @Override
                    protected void onSelect(int index) {
                        super.onSelect(index);
                        if (index == 0) {
                            Shopkeeper.sell();
                        } else if (index == 1) {
                            GameScene.show(new WndTitledMessage(Shopkeeper.this.sprite(), Messages.titleCase(Shopkeeper.this.name()), Shopkeeper.this.chatText()));
                        } else if (index > 1) {
                            GLog.i(Messages.get(Shopkeeper.this, "buyback", new Object[0]), new Object[0]);
                            Item returned = Shopkeeper.this.buybackItems.remove(index - 2);
                            Dungeon.gold -= returned.value();
                            Statistics.goldCollected -= returned.value();
                            if (!returned.doPickUp(Dungeon.hero)) {
                                Dungeon.level.drop(returned, Dungeon.hero.pos);
                            }
                        }
                    }

                    @Override
                    protected boolean enabled(int index) {
                        if (index > 1) {
                            return Dungeon.gold >= Shopkeeper.this.buybackItems.get(index - 2).value();
                        }
                        return super.enabled(index);
                    }

                    @Override
                    protected boolean hasIcon(int index) {
                        return index > 1;
                    }

                    @Override
                    protected Image getIcon(int index) {
                        if (index > 1) {
                            return new ItemSprite(Shopkeeper.this.buybackItems.get(index - 2));
                        }
                        return null;
                    }
                });
            }
        });
        return true;
    }

    public String chatText() {
        if (Dungeon.hero.buff(AscensionChallenge.class) != null) {
            return Messages.get(this, "talk_ascent", new Object[0]);
        }
        switch (Dungeon.depth) {
            default: {
                return Messages.get(this, "talk_prison_intro", new Object[0]) + "\n\n" + Messages.get(this, "talk_prison_" + Dungeon.hero.heroClass.name(), new Object[0]);
            }
            case 11: {
                return Messages.get(this, "talk_caves", new Object[0]);
            }
            case 16: {
                return Messages.get(this, "talk_city", new Object[0]);
            }
            case 20: 
        }
        return Messages.get(this, "talk_halls", new Object[0]);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(BUYBACK_ITEMS, this.buybackItems);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.buybackItems.clear();
        if (bundle.contains(BUYBACK_ITEMS)) {
            for (Bundlable i : bundle.getCollection(BUYBACK_ITEMS)) {
                this.buybackItems.add((Item)i);
            }
        }
    }
}

