/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.wands;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ConfusionGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Fire;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ParalyticGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Regrowth;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.ToxicGas;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GoldenMimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Sheep;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Flare;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bombs.Bomb;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRecharging;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.CursingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ShockingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.SummoningTrap;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.TargetHealthIndicator;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.io.IOException;
import java.util.ArrayList;

public class CursedWand {
    private static float COMMON_CHANCE = 0.6f;
    private static float UNCOMMON_CHANCE = 0.3f;
    private static float RARE_CHANCE = 0.09f;
    private static float VERY_RARE_CHANCE = 0.01f;

    public static void cursedZap(final Item origin, final Char user, final Ballistica bolt, final Callback afterZap) {
        CursedWand.cursedFX(user, bolt, new Callback(){

            @Override
            public void call() {
                if (CursedWand.cursedEffect(origin, user, bolt.collisionPos) && afterZap != null) {
                    afterZap.call();
                }
            }
        });
    }

    public static void tryForWandProc(Char target, Item origin) {
        if (target != null && origin instanceof Wand) {
            Wand.wandProc(target, origin.buffedLvl(), 1);
        }
    }

    public static boolean cursedEffect(Item origin, Char user, Char target) {
        return CursedWand.cursedEffect(origin, user, target.pos);
    }

    public static boolean cursedEffect(Item origin, Char user, int targetPos) {
        switch (Random.chances(new float[]{COMMON_CHANCE, UNCOMMON_CHANCE, RARE_CHANCE, VERY_RARE_CHANCE})) {
            default: {
                return CursedWand.commonEffect(origin, user, targetPos);
            }
            case 1: {
                return CursedWand.uncommonEffect(origin, user, targetPos);
            }
            case 2: {
                return CursedWand.rareEffect(origin, user, targetPos);
            }
            case 3: 
        }
        return CursedWand.veryRareEffect(origin, user, targetPos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean commonEffect(Item origin, Char user, int targetPos) {
        switch (Random.Int(4)) {
            default: {
                Char target = Actor.findChar(targetPos);
                if (Random.Int(2) == 0) {
                    if (target != null) {
                        Buff.affect(target, Burning.class).reignite(target);
                    }
                    Buff.affect(user, Frost.class, 10.0f);
                } else {
                    Buff.affect(user, Burning.class).reignite(user);
                    if (target != null) {
                        Buff.affect(target, Frost.class, 10.0f);
                    }
                }
                CursedWand.tryForWandProc(target, origin);
                return true;
            }
            case 1: {
                GameScene.add(Blob.seed(targetPos, 30, Regrowth.class));
                CursedWand.tryForWandProc(Actor.findChar(targetPos), origin);
                return true;
            }
            case 2: {
                if (Random.Int(2) == 0) {
                    if (user == null || user.properties().contains((Object)Char.Property.IMMOVABLE)) return CursedWand.cursedEffect(origin, user, targetPos);
                    ScrollOfTeleportation.teleportChar(user);
                    return true;
                } else {
                    Char ch = Actor.findChar(targetPos);
                    if (ch == null || ch.properties().contains((Object)Char.Property.IMMOVABLE)) return CursedWand.cursedEffect(origin, user, targetPos);
                    ScrollOfTeleportation.teleportChar(ch);
                    CursedWand.tryForWandProc(ch, origin);
                }
                return true;
            }
            case 3: 
        }
        Sample.INSTANCE.play("sounds/gas.mp3");
        CursedWand.tryForWandProc(Actor.findChar(targetPos), origin);
        switch (Random.Int(3)) {
            default: {
                GameScene.add(Blob.seed(targetPos, 800, ConfusionGas.class));
                return true;
            }
            case 1: {
                GameScene.add(Blob.seed(targetPos, 500, ToxicGas.class));
                return true;
            }
            case 2: 
        }
        GameScene.add(Blob.seed(targetPos, 200, ParalyticGas.class));
        return true;
    }

    private static boolean uncommonEffect(Item origin, Char user, int targetPos) {
        switch (Random.Int(4)) {
            default: {
                int pos = targetPos;
                if (Dungeon.level.map[pos] == 28 || Dungeon.level.pit[pos] || Dungeon.level.traps.get(pos) != null || Dungeon.isChallenged(8)) {
                    return CursedWand.cursedEffect(origin, user, targetPos);
                }
                Dungeon.level.plant((Plant.Seed)Generator.randomUsingDefaults(Generator.Category.SEED), pos);
                CursedWand.tryForWandProc(Actor.findChar(pos), origin);
                return true;
            }
            case 1: {
                Char target = Actor.findChar(targetPos);
                if (target != null) {
                    Char toDamage;
                    Char toHeal;
                    int damage = Dungeon.scalingDepth() * 2;
                    if (Random.Int(2) == 0) {
                        toHeal = user;
                        toDamage = target;
                    } else {
                        toHeal = target;
                        toDamage = user;
                    }
                    toHeal.HP = Math.min(toHeal.HT, toHeal.HP + damage);
                    toHeal.sprite.emitter().burst(Speck.factory(0), 3);
                    toDamage.damage(damage, new CursedWand());
                    toDamage.sprite.emitter().start(ShadowParticle.UP, 0.05f, 10);
                    if (toDamage == Dungeon.hero) {
                        Sample.INSTANCE.play("sounds/cursed.mp3");
                        if (!toDamage.isAlive()) {
                            if (user == Dungeon.hero && origin != null) {
                                Badges.validateDeathFromFriendlyMagic();
                                Dungeon.fail(origin);
                                GLog.n(Messages.get(CursedWand.class, "ondeath", origin.name()), new Object[0]);
                            } else {
                                Badges.validateDeathFromEnemyMagic();
                                Dungeon.fail(toHeal);
                            }
                        }
                    } else {
                        Sample.INSTANCE.play("sounds/burning.mp3");
                    }
                } else {
                    return CursedWand.cursedEffect(origin, user, targetPos);
                }
                CursedWand.tryForWandProc(target, origin);
                return true;
            }
            case 2: {
                new Bomb.MagicalBomb().explode(targetPos);
                CursedWand.tryForWandProc(Actor.findChar(targetPos), origin);
                return true;
            }
            case 3: 
        }
        new ShockingTrap().set(user.pos).activate();
        Buff.prolong(user, Recharging.class, 30.0f);
        ScrollOfRecharging.charge(user);
        SpellSprite.show(user, 2);
        return true;
    }

    private static boolean rareEffect(Item origin, Char user, int targetPos) {
        switch (Random.Int(4)) {
            default: {
                Char ch = Actor.findChar(targetPos);
                if (ch == null || ch instanceof Hero || ch.properties().contains((Object)Char.Property.BOSS) || ch.properties().contains((Object)Char.Property.MINIBOSS)) {
                    return CursedWand.cursedEffect(origin, user, targetPos);
                }
                Sheep sheep = new Sheep();
                sheep.lifespan = 10.0f;
                sheep.pos = ch.pos;
                ch.destroy();
                ch.sprite.killAndErase();
                Dungeon.level.mobs.remove(ch);
                TargetHealthIndicator.instance.target(null);
                GameScene.add(sheep);
                CellEmitter.get(sheep.pos).burst(Speck.factory(7), 4);
                Sample.INSTANCE.play("sounds/puff.mp3");
                Sample.INSTANCE.play("sounds/sheep.mp3");
                return true;
            }
            case 1: {
                if (!(user instanceof Hero)) {
                    return CursedWand.cursedEffect(origin, user, targetPos);
                }
                CursingTrap.curse((Hero)user);
                return true;
            }
            case 2: {
                if (Dungeon.depth > 1 && Dungeon.interfloorTeleportAllowed() && user == Dungeon.hero) {
                    float[] depths = new float[Dungeon.depth - 1];
                    for (int i = 1; i < Dungeon.depth; ++i) {
                        depths[i - 1] = i;
                    }
                    int depth = 1 + Random.chances(depths);
                    Level.beforeTransition();
                    InterlevelScene.mode = InterlevelScene.Mode.RETURN;
                    InterlevelScene.returnDepth = depth;
                    InterlevelScene.returnBranch = 0;
                    InterlevelScene.returnPos = -1;
                    Game.switchScene(InterlevelScene.class);
                } else {
                    ScrollOfTeleportation.teleportChar(user);
                }
                return true;
            }
            case 3: 
        }
        new SummoningTrap().set(targetPos).activate();
        return true;
    }

    private static boolean veryRareEffect(Item origin, Char user, int targetPos) {
        Item result;
        switch (Random.Int(4)) {
            default: {
                for (int i = 0; i < Dungeon.level.length(); ++i) {
                    GameScene.add(Blob.seed(i, 15, Regrowth.class));
                }
                do {
                    GameScene.add(Blob.seed(Dungeon.level.randomDestination(null), 10, Fire.class));
                } while (Random.Int(5) != 0);
                new Flare(8, 32.0f).color(0xFFFF66, true).show(user.sprite, 2.0f);
                Sample.INSTANCE.play("sounds/teleport.mp3");
                GLog.p(Messages.get(CursedWand.class, "grass", new Object[0]), new Object[0]);
                GLog.w(Messages.get(CursedWand.class, "fire", new Object[0]), new Object[0]);
                return true;
            }
            case 1: {
                Item reward;
                Char ch = Actor.findChar(targetPos);
                int spawnCell = targetPos;
                if (ch != null) {
                    ArrayList<Integer> candidates = new ArrayList<Integer>();
                    for (int n : PathFinder.NEIGHBOURS8) {
                        int cell = targetPos + n;
                        if (!Dungeon.level.passable[cell] || Actor.findChar(cell) != null) continue;
                        candidates.add(cell);
                    }
                    if (!candidates.isEmpty()) {
                        spawnCell = (Integer)Random.element(candidates);
                    } else {
                        return CursedWand.cursedEffect(origin, user, targetPos);
                    }
                }
                Mimic mimic = Mimic.spawnAt(spawnCell, new ArrayList<Item>(), GoldenMimic.class);
                mimic.stopHiding();
                mimic.alignment = Char.Alignment.ENEMY;
                while ((reward = Generator.randomUsingDefaults(Random.oneOf(Generator.Category.WEAPON, Generator.Category.ARMOR, Generator.Category.RING, Generator.Category.WAND))).level() < 1) {
                }
                Sample.INSTANCE.play("sounds/mimic.mp3", 1.0f, 0.85f);
                CellEmitter.get(mimic.pos).burst(Speck.factory(1), 10);
                mimic.items.clear();
                mimic.items.add(reward);
                GameScene.add(mimic);
                return true;
            }
            case 2: {
                try {
                    Dungeon.saveAll();
                    if (Messages.lang() != Languages.ENGLISH) {
                        return CursedWand.cursedEffect(origin, user, targetPos);
                    }
                    ShatteredPixelDungeon.runOnRenderThread(new Callback(){

                        @Override
                        public void call() {
                            GameScene.show(new WndOptions(Icons.get(Icons.WARNING), "CURSED WAND ERROR", "this application will now self-destruct", new String[]{"abort", "retry", "fail"}){

                                @Override
                                protected void onSelect(int index) {
                                    Game.instance.finish();
                                }

                                @Override
                                public void onBackPressed() {
                                }
                            });
                        }
                    });
                    return false;
                }
                catch (IOException e) {
                    ShatteredPixelDungeon.reportException(e);
                    return CursedWand.cursedEffect(origin, user, targetPos);
                }
            }
            case 3: 
        }
        if (origin == null || user != Dungeon.hero || !Dungeon.hero.belongings.contains(origin)) {
            return CursedWand.cursedEffect(origin, user, targetPos);
        }
        origin.detach(Dungeon.hero.belongings.backpack);
        do {
            result = Generator.random(Random.oneOf(Generator.Category.WEAPON, Generator.Category.ARMOR, Generator.Category.RING, Generator.Category.ARTIFACT));
        } while (result.cursed);
        if (result.isUpgradable()) {
            result.upgrade();
        }
        result.cursedKnown = true;
        result.cursed = true;
        if (origin instanceof Wand) {
            GLog.w(Messages.get(CursedWand.class, "transmogrify_wand", new Object[0]), new Object[0]);
        } else {
            GLog.w(Messages.get(CursedWand.class, "transmogrify_other", new Object[0]), new Object[0]);
        }
        Dungeon.level.drop((Item)result, (int)user.pos).sprite.drop();
        return true;
    }

    private static void cursedFX(Char user, Ballistica bolt, Callback callback) {
        MagicMissile.boltFromChar(user.sprite.parent, 8, user.sprite, bolt.collisionPos, callback);
        Sample.INSTANCE.play("sounds/zap.mp3");
    }
}

