/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.Bones;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.levels.CavesBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.CavesLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.CavesPainter;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.RegularPainter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.CaveRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.tiles.CustomTilemap;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.Tilemap;
import com.watabou.noosa.audio.Music;

public class MiningLevel
extends Level {
    public MiningLevel() {
        this.color1 = 5459774;
        this.color2 = 12179041;
    }

    @Override
    public void playLevelMusic() {
        Music.INSTANCE.playTracks(new String[]{"music/caves_1.ogg", "music/caves_2.ogg", "music/caves_2.ogg"}, new float[]{1.0f, 1.0f, 0.5f}, false);
    }

    @Override
    public String tilesTex() {
        return "environment/tiles_caves.png";
    }

    @Override
    public String waterTex() {
        return "environment/water2.png";
    }

    @Override
    protected boolean build() {
        this.setSize(32, 32);
        CaveRoom c = new CaveRoom();
        c.set(1, 1, 31, 31);
        c.paint(this);
        Painter.fill(this, 15, 15, 3, 3, 1);
        int entrance = 16 * this.width() + 16;
        this.transitions.add(new LevelTransition(this, entrance, LevelTransition.Type.BRANCH_ENTRANCE, Dungeon.depth, 0, LevelTransition.Type.BRANCH_EXIT));
        this.map[entrance] = 7;
        RegularPainter painter = new CavesPainter().setWater(0.35f, 6).setGrass(0.1f, 3);
        ((Painter)painter).paint(this, null);
        BorderDarken vis = new BorderDarken();
        vis.setRect(0, 0, this.width, this.height);
        this.customWalls.add(vis);
        return true;
    }

    @Override
    public Mob createMob() {
        return null;
    }

    @Override
    protected void createMobs() {
    }

    @Override
    public Actor addRespawner() {
        return null;
    }

    @Override
    protected void createItems() {
        Item item = Bones.get();
        if (item != null) {
            this.drop((Item)item, (int)(this.entrance() - this.width())).setHauntedIfCursed().type = Heap.Type.REMAINS;
        }
    }

    @Override
    public int randomRespawnCell(Char ch) {
        return this.entrance() - this.width();
    }

    @Override
    public String tileName(int tile) {
        switch (tile) {
            case 2: {
                return Messages.get(CavesLevel.class, "grass_name", new Object[0]);
            }
            case 15: {
                return Messages.get(CavesLevel.class, "high_grass_name", new Object[0]);
            }
            case 29: {
                return Messages.get(CavesLevel.class, "water_name", new Object[0]);
            }
            case 25: {
                return Messages.get(CityLevel.class, "statue_name", new Object[0]);
            }
        }
        return super.tileName(tile);
    }

    @Override
    public String tileDesc(int tile) {
        switch (tile) {
            case 29: {
                return super.tileDesc(tile) + "\n\n" + Messages.get(CavesBossLevel.class, "water_desc", new Object[0]);
            }
            case 7: {
                return Messages.get(CavesLevel.class, "entrance_desc", new Object[0]);
            }
            case 8: {
                return Messages.get(CityLevel.class, "exit_desc", new Object[0]);
            }
            case 15: {
                return Messages.get(CavesLevel.class, "high_grass_desc", new Object[0]);
            }
            case 12: {
                return Messages.get(CavesLevel.class, "wall_deco_desc", new Object[0]);
            }
            case 27: {
                return Messages.get(CavesLevel.class, "bookshelf_desc", new Object[0]);
            }
            case 25: {
                return Messages.get(CityLevel.class, "statue_desc", new Object[0]);
            }
        }
        return super.tileDesc(tile);
    }

    @Override
    public Group addVisuals() {
        super.addVisuals();
        CavesLevel.addCavesVisuals(this, this.visuals);
        return this.visuals;
    }

    public static class BorderDarken
    extends CustomTilemap {
        public BorderDarken() {
            this.texture = "environment/custom_tiles/caves_quest.png";
        }

        @Override
        public Tilemap create() {
            Tilemap v = super.create();
            int[] data = new int[this.tileW * this.tileH];
            for (int i = 0; i < data.length; ++i) {
                data[i] = i < this.tileW ? 2 : (i % this.tileW == 0 || i % this.tileW == this.tileW - 1 ? 1 : (i + 2 * this.tileW > data.length ? 3 : -1));
            }
            v.map(data, this.tileW);
            return v;
        }

        @Override
        public Image image(int tileX, int tileY) {
            return null;
        }
    }
}

