/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.CrystalKey;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.IronKey;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfExperience;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTransmutation;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfAugmentation;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.EmptyRoom;
import com.shatteredpixel.shatteredpixeldungeon.plants.Starflower;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class CrystalPathRoom
extends SpecialRoom {
    @Override
    public int minWidth() {
        return 7;
    }

    @Override
    public int minHeight() {
        return 7;
    }

    @Override
    public void paint(Level level) {
        int i;
        boolean clockwise;
        Point center;
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 14);
        Room.Door entrance = this.entrance();
        do {
            center = this.center();
        } while (center.x == entrance.x || center.y == entrance.y);
        Painter.drawLine(level, new Point(center.x, this.top + 1), new Point(center.x, this.bottom - 1), 4);
        Painter.drawLine(level, new Point(this.left + 1, center.y), new Point(this.right - 1, center.y), 4);
        Point door = new Point(entrance);
        if (entrance.x == this.left || entrance.x == this.right) {
            door.x = center.x;
            boolean bl = clockwise = entrance.y < center.y;
            if (entrance.x == this.right) {
                clockwise = !clockwise;
            }
        } else {
            door.y = center.y;
            boolean bl = clockwise = entrance.x > center.x;
            if (entrance.y == this.bottom) {
                clockwise = !clockwise;
            }
        }
        EmptyRoom[] rooms = new EmptyRoom[4];
        rooms[0] = new EmptyRoom();
        rooms[0].set(this.left + 1, this.top + 1, center.x - 1, center.y - 1);
        rooms[1] = new EmptyRoom();
        rooms[1].set(center.x + 1, this.top + 1, this.right - 1, center.y - 1);
        rooms[2] = new EmptyRoom();
        rooms[2].set(center.x + 1, center.y + 1, this.right - 1, this.bottom - 1);
        rooms[3] = new EmptyRoom();
        rooms[3].set(this.left + 1, center.y + 1, center.x - 1, this.bottom - 1);
        for (int i2 = 0; i2 < 3; ++i2) {
            if (door.x == center.x) {
                door.y = door.y < center.y ? rooms[0].center().y : rooms[2].center().y;
            } else {
                door.x = door.x < center.x ? rooms[0].center().x : rooms[1].center().x;
            }
            Painter.set(level, door, 31);
            door.x -= center.x;
            door.y -= center.y;
            int tmp = door.x;
            door.x = door.y;
            door.y = tmp;
            if (clockwise) {
                door.x = -door.x;
            } else {
                door.y = -door.y;
            }
            door.x += center.x;
            door.y += center.y;
        }
        int idx = 0;
        for (i = 0; i < rooms.length; ++i) {
            rooms[i].set(rooms[i].shrink(-2));
            if (rooms[i].inside(entrance)) {
                idx = i;
            }
            rooms[i].set(rooms[i].shrink(2));
        }
        for (i = 0; i < 4; ++i) {
            Item item;
            int pos = level.pointToCell(rooms[idx].center());
            block0 : switch (i) {
                default: {
                    item = new Gold().random();
                    break;
                }
                case 1: {
                    item = Generator.random(Generator.Category.POTION);
                    break;
                }
                case 2: {
                    item = Generator.random(Generator.Category.SCROLL);
                    break;
                }
                case 3: {
                    switch (Random.Int(4)) {
                        default: {
                            item = new StoneOfAugmentation();
                            break block0;
                        }
                        case 1: {
                            item = new ScrollOfTransmutation();
                            break block0;
                        }
                        case 2: {
                            item = new Starflower.Seed();
                            break block0;
                        }
                        case 3: 
                    }
                    item = new PotionOfExperience();
                }
            }
            level.drop(item, pos);
            if (clockwise) {
                if (++idx <= 3) continue;
                idx = 0;
                continue;
            }
            if (--idx >= 0) continue;
            idx = 3;
        }
        level.addItemToSpawn(new CrystalKey(Dungeon.depth));
        level.addItemToSpawn(new CrystalKey(Dungeon.depth));
        level.addItemToSpawn(new CrystalKey(Dungeon.depth));
        this.entrance().set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey(Dungeon.depth));
    }

    @Override
    public boolean canConnect(Point p) {
        if (!super.canConnect(p)) {
            return false;
        }
        if (this.width() % 2 == 1 && p.x == this.center().x) {
            return false;
        }
        return this.height() % 2 != 1 || p.y != this.center().y;
    }
}

