/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.RotHeart;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.RotLasher;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.IronKey;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class RotGardenRoom
extends SpecialRoom {
    @Override
    public int minWidth() {
        return 7;
    }

    @Override
    public int minHeight() {
        return 7;
    }

    @Override
    public void paint(Level level) {
        Room.Door entrance = this.entrance();
        entrance.set(Room.Door.Type.LOCKED);
        level.addItemToSpawn(new IronKey(Dungeon.depth));
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 2);
        int heartX = Random.IntRange(this.left + 1, this.right - 1);
        int heartY = Random.IntRange(this.top + 1, this.bottom - 1);
        if (entrance.x == this.left) {
            heartX = this.right - 1;
        } else if (entrance.x == this.right) {
            heartX = this.left + 1;
        } else if (entrance.y == this.top) {
            heartY = this.bottom - 1;
        } else if (entrance.y == this.bottom) {
            heartY = this.top + 1;
        }
        RotGardenRoom.placePlant(level, heartX + heartY * level.width(), new RotHeart());
        int lashers = (this.width() - 2) * (this.height() - 2) / 8;
        for (int i = 1; i <= lashers; ++i) {
            int pos;
            while (!RotGardenRoom.validPlantPos(level, pos = level.pointToCell(this.random()))) {
            }
            RotGardenRoom.placePlant(level, pos, new RotLasher());
        }
    }

    private static boolean validPlantPos(Level level, int pos) {
        if (level.map[pos] != 2) {
            return false;
        }
        for (int i : PathFinder.NEIGHBOURS9) {
            if (level.findMob(pos + i) == null) continue;
            return false;
        }
        return true;
    }

    private static void placePlant(Level level, int pos, Mob plant) {
        plant.pos = pos;
        level.mobs.add(plant);
        for (int i : PathFinder.NEIGHBOURS8) {
            if (level.map[pos + i] != 2) continue;
            Painter.set(level, pos + i, 15);
        }
    }
}

