/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard;

import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.PatchRoom;
import com.watabou.utils.Point;

public class RuinsRoom
extends PatchRoom {
    @Override
    public float[] sizeCatProbs() {
        return new float[]{4.0f, 2.0f, 1.0f};
    }

    @Override
    public boolean canMerge(Level l, Point p, int mergeTerrain) {
        return true;
    }

    @Override
    public void paint(Level level) {
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 1);
        for (Room.Door door : this.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
        }
        int scale = Math.min(this.width() * this.height(), 324);
        float fill = 0.2f + (float)scale / 1024.0f;
        this.setupPatch(level, fill, 0, this.connected.size() > 0);
        this.cleanDiagonalEdges();
        for (int i = this.top + 1; i < this.bottom; ++i) {
            for (int j = this.left + 1; j < this.right; ++j) {
                if (!this.patch[this.xyToPatchCoords(j, i)]) continue;
                int cell = i * level.width() + j;
                level.map[cell] = 4;
            }
        }
    }
}

