/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BloodParticle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoMob;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Image;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.ui.Component;

public class BossHealthBar
extends Component {
    private Image bar;
    private Image rawShielding;
    private Image shieldedHP;
    private Image hp;
    private BitmapText hpText;
    private Button bossInfo;
    private BuffIndicator buffs;
    private static Mob boss;
    private Image skull;
    private Emitter blood;
    private static String asset;
    private static BossHealthBar instance;
    private static boolean bleeding;

    public BossHealthBar() {
        this.active = boss != null;
        this.visible = this.active;
        instance = this;
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (instance == this) {
            instance = null;
        }
        if (this.buffs != null) {
            BuffIndicator.setBossInstance(null);
        }
    }

    @Override
    protected void createChildren() {
        this.bar = new Image(asset, 0, 0, 64, 16);
        this.add(this.bar);
        this.width = this.bar.width;
        this.height = this.bar.height;
        this.rawShielding = new Image(asset, 15, 25, 47, 4);
        this.rawShielding.alpha(0.5f);
        this.add(this.rawShielding);
        this.shieldedHP = new Image(asset, 15, 25, 47, 4);
        this.add(this.shieldedHP);
        this.hp = new Image(asset, 15, 19, 47, 4);
        this.add(this.hp);
        this.hpText = new BitmapText(PixelScene.pixelFont);
        this.hpText.alpha(0.6f);
        this.add(this.hpText);
        this.bossInfo = new Button(){

            @Override
            protected void onClick() {
                super.onClick();
                if (boss != null) {
                    GameScene.show(new WndInfoMob(boss));
                }
            }

            @Override
            protected String hoverText() {
                if (boss != null) {
                    return boss.name();
                }
                return super.hoverText();
            }
        };
        this.add(this.bossInfo);
        if (boss != null) {
            this.buffs = new BuffIndicator(boss, false);
            BuffIndicator.setBossInstance(this.buffs);
            this.add(this.buffs);
        }
        this.skull = new Image(asset, 5, 18, 6, 6);
        this.add(this.skull);
        this.blood = new Emitter();
        this.blood.pos(this.skull);
        this.blood.pour(BloodParticle.FACTORY, 0.3f);
        this.blood.autoKill = false;
        this.blood.on = false;
        this.add(this.blood);
    }

    @Override
    protected void layout() {
        this.bar.x = this.x;
        this.bar.y = this.y;
        this.shieldedHP.x = this.rawShielding.x = this.bar.x + 15.0f;
        this.hp.x = this.rawShielding.x;
        this.shieldedHP.y = this.rawShielding.y = this.bar.y + 3.0f;
        this.hp.y = this.rawShielding.y;
        this.hpText.scale.set(PixelScene.align(0.5f));
        this.hpText.x = this.hp.x + 1.0f;
        this.hpText.y = this.hp.y + (this.hp.height - (this.hpText.baseLine() + this.hpText.scale.y)) / 2.0f;
        this.hpText.y -= 0.001f;
        PixelScene.align(this.hpText);
        this.bossInfo.setRect(this.x, this.y, this.bar.width, this.bar.height);
        if (this.buffs != null) {
            this.buffs.setRect(this.hp.x, this.hp.y + 5.0f, 47.0f, 8.0f);
        }
        this.skull.x = this.bar.x + 5.0f;
        this.skull.y = this.bar.y + 5.0f;
    }

    @Override
    public void update() {
        super.update();
        if (boss != null) {
            if (!boss.isAlive() || !Dungeon.level.mobs.contains(boss)) {
                boss = null;
                this.active = false;
                this.visible = false;
                if (this.buffs != null) {
                    BuffIndicator.setBossInstance(null);
                    this.remove(this.buffs);
                    this.buffs.destroy();
                    this.buffs = null;
                }
            } else {
                int health = BossHealthBar.boss.HP;
                int shield = boss.shielding();
                int max = BossHealthBar.boss.HT;
                this.hp.scale.x = Math.max(0.0f, (float)(health - shield) / (float)max);
                this.shieldedHP.scale.x = (float)health / (float)max;
                this.rawShielding.scale.x = (float)shield / (float)max;
                if (this.hp.scale.x < 0.25f) {
                    BossHealthBar.bleed(true);
                }
                if (bleeding != this.blood.on) {
                    if (bleeding) {
                        this.skull.tint(0xCC0000, 0.6f);
                    } else {
                        this.skull.resetColor();
                    }
                    this.blood.on = bleeding;
                }
                if (shield <= 0) {
                    this.hpText.text(health + "/" + max);
                } else {
                    this.hpText.text(health + "+" + shield + "/" + max);
                }
            }
        }
    }

    public static void assignBoss(Mob boss) {
        if (BossHealthBar.boss == boss) {
            return;
        }
        BossHealthBar.boss = boss;
        BossHealthBar.bleed(false);
        if (instance != null) {
            BossHealthBar.instance.active = true;
            BossHealthBar.instance.visible = true;
            if (boss != null) {
                if (BossHealthBar.instance.buffs != null) {
                    instance.remove(BossHealthBar.instance.buffs);
                    BossHealthBar.instance.buffs.destroy();
                }
                BossHealthBar.instance.buffs = new BuffIndicator(boss, false);
                BuffIndicator.setBossInstance(BossHealthBar.instance.buffs);
                instance.add(BossHealthBar.instance.buffs);
                instance.layout();
            }
        }
    }

    public static boolean isAssigned() {
        return boss != null && boss.isAlive() && Dungeon.level.mobs.contains(boss);
    }

    public static void bleed(boolean value) {
        bleeding = value;
    }

    static {
        asset = "interfaces/boss_hp.png";
    }
}

