/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Blacksmith;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.ItemSlot;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndMessage;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.ui.Component;

public class WndBlacksmith
extends Window {
    private static final int BTN_SIZE = 36;
    private static final float GAP = 2.0f;
    private static final float BTN_GAP = 10.0f;
    private static final int WIDTH = 116;
    private ItemButton btnPressed;
    private ItemButton btnItem1;
    private ItemButton btnItem2;
    private RedButton btnReforge;
    protected WndBag.ItemSelector itemSelector = new WndBag.ItemSelector(){

        @Override
        public String textPrompt() {
            return Messages.get(WndBlacksmith.class, "select", new Object[0]);
        }

        @Override
        public Class<? extends Bag> preferredBag() {
            return Belongings.Backpack.class;
        }

        @Override
        public boolean itemSelectable(Item item) {
            return item.isUpgradable();
        }

        @Override
        public void onSelect(Item item) {
            if (item != null && ((WndBlacksmith)WndBlacksmith.this).btnPressed.parent != null) {
                WndBlacksmith.this.btnPressed.item(item);
                if (((WndBlacksmith)WndBlacksmith.this).btnItem1.item != null && ((WndBlacksmith)WndBlacksmith.this).btnItem2.item != null) {
                    String result = Blacksmith.verify(((WndBlacksmith)WndBlacksmith.this).btnItem1.item, ((WndBlacksmith)WndBlacksmith.this).btnItem2.item);
                    if (result != null) {
                        GameScene.show(new WndMessage(result));
                        WndBlacksmith.this.btnReforge.enable(false);
                    } else {
                        WndBlacksmith.this.btnReforge.enable(true);
                    }
                }
            }
        }
    };

    public WndBlacksmith(Blacksmith troll, Hero hero) {
        IconTitle titlebar = new IconTitle();
        titlebar.icon(troll.sprite());
        titlebar.label(Messages.titleCase(troll.name()));
        titlebar.setRect(0.0f, 0.0f, 116.0f, 0.0f);
        this.add(titlebar);
        RenderedTextBlock message = PixelScene.renderTextBlock(Messages.get(this, "prompt", new Object[0]), 6);
        message.maxWidth(116);
        message.setPos(0.0f, titlebar.bottom() + 2.0f);
        this.add(message);
        this.btnItem1 = new ItemButton(){

            @Override
            protected void onClick() {
                WndBlacksmith.this.btnPressed = WndBlacksmith.this.btnItem1;
                GameScene.selectItem(WndBlacksmith.this.itemSelector);
            }
        };
        this.btnItem1.setRect(17.0f, message.top() + message.height() + 10.0f, 36.0f, 36.0f);
        this.add(this.btnItem1);
        this.btnItem2 = new ItemButton(){

            @Override
            protected void onClick() {
                WndBlacksmith.this.btnPressed = WndBlacksmith.this.btnItem2;
                GameScene.selectItem(WndBlacksmith.this.itemSelector);
            }
        };
        this.btnItem2.setRect(this.btnItem1.right() + 10.0f, this.btnItem1.top(), 36.0f, 36.0f);
        this.add(this.btnItem2);
        this.btnReforge = new RedButton(Messages.get(this, "reforge", new Object[0])){

            @Override
            protected void onClick() {
                Blacksmith.upgrade(((WndBlacksmith)WndBlacksmith.this).btnItem1.item, ((WndBlacksmith)WndBlacksmith.this).btnItem2.item);
                WndBlacksmith.this.hide();
            }
        };
        this.btnReforge.enable(false);
        this.btnReforge.setRect(0.0f, this.btnItem1.bottom() + 10.0f, 116.0f, 20.0f);
        this.add(this.btnReforge);
        this.resize(116, (int)this.btnReforge.bottom());
    }

    public static class ItemButton
    extends Component {
        protected NinePatch bg;
        protected ItemSlot slot;
        public Item item = null;

        @Override
        protected void createChildren() {
            super.createChildren();
            this.bg = Chrome.get(Chrome.Type.RED_BUTTON);
            this.add(this.bg);
            this.slot = new ItemSlot(){

                @Override
                protected void onPointerDown() {
                    bg.brightness(1.2f);
                    Sample.INSTANCE.play("sounds/click.mp3");
                }

                @Override
                protected void onPointerUp() {
                    bg.resetColor();
                }

                @Override
                protected void onClick() {
                    this.onClick();
                }
            };
            this.slot.enable(true);
            this.add(this.slot);
        }

        protected void onClick() {
        }

        @Override
        protected void layout() {
            super.layout();
            this.bg.x = this.x;
            this.bg.y = this.y;
            this.bg.size(this.width, this.height);
            this.slot.setRect(this.x + 2.0f, this.y + 2.0f, this.width - 4.0f, this.height - 4.0f);
        }

        public void item(Item item) {
            this.item = item;
            this.slot.item(this.item);
        }

        @Override
        public void clear() {
            this.slot.clear();
        }
    }
}

