/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa.audio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.watabou.noosa.Game;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Collections;

public enum Music {
    INSTANCE;

    private com.badlogic.gdx.audio.Music player;
    private String lastPlayed;
    private boolean looping;
    private boolean enabled = true;
    private float volume = 1.0f;
    String[] trackList;
    float[] trackChances;
    private final ArrayList<String> trackQueue = new ArrayList();
    boolean shuffle = false;
    private Music.OnCompletionListener trackLooper = new Music.OnCompletionListener(){

        @Override
        public void onCompletion(final com.badlogic.gdx.audio.Music music) {
            if (!DeviceCompat.isDesktop()) {
                new Thread(){

                    @Override
                    public void run() {
                        Music.this.playNextTrack(music);
                    }
                }.start();
            } else {
                Music.this.playNextTrack(music);
            }
        }
    };

    public synchronized void play(String assetName, boolean looping) {
        if (assetName != null && DeviceCompat.isiOS()) {
            assetName = assetName.replace(".ogg", ".mp3");
        }
        if (this.isPlaying() && this.lastPlayed != null && this.lastPlayed.equals(assetName)) {
            return;
        }
        this.stop();
        this.lastPlayed = assetName;
        this.trackList = null;
        this.looping = looping;
        this.shuffle = false;
        if (!this.enabled || assetName == null) {
            return;
        }
        this.play(assetName, null);
    }

    public synchronized void playTracks(String[] tracks, float[] chances, boolean shuffle) {
        int i;
        if (tracks == null || tracks.length == 0 || tracks.length != chances.length) {
            this.stop();
            return;
        }
        if (tracks != null && DeviceCompat.isiOS()) {
            for (i = 0; i < tracks.length; ++i) {
                tracks[i] = tracks[i].replace(".ogg", ".mp3");
            }
        }
        if (this.isPlaying() && this.trackList != null && tracks.length == this.trackList.length) {
            boolean sameList = true;
            for (int i2 = 0; i2 < tracks.length; ++i2) {
                if (tracks[i2].equals(this.trackList[i2]) && chances[i2] == this.trackChances[i2]) continue;
                sameList = false;
                break;
            }
            if (sameList) {
                return;
            }
        }
        this.stop();
        this.lastPlayed = null;
        this.trackList = tracks;
        this.trackChances = chances;
        this.trackQueue.clear();
        for (i = 0; i < this.trackList.length; ++i) {
            if (!(Random.Float() < this.trackChances[i])) continue;
            this.trackQueue.add(this.trackList[i]);
        }
        this.looping = false;
        this.shuffle = shuffle;
        if (!this.enabled || this.trackQueue.isEmpty()) {
            return;
        }
        this.play(this.trackQueue.remove(0), this.trackLooper);
    }

    private synchronized void playNextTrack(com.badlogic.gdx.audio.Music music) {
        if (this.trackList == null || this.trackList.length == 0 || music != this.player || this.player.isLooping()) {
            return;
        }
        this.stop();
        if (this.trackQueue.isEmpty()) {
            for (int i = 0; i < this.trackList.length; ++i) {
                if (!(Random.Float() < this.trackChances[i])) continue;
                this.trackQueue.add(this.trackList[i]);
            }
            if (this.shuffle) {
                Collections.shuffle(this.trackQueue);
            }
        }
        if (!this.enabled || this.trackQueue.isEmpty()) {
            return;
        }
        this.play(this.trackQueue.remove(0), this.trackLooper);
    }

    private synchronized void play(String track, Music.OnCompletionListener listener) {
        try {
            this.player = Gdx.audio.newMusic(Gdx.files.internal(track));
            this.player.setLooping(this.looping);
            this.player.setVolume(this.volume);
            this.player.play();
            if (listener != null) {
                this.player.setOnCompletionListener(listener);
            }
        }
        catch (Exception e) {
            Game.reportException(e);
            this.player = null;
        }
    }

    public synchronized void end() {
        this.lastPlayed = null;
        this.trackList = null;
        this.stop();
    }

    public synchronized void pause() {
        if (this.player != null) {
            this.player.pause();
        }
    }

    public synchronized void resume() {
        if (this.player != null) {
            this.player.play();
            this.player.setLooping(this.looping);
        }
    }

    public synchronized void stop() {
        if (this.player != null) {
            this.player.dispose();
            this.player = null;
        }
    }

    public synchronized void volume(float value) {
        this.volume = value;
        if (this.player != null) {
            this.player.setVolume(value);
        }
    }

    public synchronized boolean isPlaying() {
        return this.player != null && this.player.isPlaying();
    }

    public synchronized void enable(boolean value) {
        this.enabled = value;
        if (this.isPlaying() && !value) {
            this.stop();
        } else if (!this.isPlaying() && value) {
            if (this.trackList != null) {
                this.playTracks(this.trackList, this.trackChances, this.shuffle);
            } else if (this.lastPlayed != null) {
                this.play(this.lastPlayed, this.looping);
            }
        }
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }
}

