/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.basictypes.TerrainPos;
import hughai.mapping.BuildMap;
import hughai.mapping.HeightMap;
import hughai.mapping.Maps;
import hughai.mapping.MovementMaps;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.LogFile;

public class BuildPlanner {
    public final int BuildMargin = 8;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    UnitDefHelp unitdefhelp;
    Maps maps;
    int mapwidth;
    int mapheight;

    public BuildPlanner(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.unitdefhelp = playerObjects.getUnitDefHelp();
        this.maps = playerObjects.getMaps();
        this.mapwidth = this.aicallback.getMap().getWidth();
        this.mapheight = this.aicallback.getMap().getHeight();
    }

    public TerrainPos ClosestBuildSite(UnitDef unitDef, TerrainPos terrainPos, int n, int n2) {
        int n3 = (int)(terrainPos.x / 8.0f);
        int n4 = (int)(terrainPos.z / 8.0f);
        int n5 = n2;
        int n6 = unitDef.getXSize() + 16;
        int n7 = unitDef.getZSize() + 16;
        if (this.unitdefhelp.IsFactory(unitDef)) {
            n7 += 8;
            n4 += 4;
        }
        while (n5 < n / 8) {
            for (int i = -n5; i <= n5; ++i) {
                for (int j = -n5; j <= n5; ++j) {
                    if (i != n5 && i != -n5 && j != n5 && j != -n5) continue;
                    boolean bl = true;
                    for (int k = n4 - n7 / 2; bl && k < n4 + n7 / 2; ++k) {
                        for (int i2 = n3 - n6 / 2; bl && i2 < n3 + n6 / 2; ++i2) {
                            BuildMap.BuildMapPos buildMapPos = new BuildMap.BuildMapPos(i2 + i, k + j);
                            HeightMap.HeightMapPos heightMapPos = buildMapPos.toHeightMapPos();
                            MovementMaps.MovementMapPos movementMapPos = MovementMaps.MovementMapPos.fromHeightMapPos(heightMapPos);
                            if (buildMapPos.validate() && this.maps.getBuildMap().isSquareAvailable(buildMapPos) && this.maps.getMovementMaps().vehicleCanMoveOk(movementMapPos)) continue;
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    return new TerrainPos((n3 + i) * 8, 0.0f, (n4 + j) * 8);
                }
            }
            ++n5;
        }
        return null;
    }
}

