'use strict';

const IS_VALID_HEX = /^#(?:[\da-f]{3,4}|[\da-f]{6}|[\da-f]{8})$/i;

/**
 * Check if a value is a valid 3, 4, 6 or 8 digit hex
 *
 * @param {string} value
 * @returns {boolean}
 */
module.exports = function isValidHex(value) {
	return IS_VALID_HEX.test(value);
};
