// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: tensorflow/compiler/xla/pjrt/distributed/protocol.proto
// Original file comments:
// Copyright 2020 The TensorFlow Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ==============================================================================
//
// Distributed XLA service protocol.
//
// This is a minimal distributed protocol intended for a small set of purposes
// * barriers to wait for all clients to start up or shut down
// * health checking to detect when clients vanish
// * for sharing GPU topology and NCCL communicator state between distributed
//   hosts.
//
// The intention is that a service is started during cluster initialization and
// persists for the lifetime of the cluster.
//
#ifndef GRPC_tensorflow_2fcompiler_2fxla_2fpjrt_2fdistributed_2fprotocol_2eproto__INCLUDED
#define GRPC_tensorflow_2fcompiler_2fxla_2fpjrt_2fdistributed_2fprotocol_2eproto__INCLUDED

#include "tensorflow/compiler/xla/pjrt/distributed/protocol.pb.h"

#include <functional>
#include <grpc/impl/codegen/port_platform.h>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace xla {


namespace grpc {

class DistributedRuntimeService final {
 public:
  static constexpr char const* service_full_name() {
    return "xla.DistributedRuntimeService";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Connects a node to the distributed coordinator node. Blocks until all tasks
    // have connected. The service receives the number of nodes to expect as an
    // option passed to its constructor.
    virtual ::grpc::Status Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::xla::ConnectResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ConnectResponse>> AsyncConnect(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ConnectResponse>>(AsyncConnectRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ConnectResponse>> PrepareAsyncConnect(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ConnectResponse>>(PrepareAsyncConnectRaw(context, request, cq));
    }
    // Blocking enumeration of devices, used by the GPU backend only.
    // In parallel, all clients call EnumerateDevices() with their local device
    // topology, and receive back a global topology in response.
    virtual ::grpc::Status EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::xla::EnumerateDevicesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::EnumerateDevicesResponse>> AsyncEnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::EnumerateDevicesResponse>>(AsyncEnumerateDevicesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::EnumerateDevicesResponse>> PrepareAsyncEnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::EnumerateDevicesResponse>>(PrepareAsyncEnumerateDevicesRaw(context, request, cq));
    }
    // Health-checking RPC. Workers send heartbeats to the coordinator at regular
    // intervals. If the worker does not hear from the coordinator or the
    // coordinator does not hear from the tasks, the tasks abort.
    virtual ::grpc::Status Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::xla::HeartbeatResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::HeartbeatResponse>> AsyncHeartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::HeartbeatResponse>>(AsyncHeartbeatRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::HeartbeatResponse>> PrepareAsyncHeartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::HeartbeatResponse>>(PrepareAsyncHeartbeatRaw(context, request, cq));
    }
    // Shutdown RPC. Workers send this RPC when they are ready to shut down; the
    // RPC blocks until all tasks have indicated they are ready to shut down,
    // or a timeout is reached.
    virtual ::grpc::Status Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::xla::ShutdownResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ShutdownResponse>> AsyncShutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ShutdownResponse>>(AsyncShutdownRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ShutdownResponse>> PrepareAsyncShutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::ShutdownResponse>>(PrepareAsyncShutdownRaw(context, request, cq));
    }
    // Simple key-value store used for sharing configuration data.
    // For example, when using NCCL to communicate between multiple GPUs,
    // the NCCL communicator IDs are stored here.
    //
    // Looks up a key in the key-value service. Blocks until the key is present
    // or until `timeout` expires.
    virtual ::grpc::Status KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::xla::KeyValueGetResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueGetResponse>> AsyncKeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueGetResponse>>(AsyncKeyValueGetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueGetResponse>> PrepareAsyncKeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueGetResponse>>(PrepareAsyncKeyValueGetRaw(context, request, cq));
    }
    // Updates the value associated with a key.
    virtual ::grpc::Status KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::xla::KeyValueSetResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueSetResponse>> AsyncKeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueSetResponse>>(AsyncKeyValueSetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueSetResponse>> PrepareAsyncKeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueSetResponse>>(PrepareAsyncKeyValueSetRaw(context, request, cq));
    }
    // Blocks until all nodes are at the barrier or the barrier times out.
    virtual ::grpc::Status WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::xla::WaitAtBarrierResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::WaitAtBarrierResponse>> AsyncWaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::WaitAtBarrierResponse>>(AsyncWaitAtBarrierRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::WaitAtBarrierResponse>> PrepareAsyncWaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::xla::WaitAtBarrierResponse>>(PrepareAsyncWaitAtBarrierRaw(context, request, cq));
    }
    class experimental_async_interface {
     public:
      virtual ~experimental_async_interface() {}
      // Connects a node to the distributed coordinator node. Blocks until all tasks
      // have connected. The service receives the number of nodes to expect as an
      // option passed to its constructor.
      virtual void Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Connect(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ConnectResponse* response, std::function<void(::grpc::Status)>) = 0;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void Connect(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ConnectResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void Connect(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ConnectResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      // Blocking enumeration of devices, used by the GPU backend only.
      // In parallel, all clients call EnumerateDevices() with their local device
      // topology, and receive back a global topology in response.
      virtual void EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void EnumerateDevices(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::EnumerateDevicesResponse* response, std::function<void(::grpc::Status)>) = 0;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void EnumerateDevices(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::EnumerateDevicesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void EnumerateDevices(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::EnumerateDevicesResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      // Health-checking RPC. Workers send heartbeats to the coordinator at regular
      // intervals. If the worker does not hear from the coordinator or the
      // coordinator does not hear from the tasks, the tasks abort.
      virtual void Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Heartbeat(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::HeartbeatResponse* response, std::function<void(::grpc::Status)>) = 0;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void Heartbeat(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::HeartbeatResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void Heartbeat(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::HeartbeatResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      // Shutdown RPC. Workers send this RPC when they are ready to shut down; the
      // RPC blocks until all tasks have indicated they are ready to shut down,
      // or a timeout is reached.
      virtual void Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Shutdown(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ShutdownResponse* response, std::function<void(::grpc::Status)>) = 0;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void Shutdown(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ShutdownResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void Shutdown(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ShutdownResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      // Simple key-value store used for sharing configuration data.
      // For example, when using NCCL to communicate between multiple GPUs,
      // the NCCL communicator IDs are stored here.
      //
      // Looks up a key in the key-value service. Blocks until the key is present
      // or until `timeout` expires.
      virtual void KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void KeyValueGet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueGetResponse* response, std::function<void(::grpc::Status)>) = 0;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void KeyValueGet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueGetResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void KeyValueGet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueGetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      // Updates the value associated with a key.
      virtual void KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void KeyValueSet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueSetResponse* response, std::function<void(::grpc::Status)>) = 0;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void KeyValueSet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueSetResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void KeyValueSet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueSetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      // Blocks until all nodes are at the barrier or the barrier times out.
      virtual void WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void WaitAtBarrier(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::WaitAtBarrierResponse* response, std::function<void(::grpc::Status)>) = 0;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      virtual void WaitAtBarrier(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::WaitAtBarrierResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      #else
      virtual void WaitAtBarrier(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::WaitAtBarrierResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) = 0;
      #endif
    };
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    typedef class experimental_async_interface async_interface;
    #endif
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    async_interface* async() { return experimental_async(); }
    #endif
    virtual class experimental_async_interface* experimental_async() { return nullptr; }
  private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::ConnectResponse>* AsyncConnectRaw(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::ConnectResponse>* PrepareAsyncConnectRaw(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::EnumerateDevicesResponse>* AsyncEnumerateDevicesRaw(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::EnumerateDevicesResponse>* PrepareAsyncEnumerateDevicesRaw(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::HeartbeatResponse>* AsyncHeartbeatRaw(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::HeartbeatResponse>* PrepareAsyncHeartbeatRaw(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::ShutdownResponse>* AsyncShutdownRaw(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::ShutdownResponse>* PrepareAsyncShutdownRaw(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueGetResponse>* AsyncKeyValueGetRaw(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueGetResponse>* PrepareAsyncKeyValueGetRaw(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueSetResponse>* AsyncKeyValueSetRaw(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::KeyValueSetResponse>* PrepareAsyncKeyValueSetRaw(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::WaitAtBarrierResponse>* AsyncWaitAtBarrierRaw(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::xla::WaitAtBarrierResponse>* PrepareAsyncWaitAtBarrierRaw(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel);
    ::grpc::Status Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::xla::ConnectResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ConnectResponse>> AsyncConnect(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ConnectResponse>>(AsyncConnectRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ConnectResponse>> PrepareAsyncConnect(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ConnectResponse>>(PrepareAsyncConnectRaw(context, request, cq));
    }
    ::grpc::Status EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::xla::EnumerateDevicesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::EnumerateDevicesResponse>> AsyncEnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::EnumerateDevicesResponse>>(AsyncEnumerateDevicesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::EnumerateDevicesResponse>> PrepareAsyncEnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::EnumerateDevicesResponse>>(PrepareAsyncEnumerateDevicesRaw(context, request, cq));
    }
    ::grpc::Status Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::xla::HeartbeatResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::HeartbeatResponse>> AsyncHeartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::HeartbeatResponse>>(AsyncHeartbeatRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::HeartbeatResponse>> PrepareAsyncHeartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::HeartbeatResponse>>(PrepareAsyncHeartbeatRaw(context, request, cq));
    }
    ::grpc::Status Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::xla::ShutdownResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ShutdownResponse>> AsyncShutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ShutdownResponse>>(AsyncShutdownRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ShutdownResponse>> PrepareAsyncShutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::ShutdownResponse>>(PrepareAsyncShutdownRaw(context, request, cq));
    }
    ::grpc::Status KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::xla::KeyValueGetResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueGetResponse>> AsyncKeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueGetResponse>>(AsyncKeyValueGetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueGetResponse>> PrepareAsyncKeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueGetResponse>>(PrepareAsyncKeyValueGetRaw(context, request, cq));
    }
    ::grpc::Status KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::xla::KeyValueSetResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueSetResponse>> AsyncKeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueSetResponse>>(AsyncKeyValueSetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueSetResponse>> PrepareAsyncKeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::KeyValueSetResponse>>(PrepareAsyncKeyValueSetRaw(context, request, cq));
    }
    ::grpc::Status WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::xla::WaitAtBarrierResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::WaitAtBarrierResponse>> AsyncWaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::WaitAtBarrierResponse>>(AsyncWaitAtBarrierRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::WaitAtBarrierResponse>> PrepareAsyncWaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::xla::WaitAtBarrierResponse>>(PrepareAsyncWaitAtBarrierRaw(context, request, cq));
    }
    class experimental_async final :
      public StubInterface::experimental_async_interface {
     public:
      void Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response, std::function<void(::grpc::Status)>) override;
      void Connect(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ConnectResponse* response, std::function<void(::grpc::Status)>) override;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void Connect(::grpc::ClientContext* context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void Connect(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ConnectResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void Connect(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ConnectResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      void EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response, std::function<void(::grpc::Status)>) override;
      void EnumerateDevices(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::EnumerateDevicesResponse* response, std::function<void(::grpc::Status)>) override;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void EnumerateDevices(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void EnumerateDevices(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::EnumerateDevicesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void EnumerateDevices(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::EnumerateDevicesResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      void Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response, std::function<void(::grpc::Status)>) override;
      void Heartbeat(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::HeartbeatResponse* response, std::function<void(::grpc::Status)>) override;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void Heartbeat(::grpc::ClientContext* context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void Heartbeat(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::HeartbeatResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void Heartbeat(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::HeartbeatResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      void Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response, std::function<void(::grpc::Status)>) override;
      void Shutdown(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ShutdownResponse* response, std::function<void(::grpc::Status)>) override;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void Shutdown(::grpc::ClientContext* context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void Shutdown(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ShutdownResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void Shutdown(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::ShutdownResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      void KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response, std::function<void(::grpc::Status)>) override;
      void KeyValueGet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueGetResponse* response, std::function<void(::grpc::Status)>) override;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void KeyValueGet(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void KeyValueGet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueGetResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void KeyValueGet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueGetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      void KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response, std::function<void(::grpc::Status)>) override;
      void KeyValueSet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueSetResponse* response, std::function<void(::grpc::Status)>) override;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void KeyValueSet(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void KeyValueSet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueSetResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void KeyValueSet(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::KeyValueSetResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      void WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response, std::function<void(::grpc::Status)>) override;
      void WaitAtBarrier(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::WaitAtBarrierResponse* response, std::function<void(::grpc::Status)>) override;
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void WaitAtBarrier(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
      #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      void WaitAtBarrier(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::WaitAtBarrierResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      #else
      void WaitAtBarrier(::grpc::ClientContext* context, const ::grpc::ByteBuffer* request, ::xla::WaitAtBarrierResponse* response, ::grpc::experimental::ClientUnaryReactor* reactor) override;
      #endif
     private:
      friend class Stub;
      explicit experimental_async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class experimental_async_interface* experimental_async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class experimental_async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::xla::ConnectResponse>* AsyncConnectRaw(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::ConnectResponse>* PrepareAsyncConnectRaw(::grpc::ClientContext* context, const ::xla::ConnectRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::EnumerateDevicesResponse>* AsyncEnumerateDevicesRaw(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::EnumerateDevicesResponse>* PrepareAsyncEnumerateDevicesRaw(::grpc::ClientContext* context, const ::xla::EnumerateDevicesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::HeartbeatResponse>* AsyncHeartbeatRaw(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::HeartbeatResponse>* PrepareAsyncHeartbeatRaw(::grpc::ClientContext* context, const ::xla::HeartbeatRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::ShutdownResponse>* AsyncShutdownRaw(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::ShutdownResponse>* PrepareAsyncShutdownRaw(::grpc::ClientContext* context, const ::xla::ShutdownRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::KeyValueGetResponse>* AsyncKeyValueGetRaw(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::KeyValueGetResponse>* PrepareAsyncKeyValueGetRaw(::grpc::ClientContext* context, const ::xla::KeyValueGetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::KeyValueSetResponse>* AsyncKeyValueSetRaw(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::KeyValueSetResponse>* PrepareAsyncKeyValueSetRaw(::grpc::ClientContext* context, const ::xla::KeyValueSetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::WaitAtBarrierResponse>* AsyncWaitAtBarrierRaw(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::xla::WaitAtBarrierResponse>* PrepareAsyncWaitAtBarrierRaw(::grpc::ClientContext* context, const ::xla::WaitAtBarrierRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_Connect_;
    const ::grpc::internal::RpcMethod rpcmethod_EnumerateDevices_;
    const ::grpc::internal::RpcMethod rpcmethod_Heartbeat_;
    const ::grpc::internal::RpcMethod rpcmethod_Shutdown_;
    const ::grpc::internal::RpcMethod rpcmethod_KeyValueGet_;
    const ::grpc::internal::RpcMethod rpcmethod_KeyValueSet_;
    const ::grpc::internal::RpcMethod rpcmethod_WaitAtBarrier_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Connects a node to the distributed coordinator node. Blocks until all tasks
    // have connected. The service receives the number of nodes to expect as an
    // option passed to its constructor.
    virtual ::grpc::Status Connect(::grpc::ServerContext* context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response);
    // Blocking enumeration of devices, used by the GPU backend only.
    // In parallel, all clients call EnumerateDevices() with their local device
    // topology, and receive back a global topology in response.
    virtual ::grpc::Status EnumerateDevices(::grpc::ServerContext* context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response);
    // Health-checking RPC. Workers send heartbeats to the coordinator at regular
    // intervals. If the worker does not hear from the coordinator or the
    // coordinator does not hear from the tasks, the tasks abort.
    virtual ::grpc::Status Heartbeat(::grpc::ServerContext* context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response);
    // Shutdown RPC. Workers send this RPC when they are ready to shut down; the
    // RPC blocks until all tasks have indicated they are ready to shut down,
    // or a timeout is reached.
    virtual ::grpc::Status Shutdown(::grpc::ServerContext* context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response);
    // Simple key-value store used for sharing configuration data.
    // For example, when using NCCL to communicate between multiple GPUs,
    // the NCCL communicator IDs are stored here.
    //
    // Looks up a key in the key-value service. Blocks until the key is present
    // or until `timeout` expires.
    virtual ::grpc::Status KeyValueGet(::grpc::ServerContext* context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response);
    // Updates the value associated with a key.
    virtual ::grpc::Status KeyValueSet(::grpc::ServerContext* context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response);
    // Blocks until all nodes are at the barrier or the barrier times out.
    virtual ::grpc::Status WaitAtBarrier(::grpc::ServerContext* context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_Connect : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Connect() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_Connect() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Connect(::grpc::ServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestConnect(::grpc::ServerContext* context, ::xla::ConnectRequest* request, ::grpc::ServerAsyncResponseWriter< ::xla::ConnectResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_EnumerateDevices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_EnumerateDevices() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_EnumerateDevices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnumerateDevices(::grpc::ServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestEnumerateDevices(::grpc::ServerContext* context, ::xla::EnumerateDevicesRequest* request, ::grpc::ServerAsyncResponseWriter< ::xla::EnumerateDevicesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Heartbeat : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Heartbeat() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_Heartbeat() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Heartbeat(::grpc::ServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestHeartbeat(::grpc::ServerContext* context, ::xla::HeartbeatRequest* request, ::grpc::ServerAsyncResponseWriter< ::xla::HeartbeatResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Shutdown : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Shutdown() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_Shutdown() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Shutdown(::grpc::ServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestShutdown(::grpc::ServerContext* context, ::xla::ShutdownRequest* request, ::grpc::ServerAsyncResponseWriter< ::xla::ShutdownResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_KeyValueGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_KeyValueGet() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_KeyValueGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueGet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKeyValueGet(::grpc::ServerContext* context, ::xla::KeyValueGetRequest* request, ::grpc::ServerAsyncResponseWriter< ::xla::KeyValueGetResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_KeyValueSet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_KeyValueSet() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_KeyValueSet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueSet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKeyValueSet(::grpc::ServerContext* context, ::xla::KeyValueSetRequest* request, ::grpc::ServerAsyncResponseWriter< ::xla::KeyValueSetResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_WaitAtBarrier : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_WaitAtBarrier() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_WaitAtBarrier() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitAtBarrier(::grpc::ServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWaitAtBarrier(::grpc::ServerContext* context, ::xla::WaitAtBarrierRequest* request, ::grpc::ServerAsyncResponseWriter< ::xla::WaitAtBarrierResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_Connect<WithAsyncMethod_EnumerateDevices<WithAsyncMethod_Heartbeat<WithAsyncMethod_Shutdown<WithAsyncMethod_KeyValueGet<WithAsyncMethod_KeyValueSet<WithAsyncMethod_WaitAtBarrier<Service > > > > > > > AsyncService;
  template <class BaseClass>
  class ExperimentalWithCallbackMethod_Connect : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithCallbackMethod_Connect() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodCallback(0,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::xla::ConnectRequest, ::xla::ConnectResponse>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::xla::ConnectRequest* request, ::xla::ConnectResponse* response) { return this->Connect(context, request, response); }));}
    void SetMessageAllocatorFor_Connect(
        ::grpc::experimental::MessageAllocator< ::xla::ConnectRequest, ::xla::ConnectResponse>* allocator) {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
    #else
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::experimental().GetHandler(0);
    #endif
      static_cast<::grpc_impl::internal::CallbackUnaryHandler< ::xla::ConnectRequest, ::xla::ConnectResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~ExperimentalWithCallbackMethod_Connect() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Connect(::grpc::ServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* Connect(
      ::grpc::CallbackServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* Connect(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithCallbackMethod_EnumerateDevices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithCallbackMethod_EnumerateDevices() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodCallback(1,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::xla::EnumerateDevicesRequest, ::xla::EnumerateDevicesResponse>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::xla::EnumerateDevicesRequest* request, ::xla::EnumerateDevicesResponse* response) { return this->EnumerateDevices(context, request, response); }));}
    void SetMessageAllocatorFor_EnumerateDevices(
        ::grpc::experimental::MessageAllocator< ::xla::EnumerateDevicesRequest, ::xla::EnumerateDevicesResponse>* allocator) {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
    #else
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::experimental().GetHandler(1);
    #endif
      static_cast<::grpc_impl::internal::CallbackUnaryHandler< ::xla::EnumerateDevicesRequest, ::xla::EnumerateDevicesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~ExperimentalWithCallbackMethod_EnumerateDevices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnumerateDevices(::grpc::ServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* EnumerateDevices(
      ::grpc::CallbackServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* EnumerateDevices(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithCallbackMethod_Heartbeat : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithCallbackMethod_Heartbeat() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodCallback(2,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::xla::HeartbeatRequest, ::xla::HeartbeatResponse>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::xla::HeartbeatRequest* request, ::xla::HeartbeatResponse* response) { return this->Heartbeat(context, request, response); }));}
    void SetMessageAllocatorFor_Heartbeat(
        ::grpc::experimental::MessageAllocator< ::xla::HeartbeatRequest, ::xla::HeartbeatResponse>* allocator) {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
    #else
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::experimental().GetHandler(2);
    #endif
      static_cast<::grpc_impl::internal::CallbackUnaryHandler< ::xla::HeartbeatRequest, ::xla::HeartbeatResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~ExperimentalWithCallbackMethod_Heartbeat() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Heartbeat(::grpc::ServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* Heartbeat(
      ::grpc::CallbackServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* Heartbeat(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithCallbackMethod_Shutdown : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithCallbackMethod_Shutdown() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodCallback(3,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::xla::ShutdownRequest, ::xla::ShutdownResponse>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::xla::ShutdownRequest* request, ::xla::ShutdownResponse* response) { return this->Shutdown(context, request, response); }));}
    void SetMessageAllocatorFor_Shutdown(
        ::grpc::experimental::MessageAllocator< ::xla::ShutdownRequest, ::xla::ShutdownResponse>* allocator) {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
    #else
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::experimental().GetHandler(3);
    #endif
      static_cast<::grpc_impl::internal::CallbackUnaryHandler< ::xla::ShutdownRequest, ::xla::ShutdownResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~ExperimentalWithCallbackMethod_Shutdown() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Shutdown(::grpc::ServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* Shutdown(
      ::grpc::CallbackServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* Shutdown(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithCallbackMethod_KeyValueGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithCallbackMethod_KeyValueGet() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodCallback(4,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::xla::KeyValueGetRequest, ::xla::KeyValueGetResponse>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::xla::KeyValueGetRequest* request, ::xla::KeyValueGetResponse* response) { return this->KeyValueGet(context, request, response); }));}
    void SetMessageAllocatorFor_KeyValueGet(
        ::grpc::experimental::MessageAllocator< ::xla::KeyValueGetRequest, ::xla::KeyValueGetResponse>* allocator) {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
    #else
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::experimental().GetHandler(4);
    #endif
      static_cast<::grpc_impl::internal::CallbackUnaryHandler< ::xla::KeyValueGetRequest, ::xla::KeyValueGetResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~ExperimentalWithCallbackMethod_KeyValueGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueGet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* KeyValueGet(
      ::grpc::CallbackServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* KeyValueGet(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithCallbackMethod_KeyValueSet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithCallbackMethod_KeyValueSet() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodCallback(5,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::xla::KeyValueSetRequest, ::xla::KeyValueSetResponse>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::xla::KeyValueSetRequest* request, ::xla::KeyValueSetResponse* response) { return this->KeyValueSet(context, request, response); }));}
    void SetMessageAllocatorFor_KeyValueSet(
        ::grpc::experimental::MessageAllocator< ::xla::KeyValueSetRequest, ::xla::KeyValueSetResponse>* allocator) {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
    #else
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::experimental().GetHandler(5);
    #endif
      static_cast<::grpc_impl::internal::CallbackUnaryHandler< ::xla::KeyValueSetRequest, ::xla::KeyValueSetResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~ExperimentalWithCallbackMethod_KeyValueSet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueSet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* KeyValueSet(
      ::grpc::CallbackServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* KeyValueSet(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithCallbackMethod_WaitAtBarrier : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithCallbackMethod_WaitAtBarrier() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodCallback(6,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::xla::WaitAtBarrierRequest, ::xla::WaitAtBarrierResponse>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::xla::WaitAtBarrierRequest* request, ::xla::WaitAtBarrierResponse* response) { return this->WaitAtBarrier(context, request, response); }));}
    void SetMessageAllocatorFor_WaitAtBarrier(
        ::grpc::experimental::MessageAllocator< ::xla::WaitAtBarrierRequest, ::xla::WaitAtBarrierResponse>* allocator) {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
    #else
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::experimental().GetHandler(6);
    #endif
      static_cast<::grpc_impl::internal::CallbackUnaryHandler< ::xla::WaitAtBarrierRequest, ::xla::WaitAtBarrierResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~ExperimentalWithCallbackMethod_WaitAtBarrier() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitAtBarrier(::grpc::ServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* WaitAtBarrier(
      ::grpc::CallbackServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* WaitAtBarrier(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/)
    #endif
      { return nullptr; }
  };
  #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
  typedef ExperimentalWithCallbackMethod_Connect<ExperimentalWithCallbackMethod_EnumerateDevices<ExperimentalWithCallbackMethod_Heartbeat<ExperimentalWithCallbackMethod_Shutdown<ExperimentalWithCallbackMethod_KeyValueGet<ExperimentalWithCallbackMethod_KeyValueSet<ExperimentalWithCallbackMethod_WaitAtBarrier<Service > > > > > > > CallbackService;
  #endif

  typedef ExperimentalWithCallbackMethod_Connect<ExperimentalWithCallbackMethod_EnumerateDevices<ExperimentalWithCallbackMethod_Heartbeat<ExperimentalWithCallbackMethod_Shutdown<ExperimentalWithCallbackMethod_KeyValueGet<ExperimentalWithCallbackMethod_KeyValueSet<ExperimentalWithCallbackMethod_WaitAtBarrier<Service > > > > > > > ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_Connect : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Connect() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_Connect() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Connect(::grpc::ServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_EnumerateDevices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_EnumerateDevices() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_EnumerateDevices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnumerateDevices(::grpc::ServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Heartbeat : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Heartbeat() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_Heartbeat() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Heartbeat(::grpc::ServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Shutdown : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Shutdown() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_Shutdown() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Shutdown(::grpc::ServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_KeyValueGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_KeyValueGet() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_KeyValueGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueGet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_KeyValueSet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_KeyValueSet() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_KeyValueSet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueSet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_WaitAtBarrier : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_WaitAtBarrier() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_WaitAtBarrier() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitAtBarrier(::grpc::ServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_Connect : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Connect() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_Connect() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Connect(::grpc::ServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestConnect(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_EnumerateDevices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_EnumerateDevices() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_EnumerateDevices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnumerateDevices(::grpc::ServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestEnumerateDevices(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Heartbeat : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Heartbeat() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_Heartbeat() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Heartbeat(::grpc::ServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestHeartbeat(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Shutdown : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Shutdown() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_Shutdown() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Shutdown(::grpc::ServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestShutdown(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_KeyValueGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_KeyValueGet() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_KeyValueGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueGet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKeyValueGet(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_KeyValueSet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_KeyValueSet() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_KeyValueSet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueSet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestKeyValueSet(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_WaitAtBarrier : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_WaitAtBarrier() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_WaitAtBarrier() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitAtBarrier(::grpc::ServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestWaitAtBarrier(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class ExperimentalWithRawCallbackMethod_Connect : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithRawCallbackMethod_Connect() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodRawCallback(0,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Connect(context, request, response); }));
    }
    ~ExperimentalWithRawCallbackMethod_Connect() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Connect(::grpc::ServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* Connect(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* Connect(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithRawCallbackMethod_EnumerateDevices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithRawCallbackMethod_EnumerateDevices() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodRawCallback(1,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->EnumerateDevices(context, request, response); }));
    }
    ~ExperimentalWithRawCallbackMethod_EnumerateDevices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnumerateDevices(::grpc::ServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* EnumerateDevices(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* EnumerateDevices(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithRawCallbackMethod_Heartbeat : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithRawCallbackMethod_Heartbeat() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodRawCallback(2,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Heartbeat(context, request, response); }));
    }
    ~ExperimentalWithRawCallbackMethod_Heartbeat() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Heartbeat(::grpc::ServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* Heartbeat(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* Heartbeat(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithRawCallbackMethod_Shutdown : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithRawCallbackMethod_Shutdown() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodRawCallback(3,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Shutdown(context, request, response); }));
    }
    ~ExperimentalWithRawCallbackMethod_Shutdown() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Shutdown(::grpc::ServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* Shutdown(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* Shutdown(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithRawCallbackMethod_KeyValueGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithRawCallbackMethod_KeyValueGet() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodRawCallback(4,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->KeyValueGet(context, request, response); }));
    }
    ~ExperimentalWithRawCallbackMethod_KeyValueGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueGet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* KeyValueGet(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* KeyValueGet(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithRawCallbackMethod_KeyValueSet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithRawCallbackMethod_KeyValueSet() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodRawCallback(5,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->KeyValueSet(context, request, response); }));
    }
    ~ExperimentalWithRawCallbackMethod_KeyValueSet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status KeyValueSet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* KeyValueSet(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* KeyValueSet(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class ExperimentalWithRawCallbackMethod_WaitAtBarrier : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    ExperimentalWithRawCallbackMethod_WaitAtBarrier() {
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
      ::grpc::Service::
    #else
      ::grpc::Service::experimental().
    #endif
        MarkMethodRawCallback(6,
          new ::grpc_impl::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
                   ::grpc::CallbackServerContext*
    #else
                   ::grpc::experimental::CallbackServerContext*
    #endif
                     context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->WaitAtBarrier(context, request, response); }));
    }
    ~ExperimentalWithRawCallbackMethod_WaitAtBarrier() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status WaitAtBarrier(::grpc::ServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    #ifdef GRPC_CALLBACK_API_NONEXPERIMENTAL
    virtual ::grpc::ServerUnaryReactor* WaitAtBarrier(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #else
    virtual ::grpc::experimental::ServerUnaryReactor* WaitAtBarrier(
      ::grpc::experimental::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)
    #endif
      { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Connect : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Connect() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler< ::xla::ConnectRequest, ::xla::ConnectResponse>(std::bind(&WithStreamedUnaryMethod_Connect<BaseClass>::StreamedConnect, this, std::placeholders::_1, std::placeholders::_2)));
    }
    ~WithStreamedUnaryMethod_Connect() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Connect(::grpc::ServerContext* /*context*/, const ::xla::ConnectRequest* /*request*/, ::xla::ConnectResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedConnect(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::xla::ConnectRequest,::xla::ConnectResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_EnumerateDevices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_EnumerateDevices() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler< ::xla::EnumerateDevicesRequest, ::xla::EnumerateDevicesResponse>(std::bind(&WithStreamedUnaryMethod_EnumerateDevices<BaseClass>::StreamedEnumerateDevices, this, std::placeholders::_1, std::placeholders::_2)));
    }
    ~WithStreamedUnaryMethod_EnumerateDevices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status EnumerateDevices(::grpc::ServerContext* /*context*/, const ::xla::EnumerateDevicesRequest* /*request*/, ::xla::EnumerateDevicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedEnumerateDevices(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::xla::EnumerateDevicesRequest,::xla::EnumerateDevicesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Heartbeat : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Heartbeat() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler< ::xla::HeartbeatRequest, ::xla::HeartbeatResponse>(std::bind(&WithStreamedUnaryMethod_Heartbeat<BaseClass>::StreamedHeartbeat, this, std::placeholders::_1, std::placeholders::_2)));
    }
    ~WithStreamedUnaryMethod_Heartbeat() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Heartbeat(::grpc::ServerContext* /*context*/, const ::xla::HeartbeatRequest* /*request*/, ::xla::HeartbeatResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedHeartbeat(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::xla::HeartbeatRequest,::xla::HeartbeatResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Shutdown : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Shutdown() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler< ::xla::ShutdownRequest, ::xla::ShutdownResponse>(std::bind(&WithStreamedUnaryMethod_Shutdown<BaseClass>::StreamedShutdown, this, std::placeholders::_1, std::placeholders::_2)));
    }
    ~WithStreamedUnaryMethod_Shutdown() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Shutdown(::grpc::ServerContext* /*context*/, const ::xla::ShutdownRequest* /*request*/, ::xla::ShutdownResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedShutdown(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::xla::ShutdownRequest,::xla::ShutdownResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_KeyValueGet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_KeyValueGet() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler< ::xla::KeyValueGetRequest, ::xla::KeyValueGetResponse>(std::bind(&WithStreamedUnaryMethod_KeyValueGet<BaseClass>::StreamedKeyValueGet, this, std::placeholders::_1, std::placeholders::_2)));
    }
    ~WithStreamedUnaryMethod_KeyValueGet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status KeyValueGet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueGetRequest* /*request*/, ::xla::KeyValueGetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedKeyValueGet(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::xla::KeyValueGetRequest,::xla::KeyValueGetResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_KeyValueSet : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_KeyValueSet() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler< ::xla::KeyValueSetRequest, ::xla::KeyValueSetResponse>(std::bind(&WithStreamedUnaryMethod_KeyValueSet<BaseClass>::StreamedKeyValueSet, this, std::placeholders::_1, std::placeholders::_2)));
    }
    ~WithStreamedUnaryMethod_KeyValueSet() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status KeyValueSet(::grpc::ServerContext* /*context*/, const ::xla::KeyValueSetRequest* /*request*/, ::xla::KeyValueSetResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedKeyValueSet(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::xla::KeyValueSetRequest,::xla::KeyValueSetResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_WaitAtBarrier : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_WaitAtBarrier() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler< ::xla::WaitAtBarrierRequest, ::xla::WaitAtBarrierResponse>(std::bind(&WithStreamedUnaryMethod_WaitAtBarrier<BaseClass>::StreamedWaitAtBarrier, this, std::placeholders::_1, std::placeholders::_2)));
    }
    ~WithStreamedUnaryMethod_WaitAtBarrier() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status WaitAtBarrier(::grpc::ServerContext* /*context*/, const ::xla::WaitAtBarrierRequest* /*request*/, ::xla::WaitAtBarrierResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedWaitAtBarrier(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::xla::WaitAtBarrierRequest,::xla::WaitAtBarrierResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_Connect<WithStreamedUnaryMethod_EnumerateDevices<WithStreamedUnaryMethod_Heartbeat<WithStreamedUnaryMethod_Shutdown<WithStreamedUnaryMethod_KeyValueGet<WithStreamedUnaryMethod_KeyValueSet<WithStreamedUnaryMethod_WaitAtBarrier<Service > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_Connect<WithStreamedUnaryMethod_EnumerateDevices<WithStreamedUnaryMethod_Heartbeat<WithStreamedUnaryMethod_Shutdown<WithStreamedUnaryMethod_KeyValueGet<WithStreamedUnaryMethod_KeyValueSet<WithStreamedUnaryMethod_WaitAtBarrier<Service > > > > > > > StreamedService;
};

}  // namespace grpc

}  // namespace xla


#endif  // GRPC_tensorflow_2fcompiler_2fxla_2fpjrt_2fdistributed_2fprotocol_2eproto__INCLUDED
