/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::tfg::CaseOp,
::mlir::tfg::CaseRegionOp,
::mlir::tfg::ConditionOp,
::mlir::tfg::ForOp,
::mlir::tfg::ForRegionOp,
::mlir::tfg::GetResultOp,
::mlir::tfg::GraphFuncOp,
::mlir::tfg::GraphOp,
::mlir::tfg::IfOp,
::mlir::tfg::IfRegionOp,
::mlir::tfg::ReturnOp,
::mlir::tfg::StatefulCaseOp,
::mlir::tfg::StatefulCaseRegionOp,
::mlir::tfg::StatefulIfOp,
::mlir::tfg::StatefulIfRegionOp,
::mlir::tfg::StatefulWhileOp,
::mlir::tfg::StatefulWhileRegionOp,
::mlir::tfg::StatelessCaseOp,
::mlir::tfg::StatelessCaseRegionOp,
::mlir::tfg::StatelessIfOp,
::mlir::tfg::StatelessIfRegionOp,
::mlir::tfg::StatelessWhileOp,
::mlir::tfg::StatelessWhileRegionOp,
::mlir::tfg::WhileOp,
::mlir::tfg::WhileRegionOp,
::mlir::tfg::YieldOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace tfg {

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops0(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(32)); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be  or opaque tensor type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (true); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>()))) || ((type.isa<::mlir::tf_type::ControlType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any tensor or control type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (true); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be  or opaque tensor type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isa<::mlir::tf_type::ControlType>()))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be , but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(32)); }(type.cast<::mlir::ShapedType>().getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be tensor of 32-bit signless integer values, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(1)); }(type.cast<::mlir::ShapedType>().getElementType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be tensor of 1-bit signless integer values, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops6(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isa<::mlir::tf_type::OpaqueTensorType>()))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be , but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops7(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((type.isa<::mlir::TensorType>())) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(1)); }(type.cast<::mlir::ShapedType>().getElementType()))) || ((type.isa<::mlir::tf_type::OpaqueTensorType>())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be  or opaque tensor type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_ops8(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((true))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops0(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: an array of functions";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: type array attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: An array of shapes.";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: an array of dictionaries";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: case region preserved attributes";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::tf_type::FuncAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::DictionaryAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: dictionary of named attribute values";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::tfg::RegionAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: Region attributes, argument and result attributes.";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::StringAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: string attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops9(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::IntegerAttr>())) && ((attr.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(32))))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops10(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::UnitAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: unit attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops11(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::FunctionType>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::FunctionType>())))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: type attribute of function type";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops12(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::ArrayAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: array attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops13(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::FlatSymbolRefAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: flat symbol reference attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops14(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::DenseIntElementsAttr>())) && ((attr.cast<::mlir::DenseIntElementsAttr>().getType().getElementType().isSignlessInteger(32))))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: 32-bit signless integer elements attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops15(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(attr.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::StringAttr>())); })))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: string array attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops16(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !((attr.isa<::mlir::tf_type::VersionAttr>()))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: An Attribute describing the version for a TensorFlow Graph";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops17(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true)))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: any type attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_ops18(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  if (attr && !(((attr.isa<::mlir::IntegerAttr>())) && ((attr.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64))))) {
    return op->emitOpError("attribute '") << attrName
        << "' failed to satisfy constraint: 64-bit signless integer attribute";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_region_constraint_ops0(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((::llvm::hasNItems(region, 1)))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: region with 1 blocks";
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_region_constraint_ops1(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((true))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: any region";
  }
  return ::mlir::success();
}
} // namespace tfg
} // namespace mlir
namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::CaseOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CaseOpGenericAdaptorBase::CaseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.Case", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> CaseOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr CaseOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr CaseOpGenericAdaptorBase::getBranchesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, CaseOp::getBranchesAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr CaseOpGenericAdaptorBase::getBranches() {
  auto attr = getBranchesAttr();
  return attr;
}

::mlir::ArrayAttr CaseOpGenericAdaptorBase::getTinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, CaseOp::getTinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > CaseOpGenericAdaptorBase::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr CaseOpGenericAdaptorBase::getToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, CaseOp::getToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > CaseOpGenericAdaptorBase::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr CaseOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, CaseOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > CaseOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
CaseOpAdaptor::CaseOpAdaptor(CaseOp op) : CaseOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult CaseOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.Case' op ""requires attribute 'branches'");
    if (namedAttrIt->getName() == CaseOp::getBranchesAttrName(*odsOpName)) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == CaseOp::getTinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == CaseOp::getToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == CaseOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branches && !(((tblgen_branches.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branches.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'branches' failed to satisfy constraint: an array of functions");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.Case' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void CaseOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> CaseOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range CaseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value CaseOp::getBranchIndex() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range CaseOp::getArgs() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange CaseOp::getBranchIndexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange CaseOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> CaseOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range CaseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range CaseOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> CaseOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::ArrayAttr CaseOp::getBranchesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getBranchesAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr CaseOp::getBranches() {
  auto attr = getBranchesAttr();
  return attr;
}

::mlir::ArrayAttr CaseOp::getTinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getTinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > CaseOp::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr CaseOp::getToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > CaseOp::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr CaseOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > CaseOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void CaseOp::setBranchesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getBranchesAttrName(), attr);
}

void CaseOp::setTinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTinAttrName(), attr);
}

void CaseOp::setToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getToutAttrName(), attr);
}

void CaseOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute CaseOp::removeTinAttr() {
  return (*this)->removeAttr(getTinAttrName());
}

::mlir::Attribute CaseOp::removeToutAttr() {
  return (*this)->removeAttr(getToutAttrName());
}

::mlir::Attribute CaseOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void CaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value branch_index, ValueRange args, ArrayAttr branches) {
      build(odsBuilder, odsState, results, branch_index, args, branches,
            /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void CaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(getBranchesAttrName(odsState.name), branches);
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void CaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(getBranchesAttrName(odsState.name), branches);
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CaseOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CaseOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'branches'");
    if (namedAttrIt->getName() == getBranchesAttrName()) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops0(*this, tblgen_branches, "branches")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CaseOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult CaseOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyCaseLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::CaseOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::CaseRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CaseRegionOpGenericAdaptorBase::CaseRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.CaseRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> CaseRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr CaseRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr CaseRegionOpGenericAdaptorBase::getBranchAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, CaseRegionOp::getBranchAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > CaseRegionOpGenericAdaptorBase::getBranchAttrs() {
  auto attr = getBranchAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr CaseRegionOpGenericAdaptorBase::getRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, CaseRegionOp::getRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > CaseRegionOpGenericAdaptorBase::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::RegionRange CaseRegionOpGenericAdaptorBase::getBranches() {
  return odsRegions.drop_front(0);
}

::mlir::RegionRange CaseRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
CaseRegionOpAdaptor::CaseRegionOpAdaptor(CaseRegionOp op) : CaseRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult CaseRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == CaseRegionOp::getBranchAttrsAttrName(*odsOpName)) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == CaseRegionOp::getRegionAttrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branch_attrs && !(((tblgen_branch_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branch_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.CaseRegion' op ""attribute 'branch_attrs' failed to satisfy constraint: an array of dictionaries");

  if (tblgen_region_attrs && !(((tblgen_region_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_region_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); }))))
    return emitError(loc, "'tfg.CaseRegion' op ""attribute 'region_attrs' failed to satisfy constraint: case region preserved attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CaseRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range CaseRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> CaseRegionOp::getBranchIndex() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range CaseRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange CaseRegionOp::getBranchIndexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange CaseRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> CaseRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range CaseRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range CaseRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> CaseRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::MutableArrayRef<::mlir::Region> CaseRegionOp::getBranches() {
  return (*this)->getRegions().drop_front(0);
}

::mlir::ArrayAttr CaseRegionOp::getBranchAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getBranchAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > CaseRegionOp::getBranchAttrs() {
  auto attr = getBranchAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr CaseRegionOp::getRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getRegionAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > CaseRegionOp::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void CaseRegionOp::setBranchAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getBranchAttrsAttrName(), attr);
}

void CaseRegionOp::setRegionAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getRegionAttrsAttrName(), attr);
}

::mlir::Attribute CaseRegionOp::removeBranchAttrsAttr() {
  return (*this)->removeAttr(getBranchAttrsAttrName());
}

::mlir::Attribute CaseRegionOp::removeRegionAttrsAttr() {
  return (*this)->removeAttr(getRegionAttrsAttrName());
}

void CaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
    odsState.addAttribute(getBranchAttrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void CaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
    odsState.addAttribute(getBranchAttrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CaseRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult CaseRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getBranchAttrsAttrName()) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getRegionAttrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_branch_attrs, "branch_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops4(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : getBranches())
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "branches", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult CaseRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CaseRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand branch_indexRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> branch_indexOperands(branch_indexRawOperands);  ::llvm::SMLoc branch_indexOperandsLoc;
  (void)branch_indexOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<std::unique_ptr<::mlir::Region>, 2> branchesRegions;
  ::llvm::ArrayRef<::mlir::Type> branch_indexTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  branch_indexOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(branch_indexRawOperands[0]))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  {
    std::unique_ptr<::mlir::Region> region;
    auto firstRegionResult = parser.parseOptionalRegion(region);
    if (firstRegionResult.has_value()) {
      if (failed(*firstRegionResult))
        return ::mlir::failure();
      branchesRegions.emplace_back(std::move(region));

      // Parse any trailing regions.
      while (succeeded(parser.parseOptionalComma())) {
        region = std::make_unique<::mlir::Region>();
        if (parser.parseRegion(*region))
          return ::mlir::failure();
        branchesRegions.emplace_back(std::move(region));
      }
    }
  }

  for (auto &region : branchesRegions)
    if (region->empty()) region->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType branch_index__outs_functionType;
  if (parser.parseType(branch_index__outs_functionType))
    return ::mlir::failure();
  branch_indexTypes = branch_index__outs_functionType.getInputs();
  outsTypes = branch_index__outs_functionType.getResults();
  result.addRegions(branchesRegions);
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(branch_indexOperands, branch_indexTypes, branch_indexOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CaseRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBranchIndex();
  if (!getCtls().empty()) {
    _odsPrinter << ' ';
    _odsPrinter << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ';
    llvm::interleaveComma(getBranches(), _odsPrinter, [&](::mlir::Region &region) {
        _odsPrinter.printRegion(region);
    });
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(getBranchIndex().getType()), getOuts().getTypes());
}

StringRef CaseRegionOp::getDefaultDialect() { return "tfg"; }
void CaseRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp CaseRegionOp::branch_yield(unsigned idx) {
  return cast<YieldOp>(getBranchBlock(idx).getTerminator());
}

void CaseRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetCaseLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void CaseRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(getNumRegions(), /*Elt=*/{0, 1});
}

LogicalResult CaseRegionOp::verify() { return VerifyCaseLikeRegionOp(*this); }

BlockArgument CaseRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument CaseRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument CaseRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument CaseRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::CaseRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ConditionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ConditionOpGenericAdaptorBase::ConditionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.condition", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ConditionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ConditionOp::getOperandSegmentSizesAttrName(*odsOpName)).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr ConditionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
ConditionOpAdaptor::ConditionOpAdaptor(ConditionOp op) : ConditionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult ConditionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.condition' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == ConditionOp::getOperandSegmentSizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 3)
      return emitError(loc, "'tfg.condition' op ""'operand_segment_sizes' attribute for specifying operand segments must have 3 "
                "elements, but got ") << numElements;
  }
    return ::mlir::success();
}

std::pair<unsigned, unsigned> ConditionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName()).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range ConditionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> ConditionOp::getCond() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range ConditionOp::getArgs() {
  return getODSOperands(1);
}

::mlir::Operation::operand_range ConditionOp::getCtls() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange ConditionOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ConditionOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ConditionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> ConditionOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ConditionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void ConditionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({1, static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
}

void ConditionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({1, static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConditionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ConditionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == getOperandSegmentSizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 3)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 3 "
                "elements, but got ") << numElements;
  }
    {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ConditionOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ConditionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::mlir::Type condRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> condTypes(condRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> argsOperands;
  ::llvm::SMLoc argsOperandsLoc;
  (void)argsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> argsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    condRawTypes[0] = type;
  }
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  argsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(argsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalColon())) {

  if (parser.parseTypeList(argsTypes))
    return ::mlir::failure();
  }
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getDenseI32ArrayAttr({1, static_cast<int32_t>(argsOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(argsOperands, argsTypes, argsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ConditionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getCond();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getCond().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  if (!getArgs().empty()) {
    _odsPrinter << ' ';
    _odsPrinter << "(";
    _odsPrinter << getArgs();
    _odsPrinter << ")";
  }
  if (!getCtls().empty()) {
    _odsPrinter << ' ' << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operand_segment_sizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  if (!getArgs().empty()) {
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << getArgs().getTypes();
  }
}

void ConditionOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ConditionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ForOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ForOpGenericAdaptorBase::ForOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.For", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ForOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr ForOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr ForOpGenericAdaptorBase::getBodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ForOp::getBodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr ForOpGenericAdaptorBase::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::ArrayAttr ForOpGenericAdaptorBase::getTAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, ForOp::getTAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > ForOpGenericAdaptorBase::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
ForOpAdaptor::ForOpAdaptor(ForOp op) : ForOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult ForOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.For' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == ForOp::getBodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == ForOp::getTAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.For' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.For' op ""attribute 'T' failed to satisfy constraint: type array attribute");
  return ::mlir::success();
}

void ForOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> ForOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 3) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range ForOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ForOp::getStart() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Value ForOp::getLimit() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(1).begin());
}

::mlir::Value ForOp::getDelta() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(2).begin());
}

::mlir::Operation::operand_range ForOp::getArgs() {
  return getODSOperands(3);
}

::mlir::MutableOperandRange ForOp::getStartMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange ForOp::getLimitMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange ForOp::getDeltaMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange ForOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> ForOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range ForOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range ForOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> ForOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::tf_type::FuncAttr ForOp::getBodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getBodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr ForOp::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::ArrayAttr ForOp::getTAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getTAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > ForOp::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void ForOp::setBodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getBodyAttrName(), attr);
}

void ForOp::setTAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTAttrName(), attr);
}

::mlir::Attribute ForOp::removeTAttr() {
  return (*this)->removeAttr(getTAttrName());
}

void ForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value start, Value limit, Value delta, ValueRange args, FuncAttr body) {
      build(odsBuilder, odsState, results, start, limit, delta, args, body,
            /*T=*/{});
    
}

void ForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr body, /*optional*/::mlir::ArrayAttr T) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(args);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void ForOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr body, /*optional*/::mlir::ArrayAttr T) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(args);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ForOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ForOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == getBodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ForOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ForOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ForRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ForRegionOpGenericAdaptorBase::ForRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.ForRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ForRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ForRegionOp::getOperandSegmentSizesAttrName(*odsOpName)).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr ForRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr ForRegionOpGenericAdaptorBase::getBodyAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, ForRegionOp::getBodyAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > ForRegionOpGenericAdaptorBase::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr ForRegionOpGenericAdaptorBase::getRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, ForRegionOp::getRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> ForRegionOpGenericAdaptorBase::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::Region &ForRegionOpGenericAdaptorBase::getBodyRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange ForRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
ForRegionOpAdaptor::ForRegionOpAdaptor(ForRegionOp op) : ForRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult ForRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.ForRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == ForRegionOp::getOperandSegmentSizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == ForRegionOp::getBodyAttrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == ForRegionOp::getRegionAttrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 5)
      return emitError(loc, "'tfg.ForRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 5 "
                "elements, but got ") << numElements;
  }

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.ForRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_region_attrs && !((tblgen_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.ForRegion' op ""attribute 'region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ForRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName()).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range ForRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> ForRegionOp::getStart() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::TensorType> ForRegionOp::getLimit() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(1).begin());
}

::mlir::TypedValue<::mlir::TensorType> ForRegionOp::getDelta() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(2).begin());
}

::mlir::Operation::operand_range ForRegionOp::getInit() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range ForRegionOp::getCtls() {
  return getODSOperands(4);
}

::mlir::MutableOperandRange ForRegionOp::getStartMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::getLimitMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::getDeltaMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::getInitMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange ForRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> ForRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range ForRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range ForRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> ForRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::Region &ForRegionOp::getBodyRegion() {
  return (*this)->getRegion(0);
}

::mlir::DictionaryAttr ForRegionOp::getBodyAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getBodyAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > ForRegionOp::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr ForRegionOp::getRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> ForRegionOp::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

void ForRegionOp::setBodyAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getBodyAttrsAttrName(), attr);
}

void ForRegionOp::setRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getRegionAttrsAttrName(), attr);
}

::mlir::Attribute ForRegionOp::removeBodyAttrsAttr() {
  return (*this)->removeAttr(getBodyAttrsAttrName());
}

::mlir::Attribute ForRegionOp::removeRegionAttrsAttr() {
  return (*this)->removeAttr(getRegionAttrsAttrName());
}

void ForRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange init, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr region_attrs) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({1, 1, 1, static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void ForRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value start, ::mlir::Value limit, ::mlir::Value delta, ::mlir::ValueRange init, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr region_attrs) {
  odsState.addOperands(start);
  odsState.addOperands(limit);
  odsState.addOperands(delta);
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({1, 1, 1, static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ForRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ForRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == getOperandSegmentSizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getBodyAttrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getRegionAttrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 5)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 5 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult ForRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ForRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand startRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> startOperands(startRawOperands);  ::llvm::SMLoc startOperandsLoc;
  (void)startOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand limitRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> limitOperands(limitRawOperands);  ::llvm::SMLoc limitOperandsLoc;
  (void)limitOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand deltaRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> deltaOperands(deltaRawOperands);  ::llvm::SMLoc deltaOperandsLoc;
  (void)deltaOperandsLoc;
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::mlir::Type startRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> startTypes(startRawTypes);
  ::mlir::Type limitRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> limitTypes(limitRawTypes);
  ::mlir::Type deltaRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> deltaTypes(deltaRawTypes);
  ::llvm::SmallVector<::mlir::Type, 1> initTypes;
  ::llvm::SmallVector<::mlir::Type, 1> outsTypes;
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("from"))
    return ::mlir::failure();

  startOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(startRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseKeyword("to"))
    return ::mlir::failure();

  limitOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(limitRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseKeyword("by"))
    return ::mlir::failure();

  deltaOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(deltaRawOperands[0]))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    startRawTypes[0] = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    limitRawTypes[0] = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::TensorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    deltaRawTypes[0] = type;
  }
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  if (parser.parseTypeList(initTypes))
    return ::mlir::failure();
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalArrow())) {
  if (parser.parseLParen())
    return ::mlir::failure();

  if (parser.parseTypeList(outsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getDenseI32ArrayAttr({1, 1, 1, static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(startOperands, startTypes, startOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(limitOperands, limitTypes, limitOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(deltaOperands, deltaTypes, deltaOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ForRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!getInit().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getInit();
    _odsPrinter << ")";
  }
  if (!getCtls().empty()) {
    _odsPrinter << ' ' << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "from";
  _odsPrinter << ' ';
  _odsPrinter << getStart();
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ';
  _odsPrinter << getLimit();
  _odsPrinter << ' ' << "by";
  _odsPrinter << ' ';
  _odsPrinter << getDelta();
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getBodyRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operand_segment_sizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ' << "(";
  {
    auto type = getStart().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getLimit().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getDelta().getType();
    if (auto validType = type.dyn_cast<::mlir::TensorType>())
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  if (!getInit().empty()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    _odsPrinter << getInit().getTypes();
  }
  _odsPrinter << ")";
  if (!getOuts().empty()) {
    _odsPrinter << ' ' << "->";
    _odsPrinter << ' ' << "(";
    _odsPrinter << getOuts().getTypes();
    _odsPrinter << ")";
  }
}

StringRef ForRegionOp::getDefaultDialect() { return "tfg"; }
void ForRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp ForRegionOp::getBodyYield() {
  return cast<YieldOp>(getBodyBlock().getTerminator());
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ForRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::GetResultOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GetResultOpGenericAdaptorBase::GetResultOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.get_result", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> GetResultOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr GetResultOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::StringAttr GetResultOpGenericAdaptorBase::getNameAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, GetResultOp::getNameAttrName(*odsOpName)).cast<::mlir::StringAttr>();
  return attr;
}

::llvm::StringRef GetResultOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr.getValue();
}

::mlir::IntegerAttr GetResultOpGenericAdaptorBase::getNumberAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, GetResultOp::getNumberAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint32_t GetResultOpGenericAdaptorBase::getNumber() {
  auto attr = getNumberAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
GetResultOpAdaptor::GetResultOpAdaptor(GetResultOp op) : GetResultOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult GetResultOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_name;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.get_result' op ""requires attribute 'name'");
    if (namedAttrIt->getName() == GetResultOp::getNameAttrName(*odsOpName)) {
      tblgen_name = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_number;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.get_result' op ""requires attribute 'number'");
    if (namedAttrIt->getName() == GetResultOp::getNumberAttrName(*odsOpName)) {
      tblgen_number = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (tblgen_name && !((tblgen_name.isa<::mlir::StringAttr>())))
    return emitError(loc, "'tfg.get_result' op ""attribute 'name' failed to satisfy constraint: string attribute");

  if (tblgen_number && !(((tblgen_number.isa<::mlir::IntegerAttr>())) && ((tblgen_number.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(32)))))
    return emitError(loc, "'tfg.get_result' op ""attribute 'number' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GetResultOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GetResultOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::tf_type::OpaqueTensorType> GetResultOp::getValue() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::OpaqueTensorType>>(*getODSOperands(0).begin());
}

::mlir::MutableOperandRange GetResultOp::getValueMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> GetResultOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GetResultOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::tf_type::OpaqueTensorType> GetResultOp::getResult() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::OpaqueTensorType>>(*getODSResults(0).begin());
}

::mlir::StringAttr GetResultOp::getNameAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getNameAttrName()).cast<::mlir::StringAttr>();
}

::llvm::StringRef GetResultOp::getName() {
  auto attr = getNameAttr();
  return attr.getValue();
}

::mlir::IntegerAttr GetResultOp::getNumberAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getNumberAttrName()).cast<::mlir::IntegerAttr>();
}

uint32_t GetResultOp::getNumber() {
  auto attr = getNumberAttr();
  return attr.getValue().getZExtValue();
}

void GetResultOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void GetResultOp::setName(::llvm::StringRef attrValue) {
  (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue));
}

void GetResultOp::setNumberAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getNumberAttrName(), attr);
}

void GetResultOp::setNumber(uint32_t attrValue) {
  (*this)->setAttr(getNumberAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue));
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value value, ::mlir::StringAttr name, ::mlir::IntegerAttr number) {
  odsState.addOperands(value);
  odsState.addAttribute(getNameAttrName(odsState.name), name);
  odsState.addAttribute(getNumberAttrName(odsState.name), number);
  odsState.addTypes(result);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::StringAttr name, ::mlir::IntegerAttr number) {
  odsState.addOperands(value);
  odsState.addAttribute(getNameAttrName(odsState.name), name);
  odsState.addAttribute(getNumberAttrName(odsState.name), number);

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(GetResultOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::StringAttr name, ::mlir::IntegerAttr number) {
  odsState.addOperands(value);
  odsState.addAttribute(getNameAttrName(odsState.name), name);
  odsState.addAttribute(getNumberAttrName(odsState.name), number);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value value, ::llvm::StringRef name, uint32_t number) {
  odsState.addOperands(value);
  odsState.addAttribute(getNameAttrName(odsState.name), odsBuilder.getStringAttr(name));
  odsState.addAttribute(getNumberAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), number));
  odsState.addTypes(result);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::llvm::StringRef name, uint32_t number) {
  odsState.addOperands(value);
  odsState.addAttribute(getNameAttrName(odsState.name), odsBuilder.getStringAttr(name));
  odsState.addAttribute(getNumberAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), number));

        ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
        if (::mlir::succeeded(GetResultOp::inferReturnTypes(odsBuilder.getContext(),
                      odsState.location, odsState.operands,
                      odsState.attributes.getDictionary(odsState.getContext()),
                      odsState.regions, inferredReturnTypes)))
          odsState.addTypes(inferredReturnTypes);
        else
          ::llvm::report_fatal_error("Failed to infer result type(s).");
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::llvm::StringRef name, uint32_t number) {
  odsState.addOperands(value);
  odsState.addAttribute(getNameAttrName(odsState.name), odsBuilder.getStringAttr(name));
  odsState.addAttribute(getNumberAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), number));
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GetResultOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void GetResultOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);

  ::llvm::SmallVector<::mlir::Type, 2> inferredReturnTypes;
  if (::mlir::succeeded(GetResultOp::inferReturnTypes(odsBuilder.getContext(),
          odsState.location, operands,
          odsState.attributes.getDictionary(odsState.getContext()),
          odsState.regions, inferredReturnTypes))) {
    assert(inferredReturnTypes.size() == 1u && "mismatched number of return types");
    odsState.addTypes(inferredReturnTypes);
  } else {
    ::llvm::report_fatal_error("Failed to infer result type(s).");
  }
}

::mlir::LogicalResult GetResultOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_name;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'name'");
    if (namedAttrIt->getName() == getNameAttrName()) {
      tblgen_name = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_number;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'number'");
    if (namedAttrIt->getName() == getNumberAttrName()) {
      tblgen_number = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops8(*this, tblgen_name, "name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops9(*this, tblgen_number, "number")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops6(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult GetResultOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::LogicalResult GetResultOp::inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes) {
  inferredReturnTypes.resize(1);
  ::mlir::Builder odsBuilder(context);
  ::mlir::Type odsInferredType0 = odsBuilder.getType<::mlir::tf_type::OpaqueTensorType>();
  inferredReturnTypes[0] = odsInferredType0;
  return ::mlir::success();
}

::mlir::ParseResult GetResultOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand valueRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valueOperands(valueRawOperands);  ::llvm::SMLoc valueOperandsLoc;
  (void)valueOperandsLoc;
  ::mlir::StringAttr nameAttr;
  ::mlir::IntegerAttr numberAttr;
  if (parser.parseLParen())
    return ::mlir::failure();

  valueOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valueRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(nameAttr, parser.getBuilder().getType<::mlir::NoneType>(), "name",
          result.attributes)) {
    return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(numberAttr, parser.getBuilder().getIntegerType(32), "number",
          result.attributes)) {
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::OpaqueTensorType>();
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(valueOperands, odsBuildableType0, valueOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void GetResultOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << "(";
  _odsPrinter << getValue();
  _odsPrinter << ")";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getNameAttr());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getNumberAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("name");
  elidedAttrs.push_back("number");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

void GetResultOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::GetResultOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::GraphFuncOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GraphFuncOpGenericAdaptorBase::GraphFuncOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.func", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> GraphFuncOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr GraphFuncOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr GraphFuncOpGenericAdaptorBase::getGenericAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::getGenericAttrName(*odsOpName)).dyn_cast_or_null<::mlir::UnitAttr>();
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool GraphFuncOpGenericAdaptorBase::getGeneric() {
  auto attr = getGenericAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::StringAttr GraphFuncOpGenericAdaptorBase::getSymNameAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, GraphFuncOp::getSymNameAttrName(*odsOpName)).cast<::mlir::StringAttr>();
  return attr;
}

::llvm::StringRef GraphFuncOpGenericAdaptorBase::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr GraphFuncOpGenericAdaptorBase::getFunctionTypeAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, GraphFuncOp::getFunctionTypeAttrName(*odsOpName)).cast<::mlir::TypeAttr>();
  return attr;
}

::mlir::FunctionType GraphFuncOpGenericAdaptorBase::getFunctionType() {
  auto attr = getFunctionTypeAttr();
  return attr.getValue().cast<::mlir::FunctionType>();
}

::mlir::ArrayAttr GraphFuncOpGenericAdaptorBase::getArgAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, GraphFuncOp::getArgAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > GraphFuncOpGenericAdaptorBase::getArgAttrs() {
  auto attr = getArgAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr GraphFuncOpGenericAdaptorBase::getResAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::getResAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > GraphFuncOpGenericAdaptorBase::getResAttrs() {
  auto attr = getResAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::StringAttr GraphFuncOpGenericAdaptorBase::getDescriptionAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, GraphFuncOp::getDescriptionAttrName(*odsOpName)).dyn_cast_or_null<::mlir::StringAttr>();
  return attr;
}

::std::optional< ::llvm::StringRef > GraphFuncOpGenericAdaptorBase::getDescription() {
  auto attr = getDescriptionAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::mlir::UnitAttr GraphFuncOpGenericAdaptorBase::getIsStatefulAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::getIsStatefulAttrName(*odsOpName)).dyn_cast_or_null<::mlir::UnitAttr>();
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool GraphFuncOpGenericAdaptorBase::getIsStateful() {
  auto attr = getIsStatefulAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::FlatSymbolRefAttr GraphFuncOpGenericAdaptorBase::getGradientAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::getGradientAttrName(*odsOpName)).dyn_cast_or_null<::mlir::FlatSymbolRefAttr>();
  return attr;
}

::std::optional< ::llvm::StringRef > GraphFuncOpGenericAdaptorBase::getGradient() {
  auto attr = getGradientAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::mlir::DenseIntElementsAttr GraphFuncOpGenericAdaptorBase::getResourceArgUniqueIdsKeysAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::getResourceArgUniqueIdsKeysAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
  return attr;
}

::std::optional< ::mlir::DenseIntElementsAttr > GraphFuncOpGenericAdaptorBase::getResourceArgUniqueIdsKeys() {
  auto attr = getResourceArgUniqueIdsKeysAttr();
  return attr ? ::std::optional< ::mlir::DenseIntElementsAttr >(attr) : (::std::nullopt);
}

::mlir::DenseIntElementsAttr GraphFuncOpGenericAdaptorBase::getResourceArgUniqueIdsValuesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, GraphFuncOp::getResourceArgUniqueIdsValuesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
  return attr;
}

::std::optional< ::mlir::DenseIntElementsAttr > GraphFuncOpGenericAdaptorBase::getResourceArgUniqueIdsValues() {
  auto attr = getResourceArgUniqueIdsValuesAttr();
  return attr ? ::std::optional< ::mlir::DenseIntElementsAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr GraphFuncOpGenericAdaptorBase::getControlOutputAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, GraphFuncOp::getControlOutputAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > GraphFuncOpGenericAdaptorBase::getControlOutput() {
  auto attr = getControlOutputAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::Region &GraphFuncOpGenericAdaptorBase::getBody() {
  return *odsRegions[0];
}

::mlir::RegionRange GraphFuncOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
GraphFuncOpAdaptor::GraphFuncOpAdaptor(GraphFuncOp op) : GraphFuncOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult GraphFuncOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_function_type;
  ::mlir::Attribute tblgen_arg_attrs;
  ::mlir::Attribute tblgen_control_output;
  ::mlir::Attribute tblgen_description;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.func' op ""requires attribute 'function_type'");
    if (namedAttrIt->getName() == GraphFuncOp::getFunctionTypeAttrName(*odsOpName)) {
      tblgen_function_type = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getArgAttrsAttrName(*odsOpName)) {
      tblgen_arg_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getControlOutputAttrName(*odsOpName)) {
      tblgen_control_output = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getDescriptionAttrName(*odsOpName)) {
      tblgen_description = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_sym_name;
  ::mlir::Attribute tblgen_generic;
  ::mlir::Attribute tblgen_gradient;
  ::mlir::Attribute tblgen_is_stateful;
  ::mlir::Attribute tblgen_res_attrs;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_keys;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_values;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.func' op ""requires attribute 'sym_name'");
    if (namedAttrIt->getName() == GraphFuncOp::getSymNameAttrName(*odsOpName)) {
      tblgen_sym_name = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getGenericAttrName(*odsOpName)) {
      tblgen_generic = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getGradientAttrName(*odsOpName)) {
      tblgen_gradient = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getIsStatefulAttrName(*odsOpName)) {
      tblgen_is_stateful = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getResAttrsAttrName(*odsOpName)) {
      tblgen_res_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getResourceArgUniqueIdsKeysAttrName(*odsOpName)) {
      tblgen_resource_arg_unique_ids_keys = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == GraphFuncOp::getResourceArgUniqueIdsValuesAttrName(*odsOpName)) {
      tblgen_resource_arg_unique_ids_values = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_generic && !((tblgen_generic.isa<::mlir::UnitAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'generic' failed to satisfy constraint: unit attribute");

  if (tblgen_sym_name && !((tblgen_sym_name.isa<::mlir::StringAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");

  if (tblgen_function_type && !(((tblgen_function_type.isa<::mlir::TypeAttr>())) && ((tblgen_function_type.cast<::mlir::TypeAttr>().getValue().isa<::mlir::FunctionType>())) && ((tblgen_function_type.cast<::mlir::TypeAttr>().getValue().isa<::mlir::FunctionType>()))))
    return emitError(loc, "'tfg.func' op ""attribute 'function_type' failed to satisfy constraint: type attribute of function type");

  if (tblgen_arg_attrs && !((tblgen_arg_attrs.isa<::mlir::ArrayAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'arg_attrs' failed to satisfy constraint: array attribute");

  if (tblgen_res_attrs && !((tblgen_res_attrs.isa<::mlir::ArrayAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'res_attrs' failed to satisfy constraint: array attribute");

  if (tblgen_description && !((tblgen_description.isa<::mlir::StringAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'description' failed to satisfy constraint: string attribute");

  if (tblgen_is_stateful && !((tblgen_is_stateful.isa<::mlir::UnitAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'is_stateful' failed to satisfy constraint: unit attribute");

  if (tblgen_gradient && !((tblgen_gradient.isa<::mlir::FlatSymbolRefAttr>())))
    return emitError(loc, "'tfg.func' op ""attribute 'gradient' failed to satisfy constraint: flat symbol reference attribute");

  if (tblgen_resource_arg_unique_ids_keys && !(((tblgen_resource_arg_unique_ids_keys.isa<::mlir::DenseIntElementsAttr>())) && ((tblgen_resource_arg_unique_ids_keys.cast<::mlir::DenseIntElementsAttr>().getType().getElementType().isSignlessInteger(32)))))
    return emitError(loc, "'tfg.func' op ""attribute 'resource_arg_unique_ids_keys' failed to satisfy constraint: 32-bit signless integer elements attribute");

  if (tblgen_resource_arg_unique_ids_values && !(((tblgen_resource_arg_unique_ids_values.isa<::mlir::DenseIntElementsAttr>())) && ((tblgen_resource_arg_unique_ids_values.cast<::mlir::DenseIntElementsAttr>().getType().getElementType().isSignlessInteger(32)))))
    return emitError(loc, "'tfg.func' op ""attribute 'resource_arg_unique_ids_values' failed to satisfy constraint: 32-bit signless integer elements attribute");

  if (tblgen_control_output && !(((tblgen_control_output.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_control_output.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::StringAttr>())); }))))
    return emitError(loc, "'tfg.func' op ""attribute 'control_output' failed to satisfy constraint: string array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GraphFuncOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GraphFuncOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GraphFuncOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GraphFuncOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &GraphFuncOp::getBody() {
  return (*this)->getRegion(0);
}

::mlir::UnitAttr GraphFuncOp::getGenericAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getGenericAttrName()).dyn_cast_or_null<::mlir::UnitAttr>();
}

bool GraphFuncOp::getGeneric() {
  auto attr = getGenericAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::StringAttr GraphFuncOp::getSymNameAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getSymNameAttrName()).cast<::mlir::StringAttr>();
}

::llvm::StringRef GraphFuncOp::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr GraphFuncOp::getFunctionTypeAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getFunctionTypeAttrName()).cast<::mlir::TypeAttr>();
}

::mlir::FunctionType GraphFuncOp::getFunctionType() {
  auto attr = getFunctionTypeAttr();
  return attr.getValue().cast<::mlir::FunctionType>();
}

::mlir::ArrayAttr GraphFuncOp::getArgAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getArgAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > GraphFuncOp::getArgAttrs() {
  auto attr = getArgAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr GraphFuncOp::getResAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getResAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > GraphFuncOp::getResAttrs() {
  auto attr = getResAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::StringAttr GraphFuncOp::getDescriptionAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getDescriptionAttrName()).dyn_cast_or_null<::mlir::StringAttr>();
}

::std::optional< ::llvm::StringRef > GraphFuncOp::getDescription() {
  auto attr = getDescriptionAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::mlir::UnitAttr GraphFuncOp::getIsStatefulAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getIsStatefulAttrName()).dyn_cast_or_null<::mlir::UnitAttr>();
}

bool GraphFuncOp::getIsStateful() {
  auto attr = getIsStatefulAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::FlatSymbolRefAttr GraphFuncOp::getGradientAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getGradientAttrName()).dyn_cast_or_null<::mlir::FlatSymbolRefAttr>();
}

::std::optional< ::llvm::StringRef > GraphFuncOp::getGradient() {
  auto attr = getGradientAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

::mlir::DenseIntElementsAttr GraphFuncOp::getResourceArgUniqueIdsKeysAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getResourceArgUniqueIdsKeysAttrName()).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
}

::std::optional< ::mlir::DenseIntElementsAttr > GraphFuncOp::getResourceArgUniqueIdsKeys() {
  auto attr = getResourceArgUniqueIdsKeysAttr();
  return attr ? ::std::optional< ::mlir::DenseIntElementsAttr >(attr) : (::std::nullopt);
}

::mlir::DenseIntElementsAttr GraphFuncOp::getResourceArgUniqueIdsValuesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getResourceArgUniqueIdsValuesAttrName()).dyn_cast_or_null<::mlir::DenseIntElementsAttr>();
}

::std::optional< ::mlir::DenseIntElementsAttr > GraphFuncOp::getResourceArgUniqueIdsValues() {
  auto attr = getResourceArgUniqueIdsValuesAttr();
  return attr ? ::std::optional< ::mlir::DenseIntElementsAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr GraphFuncOp::getControlOutputAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getControlOutputAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > GraphFuncOp::getControlOutput() {
  auto attr = getControlOutputAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void GraphFuncOp::setGenericAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getGenericAttrName(), attr);
}

void GraphFuncOp::setGeneric(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getGenericAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getGenericAttrName());
}

void GraphFuncOp::setSymNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getSymNameAttrName(), attr);
}

void GraphFuncOp::setSymName(::llvm::StringRef attrValue) {
  (*this)->setAttr(getSymNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue));
}

void GraphFuncOp::setFunctionTypeAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(getFunctionTypeAttrName(), attr);
}

void GraphFuncOp::setFunctionType(::mlir::FunctionType attrValue) {
  (*this)->setAttr(getFunctionTypeAttrName(), ::mlir::TypeAttr::get(attrValue));
}

void GraphFuncOp::setArgAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getArgAttrsAttrName(), attr);
}

void GraphFuncOp::setResAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getResAttrsAttrName(), attr);
}

void GraphFuncOp::setDescriptionAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getDescriptionAttrName(), attr);
}

void GraphFuncOp::setDescription(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getDescriptionAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getDescriptionAttrName());
}

void GraphFuncOp::setIsStatefulAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getIsStatefulAttrName(), attr);
}

void GraphFuncOp::setIsStateful(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getIsStatefulAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getIsStatefulAttrName());
}

void GraphFuncOp::setGradientAttr(::mlir::FlatSymbolRefAttr attr) {
  (*this)->setAttr(getGradientAttrName(), attr);
}

void GraphFuncOp::setGradient(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getGradientAttrName(), ::mlir::SymbolRefAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue));
    (*this)->removeAttr(getGradientAttrName());
}

void GraphFuncOp::setResourceArgUniqueIdsKeysAttr(::mlir::DenseIntElementsAttr attr) {
  (*this)->setAttr(getResourceArgUniqueIdsKeysAttrName(), attr);
}

void GraphFuncOp::setResourceArgUniqueIdsValuesAttr(::mlir::DenseIntElementsAttr attr) {
  (*this)->setAttr(getResourceArgUniqueIdsValuesAttrName(), attr);
}

void GraphFuncOp::setControlOutputAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getControlOutputAttrName(), attr);
}

::mlir::Attribute GraphFuncOp::removeGenericAttr() {
  return (*this)->removeAttr(getGenericAttrName());
}

::mlir::Attribute GraphFuncOp::removeArgAttrsAttr() {
  return (*this)->removeAttr(getArgAttrsAttrName());
}

::mlir::Attribute GraphFuncOp::removeResAttrsAttr() {
  return (*this)->removeAttr(getResAttrsAttrName());
}

::mlir::Attribute GraphFuncOp::removeDescriptionAttr() {
  return (*this)->removeAttr(getDescriptionAttrName());
}

::mlir::Attribute GraphFuncOp::removeIsStatefulAttr() {
  return (*this)->removeAttr(getIsStatefulAttrName());
}

::mlir::Attribute GraphFuncOp::removeGradientAttr() {
  return (*this)->removeAttr(getGradientAttrName());
}

::mlir::Attribute GraphFuncOp::removeResourceArgUniqueIdsKeysAttr() {
  return (*this)->removeAttr(getResourceArgUniqueIdsKeysAttrName());
}

::mlir::Attribute GraphFuncOp::removeResourceArgUniqueIdsValuesAttr() {
  return (*this)->removeAttr(getResourceArgUniqueIdsValuesAttrName());
}

::mlir::Attribute GraphFuncOp::removeControlOutputAttr() {
  return (*this)->removeAttr(getControlOutputAttrName());
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState) {
 (void)odsState.addRegion(); 
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, const Twine &sym_name, FunctionType type, bool generic) {
      build(odsBuilder, odsState);
      odsState.addAttribute(GraphFuncOp::getSymNameAttrName(odsState.name),
                           odsBuilder.getStringAttr(sym_name));
      odsState.addAttribute(GraphFuncOp::getFunctionTypeAttrName(odsState.name),
                           TypeAttr::get(type));
      if (generic) {
        odsState.addAttribute(GraphFuncOp::getGenericAttrName(odsState.name),
                             odsBuilder.getUnitAttr());
      }
    
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::UnitAttr generic, ::mlir::StringAttr sym_name, ::mlir::TypeAttr function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/::mlir::UnitAttr is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
    odsState.addAttribute(getGenericAttrName(odsState.name), generic);
  }
  odsState.addAttribute(getSymNameAttrName(odsState.name), sym_name);
  odsState.addAttribute(getFunctionTypeAttrName(odsState.name), function_type);
  if (arg_attrs) {
    odsState.addAttribute(getArgAttrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
    odsState.addAttribute(getResAttrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
    odsState.addAttribute(getDescriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
    odsState.addAttribute(getIsStatefulAttrName(odsState.name), is_stateful);
  }
  if (gradient) {
    odsState.addAttribute(getGradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
    odsState.addAttribute(getResourceArgUniqueIdsKeysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
    odsState.addAttribute(getResourceArgUniqueIdsValuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
    odsState.addAttribute(getControlOutputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::UnitAttr generic, ::mlir::StringAttr sym_name, ::mlir::TypeAttr function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/::mlir::UnitAttr is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
    odsState.addAttribute(getGenericAttrName(odsState.name), generic);
  }
  odsState.addAttribute(getSymNameAttrName(odsState.name), sym_name);
  odsState.addAttribute(getFunctionTypeAttrName(odsState.name), function_type);
  if (arg_attrs) {
    odsState.addAttribute(getArgAttrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
    odsState.addAttribute(getResAttrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
    odsState.addAttribute(getDescriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
    odsState.addAttribute(getIsStatefulAttrName(odsState.name), is_stateful);
  }
  if (gradient) {
    odsState.addAttribute(getGradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
    odsState.addAttribute(getResourceArgUniqueIdsKeysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
    odsState.addAttribute(getResourceArgUniqueIdsValuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
    odsState.addAttribute(getControlOutputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/bool generic, ::llvm::StringRef sym_name, ::mlir::FunctionType function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/bool is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
    odsState.addAttribute(getGenericAttrName(odsState.name), ((generic) ? odsBuilder.getUnitAttr() : nullptr));
  }
  odsState.addAttribute(getSymNameAttrName(odsState.name), odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute(getFunctionTypeAttrName(odsState.name), ::mlir::TypeAttr::get(function_type));
  if (arg_attrs) {
    odsState.addAttribute(getArgAttrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
    odsState.addAttribute(getResAttrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
    odsState.addAttribute(getDescriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
    odsState.addAttribute(getIsStatefulAttrName(odsState.name), ((is_stateful) ? odsBuilder.getUnitAttr() : nullptr));
  }
  if (gradient) {
    odsState.addAttribute(getGradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
    odsState.addAttribute(getResourceArgUniqueIdsKeysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
    odsState.addAttribute(getResourceArgUniqueIdsValuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
    odsState.addAttribute(getControlOutputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
}

void GraphFuncOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/bool generic, ::llvm::StringRef sym_name, ::mlir::FunctionType function_type, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::mlir::StringAttr description, /*optional*/bool is_stateful, /*optional*/::mlir::FlatSymbolRefAttr gradient, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_keys, /*optional*/::mlir::DenseIntElementsAttr resource_arg_unique_ids_values, /*optional*/::mlir::ArrayAttr control_output) {
  if (generic) {
    odsState.addAttribute(getGenericAttrName(odsState.name), ((generic) ? odsBuilder.getUnitAttr() : nullptr));
  }
  odsState.addAttribute(getSymNameAttrName(odsState.name), odsBuilder.getStringAttr(sym_name));
  odsState.addAttribute(getFunctionTypeAttrName(odsState.name), ::mlir::TypeAttr::get(function_type));
  if (arg_attrs) {
    odsState.addAttribute(getArgAttrsAttrName(odsState.name), arg_attrs);
  }
  if (res_attrs) {
    odsState.addAttribute(getResAttrsAttrName(odsState.name), res_attrs);
  }
  if (description) {
    odsState.addAttribute(getDescriptionAttrName(odsState.name), description);
  }
  if (is_stateful) {
    odsState.addAttribute(getIsStatefulAttrName(odsState.name), ((is_stateful) ? odsBuilder.getUnitAttr() : nullptr));
  }
  if (gradient) {
    odsState.addAttribute(getGradientAttrName(odsState.name), gradient);
  }
  if (resource_arg_unique_ids_keys) {
    odsState.addAttribute(getResourceArgUniqueIdsKeysAttrName(odsState.name), resource_arg_unique_ids_keys);
  }
  if (resource_arg_unique_ids_values) {
    odsState.addAttribute(getResourceArgUniqueIdsValuesAttrName(odsState.name), resource_arg_unique_ids_values);
  }
  if (control_output) {
    odsState.addAttribute(getControlOutputAttrName(odsState.name), control_output);
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GraphFuncOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult GraphFuncOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_function_type;
  ::mlir::Attribute tblgen_arg_attrs;
  ::mlir::Attribute tblgen_control_output;
  ::mlir::Attribute tblgen_description;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'function_type'");
    if (namedAttrIt->getName() == getFunctionTypeAttrName()) {
      tblgen_function_type = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getArgAttrsAttrName()) {
      tblgen_arg_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getControlOutputAttrName()) {
      tblgen_control_output = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getDescriptionAttrName()) {
      tblgen_description = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_sym_name;
  ::mlir::Attribute tblgen_generic;
  ::mlir::Attribute tblgen_gradient;
  ::mlir::Attribute tblgen_is_stateful;
  ::mlir::Attribute tblgen_res_attrs;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_keys;
  ::mlir::Attribute tblgen_resource_arg_unique_ids_values;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'sym_name'");
    if (namedAttrIt->getName() == getSymNameAttrName()) {
      tblgen_sym_name = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getGenericAttrName()) {
      tblgen_generic = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getGradientAttrName()) {
      tblgen_gradient = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getIsStatefulAttrName()) {
      tblgen_is_stateful = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getResAttrsAttrName()) {
      tblgen_res_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getResourceArgUniqueIdsKeysAttrName()) {
      tblgen_resource_arg_unique_ids_keys = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getResourceArgUniqueIdsValuesAttrName()) {
      tblgen_resource_arg_unique_ids_values = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops10(*this, tblgen_generic, "generic")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops8(*this, tblgen_sym_name, "sym_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops11(*this, tblgen_function_type, "function_type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops12(*this, tblgen_arg_attrs, "arg_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops12(*this, tblgen_res_attrs, "res_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops8(*this, tblgen_description, "description")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops10(*this, tblgen_is_stateful, "is_stateful")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops13(*this, tblgen_gradient, "gradient")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops14(*this, tblgen_resource_arg_unique_ids_keys, "resource_arg_unique_ids_keys")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops14(*this, tblgen_resource_arg_unique_ids_values, "resource_arg_unique_ids_values")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops15(*this, tblgen_control_output, "control_output")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops1(*this, region, "body", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult GraphFuncOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

void GraphFuncOp::getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context) {
  results.add(canonicalize);
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::GraphFuncOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::GraphOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GraphOpGenericAdaptorBase::GraphOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.graph", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> GraphOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr GraphOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::VersionAttr GraphOpGenericAdaptorBase::getVersionAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, GraphOp::getVersionAttrName(*odsOpName)).cast<::mlir::tf_type::VersionAttr>();
  return attr;
}

::mlir::tf_type::VersionAttr GraphOpGenericAdaptorBase::getVersion() {
  auto attr = getVersionAttr();
  return attr.cast<::mlir::tf_type::VersionAttr>();
}

::mlir::Region &GraphOpGenericAdaptorBase::getNodes() {
  return *odsRegions[0];
}

::mlir::RegionRange GraphOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
GraphOpAdaptor::GraphOpAdaptor(GraphOp op) : GraphOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult GraphOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_version;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.graph' op ""requires attribute 'version'");
    if (namedAttrIt->getName() == GraphOp::getVersionAttrName(*odsOpName)) {
      tblgen_version = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (tblgen_version && !((tblgen_version.isa<::mlir::tf_type::VersionAttr>())))
    return emitError(loc, "'tfg.graph' op ""attribute 'version' failed to satisfy constraint: An Attribute describing the version for a TensorFlow Graph");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GraphOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GraphOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GraphOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GraphOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &GraphOp::getNodes() {
  return (*this)->getRegion(0);
}

::mlir::tf_type::VersionAttr GraphOp::getVersionAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getVersionAttrName()).cast<::mlir::tf_type::VersionAttr>();
}

::mlir::tf_type::VersionAttr GraphOp::getVersion() {
  auto attr = getVersionAttr();
  return attr.cast<::mlir::tf_type::VersionAttr>();
}

void GraphOp::setVersionAttr(::mlir::tf_type::VersionAttr attr) {
  (*this)->setAttr(getVersionAttrName(), attr);
}

void GraphOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::tf_type::VersionAttr version) {
  odsState.addAttribute(getVersionAttrName(odsState.name), version);
  (void)odsState.addRegion();
}

void GraphOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::tf_type::VersionAttr version) {
  odsState.addAttribute(getVersionAttrName(odsState.name), version);
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GraphOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult GraphOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_version;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'version'");
    if (namedAttrIt->getName() == getVersionAttrName()) {
      tblgen_version = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops16(*this, tblgen_version, "version")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "nodes", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult GraphOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult GraphOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::tf_type::VersionAttr versionAttr;
  std::unique_ptr<::mlir::Region> nodesRegion = std::make_unique<::mlir::Region>();

  if (parser.parseAttribute(versionAttr, ::mlir::Type{}, "version", result.attributes))
    return ::mlir::failure();
  if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
    return ::mlir::failure();

  if (parser.parseRegion(*nodesRegion))
    return ::mlir::failure();

  if (nodesRegion->empty()) nodesRegion->emplaceBlock();
  result.addRegion(std::move(nodesRegion));
  return ::mlir::success();
}

void GraphOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttribute(getVersionAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("version");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getNodes());
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::GraphOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::IfOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
IfOpGenericAdaptorBase::IfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.If", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> IfOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr IfOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr IfOpGenericAdaptorBase::getThenBranchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, IfOp::getThenBranchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr IfOpGenericAdaptorBase::getThenBranch() {
  auto attr = getThenBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOpGenericAdaptorBase::getElseBranchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, IfOp::getElseBranchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr IfOpGenericAdaptorBase::getElseBranch() {
  auto attr = getElseBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr IfOpGenericAdaptorBase::getTcondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, IfOp::getTcondAttrName(*odsOpName)).dyn_cast_or_null<::mlir::TypeAttr>();
  return attr;
}

::std::optional<::mlir::Type> IfOpGenericAdaptorBase::getTcond() {
  auto attr = getTcondAttr();
  return attr ? ::std::optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::std::nullopt);
}

::mlir::ArrayAttr IfOpGenericAdaptorBase::getTinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, IfOp::getTinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > IfOpGenericAdaptorBase::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr IfOpGenericAdaptorBase::getToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, IfOp::getToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > IfOpGenericAdaptorBase::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr IfOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, IfOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > IfOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
IfOpAdaptor::IfOpAdaptor(IfOp op) : IfOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult IfOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.If' op ""requires attribute 'else_branch'");
    if (namedAttrIt->getName() == IfOp::getElseBranchAttrName(*odsOpName)) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == IfOp::getTcondAttrName(*odsOpName)) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfOp::getTinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfOp::getToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.If' op ""requires attribute 'then_branch'");
    if (namedAttrIt->getName() == IfOp::getThenBranchAttrName(*odsOpName)) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == IfOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_branch && !((tblgen_then_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.If' op ""attribute 'then_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_else_branch && !((tblgen_else_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.If' op ""attribute 'else_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_Tcond && !(((tblgen_Tcond.isa<::mlir::TypeAttr>())) && ((tblgen_Tcond.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))))
    return emitError(loc, "'tfg.If' op ""attribute 'Tcond' failed to satisfy constraint: any type attribute");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.If' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.If' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.If' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void IfOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> IfOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range IfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value IfOp::getCond() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range IfOp::getArgs() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange IfOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange IfOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> IfOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range IfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range IfOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> IfOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::tf_type::FuncAttr IfOp::getThenBranchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getThenBranchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOp::getThenBranch() {
  auto attr = getThenBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOp::getElseBranchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getElseBranchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr IfOp::getElseBranch() {
  auto attr = getElseBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr IfOp::getTcondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getTcondAttrName()).dyn_cast_or_null<::mlir::TypeAttr>();
}

::std::optional<::mlir::Type> IfOp::getTcond() {
  auto attr = getTcondAttr();
  return attr ? ::std::optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::std::nullopt);
}

::mlir::ArrayAttr IfOp::getTinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getTinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > IfOp::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr IfOp::getToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > IfOp::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr IfOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > IfOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void IfOp::setThenBranchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getThenBranchAttrName(), attr);
}

void IfOp::setElseBranchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getElseBranchAttrName(), attr);
}

void IfOp::setTcondAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(getTcondAttrName(), attr);
}

void IfOp::setTcond(::std::optional<::mlir::Type> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getTcondAttrName(), ::mlir::TypeAttr::get(*attrValue));
    (*this)->removeAttr(getTcondAttrName());
}

void IfOp::setTinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTinAttrName(), attr);
}

void IfOp::setToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getToutAttrName(), attr);
}

void IfOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute IfOp::removeTcondAttr() {
  return (*this)->removeAttr(getTcondAttrName());
}

::mlir::Attribute IfOp::removeTinAttr() {
  return (*this)->removeAttr(getTinAttrName());
}

::mlir::Attribute IfOp::removeToutAttr() {
  return (*this)->removeAttr(getToutAttrName());
}

::mlir::Attribute IfOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void IfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value cond, ValueRange args, FuncAttr then_branch, FuncAttr else_branch) {
      build(odsBuilder, odsState, results, cond, args, then_branch, else_branch,
            /*Tcond=*/{}, /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void IfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(getThenBranchAttrName(odsState.name), then_branch);
  odsState.addAttribute(getElseBranchAttrName(odsState.name), else_branch);
  if (Tcond) {
    odsState.addAttribute(getTcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void IfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(getThenBranchAttrName(odsState.name), then_branch);
  odsState.addAttribute(getElseBranchAttrName(odsState.name), else_branch);
  if (Tcond) {
    odsState.addAttribute(getTcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IfOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult IfOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'else_branch'");
    if (namedAttrIt->getName() == getElseBranchAttrName()) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTcondAttrName()) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getTinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'then_branch'");
    if (namedAttrIt->getName() == getThenBranchAttrName()) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_then_branch, "then_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_else_branch, "else_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops17(*this, tblgen_Tcond, "Tcond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult IfOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult IfOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyIfLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::IfOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::IfRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
IfRegionOpGenericAdaptorBase::IfRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.IfRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> IfRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr IfRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr IfRegionOpGenericAdaptorBase::getThenAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::getThenAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > IfRegionOpGenericAdaptorBase::getThenAttrs() {
  auto attr = getThenAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr IfRegionOpGenericAdaptorBase::getElseAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::getElseAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > IfRegionOpGenericAdaptorBase::getElseAttrs() {
  auto attr = getElseAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr IfRegionOpGenericAdaptorBase::getThenRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::getThenRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> IfRegionOpGenericAdaptorBase::getThenRegionAttrs() {
  auto attr = getThenRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr IfRegionOpGenericAdaptorBase::getElseRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, IfRegionOp::getElseRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> IfRegionOpGenericAdaptorBase::getElseRegionAttrs() {
  auto attr = getElseRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::Region &IfRegionOpGenericAdaptorBase::getThenRegion() {
  return *odsRegions[0];
}

::mlir::Region &IfRegionOpGenericAdaptorBase::getElseRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange IfRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
IfRegionOpAdaptor::IfRegionOpAdaptor(IfRegionOp op) : IfRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult IfRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == IfRegionOp::getElseAttrsAttrName(*odsOpName)) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfRegionOp::getElseRegionAttrsAttrName(*odsOpName)) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfRegionOp::getThenAttrsAttrName(*odsOpName)) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == IfRegionOp::getThenRegionAttrsAttrName(*odsOpName)) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_attrs && !((tblgen_then_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'then_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_else_attrs && !((tblgen_else_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'else_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_then_region_attrs && !((tblgen_then_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'then_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_else_region_attrs && !((tblgen_else_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.IfRegion' op ""attribute 'else_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> IfRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range IfRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> IfRegionOp::getCond() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range IfRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange IfRegionOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange IfRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> IfRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range IfRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range IfRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> IfRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::Region &IfRegionOp::getThenRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &IfRegionOp::getElseRegion() {
  return (*this)->getRegion(1);
}

::mlir::DictionaryAttr IfRegionOp::getThenAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getThenAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > IfRegionOp::getThenAttrs() {
  auto attr = getThenAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr IfRegionOp::getElseAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getElseAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > IfRegionOp::getElseAttrs() {
  auto attr = getElseAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr IfRegionOp::getThenRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getThenRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> IfRegionOp::getThenRegionAttrs() {
  auto attr = getThenRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr IfRegionOp::getElseRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getElseRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> IfRegionOp::getElseRegionAttrs() {
  auto attr = getElseRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

void IfRegionOp::setThenAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getThenAttrsAttrName(), attr);
}

void IfRegionOp::setElseAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getElseAttrsAttrName(), attr);
}

void IfRegionOp::setThenRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getThenRegionAttrsAttrName(), attr);
}

void IfRegionOp::setElseRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getElseRegionAttrsAttrName(), attr);
}

::mlir::Attribute IfRegionOp::removeThenAttrsAttr() {
  return (*this)->removeAttr(getThenAttrsAttrName());
}

::mlir::Attribute IfRegionOp::removeElseAttrsAttr() {
  return (*this)->removeAttr(getElseAttrsAttrName());
}

::mlir::Attribute IfRegionOp::removeThenRegionAttrsAttr() {
  return (*this)->removeAttr(getThenRegionAttrsAttrName());
}

::mlir::Attribute IfRegionOp::removeElseRegionAttrsAttr() {
  return (*this)->removeAttr(getElseRegionAttrsAttrName());
}

void IfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
    odsState.addAttribute(getThenAttrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
    odsState.addAttribute(getElseAttrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
    odsState.addAttribute(getThenRegionAttrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
    odsState.addAttribute(getElseRegionAttrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void IfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
    odsState.addAttribute(getThenAttrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
    odsState.addAttribute(getElseAttrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
    odsState.addAttribute(getThenRegionAttrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
    odsState.addAttribute(getElseRegionAttrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void IfRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult IfRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getElseAttrsAttrName()) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getElseRegionAttrsAttrName()) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getThenAttrsAttrName()) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getThenRegionAttrsAttrName()) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_then_attrs, "then_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_else_attrs, "else_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_then_region_attrs, "then_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_else_region_attrs, "else_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "then_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "else_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult IfRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult IfRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> then_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> else_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> condTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("then"))
    return ::mlir::failure();

  if (parser.parseRegion(*then_regionRegion))
    return ::mlir::failure();

  if (then_regionRegion->empty()) then_regionRegion->emplaceBlock();
  if (parser.parseKeyword("else"))
    return ::mlir::failure();

  if (parser.parseRegion(*else_regionRegion))
    return ::mlir::failure();

  if (else_regionRegion->empty()) else_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType cond__outs_functionType;
  if (parser.parseType(cond__outs_functionType))
    return ::mlir::failure();
  condTypes = cond__outs_functionType.getInputs();
  outsTypes = cond__outs_functionType.getResults();
  result.addRegion(std::move(then_regionRegion));
  result.addRegion(std::move(else_regionRegion));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void IfRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getCond();
  if (!getCtls().empty()) {
    _odsPrinter << ' ';
    _odsPrinter << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "then";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getThenRegion());
  _odsPrinter << ' ' << "else";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getElseRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(getCond().getType()), getOuts().getTypes());
}

StringRef IfRegionOp::getDefaultDialect() { return "tfg"; }
void IfRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp IfRegionOp::getThenYield() {
  return cast<YieldOp>(getThenBlock().getTerminator());
}
YieldOp IfRegionOp::getElseYield() {
  return cast<YieldOp>(getElseBlock().getTerminator());
}

void IfRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetIfLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void IfRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(/*NumInputs=*/2, /*Elt=*/{0, 1});
}

LogicalResult IfRegionOp::verify() { return VerifyIfLikeRegionOp(*this); }

BlockArgument IfRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument IfRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument IfRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument IfRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::IfRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::ReturnOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ReturnOpGenericAdaptorBase::ReturnOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.return", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ReturnOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr ReturnOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr ReturnOpGenericAdaptorBase::getControlRetAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, ReturnOp::getControlRetAttrsAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr ReturnOpGenericAdaptorBase::getControlRetAttrs() {
  auto attr = getControlRetAttrsAttr();
  return attr;
}

} // namespace detail
ReturnOpAdaptor::ReturnOpAdaptor(ReturnOp op) : ReturnOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult ReturnOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_control_ret_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.return' op ""requires attribute 'control_ret_attrs'");
    if (namedAttrIt->getName() == ReturnOp::getControlRetAttrsAttrName(*odsOpName)) {
      tblgen_control_ret_attrs = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (tblgen_control_ret_attrs && !(((tblgen_control_ret_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_control_ret_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.return' op ""attribute 'control_ret_attrs' failed to satisfy constraint: an array of dictionaries");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ReturnOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range ReturnOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ReturnOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ReturnOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::ArrayAttr ReturnOp::getControlRetAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getControlRetAttrsAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr ReturnOp::getControlRetAttrs() {
  auto attr = getControlRetAttrsAttr();
  return attr;
}

void ReturnOp::setControlRetAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getControlRetAttrsAttrName(), attr);
}

void ReturnOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange odsArg_0, ::mlir::ArrayAttr control_ret_attrs) {
  odsState.addOperands(odsArg_0);
  odsState.addAttribute(getControlRetAttrsAttrName(odsState.name), control_ret_attrs);
}

void ReturnOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange odsArg_0, ::mlir::ArrayAttr control_ret_attrs) {
  odsState.addOperands(odsArg_0);
  odsState.addAttribute(getControlRetAttrsAttrName(odsState.name), control_ret_attrs);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReturnOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ReturnOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_control_ret_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'control_ret_attrs'");
    if (namedAttrIt->getName() == getControlRetAttrsAttrName()) {
      tblgen_control_ret_attrs = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_control_ret_attrs, "control_ret_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ReturnOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

void ReturnOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::ReturnOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulCaseOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatefulCaseOpGenericAdaptorBase::StatefulCaseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulCase", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatefulCaseOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatefulCaseOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatefulCaseOpGenericAdaptorBase::getBranchesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulCaseOp::getBranchesAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr StatefulCaseOpGenericAdaptorBase::getBranches() {
  auto attr = getBranchesAttr();
  return attr;
}

::mlir::ArrayAttr StatefulCaseOpGenericAdaptorBase::getTinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulCaseOp::getTinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseOpGenericAdaptorBase::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulCaseOpGenericAdaptorBase::getToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulCaseOp::getToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseOpGenericAdaptorBase::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulCaseOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatefulCaseOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
StatefulCaseOpAdaptor::StatefulCaseOpAdaptor(StatefulCaseOp op) : StatefulCaseOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatefulCaseOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulCase' op ""requires attribute 'branches'");
    if (namedAttrIt->getName() == StatefulCaseOp::getBranchesAttrName(*odsOpName)) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulCaseOp::getTinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulCaseOp::getToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatefulCaseOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branches && !(((tblgen_branches.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branches.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'branches' failed to satisfy constraint: an array of functions");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCase' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatefulCaseOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatefulCaseOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulCaseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulCaseOp::getBranchIndex() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatefulCaseOp::getArgs() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulCaseOp::getBranchIndexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulCaseOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulCaseOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulCaseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulCaseOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatefulCaseOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::ArrayAttr StatefulCaseOp::getBranchesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getBranchesAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr StatefulCaseOp::getBranches() {
  auto attr = getBranchesAttr();
  return attr;
}

::mlir::ArrayAttr StatefulCaseOp::getTinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getTinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseOp::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulCaseOp::getToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseOp::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulCaseOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatefulCaseOp::setBranchesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getBranchesAttrName(), attr);
}

void StatefulCaseOp::setTinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTinAttrName(), attr);
}

void StatefulCaseOp::setToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getToutAttrName(), attr);
}

void StatefulCaseOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute StatefulCaseOp::removeTinAttr() {
  return (*this)->removeAttr(getTinAttrName());
}

::mlir::Attribute StatefulCaseOp::removeToutAttr() {
  return (*this)->removeAttr(getToutAttrName());
}

::mlir::Attribute StatefulCaseOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void StatefulCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value branch_index, ValueRange args, ArrayAttr branches) {
      build(odsBuilder, odsState, results, branch_index, args, branches,
            /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatefulCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(getBranchesAttrName(odsState.name), branches);
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(getBranchesAttrName(odsState.name), branches);
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulCaseOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulCaseOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'branches'");
    if (namedAttrIt->getName() == getBranchesAttrName()) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops0(*this, tblgen_branches, "branches")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulCaseOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatefulCaseOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyCaseLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulCaseOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulCaseRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatefulCaseRegionOpGenericAdaptorBase::StatefulCaseRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulCaseRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatefulCaseRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatefulCaseRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatefulCaseRegionOpGenericAdaptorBase::getBranchAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulCaseRegionOp::getBranchAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseRegionOpGenericAdaptorBase::getBranchAttrs() {
  auto attr = getBranchAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulCaseRegionOpGenericAdaptorBase::getRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulCaseRegionOp::getRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseRegionOpGenericAdaptorBase::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::RegionRange StatefulCaseRegionOpGenericAdaptorBase::getBranches() {
  return odsRegions.drop_front(0);
}

::mlir::RegionRange StatefulCaseRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
StatefulCaseRegionOpAdaptor::StatefulCaseRegionOpAdaptor(StatefulCaseRegionOp op) : StatefulCaseRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatefulCaseRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatefulCaseRegionOp::getBranchAttrsAttrName(*odsOpName)) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulCaseRegionOp::getRegionAttrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branch_attrs && !(((tblgen_branch_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branch_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCaseRegion' op ""attribute 'branch_attrs' failed to satisfy constraint: an array of dictionaries");

  if (tblgen_region_attrs && !(((tblgen_region_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_region_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); }))))
    return emitError(loc, "'tfg.StatefulCaseRegion' op ""attribute 'region_attrs' failed to satisfy constraint: case region preserved attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatefulCaseRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulCaseRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> StatefulCaseRegionOp::getBranchIndex() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatefulCaseRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulCaseRegionOp::getBranchIndexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulCaseRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulCaseRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulCaseRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulCaseRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatefulCaseRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::MutableArrayRef<::mlir::Region> StatefulCaseRegionOp::getBranches() {
  return (*this)->getRegions().drop_front(0);
}

::mlir::ArrayAttr StatefulCaseRegionOp::getBranchAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getBranchAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseRegionOp::getBranchAttrs() {
  auto attr = getBranchAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulCaseRegionOp::getRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getRegionAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulCaseRegionOp::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatefulCaseRegionOp::setBranchAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getBranchAttrsAttrName(), attr);
}

void StatefulCaseRegionOp::setRegionAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getRegionAttrsAttrName(), attr);
}

::mlir::Attribute StatefulCaseRegionOp::removeBranchAttrsAttr() {
  return (*this)->removeAttr(getBranchAttrsAttrName());
}

::mlir::Attribute StatefulCaseRegionOp::removeRegionAttrsAttr() {
  return (*this)->removeAttr(getRegionAttrsAttrName());
}

void StatefulCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
    odsState.addAttribute(getBranchAttrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
    odsState.addAttribute(getBranchAttrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulCaseRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulCaseRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getBranchAttrsAttrName()) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getRegionAttrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_branch_attrs, "branch_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops4(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : getBranches())
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "branches", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulCaseRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatefulCaseRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand branch_indexRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> branch_indexOperands(branch_indexRawOperands);  ::llvm::SMLoc branch_indexOperandsLoc;
  (void)branch_indexOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<std::unique_ptr<::mlir::Region>, 2> branchesRegions;
  ::llvm::ArrayRef<::mlir::Type> branch_indexTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  branch_indexOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(branch_indexRawOperands[0]))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  {
    std::unique_ptr<::mlir::Region> region;
    auto firstRegionResult = parser.parseOptionalRegion(region);
    if (firstRegionResult.has_value()) {
      if (failed(*firstRegionResult))
        return ::mlir::failure();
      branchesRegions.emplace_back(std::move(region));

      // Parse any trailing regions.
      while (succeeded(parser.parseOptionalComma())) {
        region = std::make_unique<::mlir::Region>();
        if (parser.parseRegion(*region))
          return ::mlir::failure();
        branchesRegions.emplace_back(std::move(region));
      }
    }
  }

  for (auto &region : branchesRegions)
    if (region->empty()) region->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType branch_index__outs_functionType;
  if (parser.parseType(branch_index__outs_functionType))
    return ::mlir::failure();
  branch_indexTypes = branch_index__outs_functionType.getInputs();
  outsTypes = branch_index__outs_functionType.getResults();
  result.addRegions(branchesRegions);
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(branch_indexOperands, branch_indexTypes, branch_indexOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatefulCaseRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBranchIndex();
  if (!getCtls().empty()) {
    _odsPrinter << ' ';
    _odsPrinter << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ';
    llvm::interleaveComma(getBranches(), _odsPrinter, [&](::mlir::Region &region) {
        _odsPrinter.printRegion(region);
    });
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(getBranchIndex().getType()), getOuts().getTypes());
}

StringRef StatefulCaseRegionOp::getDefaultDialect() { return "tfg"; }
void StatefulCaseRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatefulCaseRegionOp::branch_yield(unsigned idx) {
  return cast<YieldOp>(getBranchBlock(idx).getTerminator());
}

void StatefulCaseRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetCaseLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatefulCaseRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(getNumRegions(), /*Elt=*/{0, 1});
}

LogicalResult StatefulCaseRegionOp::verify() { return VerifyCaseLikeRegionOp(*this); }

BlockArgument StatefulCaseRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatefulCaseRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatefulCaseRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatefulCaseRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulCaseRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulIfOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatefulIfOpGenericAdaptorBase::StatefulIfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulIf", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatefulIfOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatefulIfOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatefulIfOpGenericAdaptorBase::getThenBranchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatefulIfOp::getThenBranchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulIfOpGenericAdaptorBase::getThenBranch() {
  auto attr = getThenBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOpGenericAdaptorBase::getElseBranchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulIfOp::getElseBranchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulIfOpGenericAdaptorBase::getElseBranch() {
  auto attr = getElseBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatefulIfOpGenericAdaptorBase::getTcondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulIfOp::getTcondAttrName(*odsOpName)).dyn_cast_or_null<::mlir::TypeAttr>();
  return attr;
}

::std::optional<::mlir::Type> StatefulIfOpGenericAdaptorBase::getTcond() {
  auto attr = getTcondAttr();
  return attr ? ::std::optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulIfOpGenericAdaptorBase::getTinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulIfOp::getTinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulIfOpGenericAdaptorBase::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulIfOpGenericAdaptorBase::getToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulIfOp::getToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulIfOpGenericAdaptorBase::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulIfOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatefulIfOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulIfOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
StatefulIfOpAdaptor::StatefulIfOpAdaptor(StatefulIfOp op) : StatefulIfOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatefulIfOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulIf' op ""requires attribute 'else_branch'");
    if (namedAttrIt->getName() == StatefulIfOp::getElseBranchAttrName(*odsOpName)) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulIfOp::getTcondAttrName(*odsOpName)) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfOp::getTinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfOp::getToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulIf' op ""requires attribute 'then_branch'");
    if (namedAttrIt->getName() == StatefulIfOp::getThenBranchAttrName(*odsOpName)) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulIfOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_branch && !((tblgen_then_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'then_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_else_branch && !((tblgen_else_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'else_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_Tcond && !(((tblgen_Tcond.isa<::mlir::TypeAttr>())) && ((tblgen_Tcond.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'Tcond' failed to satisfy constraint: any type attribute");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatefulIf' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatefulIfOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatefulIfOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulIfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatefulIfOp::getCond() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatefulIfOp::getArgs() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulIfOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulIfOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulIfOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulIfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulIfOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatefulIfOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::tf_type::FuncAttr StatefulIfOp::getThenBranchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getThenBranchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOp::getThenBranch() {
  auto attr = getThenBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOp::getElseBranchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getElseBranchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulIfOp::getElseBranch() {
  auto attr = getElseBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatefulIfOp::getTcondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getTcondAttrName()).dyn_cast_or_null<::mlir::TypeAttr>();
}

::std::optional<::mlir::Type> StatefulIfOp::getTcond() {
  auto attr = getTcondAttr();
  return attr ? ::std::optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulIfOp::getTinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getTinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulIfOp::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulIfOp::getToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulIfOp::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulIfOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulIfOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatefulIfOp::setThenBranchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getThenBranchAttrName(), attr);
}

void StatefulIfOp::setElseBranchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getElseBranchAttrName(), attr);
}

void StatefulIfOp::setTcondAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(getTcondAttrName(), attr);
}

void StatefulIfOp::setTcond(::std::optional<::mlir::Type> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getTcondAttrName(), ::mlir::TypeAttr::get(*attrValue));
    (*this)->removeAttr(getTcondAttrName());
}

void StatefulIfOp::setTinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTinAttrName(), attr);
}

void StatefulIfOp::setToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getToutAttrName(), attr);
}

void StatefulIfOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute StatefulIfOp::removeTcondAttr() {
  return (*this)->removeAttr(getTcondAttrName());
}

::mlir::Attribute StatefulIfOp::removeTinAttr() {
  return (*this)->removeAttr(getTinAttrName());
}

::mlir::Attribute StatefulIfOp::removeToutAttr() {
  return (*this)->removeAttr(getToutAttrName());
}

::mlir::Attribute StatefulIfOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void StatefulIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value cond, ValueRange args, FuncAttr then_branch, FuncAttr else_branch) {
      build(odsBuilder, odsState, results, cond, args, then_branch, else_branch,
            /*Tcond=*/{}, /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatefulIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(getThenBranchAttrName(odsState.name), then_branch);
  odsState.addAttribute(getElseBranchAttrName(odsState.name), else_branch);
  if (Tcond) {
    odsState.addAttribute(getTcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(getThenBranchAttrName(odsState.name), then_branch);
  odsState.addAttribute(getElseBranchAttrName(odsState.name), else_branch);
  if (Tcond) {
    odsState.addAttribute(getTcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulIfOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulIfOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'else_branch'");
    if (namedAttrIt->getName() == getElseBranchAttrName()) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTcondAttrName()) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getTinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'then_branch'");
    if (namedAttrIt->getName() == getThenBranchAttrName()) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_then_branch, "then_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_else_branch, "else_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops17(*this, tblgen_Tcond, "Tcond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulIfOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatefulIfOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyIfLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulIfOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulIfRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatefulIfRegionOpGenericAdaptorBase::StatefulIfRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulIfRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatefulIfRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatefulIfRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr StatefulIfRegionOpGenericAdaptorBase::getThenAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::getThenAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatefulIfRegionOpGenericAdaptorBase::getThenAttrs() {
  auto attr = getThenAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatefulIfRegionOpGenericAdaptorBase::getElseAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::getElseAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatefulIfRegionOpGenericAdaptorBase::getElseAttrs() {
  auto attr = getElseAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulIfRegionOpGenericAdaptorBase::getThenRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::getThenRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatefulIfRegionOpGenericAdaptorBase::getThenRegionAttrs() {
  auto attr = getThenRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulIfRegionOpGenericAdaptorBase::getElseRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatefulIfRegionOp::getElseRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatefulIfRegionOpGenericAdaptorBase::getElseRegionAttrs() {
  auto attr = getElseRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::Region &StatefulIfRegionOpGenericAdaptorBase::getThenRegion() {
  return *odsRegions[0];
}

::mlir::Region &StatefulIfRegionOpGenericAdaptorBase::getElseRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange StatefulIfRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
StatefulIfRegionOpAdaptor::StatefulIfRegionOpAdaptor(StatefulIfRegionOp op) : StatefulIfRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatefulIfRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::getElseAttrsAttrName(*odsOpName)) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::getElseRegionAttrsAttrName(*odsOpName)) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::getThenAttrsAttrName(*odsOpName)) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulIfRegionOp::getThenRegionAttrsAttrName(*odsOpName)) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_attrs && !((tblgen_then_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'then_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_else_attrs && !((tblgen_else_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'else_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_then_region_attrs && !((tblgen_then_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'then_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_else_region_attrs && !((tblgen_else_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulIfRegion' op ""attribute 'else_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatefulIfRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulIfRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> StatefulIfRegionOp::getCond() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatefulIfRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulIfRegionOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatefulIfRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulIfRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulIfRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulIfRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatefulIfRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::Region &StatefulIfRegionOp::getThenRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatefulIfRegionOp::getElseRegion() {
  return (*this)->getRegion(1);
}

::mlir::DictionaryAttr StatefulIfRegionOp::getThenAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getThenAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatefulIfRegionOp::getThenAttrs() {
  auto attr = getThenAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatefulIfRegionOp::getElseAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getElseAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatefulIfRegionOp::getElseAttrs() {
  auto attr = getElseAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulIfRegionOp::getThenRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getThenRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatefulIfRegionOp::getThenRegionAttrs() {
  auto attr = getThenRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulIfRegionOp::getElseRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getElseRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatefulIfRegionOp::getElseRegionAttrs() {
  auto attr = getElseRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

void StatefulIfRegionOp::setThenAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getThenAttrsAttrName(), attr);
}

void StatefulIfRegionOp::setElseAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getElseAttrsAttrName(), attr);
}

void StatefulIfRegionOp::setThenRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getThenRegionAttrsAttrName(), attr);
}

void StatefulIfRegionOp::setElseRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getElseRegionAttrsAttrName(), attr);
}

::mlir::Attribute StatefulIfRegionOp::removeThenAttrsAttr() {
  return (*this)->removeAttr(getThenAttrsAttrName());
}

::mlir::Attribute StatefulIfRegionOp::removeElseAttrsAttr() {
  return (*this)->removeAttr(getElseAttrsAttrName());
}

::mlir::Attribute StatefulIfRegionOp::removeThenRegionAttrsAttr() {
  return (*this)->removeAttr(getThenRegionAttrsAttrName());
}

::mlir::Attribute StatefulIfRegionOp::removeElseRegionAttrsAttr() {
  return (*this)->removeAttr(getElseRegionAttrsAttrName());
}

void StatefulIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
    odsState.addAttribute(getThenAttrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
    odsState.addAttribute(getElseAttrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
    odsState.addAttribute(getThenRegionAttrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
    odsState.addAttribute(getElseRegionAttrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
    odsState.addAttribute(getThenAttrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
    odsState.addAttribute(getElseAttrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
    odsState.addAttribute(getThenRegionAttrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
    odsState.addAttribute(getElseRegionAttrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulIfRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulIfRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getElseAttrsAttrName()) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getElseRegionAttrsAttrName()) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getThenAttrsAttrName()) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getThenRegionAttrsAttrName()) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_then_attrs, "then_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_else_attrs, "else_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_then_region_attrs, "then_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_else_region_attrs, "else_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "then_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "else_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulIfRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatefulIfRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> then_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> else_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> condTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("then"))
    return ::mlir::failure();

  if (parser.parseRegion(*then_regionRegion))
    return ::mlir::failure();

  if (then_regionRegion->empty()) then_regionRegion->emplaceBlock();
  if (parser.parseKeyword("else"))
    return ::mlir::failure();

  if (parser.parseRegion(*else_regionRegion))
    return ::mlir::failure();

  if (else_regionRegion->empty()) else_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType cond__outs_functionType;
  if (parser.parseType(cond__outs_functionType))
    return ::mlir::failure();
  condTypes = cond__outs_functionType.getInputs();
  outsTypes = cond__outs_functionType.getResults();
  result.addRegion(std::move(then_regionRegion));
  result.addRegion(std::move(else_regionRegion));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatefulIfRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getCond();
  if (!getCtls().empty()) {
    _odsPrinter << ' ';
    _odsPrinter << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "then";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getThenRegion());
  _odsPrinter << ' ' << "else";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getElseRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(getCond().getType()), getOuts().getTypes());
}

StringRef StatefulIfRegionOp::getDefaultDialect() { return "tfg"; }
void StatefulIfRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatefulIfRegionOp::getThenYield() {
  return cast<YieldOp>(getThenBlock().getTerminator());
}
YieldOp StatefulIfRegionOp::getElseYield() {
  return cast<YieldOp>(getElseBlock().getTerminator());
}

void StatefulIfRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetIfLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatefulIfRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(/*NumInputs=*/2, /*Elt=*/{0, 1});
}

LogicalResult StatefulIfRegionOp::verify() { return VerifyIfLikeRegionOp(*this); }

BlockArgument StatefulIfRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatefulIfRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatefulIfRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatefulIfRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulIfRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulWhileOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatefulWhileOpGenericAdaptorBase::StatefulWhileOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulWhile", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatefulWhileOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatefulWhileOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatefulWhileOpGenericAdaptorBase::getCondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatefulWhileOp::getCondAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulWhileOpGenericAdaptorBase::getCond() {
  auto attr = getCondAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOpGenericAdaptorBase::getBodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileOp::getBodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatefulWhileOpGenericAdaptorBase::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatefulWhileOpGenericAdaptorBase::getParallelIterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 0, StatefulWhileOp::getParallelIterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatefulWhileOpGenericAdaptorBase::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatefulWhileOpGenericAdaptorBase::getTAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 3, StatefulWhileOp::getTAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulWhileOpGenericAdaptorBase::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulWhileOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 1, StatefulWhileOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatefulWhileOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
StatefulWhileOpAdaptor::StatefulWhileOpAdaptor(StatefulWhileOp op) : StatefulWhileOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatefulWhileOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhile' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == StatefulWhileOp::getBodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulWhileOp::getTAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhile' op ""requires attribute 'cond'");
    if (namedAttrIt->getName() == StatefulWhileOp::getCondAttrName(*odsOpName)) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhile' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatefulWhileOp::getParallelIterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulWhileOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_cond && !((tblgen_cond.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'cond' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'T' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatefulWhile' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatefulWhileOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatefulWhileOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatefulWhileOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatefulWhileOp::getArgs() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange StatefulWhileOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulWhileOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulWhileOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulWhileOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatefulWhileOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::tf_type::FuncAttr StatefulWhileOp::getCondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getCondAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOp::getCond() {
  auto attr = getCondAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOp::getBodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatefulWhileOp::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatefulWhileOp::getParallelIterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 0, getParallelIterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatefulWhileOp::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatefulWhileOp::getTAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 3, getTAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulWhileOp::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatefulWhileOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 1, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatefulWhileOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatefulWhileOp::setCondAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getCondAttrName(), attr);
}

void StatefulWhileOp::setBodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getBodyAttrName(), attr);
}

void StatefulWhileOp::setParallelIterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getParallelIterationsAttrName(), attr);
}

void StatefulWhileOp::setParallelIterations(uint64_t attrValue) {
  (*this)->setAttr(getParallelIterationsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void StatefulWhileOp::setTAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTAttrName(), attr);
}

void StatefulWhileOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute StatefulWhileOp::removeTAttr() {
  return (*this)->removeAttr(getTAttrName());
}

::mlir::Attribute StatefulWhileOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, ValueRange args, FuncAttr cond, FuncAttr body, IntegerAttr parallel_iterations) {
      build(odsBuilder, odsState, results, args, cond, body, parallel_iterations,
            /*T=*/{}, /*output_shapes=*/{});
    
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulWhileOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == getBodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'cond'");
    if (namedAttrIt->getName() == getCondAttrName()) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == getParallelIterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_cond, "cond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulWhileOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatefulWhileOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyWhileLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulWhileOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatefulWhileRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatefulWhileRegionOpGenericAdaptorBase::StatefulWhileRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatefulWhileRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatefulWhileRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatefulWhileRegionOp::getOperandSegmentSizesAttrName(*odsOpName)).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr StatefulWhileRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr StatefulWhileRegionOpGenericAdaptorBase::getParallelIterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatefulWhileRegionOp::getParallelIterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatefulWhileRegionOpGenericAdaptorBase::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatefulWhileRegionOpGenericAdaptorBase::getCondAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::getCondAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatefulWhileRegionOpGenericAdaptorBase::getCondAttrs() {
  auto attr = getCondAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatefulWhileRegionOpGenericAdaptorBase::getBodyAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::getBodyAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatefulWhileRegionOpGenericAdaptorBase::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOpGenericAdaptorBase::getCondRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::getCondRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOpGenericAdaptorBase::getCondRegionAttrs() {
  auto attr = getCondRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOpGenericAdaptorBase::getBodyRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatefulWhileRegionOp::getBodyRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOpGenericAdaptorBase::getBodyRegionAttrs() {
  auto attr = getBodyRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::Region &StatefulWhileRegionOpGenericAdaptorBase::getCondRegion() {
  return *odsRegions[0];
}

::mlir::Region &StatefulWhileRegionOpGenericAdaptorBase::getBodyRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange StatefulWhileRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
StatefulWhileRegionOpAdaptor::StatefulWhileRegionOpAdaptor(StatefulWhileRegionOp op) : StatefulWhileRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatefulWhileRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhileRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == StatefulWhileRegionOp::getOperandSegmentSizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::getBodyAttrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::getBodyRegionAttrsAttrName(*odsOpName)) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::getCondAttrsAttrName(*odsOpName)) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatefulWhileRegionOp::getCondRegionAttrsAttrName(*odsOpName)) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatefulWhileRegion' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatefulWhileRegionOp::getParallelIterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitError(loc, "'tfg.StatefulWhileRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_cond_attrs && !((tblgen_cond_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'cond_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_cond_region_attrs && !((tblgen_cond_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'cond_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_body_region_attrs && !((tblgen_body_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatefulWhileRegion' op ""attribute 'body_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatefulWhileRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName()).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range StatefulWhileRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatefulWhileRegionOp::getInit() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range StatefulWhileRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatefulWhileRegionOp::getInitMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange StatefulWhileRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> StatefulWhileRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatefulWhileRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatefulWhileRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatefulWhileRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::Region &StatefulWhileRegionOp::getCondRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatefulWhileRegionOp::getBodyRegion() {
  return (*this)->getRegion(1);
}

::mlir::IntegerAttr StatefulWhileRegionOp::getParallelIterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getParallelIterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatefulWhileRegionOp::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatefulWhileRegionOp::getCondAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getCondAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatefulWhileRegionOp::getCondAttrs() {
  auto attr = getCondAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatefulWhileRegionOp::getBodyAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatefulWhileRegionOp::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOp::getCondRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getCondRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOp::getCondRegionAttrs() {
  auto attr = getCondRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatefulWhileRegionOp::getBodyRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatefulWhileRegionOp::getBodyRegionAttrs() {
  auto attr = getBodyRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

void StatefulWhileRegionOp::setParallelIterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getParallelIterationsAttrName(), attr);
}

void StatefulWhileRegionOp::setParallelIterations(uint64_t attrValue) {
  (*this)->setAttr(getParallelIterationsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void StatefulWhileRegionOp::setCondAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getCondAttrsAttrName(), attr);
}

void StatefulWhileRegionOp::setBodyAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getBodyAttrsAttrName(), attr);
}

void StatefulWhileRegionOp::setCondRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getCondRegionAttrsAttrName(), attr);
}

void StatefulWhileRegionOp::setBodyRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getBodyRegionAttrsAttrName(), attr);
}

::mlir::Attribute StatefulWhileRegionOp::removeCondAttrsAttr() {
  return (*this)->removeAttr(getCondAttrsAttrName());
}

::mlir::Attribute StatefulWhileRegionOp::removeBodyAttrsAttr() {
  return (*this)->removeAttr(getBodyAttrsAttrName());
}

::mlir::Attribute StatefulWhileRegionOp::removeCondRegionAttrsAttr() {
  return (*this)->removeAttr(getCondRegionAttrsAttrName());
}

::mlir::Attribute StatefulWhileRegionOp::removeBodyRegionAttrsAttr() {
  return (*this)->removeAttr(getBodyRegionAttrsAttrName());
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatefulWhileRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatefulWhileRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == getOperandSegmentSizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getBodyAttrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getBodyRegionAttrsAttrName()) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getCondAttrsAttrName()) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getCondRegionAttrsAttrName()) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == getParallelIterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_cond_attrs, "cond_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_cond_region_attrs, "cond_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_body_region_attrs, "body_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "cond_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatefulWhileRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatefulWhileRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> cond_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> initTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  if (parser.parseRegion(*cond_regionRegion))
    return ::mlir::failure();

  if (cond_regionRegion->empty()) cond_regionRegion->emplaceBlock();
  if (parser.parseKeyword("do"))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalColon())) {

  ::mlir::FunctionType init__outs_functionType;
  if (parser.parseType(init__outs_functionType))
    return ::mlir::failure();
  initTypes = init__outs_functionType.getInputs();
  outsTypes = init__outs_functionType.getResults();
  }
  result.addRegion(std::move(cond_regionRegion));
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getDenseI32ArrayAttr({static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatefulWhileRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!getInit().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getInit();
    _odsPrinter << ")";
  }
  if (!getCtls().empty()) {
    _odsPrinter << ' ' << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getCondRegion());
  _odsPrinter << ' ' << "do";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getBodyRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operand_segment_sizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  if (!getInit().empty()) {
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter.printFunctionalType(getInit().getTypes(), getOuts().getTypes());
  }
}

StringRef StatefulWhileRegionOp::getDefaultDialect() { return "tfg"; }
void StatefulWhileRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

ConditionOp StatefulWhileRegionOp::getCondCondition() {
  return cast<ConditionOp>(getCondBlock().getTerminator());
}
YieldOp StatefulWhileRegionOp::getBodyYield() {
  return cast<YieldOp>(getBodyBlock().getTerminator());
}

OperandRange StatefulWhileRegionOp::getSuccessorEntryOperands(
    std::optional<unsigned> index) {
  return getInit();
}
void StatefulWhileRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  return GetWhileLikeRegionOpSuccessorRegions(*this, index, operands,
                                              regions);
}

LogicalResult StatefulWhileRegionOp::verify() { return VerifyWhileLikeRegionOp(*this); }

BlockArgument StatefulWhileRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatefulWhileRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatefulWhileRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatefulWhileRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatefulWhileRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessCaseOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatelessCaseOpGenericAdaptorBase::StatelessCaseOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessCase", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatelessCaseOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatelessCaseOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatelessCaseOpGenericAdaptorBase::getBranchesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessCaseOp::getBranchesAttrName(*odsOpName)).cast<::mlir::ArrayAttr>();
  return attr;
}

::mlir::ArrayAttr StatelessCaseOpGenericAdaptorBase::getBranches() {
  auto attr = getBranchesAttr();
  return attr;
}

::mlir::ArrayAttr StatelessCaseOpGenericAdaptorBase::getTinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessCaseOp::getTinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseOpGenericAdaptorBase::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessCaseOpGenericAdaptorBase::getToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessCaseOp::getToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseOpGenericAdaptorBase::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessCaseOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatelessCaseOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
StatelessCaseOpAdaptor::StatelessCaseOpAdaptor(StatelessCaseOp op) : StatelessCaseOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatelessCaseOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessCase' op ""requires attribute 'branches'");
    if (namedAttrIt->getName() == StatelessCaseOp::getBranchesAttrName(*odsOpName)) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessCaseOp::getTinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessCaseOp::getToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatelessCaseOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branches && !(((tblgen_branches.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branches.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::FuncAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'branches' failed to satisfy constraint: an array of functions");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCase' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatelessCaseOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatelessCaseOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessCaseOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessCaseOp::getBranchIndex() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatelessCaseOp::getArgs() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessCaseOp::getBranchIndexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessCaseOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessCaseOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessCaseOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessCaseOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatelessCaseOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::ArrayAttr StatelessCaseOp::getBranchesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getBranchesAttrName()).cast<::mlir::ArrayAttr>();
}

::mlir::ArrayAttr StatelessCaseOp::getBranches() {
  auto attr = getBranchesAttr();
  return attr;
}

::mlir::ArrayAttr StatelessCaseOp::getTinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getTinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseOp::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessCaseOp::getToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseOp::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessCaseOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatelessCaseOp::setBranchesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getBranchesAttrName(), attr);
}

void StatelessCaseOp::setTinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTinAttrName(), attr);
}

void StatelessCaseOp::setToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getToutAttrName(), attr);
}

void StatelessCaseOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute StatelessCaseOp::removeTinAttr() {
  return (*this)->removeAttr(getTinAttrName());
}

::mlir::Attribute StatelessCaseOp::removeToutAttr() {
  return (*this)->removeAttr(getToutAttrName());
}

::mlir::Attribute StatelessCaseOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void StatelessCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value branch_index, ValueRange args, ArrayAttr branches) {
      build(odsBuilder, odsState, results, branch_index, args, branches,
            /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatelessCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(getBranchesAttrName(odsState.name), branches);
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessCaseOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange args, ::mlir::ArrayAttr branches, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(branch_index);
  odsState.addOperands(args);
  odsState.addAttribute(getBranchesAttrName(odsState.name), branches);
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessCaseOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessCaseOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branches;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'branches'");
    if (namedAttrIt->getName() == getBranchesAttrName()) {
      tblgen_branches = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops0(*this, tblgen_branches, "branches")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessCaseOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatelessCaseOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyCaseLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessCaseOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessCaseRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatelessCaseRegionOpGenericAdaptorBase::StatelessCaseRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessCaseRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatelessCaseRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatelessCaseRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::ArrayAttr StatelessCaseRegionOpGenericAdaptorBase::getBranchAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessCaseRegionOp::getBranchAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseRegionOpGenericAdaptorBase::getBranchAttrs() {
  auto attr = getBranchAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessCaseRegionOpGenericAdaptorBase::getRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessCaseRegionOp::getRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseRegionOpGenericAdaptorBase::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::RegionRange StatelessCaseRegionOpGenericAdaptorBase::getBranches() {
  return odsRegions.drop_front(0);
}

::mlir::RegionRange StatelessCaseRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
StatelessCaseRegionOpAdaptor::StatelessCaseRegionOpAdaptor(StatelessCaseRegionOp op) : StatelessCaseRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatelessCaseRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatelessCaseRegionOp::getBranchAttrsAttrName(*odsOpName)) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessCaseRegionOp::getRegionAttrsAttrName(*odsOpName)) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_branch_attrs && !(((tblgen_branch_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_branch_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::DictionaryAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCaseRegion' op ""attribute 'branch_attrs' failed to satisfy constraint: an array of dictionaries");

  if (tblgen_region_attrs && !(((tblgen_region_attrs.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_region_attrs.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tfg::RegionAttr>())); }))))
    return emitError(loc, "'tfg.StatelessCaseRegion' op ""attribute 'region_attrs' failed to satisfy constraint: case region preserved attributes");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatelessCaseRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessCaseRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> StatelessCaseRegionOp::getBranchIndex() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatelessCaseRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessCaseRegionOp::getBranchIndexMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessCaseRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessCaseRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessCaseRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessCaseRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatelessCaseRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::MutableArrayRef<::mlir::Region> StatelessCaseRegionOp::getBranches() {
  return (*this)->getRegions().drop_front(0);
}

::mlir::ArrayAttr StatelessCaseRegionOp::getBranchAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getBranchAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseRegionOp::getBranchAttrs() {
  auto attr = getBranchAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessCaseRegionOp::getRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getRegionAttrsAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessCaseRegionOp::getRegionAttrs() {
  auto attr = getRegionAttrsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatelessCaseRegionOp::setBranchAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getBranchAttrsAttrName(), attr);
}

void StatelessCaseRegionOp::setRegionAttrsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getRegionAttrsAttrName(), attr);
}

::mlir::Attribute StatelessCaseRegionOp::removeBranchAttrsAttr() {
  return (*this)->removeAttr(getBranchAttrsAttrName());
}

::mlir::Attribute StatelessCaseRegionOp::removeRegionAttrsAttr() {
  return (*this)->removeAttr(getRegionAttrsAttrName());
}

void StatelessCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
    odsState.addAttribute(getBranchAttrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessCaseRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value branch_index, ::mlir::ValueRange ctls, /*optional*/::mlir::ArrayAttr branch_attrs, /*optional*/::mlir::ArrayAttr region_attrs, unsigned branchesCount) {
  odsState.addOperands(branch_index);
  odsState.addOperands(ctls);
  if (branch_attrs) {
    odsState.addAttribute(getBranchAttrsAttrName(odsState.name), branch_attrs);
  }
  if (region_attrs) {
    odsState.addAttribute(getRegionAttrsAttrName(odsState.name), region_attrs);
  }
  for (unsigned i = 0; i < branchesCount; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessCaseRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes, unsigned numRegions) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != numRegions; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessCaseRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_branch_attrs;
  ::mlir::Attribute tblgen_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getBranchAttrsAttrName()) {
      tblgen_branch_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getRegionAttrsAttrName()) {
      tblgen_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops3(*this, tblgen_branch_attrs, "branch_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops4(*this, tblgen_region_attrs, "region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : getBranches())
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "branches", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessCaseRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatelessCaseRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand branch_indexRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> branch_indexOperands(branch_indexRawOperands);  ::llvm::SMLoc branch_indexOperandsLoc;
  (void)branch_indexOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<std::unique_ptr<::mlir::Region>, 2> branchesRegions;
  ::llvm::ArrayRef<::mlir::Type> branch_indexTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  branch_indexOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(branch_indexRawOperands[0]))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  {
    std::unique_ptr<::mlir::Region> region;
    auto firstRegionResult = parser.parseOptionalRegion(region);
    if (firstRegionResult.has_value()) {
      if (failed(*firstRegionResult))
        return ::mlir::failure();
      branchesRegions.emplace_back(std::move(region));

      // Parse any trailing regions.
      while (succeeded(parser.parseOptionalComma())) {
        region = std::make_unique<::mlir::Region>();
        if (parser.parseRegion(*region))
          return ::mlir::failure();
        branchesRegions.emplace_back(std::move(region));
      }
    }
  }

  for (auto &region : branchesRegions)
    if (region->empty()) region->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType branch_index__outs_functionType;
  if (parser.parseType(branch_index__outs_functionType))
    return ::mlir::failure();
  branch_indexTypes = branch_index__outs_functionType.getInputs();
  outsTypes = branch_index__outs_functionType.getResults();
  result.addRegions(branchesRegions);
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(branch_indexOperands, branch_indexTypes, branch_indexOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatelessCaseRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBranchIndex();
  if (!getCtls().empty()) {
    _odsPrinter << ' ';
    _odsPrinter << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ';
    llvm::interleaveComma(getBranches(), _odsPrinter, [&](::mlir::Region &region) {
        _odsPrinter.printRegion(region);
    });
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(getBranchIndex().getType()), getOuts().getTypes());
}

StringRef StatelessCaseRegionOp::getDefaultDialect() { return "tfg"; }
void StatelessCaseRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatelessCaseRegionOp::branch_yield(unsigned idx) {
  return cast<YieldOp>(getBranchBlock(idx).getTerminator());
}

void StatelessCaseRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetCaseLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatelessCaseRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(getNumRegions(), /*Elt=*/{0, 1});
}

LogicalResult StatelessCaseRegionOp::verify() { return VerifyCaseLikeRegionOp(*this); }

BlockArgument StatelessCaseRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatelessCaseRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatelessCaseRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatelessCaseRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessCaseRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessIfOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatelessIfOpGenericAdaptorBase::StatelessIfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessIf", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatelessIfOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatelessIfOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatelessIfOpGenericAdaptorBase::getThenBranchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatelessIfOp::getThenBranchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessIfOpGenericAdaptorBase::getThenBranch() {
  auto attr = getThenBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOpGenericAdaptorBase::getElseBranchAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessIfOp::getElseBranchAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessIfOpGenericAdaptorBase::getElseBranch() {
  auto attr = getElseBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatelessIfOpGenericAdaptorBase::getTcondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessIfOp::getTcondAttrName(*odsOpName)).dyn_cast_or_null<::mlir::TypeAttr>();
  return attr;
}

::std::optional<::mlir::Type> StatelessIfOpGenericAdaptorBase::getTcond() {
  auto attr = getTcondAttr();
  return attr ? ::std::optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessIfOpGenericAdaptorBase::getTinAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessIfOp::getTinAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessIfOpGenericAdaptorBase::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessIfOpGenericAdaptorBase::getToutAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessIfOp::getToutAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessIfOpGenericAdaptorBase::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessIfOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatelessIfOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessIfOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
StatelessIfOpAdaptor::StatelessIfOpAdaptor(StatelessIfOp op) : StatelessIfOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatelessIfOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessIf' op ""requires attribute 'else_branch'");
    if (namedAttrIt->getName() == StatelessIfOp::getElseBranchAttrName(*odsOpName)) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessIfOp::getTcondAttrName(*odsOpName)) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfOp::getTinAttrName(*odsOpName)) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfOp::getToutAttrName(*odsOpName)) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessIf' op ""requires attribute 'then_branch'");
    if (namedAttrIt->getName() == StatelessIfOp::getThenBranchAttrName(*odsOpName)) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessIfOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_branch && !((tblgen_then_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'then_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_else_branch && !((tblgen_else_branch.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'else_branch' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_Tcond && !(((tblgen_Tcond.isa<::mlir::TypeAttr>())) && ((tblgen_Tcond.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'Tcond' failed to satisfy constraint: any type attribute");

  if (tblgen_Tin && !(((tblgen_Tin.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tin.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'Tin' failed to satisfy constraint: type array attribute");

  if (tblgen_Tout && !(((tblgen_Tout.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_Tout.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'Tout' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatelessIf' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatelessIfOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatelessIfOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessIfOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value StatelessIfOp::getCond() {
  return ::llvm::cast<::mlir::Value>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatelessIfOp::getArgs() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessIfOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessIfOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessIfOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessIfOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessIfOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatelessIfOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::tf_type::FuncAttr StatelessIfOp::getThenBranchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getThenBranchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOp::getThenBranch() {
  auto attr = getThenBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOp::getElseBranchAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getElseBranchAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessIfOp::getElseBranch() {
  auto attr = getElseBranchAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::TypeAttr StatelessIfOp::getTcondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getTcondAttrName()).dyn_cast_or_null<::mlir::TypeAttr>();
}

::std::optional<::mlir::Type> StatelessIfOp::getTcond() {
  auto attr = getTcondAttr();
  return attr ? ::std::optional<::mlir::Type>(attr.getValue().cast<::mlir::Type>()) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessIfOp::getTinAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getTinAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessIfOp::getTin() {
  auto attr = getTinAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessIfOp::getToutAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getToutAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessIfOp::getTout() {
  auto attr = getToutAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessIfOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessIfOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatelessIfOp::setThenBranchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getThenBranchAttrName(), attr);
}

void StatelessIfOp::setElseBranchAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getElseBranchAttrName(), attr);
}

void StatelessIfOp::setTcondAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(getTcondAttrName(), attr);
}

void StatelessIfOp::setTcond(::std::optional<::mlir::Type> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getTcondAttrName(), ::mlir::TypeAttr::get(*attrValue));
    (*this)->removeAttr(getTcondAttrName());
}

void StatelessIfOp::setTinAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTinAttrName(), attr);
}

void StatelessIfOp::setToutAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getToutAttrName(), attr);
}

void StatelessIfOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute StatelessIfOp::removeTcondAttr() {
  return (*this)->removeAttr(getTcondAttrName());
}

::mlir::Attribute StatelessIfOp::removeTinAttr() {
  return (*this)->removeAttr(getTinAttrName());
}

::mlir::Attribute StatelessIfOp::removeToutAttr() {
  return (*this)->removeAttr(getToutAttrName());
}

::mlir::Attribute StatelessIfOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void StatelessIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, Value cond, ValueRange args, FuncAttr then_branch, FuncAttr else_branch) {
      build(odsBuilder, odsState, results, cond, args, then_branch, else_branch,
            /*Tcond=*/{}, /*Tin=*/{}, /*Tout=*/{}, /*output_shapes=*/{});
    
}

void StatelessIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(getThenBranchAttrName(odsState.name), then_branch);
  odsState.addAttribute(getElseBranchAttrName(odsState.name), else_branch);
  if (Tcond) {
    odsState.addAttribute(getTcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessIfOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr then_branch, ::mlir::tf_type::FuncAttr else_branch, /*optional*/::mlir::TypeAttr Tcond, /*optional*/::mlir::ArrayAttr Tin, /*optional*/::mlir::ArrayAttr Tout, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(cond);
  odsState.addOperands(args);
  odsState.addAttribute(getThenBranchAttrName(odsState.name), then_branch);
  odsState.addAttribute(getElseBranchAttrName(odsState.name), else_branch);
  if (Tcond) {
    odsState.addAttribute(getTcondAttrName(odsState.name), Tcond);
  }
  if (Tin) {
    odsState.addAttribute(getTinAttrName(odsState.name), Tin);
  }
  if (Tout) {
    odsState.addAttribute(getToutAttrName(odsState.name), Tout);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessIfOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessIfOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_branch;
  ::mlir::Attribute tblgen_Tcond;
  ::mlir::Attribute tblgen_Tin;
  ::mlir::Attribute tblgen_Tout;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'else_branch'");
    if (namedAttrIt->getName() == getElseBranchAttrName()) {
      tblgen_else_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTcondAttrName()) {
      tblgen_Tcond = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getTinAttrName()) {
      tblgen_Tin = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getToutAttrName()) {
      tblgen_Tout = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_then_branch;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'then_branch'");
    if (namedAttrIt->getName() == getThenBranchAttrName()) {
      tblgen_then_branch = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_then_branch, "then_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_else_branch, "else_branch")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops17(*this, tblgen_Tcond, "Tcond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tin, "Tin")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_Tout, "Tout")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessIfOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatelessIfOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyIfLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessIfOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessIfRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatelessIfRegionOpGenericAdaptorBase::StatelessIfRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessIfRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatelessIfRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatelessIfRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::DictionaryAttr StatelessIfRegionOpGenericAdaptorBase::getThenAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::getThenAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatelessIfRegionOpGenericAdaptorBase::getThenAttrs() {
  auto attr = getThenAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatelessIfRegionOpGenericAdaptorBase::getElseAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::getElseAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatelessIfRegionOpGenericAdaptorBase::getElseAttrs() {
  auto attr = getElseAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessIfRegionOpGenericAdaptorBase::getThenRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::getThenRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatelessIfRegionOpGenericAdaptorBase::getThenRegionAttrs() {
  auto attr = getThenRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessIfRegionOpGenericAdaptorBase::getElseRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, StatelessIfRegionOp::getElseRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatelessIfRegionOpGenericAdaptorBase::getElseRegionAttrs() {
  auto attr = getElseRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::Region &StatelessIfRegionOpGenericAdaptorBase::getThenRegion() {
  return *odsRegions[0];
}

::mlir::Region &StatelessIfRegionOpGenericAdaptorBase::getElseRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange StatelessIfRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
StatelessIfRegionOpAdaptor::StatelessIfRegionOpAdaptor(StatelessIfRegionOp op) : StatelessIfRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatelessIfRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::getElseAttrsAttrName(*odsOpName)) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::getElseRegionAttrsAttrName(*odsOpName)) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::getThenAttrsAttrName(*odsOpName)) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessIfRegionOp::getThenRegionAttrsAttrName(*odsOpName)) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_then_attrs && !((tblgen_then_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'then_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_else_attrs && !((tblgen_else_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'else_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_then_region_attrs && !((tblgen_then_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'then_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_else_region_attrs && !((tblgen_else_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessIfRegion' op ""attribute 'else_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatelessIfRegionOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessIfRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::TensorType> StatelessIfRegionOp::getCond() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
}

::mlir::Operation::operand_range StatelessIfRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessIfRegionOp::getCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::mlir::MutableOperandRange StatelessIfRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessIfRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessIfRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessIfRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatelessIfRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::Region &StatelessIfRegionOp::getThenRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatelessIfRegionOp::getElseRegion() {
  return (*this)->getRegion(1);
}

::mlir::DictionaryAttr StatelessIfRegionOp::getThenAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getThenAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatelessIfRegionOp::getThenAttrs() {
  auto attr = getThenAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatelessIfRegionOp::getElseAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getElseAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatelessIfRegionOp::getElseAttrs() {
  auto attr = getElseAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessIfRegionOp::getThenRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getThenRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatelessIfRegionOp::getThenRegionAttrs() {
  auto attr = getThenRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessIfRegionOp::getElseRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getElseRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatelessIfRegionOp::getElseRegionAttrs() {
  auto attr = getElseRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

void StatelessIfRegionOp::setThenAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getThenAttrsAttrName(), attr);
}

void StatelessIfRegionOp::setElseAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getElseAttrsAttrName(), attr);
}

void StatelessIfRegionOp::setThenRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getThenRegionAttrsAttrName(), attr);
}

void StatelessIfRegionOp::setElseRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getElseRegionAttrsAttrName(), attr);
}

::mlir::Attribute StatelessIfRegionOp::removeThenAttrsAttr() {
  return (*this)->removeAttr(getThenAttrsAttrName());
}

::mlir::Attribute StatelessIfRegionOp::removeElseAttrsAttr() {
  return (*this)->removeAttr(getElseAttrsAttrName());
}

::mlir::Attribute StatelessIfRegionOp::removeThenRegionAttrsAttr() {
  return (*this)->removeAttr(getThenRegionAttrsAttrName());
}

::mlir::Attribute StatelessIfRegionOp::removeElseRegionAttrsAttr() {
  return (*this)->removeAttr(getElseRegionAttrsAttrName());
}

void StatelessIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
    odsState.addAttribute(getThenAttrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
    odsState.addAttribute(getElseAttrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
    odsState.addAttribute(getThenRegionAttrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
    odsState.addAttribute(getElseRegionAttrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessIfRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value cond, ::mlir::ValueRange ctls, /*optional*/::mlir::DictionaryAttr then_attrs, /*optional*/::mlir::DictionaryAttr else_attrs, /*optional*/::mlir::tfg::RegionAttr then_region_attrs, /*optional*/::mlir::tfg::RegionAttr else_region_attrs) {
  odsState.addOperands(cond);
  odsState.addOperands(ctls);
  if (then_attrs) {
    odsState.addAttribute(getThenAttrsAttrName(odsState.name), then_attrs);
  }
  if (else_attrs) {
    odsState.addAttribute(getElseAttrsAttrName(odsState.name), else_attrs);
  }
  if (then_region_attrs) {
    odsState.addAttribute(getThenRegionAttrsAttrName(odsState.name), then_region_attrs);
  }
  if (else_region_attrs) {
    odsState.addAttribute(getElseRegionAttrsAttrName(odsState.name), else_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessIfRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessIfRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_else_attrs;
  ::mlir::Attribute tblgen_else_region_attrs;
  ::mlir::Attribute tblgen_then_attrs;
  ::mlir::Attribute tblgen_then_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end()) {
      break;
    }
    else if (namedAttrIt->getName() == getElseAttrsAttrName()) {
      tblgen_else_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getElseRegionAttrsAttrName()) {
      tblgen_else_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getThenAttrsAttrName()) {
      tblgen_then_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getThenRegionAttrsAttrName()) {
      tblgen_then_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_then_attrs, "then_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_else_attrs, "else_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_then_region_attrs, "then_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_else_region_attrs, "else_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "then_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "else_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessIfRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatelessIfRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand condRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> condOperands(condRawOperands);  ::llvm::SMLoc condOperandsLoc;
  (void)condOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> then_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> else_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> condTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;

  condOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(condRawOperands[0]))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseKeyword("then"))
    return ::mlir::failure();

  if (parser.parseRegion(*then_regionRegion))
    return ::mlir::failure();

  if (then_regionRegion->empty()) then_regionRegion->emplaceBlock();
  if (parser.parseKeyword("else"))
    return ::mlir::failure();

  if (parser.parseRegion(*else_regionRegion))
    return ::mlir::failure();

  if (else_regionRegion->empty()) else_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType cond__outs_functionType;
  if (parser.parseType(cond__outs_functionType))
    return ::mlir::failure();
  condTypes = cond__outs_functionType.getInputs();
  outsTypes = cond__outs_functionType.getResults();
  result.addRegion(std::move(then_regionRegion));
  result.addRegion(std::move(else_regionRegion));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(condOperands, condTypes, condOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatelessIfRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getCond();
  if (!getCtls().empty()) {
    _odsPrinter << ' ';
    _odsPrinter << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ' << "then";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getThenRegion());
  _odsPrinter << ' ' << "else";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getElseRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(::llvm::ArrayRef<::mlir::Type>(getCond().getType()), getOuts().getTypes());
}

StringRef StatelessIfRegionOp::getDefaultDialect() { return "tfg"; }
void StatelessIfRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

YieldOp StatelessIfRegionOp::getThenYield() {
  return cast<YieldOp>(getThenBlock().getTerminator());
}
YieldOp StatelessIfRegionOp::getElseYield() {
  return cast<YieldOp>(getElseBlock().getTerminator());
}

void StatelessIfRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  GetIfLikeRegionOpSuccessorRegions(*this, index, operands, regions);
}
void StatelessIfRegionOp::getRegionInvocationBounds(
    ArrayRef<Attribute> operands,
    SmallVectorImpl<InvocationBounds> &invocationBounds) {
  invocationBounds.append(/*NumInputs=*/2, /*Elt=*/{0, 1});
}

LogicalResult StatelessIfRegionOp::verify() { return VerifyIfLikeRegionOp(*this); }

BlockArgument StatelessIfRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatelessIfRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatelessIfRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatelessIfRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessIfRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessWhileOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatelessWhileOpGenericAdaptorBase::StatelessWhileOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessWhile", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatelessWhileOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr StatelessWhileOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr StatelessWhileOpGenericAdaptorBase::getCondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, StatelessWhileOp::getCondAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessWhileOpGenericAdaptorBase::getCond() {
  auto attr = getCondAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOpGenericAdaptorBase::getBodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileOp::getBodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr StatelessWhileOpGenericAdaptorBase::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatelessWhileOpGenericAdaptorBase::getParallelIterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 0, StatelessWhileOp::getParallelIterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatelessWhileOpGenericAdaptorBase::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatelessWhileOpGenericAdaptorBase::getTAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 3, StatelessWhileOp::getTAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessWhileOpGenericAdaptorBase::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessWhileOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 1, StatelessWhileOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > StatelessWhileOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
StatelessWhileOpAdaptor::StatelessWhileOpAdaptor(StatelessWhileOp op) : StatelessWhileOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatelessWhileOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhile' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == StatelessWhileOp::getBodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessWhileOp::getTAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhile' op ""requires attribute 'cond'");
    if (namedAttrIt->getName() == StatelessWhileOp::getCondAttrName(*odsOpName)) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhile' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatelessWhileOp::getParallelIterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessWhileOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_cond && !((tblgen_cond.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'cond' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'T' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.StatelessWhile' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void StatelessWhileOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> StatelessWhileOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range StatelessWhileOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatelessWhileOp::getArgs() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange StatelessWhileOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessWhileOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessWhileOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessWhileOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatelessWhileOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::tf_type::FuncAttr StatelessWhileOp::getCondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getCondAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOp::getCond() {
  auto attr = getCondAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOp::getBodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr StatelessWhileOp::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr StatelessWhileOp::getParallelIterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 0, getParallelIterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatelessWhileOp::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr StatelessWhileOp::getTAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 3, getTAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessWhileOp::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr StatelessWhileOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 1, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > StatelessWhileOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void StatelessWhileOp::setCondAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getCondAttrName(), attr);
}

void StatelessWhileOp::setBodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getBodyAttrName(), attr);
}

void StatelessWhileOp::setParallelIterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getParallelIterationsAttrName(), attr);
}

void StatelessWhileOp::setParallelIterations(uint64_t attrValue) {
  (*this)->setAttr(getParallelIterationsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void StatelessWhileOp::setTAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTAttrName(), attr);
}

void StatelessWhileOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute StatelessWhileOp::removeTAttr() {
  return (*this)->removeAttr(getTAttrName());
}

::mlir::Attribute StatelessWhileOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, ValueRange args, FuncAttr cond, FuncAttr body, IntegerAttr parallel_iterations) {
      build(odsBuilder, odsState, results, args, cond, body, parallel_iterations,
            /*T=*/{}, /*output_shapes=*/{});
    
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessWhileOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == getBodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'cond'");
    if (namedAttrIt->getName() == getCondAttrName()) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == getParallelIterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_cond, "cond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessWhileOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult StatelessWhileOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyWhileLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessWhileOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::StatelessWhileRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StatelessWhileRegionOpGenericAdaptorBase::StatelessWhileRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.StatelessWhileRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> StatelessWhileRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, StatelessWhileRegionOp::getOperandSegmentSizesAttrName(*odsOpName)).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr StatelessWhileRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr StatelessWhileRegionOpGenericAdaptorBase::getParallelIterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, StatelessWhileRegionOp::getParallelIterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t StatelessWhileRegionOpGenericAdaptorBase::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatelessWhileRegionOpGenericAdaptorBase::getCondAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::getCondAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatelessWhileRegionOpGenericAdaptorBase::getCondAttrs() {
  auto attr = getCondAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatelessWhileRegionOpGenericAdaptorBase::getBodyAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::getBodyAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > StatelessWhileRegionOpGenericAdaptorBase::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOpGenericAdaptorBase::getCondRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::getCondRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOpGenericAdaptorBase::getCondRegionAttrs() {
  auto attr = getCondRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOpGenericAdaptorBase::getBodyRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, StatelessWhileRegionOp::getBodyRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOpGenericAdaptorBase::getBodyRegionAttrs() {
  auto attr = getBodyRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::Region &StatelessWhileRegionOpGenericAdaptorBase::getCondRegion() {
  return *odsRegions[0];
}

::mlir::Region &StatelessWhileRegionOpGenericAdaptorBase::getBodyRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange StatelessWhileRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
StatelessWhileRegionOpAdaptor::StatelessWhileRegionOpAdaptor(StatelessWhileRegionOp op) : StatelessWhileRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult StatelessWhileRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhileRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == StatelessWhileRegionOp::getOperandSegmentSizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::getBodyAttrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::getBodyRegionAttrsAttrName(*odsOpName)) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::getCondAttrsAttrName(*odsOpName)) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == StatelessWhileRegionOp::getCondRegionAttrsAttrName(*odsOpName)) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.StatelessWhileRegion' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == StatelessWhileRegionOp::getParallelIterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitError(loc, "'tfg.StatelessWhileRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_cond_attrs && !((tblgen_cond_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'cond_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_cond_region_attrs && !((tblgen_cond_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'cond_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_body_region_attrs && !((tblgen_body_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.StatelessWhileRegion' op ""attribute 'body_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> StatelessWhileRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName()).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range StatelessWhileRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range StatelessWhileRegionOp::getInit() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range StatelessWhileRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange StatelessWhileRegionOp::getInitMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange StatelessWhileRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> StatelessWhileRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range StatelessWhileRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range StatelessWhileRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> StatelessWhileRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::Region &StatelessWhileRegionOp::getCondRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &StatelessWhileRegionOp::getBodyRegion() {
  return (*this)->getRegion(1);
}

::mlir::IntegerAttr StatelessWhileRegionOp::getParallelIterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getParallelIterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t StatelessWhileRegionOp::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr StatelessWhileRegionOp::getCondAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getCondAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatelessWhileRegionOp::getCondAttrs() {
  auto attr = getCondAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr StatelessWhileRegionOp::getBodyAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > StatelessWhileRegionOp::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOp::getCondRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getCondRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOp::getCondRegionAttrs() {
  auto attr = getCondRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr StatelessWhileRegionOp::getBodyRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> StatelessWhileRegionOp::getBodyRegionAttrs() {
  auto attr = getBodyRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

void StatelessWhileRegionOp::setParallelIterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getParallelIterationsAttrName(), attr);
}

void StatelessWhileRegionOp::setParallelIterations(uint64_t attrValue) {
  (*this)->setAttr(getParallelIterationsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void StatelessWhileRegionOp::setCondAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getCondAttrsAttrName(), attr);
}

void StatelessWhileRegionOp::setBodyAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getBodyAttrsAttrName(), attr);
}

void StatelessWhileRegionOp::setCondRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getCondRegionAttrsAttrName(), attr);
}

void StatelessWhileRegionOp::setBodyRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getBodyRegionAttrsAttrName(), attr);
}

::mlir::Attribute StatelessWhileRegionOp::removeCondAttrsAttr() {
  return (*this)->removeAttr(getCondAttrsAttrName());
}

::mlir::Attribute StatelessWhileRegionOp::removeBodyAttrsAttr() {
  return (*this)->removeAttr(getBodyAttrsAttrName());
}

::mlir::Attribute StatelessWhileRegionOp::removeCondRegionAttrsAttr() {
  return (*this)->removeAttr(getCondRegionAttrsAttrName());
}

::mlir::Attribute StatelessWhileRegionOp::removeBodyRegionAttrsAttr() {
  return (*this)->removeAttr(getBodyRegionAttrsAttrName());
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StatelessWhileRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult StatelessWhileRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == getOperandSegmentSizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getBodyAttrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getBodyRegionAttrsAttrName()) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getCondAttrsAttrName()) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getCondRegionAttrsAttrName()) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == getParallelIterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_cond_attrs, "cond_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_cond_region_attrs, "cond_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_body_region_attrs, "body_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "cond_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult StatelessWhileRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StatelessWhileRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> cond_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> initTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  if (parser.parseRegion(*cond_regionRegion))
    return ::mlir::failure();

  if (cond_regionRegion->empty()) cond_regionRegion->emplaceBlock();
  if (parser.parseKeyword("do"))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalColon())) {

  ::mlir::FunctionType init__outs_functionType;
  if (parser.parseType(init__outs_functionType))
    return ::mlir::failure();
  initTypes = init__outs_functionType.getInputs();
  outsTypes = init__outs_functionType.getResults();
  }
  result.addRegion(std::move(cond_regionRegion));
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getDenseI32ArrayAttr({static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void StatelessWhileRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!getInit().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getInit();
    _odsPrinter << ")";
  }
  if (!getCtls().empty()) {
    _odsPrinter << ' ' << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getCondRegion());
  _odsPrinter << ' ' << "do";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getBodyRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operand_segment_sizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  if (!getInit().empty()) {
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter.printFunctionalType(getInit().getTypes(), getOuts().getTypes());
  }
}

StringRef StatelessWhileRegionOp::getDefaultDialect() { return "tfg"; }
void StatelessWhileRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

ConditionOp StatelessWhileRegionOp::getCondCondition() {
  return cast<ConditionOp>(getCondBlock().getTerminator());
}
YieldOp StatelessWhileRegionOp::getBodyYield() {
  return cast<YieldOp>(getBodyBlock().getTerminator());
}

OperandRange StatelessWhileRegionOp::getSuccessorEntryOperands(
    std::optional<unsigned> index) {
  return getInit();
}
void StatelessWhileRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  return GetWhileLikeRegionOpSuccessorRegions(*this, index, operands,
                                              regions);
}

LogicalResult StatelessWhileRegionOp::verify() { return VerifyWhileLikeRegionOp(*this); }

BlockArgument StatelessWhileRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument StatelessWhileRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument StatelessWhileRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument StatelessWhileRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::StatelessWhileRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::WhileOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WhileOpGenericAdaptorBase::WhileOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.While", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> WhileOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr WhileOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::tf_type::FuncAttr WhileOpGenericAdaptorBase::getCondAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 1, WhileOp::getCondAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr WhileOpGenericAdaptorBase::getCond() {
  auto attr = getCondAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOpGenericAdaptorBase::getBodyAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileOp::getBodyAttrName(*odsOpName)).cast<::mlir::tf_type::FuncAttr>();
  return attr;
}

::mlir::tf_type::FuncAttr WhileOpGenericAdaptorBase::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr WhileOpGenericAdaptorBase::getParallelIterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 0, WhileOp::getParallelIterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t WhileOpGenericAdaptorBase::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr WhileOpGenericAdaptorBase::getTAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 3, WhileOp::getTAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > WhileOpGenericAdaptorBase::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr WhileOpGenericAdaptorBase::getOutputShapesAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 2, odsAttrs.end() - 1, WhileOp::getOutputShapesAttrName(*odsOpName)).dyn_cast_or_null<::mlir::ArrayAttr>();
  return attr;
}

::std::optional< ::mlir::ArrayAttr > WhileOpGenericAdaptorBase::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

} // namespace detail
WhileOpAdaptor::WhileOpAdaptor(WhileOp op) : WhileOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult WhileOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.While' op ""requires attribute 'body'");
    if (namedAttrIt->getName() == WhileOp::getBodyAttrName(*odsOpName)) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == WhileOp::getTAttrName(*odsOpName)) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.While' op ""requires attribute 'cond'");
    if (namedAttrIt->getName() == WhileOp::getCondAttrName(*odsOpName)) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.While' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == WhileOp::getParallelIterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == WhileOp::getOutputShapesAttrName(*odsOpName)) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (tblgen_cond && !((tblgen_cond.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.While' op ""attribute 'cond' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_body && !((tblgen_body.isa<::mlir::tf_type::FuncAttr>())))
    return emitError(loc, "'tfg.While' op ""attribute 'body' failed to satisfy constraint: Models the `AttrValue.value.func` proto attribute value as a pair of SymbolRef and DictionaryAttr");

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.While' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_T && !(((tblgen_T.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_T.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && (((attr.isa<::mlir::TypeAttr>())) && ((attr.cast<::mlir::TypeAttr>().getValue().isa<::mlir::Type>())) && ((true))); }))))
    return emitError(loc, "'tfg.While' op ""attribute 'T' failed to satisfy constraint: type array attribute");

  if (tblgen_output_shapes && !(((tblgen_output_shapes.isa<::mlir::ArrayAttr>())) && (::llvm::all_of(tblgen_output_shapes.cast<::mlir::ArrayAttr>(), [&](::mlir::Attribute attr) { return attr && ((attr.isa<::mlir::tf_type::ShapeAttr>())); }))))
    return emitError(loc, "'tfg.While' op ""attribute 'output_shapes' failed to satisfy constraint: An array of shapes.");
  return ::mlir::success();
}

void WhileOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "outs");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "ctl");
}

std::pair<unsigned, unsigned> WhileOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range WhileOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range WhileOp::getArgs() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange WhileOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> WhileOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range WhileOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range WhileOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> WhileOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::tf_type::FuncAttr WhileOp::getCondAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 1, getCondAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOp::getCond() {
  auto attr = getCondAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOp::getBodyAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyAttrName()).cast<::mlir::tf_type::FuncAttr>();
}

::mlir::tf_type::FuncAttr WhileOp::getBody() {
  auto attr = getBodyAttr();
  return attr.cast<::mlir::tf_type::FuncAttr>();
}

::mlir::IntegerAttr WhileOp::getParallelIterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 0, getParallelIterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t WhileOp::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::ArrayAttr WhileOp::getTAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 3, getTAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > WhileOp::getT() {
  auto attr = getTAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr WhileOp::getOutputShapesAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 2, (*this)->getAttrs().end() - 1, getOutputShapesAttrName()).dyn_cast_or_null<::mlir::ArrayAttr>();
}

::std::optional< ::mlir::ArrayAttr > WhileOp::getOutputShapes() {
  auto attr = getOutputShapesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void WhileOp::setCondAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getCondAttrName(), attr);
}

void WhileOp::setBodyAttr(::mlir::tf_type::FuncAttr attr) {
  (*this)->setAttr(getBodyAttrName(), attr);
}

void WhileOp::setParallelIterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getParallelIterationsAttrName(), attr);
}

void WhileOp::setParallelIterations(uint64_t attrValue) {
  (*this)->setAttr(getParallelIterationsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void WhileOp::setTAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getTAttrName(), attr);
}

void WhileOp::setOutputShapesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getOutputShapesAttrName(), attr);
}

::mlir::Attribute WhileOp::removeTAttr() {
  return (*this)->removeAttr(getTAttrName());
}

::mlir::Attribute WhileOp::removeOutputShapesAttr() {
  return (*this)->removeAttr(getOutputShapesAttrName());
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TypeRange results, ValueRange args, FuncAttr cond, FuncAttr body, IntegerAttr parallel_iterations) {
      build(odsBuilder, odsState, results, args, cond, body, parallel_iterations,
            /*T=*/{}, /*output_shapes=*/{});
    
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::tf_type::FuncAttr cond, ::mlir::tf_type::FuncAttr body, uint64_t parallel_iterations, /*optional*/::mlir::ArrayAttr T, /*optional*/::mlir::ArrayAttr output_shapes) {
  odsState.addOperands(args);
  odsState.addAttribute(getCondAttrName(odsState.name), cond);
  odsState.addAttribute(getBodyAttrName(odsState.name), body);
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (T) {
    odsState.addAttribute(getTAttrName(odsState.name), T);
  }
  if (output_shapes) {
    odsState.addAttribute(getOutputShapesAttrName(odsState.name), output_shapes);
  }
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult WhileOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_body;
  ::mlir::Attribute tblgen_T;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'body'");
    if (namedAttrIt->getName() == getBodyAttrName()) {
      tblgen_body = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getTAttrName()) {
      tblgen_T = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_cond;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'cond'");
    if (namedAttrIt->getName() == getCondAttrName()) {
      tblgen_cond = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  ::mlir::Attribute tblgen_output_shapes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == getParallelIterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getOutputShapesAttrName()) {
      tblgen_output_shapes = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_cond, "cond")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops5(*this, tblgen_body, "body")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops1(*this, tblgen_T, "T")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops2(*this, tblgen_output_shapes, "output_shapes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult WhileOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

LogicalResult WhileOp::verifySymbolUses(
    SymbolTableCollection &symbol_table) {
  return VerifyWhileLikeOp(*this, symbol_table);
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::WhileOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::WhileRegionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
WhileRegionOpGenericAdaptorBase::WhileRegionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.WhileRegion", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> WhileRegionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 1, WhileRegionOp::getOperandSegmentSizesAttrName(*odsOpName)).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr WhileRegionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr WhileRegionOpGenericAdaptorBase::getParallelIterationsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 1, odsAttrs.end() - 0, WhileRegionOp::getParallelIterationsAttrName(*odsOpName)).cast<::mlir::IntegerAttr>();
  return attr;
}

uint64_t WhileRegionOpGenericAdaptorBase::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr WhileRegionOpGenericAdaptorBase::getCondAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::getCondAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > WhileRegionOpGenericAdaptorBase::getCondAttrs() {
  auto attr = getCondAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr WhileRegionOpGenericAdaptorBase::getBodyAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::getBodyAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::DictionaryAttr>();
  return attr;
}

::std::optional< ::mlir::DictionaryAttr > WhileRegionOpGenericAdaptorBase::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr WhileRegionOpGenericAdaptorBase::getCondRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::getCondRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> WhileRegionOpGenericAdaptorBase::getCondRegionAttrs() {
  auto attr = getCondRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr WhileRegionOpGenericAdaptorBase::getBodyRegionAttrsAttr() {
  assert(odsAttrs && "no attributes when constructing adapter");
  auto attr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 2, WhileRegionOp::getBodyRegionAttrsAttrName(*odsOpName)).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
  return attr;
}

::std::optional<::mlir::tfg::RegionAttr> WhileRegionOpGenericAdaptorBase::getBodyRegionAttrs() {
  auto attr = getBodyRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::Region &WhileRegionOpGenericAdaptorBase::getCondRegion() {
  return *odsRegions[0];
}

::mlir::Region &WhileRegionOpGenericAdaptorBase::getBodyRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange WhileRegionOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
WhileRegionOpAdaptor::WhileRegionOpAdaptor(WhileRegionOp op) : WhileRegionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult WhileRegionOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.WhileRegion' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == WhileRegionOp::getOperandSegmentSizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == WhileRegionOp::getBodyAttrsAttrName(*odsOpName)) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == WhileRegionOp::getBodyRegionAttrsAttrName(*odsOpName)) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == WhileRegionOp::getCondAttrsAttrName(*odsOpName)) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == WhileRegionOp::getCondRegionAttrsAttrName(*odsOpName)) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.WhileRegion' op ""requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == WhileRegionOp::getParallelIterationsAttrName(*odsOpName)) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitError(loc, "'tfg.WhileRegion' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (tblgen_parallel_iterations && !(((tblgen_parallel_iterations.isa<::mlir::IntegerAttr>())) && ((tblgen_parallel_iterations.cast<::mlir::IntegerAttr>().getType().isSignlessInteger(64)))))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'parallel_iterations' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_cond_attrs && !((tblgen_cond_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'cond_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_body_attrs && !((tblgen_body_attrs.isa<::mlir::DictionaryAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'body_attrs' failed to satisfy constraint: dictionary of named attribute values");

  if (tblgen_cond_region_attrs && !((tblgen_cond_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'cond_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");

  if (tblgen_body_region_attrs && !((tblgen_body_region_attrs.isa<::mlir::tfg::RegionAttr>())))
    return emitError(loc, "'tfg.WhileRegion' op ""attribute 'body_region_attrs' failed to satisfy constraint: Region attributes, argument and result attributes.");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> WhileRegionOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName()).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range WhileRegionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range WhileRegionOp::getInit() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range WhileRegionOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange WhileRegionOp::getInitMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange WhileRegionOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 1, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> WhileRegionOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true, false};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range WhileRegionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range WhileRegionOp::getOuts() {
  return getODSResults(0);
}

::mlir::TypedValue<::mlir::tf_type::ControlType> WhileRegionOp::getCtl() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::tf_type::ControlType>>(*getODSResults(1).begin());
}

::mlir::Region &WhileRegionOp::getCondRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &WhileRegionOp::getBodyRegion() {
  return (*this)->getRegion(1);
}

::mlir::IntegerAttr WhileRegionOp::getParallelIterationsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 1, (*this)->getAttrs().end() - 0, getParallelIterationsAttrName()).cast<::mlir::IntegerAttr>();
}

uint64_t WhileRegionOp::getParallelIterations() {
  auto attr = getParallelIterationsAttr();
  return attr.getValue().getZExtValue();
}

::mlir::DictionaryAttr WhileRegionOp::getCondAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getCondAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > WhileRegionOp::getCondAttrs() {
  auto attr = getCondAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::DictionaryAttr WhileRegionOp::getBodyAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyAttrsAttrName()).dyn_cast_or_null<::mlir::DictionaryAttr>();
}

::std::optional< ::mlir::DictionaryAttr > WhileRegionOp::getBodyAttrs() {
  auto attr = getBodyAttrsAttr();
  return attr ? ::std::optional< ::mlir::DictionaryAttr >(attr) : (::std::nullopt);
}

::mlir::tfg::RegionAttr WhileRegionOp::getCondRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getCondRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> WhileRegionOp::getCondRegionAttrs() {
  auto attr = getCondRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

::mlir::tfg::RegionAttr WhileRegionOp::getBodyRegionAttrsAttr() {
  return ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 2, getBodyRegionAttrsAttrName()).dyn_cast_or_null<::mlir::tfg::RegionAttr>();
}

::std::optional<::mlir::tfg::RegionAttr> WhileRegionOp::getBodyRegionAttrs() {
  auto attr = getBodyRegionAttrsAttr();
  return attr ? ::std::optional<::mlir::tfg::RegionAttr>(attr.cast<::mlir::tfg::RegionAttr>()) : (::std::nullopt);
}

void WhileRegionOp::setParallelIterationsAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getParallelIterationsAttrName(), attr);
}

void WhileRegionOp::setParallelIterations(uint64_t attrValue) {
  (*this)->setAttr(getParallelIterationsAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue));
}

void WhileRegionOp::setCondAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getCondAttrsAttrName(), attr);
}

void WhileRegionOp::setBodyAttrsAttr(::mlir::DictionaryAttr attr) {
  (*this)->setAttr(getBodyAttrsAttrName(), attr);
}

void WhileRegionOp::setCondRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getCondRegionAttrsAttrName(), attr);
}

void WhileRegionOp::setBodyRegionAttrsAttr(::mlir::tfg::RegionAttr attr) {
  (*this)->setAttr(getBodyRegionAttrsAttrName(), attr);
}

::mlir::Attribute WhileRegionOp::removeCondAttrsAttr() {
  return (*this)->removeAttr(getCondAttrsAttrName());
}

::mlir::Attribute WhileRegionOp::removeBodyAttrsAttr() {
  return (*this)->removeAttr(getBodyAttrsAttrName());
}

::mlir::Attribute WhileRegionOp::removeCondRegionAttrsAttr() {
  return (*this)->removeAttr(getCondRegionAttrsAttrName());
}

::mlir::Attribute WhileRegionOp::removeBodyRegionAttrsAttr() {
  return (*this)->removeAttr(getBodyRegionAttrsAttrName());
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, ::mlir::IntegerAttr parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), parallel_iterations);
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange outs, ::mlir::Type ctl, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  odsState.addTypes(outs);
  odsState.addTypes(ctl);
}

void WhileRegionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange init, ::mlir::ValueRange ctls, uint64_t parallel_iterations, /*optional*/::mlir::DictionaryAttr cond_attrs, /*optional*/::mlir::DictionaryAttr body_attrs, /*optional*/::mlir::tfg::RegionAttr cond_region_attrs, /*optional*/::mlir::tfg::RegionAttr body_region_attrs) {
  odsState.addOperands(init);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(init.size()), static_cast<int32_t>(ctls.size())}));
  odsState.addAttribute(getParallelIterationsAttrName(odsState.name), odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), parallel_iterations));
  if (cond_attrs) {
    odsState.addAttribute(getCondAttrsAttrName(odsState.name), cond_attrs);
  }
  if (body_attrs) {
    odsState.addAttribute(getBodyAttrsAttrName(odsState.name), body_attrs);
  }
  if (cond_region_attrs) {
    odsState.addAttribute(getCondRegionAttrsAttrName(odsState.name), cond_region_attrs);
  }
  if (body_region_attrs) {
    odsState.addAttribute(getBodyRegionAttrsAttrName(odsState.name), body_region_attrs);
  }
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void WhileRegionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() >= 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult WhileRegionOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  ::mlir::Attribute tblgen_body_attrs;
  ::mlir::Attribute tblgen_body_region_attrs;
  ::mlir::Attribute tblgen_cond_attrs;
  ::mlir::Attribute tblgen_cond_region_attrs;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == getOperandSegmentSizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    else if (namedAttrIt->getName() == getBodyAttrsAttrName()) {
      tblgen_body_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getBodyRegionAttrsAttrName()) {
      tblgen_body_region_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getCondAttrsAttrName()) {
      tblgen_cond_attrs = namedAttrIt->getValue();
    }
    else if (namedAttrIt->getName() == getCondRegionAttrsAttrName()) {
      tblgen_cond_region_attrs = namedAttrIt->getValue();
    }
    ++namedAttrIt;
  }
  ::mlir::Attribute tblgen_parallel_iterations;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'parallel_iterations'");
    if (namedAttrIt->getName() == getParallelIterationsAttrName()) {
      tblgen_parallel_iterations = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops18(*this, tblgen_parallel_iterations, "parallel_iterations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_cond_attrs, "cond_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops6(*this, tblgen_body_attrs, "body_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_cond_region_attrs, "cond_region_attrs")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ops7(*this, tblgen_body_region_attrs, "body_region_attrs")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "cond_region", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_ops0(*this, region, "body_region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult WhileRegionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult WhileRegionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> initOperands;
  ::llvm::SMLoc initOperandsLoc;
  (void)initOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  std::unique_ptr<::mlir::Region> cond_regionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> body_regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> initTypes;
  ::llvm::ArrayRef<::mlir::Type> outsTypes;
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  initOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(initOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }

  if (parser.parseRegion(*cond_regionRegion))
    return ::mlir::failure();

  if (cond_regionRegion->empty()) cond_regionRegion->emplaceBlock();
  if (parser.parseKeyword("do"))
    return ::mlir::failure();

  if (parser.parseRegion(*body_regionRegion))
    return ::mlir::failure();

  if (body_regionRegion->empty()) body_regionRegion->emplaceBlock();
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalColon())) {

  ::mlir::FunctionType init__outs_functionType;
  if (parser.parseType(init__outs_functionType))
    return ::mlir::failure();
  initTypes = init__outs_functionType.getInputs();
  outsTypes = init__outs_functionType.getResults();
  }
  result.addRegion(std::move(cond_regionRegion));
  result.addRegion(std::move(body_regionRegion));
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getDenseI32ArrayAttr({static_cast<int32_t>(initOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  result.addTypes(outsTypes);
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(initOperands, initTypes, initOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void WhileRegionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!getInit().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getInit();
    _odsPrinter << ")";
  }
  if (!getCtls().empty()) {
    _odsPrinter << ' ' << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getCondRegion());
  _odsPrinter << ' ' << "do";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getBodyRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operand_segment_sizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  if (!getInit().empty()) {
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter.printFunctionalType(getInit().getTypes(), getOuts().getTypes());
  }
}

StringRef WhileRegionOp::getDefaultDialect() { return "tfg"; }
void WhileRegionOp::getAsmResultNames(OpAsmSetValueNameFn setNameFn) {
  GenericGetAsmResultNames(*this, setNameFn);
}

ConditionOp WhileRegionOp::getCondCondition() {
  return cast<ConditionOp>(getCondBlock().getTerminator());
}
YieldOp WhileRegionOp::getBodyYield() {
  return cast<YieldOp>(getBodyBlock().getTerminator());
}

OperandRange WhileRegionOp::getSuccessorEntryOperands(
    std::optional<unsigned> index) {
  return getInit();
}
void WhileRegionOp::getSuccessorRegions(
    std::optional<unsigned> index, ArrayRef<Attribute> operands,
    SmallVectorImpl<RegionSuccessor> &regions) {
  return GetWhileLikeRegionOpSuccessorRegions(*this, index, operands,
                                              regions);
}

LogicalResult WhileRegionOp::verify() { return VerifyWhileLikeRegionOp(*this); }

BlockArgument WhileRegionOp::getDataValueOf(BlockArgument ctl) {
  return GetLoopRegionDataOf(ctl);
}
BlockArgument WhileRegionOp::getControlTokenOf(BlockArgument data) {
  return GetLoopRegionControlOf(data);
}
BlockArgument WhileRegionOp::getDataValue(Region &region, unsigned idx) {
  return GetLoopRegionDataArgs(region)[idx];
}
BlockArgument WhileRegionOp::getControlToken(Region &region, unsigned idx) {
  return GetLoopRegionControlTokens(region)[idx];
}
} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::WhileRegionOp)

namespace mlir {
namespace tfg {

//===----------------------------------------------------------------------===//
// ::mlir::tfg::YieldOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
YieldOpGenericAdaptorBase::YieldOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("tfg.yield", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> YieldOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  assert(odsAttrs && "missing segment size attribute for op");
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange(odsAttrs.begin() + 0, odsAttrs.end() - 0, YieldOp::getOperandSegmentSizesAttrName(*odsOpName)).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr YieldOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
YieldOpAdaptor::YieldOpAdaptor(YieldOp op) : YieldOpAdaptor(op->getOperands(), op->getAttrDictionary(), op->getRegions()) {}

::mlir::LogicalResult YieldOpAdaptor::verify(::mlir::Location loc) {
  auto namedAttrRange = odsAttrs;
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitError(loc, "'tfg.yield' op ""requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == YieldOp::getOperandSegmentSizesAttrName(*odsOpName)) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitError(loc, "'tfg.yield' op ""'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }
    return ::mlir::success();
}

std::pair<unsigned, unsigned> YieldOp::getODSOperandIndexAndLength(unsigned index) {
  auto sizeAttr = ::mlir::impl::getAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName()).cast<::mlir::DenseI32ArrayAttr>();

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range YieldOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range YieldOp::getArgs() {
  return getODSOperands(0);
}

::mlir::Operation::operand_range YieldOp::getCtls() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange YieldOp::getArgsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

::mlir::MutableOperandRange YieldOp::getCtlsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, *::mlir::impl::getNamedAttrFromSortedRange((*this)->getAttrs().begin() + 0, (*this)->getAttrs().end() - 0, getOperandSegmentSizesAttrName())));
  return mutableRange;
}

std::pair<unsigned, unsigned> YieldOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range YieldOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void YieldOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
}

void YieldOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange args, ::mlir::ValueRange ctls) {
  odsState.addOperands(args);
  odsState.addOperands(ctls);
  odsState.addAttribute(getOperandSegmentSizesAttrName(odsState.name), odsBuilder.getDenseI32ArrayAttr({static_cast<int32_t>(args.size()), static_cast<int32_t>(ctls.size())}));
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void YieldOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult YieldOp::verifyInvariantsImpl() {
  auto namedAttrRange = (*this)->getAttrs();
  auto namedAttrIt = namedAttrRange.begin();
  ::mlir::Attribute tblgen_operand_segment_sizes;
  while (true) {
    if (namedAttrIt == namedAttrRange.end())
      return emitOpError("requires attribute 'operand_segment_sizes'");
    if (namedAttrIt->getName() == getOperandSegmentSizesAttrName()) {
      tblgen_operand_segment_sizes = namedAttrIt->getValue();
      break;
    }
    ++namedAttrIt;
  }

  {
    auto sizeAttr = tblgen_operand_segment_sizes.cast<::mlir::DenseI32ArrayAttr>();
    auto numElements = sizeAttr.asArrayRef().size();
    if (numElements != 2)
      return emitOpError("'operand_segment_sizes' attribute for specifying operand segments must have 2 "
                "elements, but got ") << numElements;
  }
    {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ops3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult YieldOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult YieldOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> argsOperands;
  ::llvm::SMLoc argsOperandsLoc;
  (void)argsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ctlsOperands;
  ::llvm::SMLoc ctlsOperandsLoc;
  (void)ctlsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> argsTypes;
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  argsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(argsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalLSquare())) {

  ctlsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(ctlsOperands))
    return ::mlir::failure();
  if (parser.parseRSquare())
    return ::mlir::failure();
  }
  if (parser.parseOptionalAttrDict(result.attributes))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalColon())) {

  if (parser.parseTypeList(argsTypes))
    return ::mlir::failure();
  }
  result.addAttribute("operand_segment_sizes", parser.getBuilder().getDenseI32ArrayAttr({static_cast<int32_t>(argsOperands.size()), static_cast<int32_t>(ctlsOperands.size())}));
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::tf_type::ControlType>();
  if (parser.resolveOperands(argsOperands, argsTypes, argsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ctlsOperands, odsBuildableType0, ctlsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void YieldOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (!getArgs().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getArgs();
    _odsPrinter << ")";
  }
  if (!getCtls().empty()) {
    _odsPrinter << ' ' << "[";
    _odsPrinter << getCtls();
    _odsPrinter << "]";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operand_segment_sizes");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  if (!getArgs().empty()) {
    _odsPrinter << ' ' << ":";
    _odsPrinter << ' ';
    _odsPrinter << getArgs().getTypes();
  }
}

void YieldOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace tfg
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::tfg::YieldOp)


#endif  // GET_OP_CLASSES

