/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.logging.log4j.core.util.StringBuilderWriter;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int EOF = -1;

    public static int copy(Reader input, Writer output) throws IOException {
        long count2 = IOUtils.copyLarge(input, output);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        return IOUtils.copyLarge(input, output, new char[4096]);
    }

    public static long copyLarge(Reader input, Writer output, char[] buffer) throws IOException {
        int n;
        long count2 = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static String toString(Reader input) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtils.copy(input, sw);
        return sw.toString();
    }
}

