/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.host;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TreeSet;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.manager.Constants;
import org.apache.catalina.manager.host.HostManagerServlet;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public final class HTMLHostManagerServlet
extends HostManagerServlet {
    private static final long serialVersionUID = 1L;
    private static final String HOSTS_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"5\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-left\"><small>{0}</small></td>\n <td class=\"header-center\"><small>{1}</small></td>\n <td class=\"header-center\"><small>{2}</small></td>\n</tr>\n";
    private static final String HOSTS_ROW_DETAILS_SECTION = "<tr>\n <td class=\"row-left\"><small><a href=\"http://{0}\" rel=\"noopener noreferrer\">{0}</a></small></td>\n <td class=\"row-center\"><small>{1}</small></td>\n";
    private static final String MANAGER_HOST_ROW_BUTTON_SECTION = " <td class=\"row-left\">\n  <small>{4}</small>\n </td>\n</tr>\n";
    private static final String HOSTS_ROW_BUTTON_SECTION = " <td class=\"row-left\" NOWRAP>\n  <form class=\"inline\" method=\"POST\" action=\"{0}\">   <small><input type=\"submit\" value=\"{1}\"></small>  </form>\n  <form class=\"inline\" method=\"POST\" action=\"{2}\">   <small><input type=\"submit\" value=\"{3}\"></small>  </form>\n </td>\n</tr>\n";
    private static final String ADD_SECTION_START = "</table>\n<br>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"post\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"name\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{4}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"aliases\" size=\"64\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{5}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"appBase\" size=\"64\">\n </td>\n</tr>\n";
    private static final String ADD_SECTION_BOOLEAN = "<tr>\n <td class=\"row-right\">\n  <small>{0}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"checkbox\" name=\"{1}\" {2}>\n </td>\n</tr>\n";
    private static final String ADD_SECTION_END = "<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{0}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n<br>\n\n";
    private static final String PERSIST_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"row-left\">\n  <form class=\"inline\" method=\"POST\" action=\"{1}\">   <small><input type=\"submit\" value=\"{2}\"></small>  </form> {3}\n </td>\n</tr>\n</table>\n<br>\n\n";

    @Override
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager.host", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        httpServletResponse.setContentType("text/html; charset=utf-8");
        String string2 = "";
        if (string != null && !string.equals("/list")) {
            string2 = string.equals("/add") || string.equals("/remove") || string.equals("/start") || string.equals("/stop") || string.equals("/persist") ? stringManager.getString("hostManagerServlet.postCommand", new Object[]{string}) : stringManager.getString("hostManagerServlet.unknownCommand", new Object[]{string});
        }
        this.list(httpServletRequest, httpServletResponse, string2, stringManager);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        StringManager stringManager = StringManager.getManager((String)"org.apache.catalina.manager.host", (Enumeration)httpServletRequest.getLocales());
        String string = httpServletRequest.getPathInfo();
        String string2 = httpServletRequest.getParameter("name");
        httpServletResponse.setContentType("text/html; charset=utf-8");
        String string3 = "";
        if (string != null) {
            if (string.equals("/add")) {
                string3 = this.add(httpServletRequest, string2, stringManager);
            } else if (string.equals("/remove")) {
                string3 = this.remove(string2, stringManager);
            } else if (string.equals("/start")) {
                string3 = this.start(string2, stringManager);
            } else if (string.equals("/stop")) {
                string3 = this.stop(string2, stringManager);
            } else if (string.equals("/persist")) {
                string3 = this.persist(stringManager);
            } else {
                this.doGet(httpServletRequest, httpServletResponse);
            }
        }
        this.list(httpServletRequest, httpServletResponse, string3, stringManager);
    }

    protected String add(HttpServletRequest httpServletRequest, String string, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.add(httpServletRequest, printWriter, string, true, stringManager);
        return stringWriter.toString();
    }

    protected String remove(String string, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.remove(printWriter, string, stringManager);
        return stringWriter.toString();
    }

    protected String start(String string, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, string, stringManager);
        return stringWriter.toString();
    }

    protected String stop(String string, StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, string, stringManager);
        return stringWriter.toString();
    }

    protected String persist(StringManager stringManager) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.persist(printWriter, stringManager);
        return stringWriter.toString();
    }

    public void list(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, StringManager stringManager) throws IOException {
        if (this.debug >= 1) {
            this.log(sm.getString("hostManagerServlet.list", new Object[]{this.engine.getName()}));
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        Object[] objectArray = new Object[]{this.getServletContext().getContextPath(), stringManager.getString("htmlHostManagerServlet.title")};
        printWriter.print(MessageFormat.format(Constants.HTML_HEADER_SECTION, objectArray));
        printWriter.print(MessageFormat.format(Constants.BODY_HEADER_SECTION, objectArray));
        objectArray = new Object[3];
        objectArray[0] = stringManager.getString("htmlHostManagerServlet.messageLabel");
        objectArray[1] = string == null || string.length() == 0 ? "OK" : Escape.htmlElementContent((String)string);
        printWriter.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n <tr>\n  <td class=\"row-left\" width=\"10%\"><small><strong>{0}</strong></small>&nbsp;</td>\n  <td class=\"row-left\"><pre>{1}</pre></td>\n </tr>\n</table>\n<br>\n\n", objectArray));
        objectArray = new Object[]{stringManager.getString("htmlHostManagerServlet.manager"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/list"), stringManager.getString("htmlHostManagerServlet.list"), this.getServletContext().getContextPath() + "/" + stringManager.getString("htmlHostManagerServlet.helpHtmlManagerFile"), stringManager.getString("htmlHostManagerServlet.helpHtmlManager"), this.getServletContext().getContextPath() + "/" + stringManager.getString("htmlHostManagerServlet.helpManagerFile"), stringManager.getString("htmlHostManagerServlet.helpManager"), httpServletResponse.encodeURL("/manager/status"), stringManager.getString("statusServlet.title")};
        printWriter.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"4\" class=\"title\">{0}</td>\n</tr>\n <tr>\n  <td class=\"row-left\"><a href=\"{1}\">{2}</a></td>\n  <td class=\"row-center\"><a href=\"{3}\" rel=\"noopener noreferrer\">{4}</a></td>\n  <td class=\"row-center\"><a href=\"{5}\" rel=\"noopener noreferrer\">{6}</a></td>\n  <td class=\"row-right\"><a href=\"{7}\">{8}</a></td>\n </tr>\n</table>\n<br>\n\n", objectArray));
        objectArray = new Object[]{stringManager.getString("htmlHostManagerServlet.hostName"), stringManager.getString("htmlHostManagerServlet.hostAliases"), stringManager.getString("htmlHostManagerServlet.hostTasks")};
        printWriter.print(MessageFormat.format(HOSTS_HEADER_SECTION, objectArray));
        Container[] containerArray = this.engine.findChildren();
        String[] stringArray = new String[containerArray.length];
        for (int i = 0; i < containerArray.length; ++i) {
            stringArray[i] = containerArray[i].getName();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(Arrays.asList(stringArray));
        String string2 = stringManager.getString("htmlHostManagerServlet.hostsStart");
        String string3 = stringManager.getString("htmlHostManagerServlet.hostsStop");
        String string4 = stringManager.getString("htmlHostManagerServlet.hostsRemove");
        String string5 = stringManager.getString("htmlHostManagerServlet.hostThis");
        for (String string6 : treeSet) {
            Host host = (Host)this.engine.findChild(string6);
            if (host == null) continue;
            objectArray = new Object[2];
            objectArray[0] = Escape.htmlElementContent((String)string6);
            String[] stringArray2 = host.findAliases();
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray2.length > 0) {
                stringBuilder.append(stringArray2[0]);
                for (int i = 1; i < stringArray2.length; ++i) {
                    stringBuilder.append(", ").append(stringArray2[i]);
                }
            }
            if (stringBuilder.length() == 0) {
                stringBuilder.append("&nbsp;");
                objectArray[1] = stringBuilder.toString();
            } else {
                objectArray[1] = Escape.htmlElementContent((String)stringBuilder.toString());
            }
            printWriter.print(MessageFormat.format(HOSTS_ROW_DETAILS_SECTION, objectArray));
            objectArray = new Object[5];
            if (host.getState().isAvailable()) {
                objectArray[0] = httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/stop?name=" + URLEncoder.encode(string6, "UTF-8"));
                objectArray[1] = string3;
            } else {
                objectArray[0] = httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/start?name=" + URLEncoder.encode(string6, "UTF-8"));
                objectArray[1] = string2;
            }
            objectArray[2] = httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/remove?name=" + URLEncoder.encode(string6, "UTF-8"));
            objectArray[3] = string4;
            objectArray[4] = string5;
            if (host == this.installedHost) {
                printWriter.print(MessageFormat.format(MANAGER_HOST_ROW_BUTTON_SECTION, objectArray));
                continue;
            }
            printWriter.print(MessageFormat.format(HOSTS_ROW_BUTTON_SECTION, objectArray));
        }
        objectArray = new Object[]{stringManager.getString("htmlHostManagerServlet.addTitle"), stringManager.getString("htmlHostManagerServlet.addHost"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/add"), stringManager.getString("htmlHostManagerServlet.addName"), stringManager.getString("htmlHostManagerServlet.addAliases"), stringManager.getString("htmlHostManagerServlet.addAppBase")};
        printWriter.print(MessageFormat.format(ADD_SECTION_START, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlHostManagerServlet.addAutoDeploy"), "autoDeploy", "checked"};
        printWriter.print(MessageFormat.format(ADD_SECTION_BOOLEAN, objectArray));
        objectArray[0] = stringManager.getString("htmlHostManagerServlet.addDeployOnStartup");
        objectArray[1] = "deployOnStartup";
        objectArray[2] = "checked";
        printWriter.print(MessageFormat.format(ADD_SECTION_BOOLEAN, objectArray));
        objectArray[0] = stringManager.getString("htmlHostManagerServlet.addDeployXML");
        objectArray[1] = "deployXML";
        objectArray[2] = "checked";
        printWriter.print(MessageFormat.format(ADD_SECTION_BOOLEAN, objectArray));
        objectArray[0] = stringManager.getString("htmlHostManagerServlet.addUnpackWARs");
        objectArray[1] = "unpackWARs";
        objectArray[2] = "checked";
        printWriter.print(MessageFormat.format(ADD_SECTION_BOOLEAN, objectArray));
        objectArray[0] = stringManager.getString("htmlHostManagerServlet.addManager");
        objectArray[1] = "manager";
        objectArray[2] = "checked";
        printWriter.print(MessageFormat.format(ADD_SECTION_BOOLEAN, objectArray));
        objectArray[0] = stringManager.getString("htmlHostManagerServlet.addCopyXML");
        objectArray[1] = "copyXML";
        objectArray[2] = "";
        printWriter.print(MessageFormat.format(ADD_SECTION_BOOLEAN, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlHostManagerServlet.addButton")};
        printWriter.print(MessageFormat.format(ADD_SECTION_END, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlHostManagerServlet.persistTitle"), httpServletResponse.encodeURL(this.getServletContext().getContextPath() + "/html/persist"), stringManager.getString("htmlHostManagerServlet.persistAllButton"), stringManager.getString("htmlHostManagerServlet.persistAll")};
        printWriter.print(MessageFormat.format(PERSIST_SECTION, objectArray));
        objectArray = new Object[]{stringManager.getString("htmlHostManagerServlet.serverTitle"), stringManager.getString("htmlHostManagerServlet.serverVersion"), stringManager.getString("htmlHostManagerServlet.serverJVMVersion"), stringManager.getString("htmlHostManagerServlet.serverJVMVendor"), stringManager.getString("htmlHostManagerServlet.serverOSName"), stringManager.getString("htmlHostManagerServlet.serverOSVersion"), stringManager.getString("htmlHostManagerServlet.serverOSArch")};
        printWriter.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"6\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-center\"><small>{1}</small></td>\n <td class=\"header-center\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-center\"><small>{5}</small></td>\n <td class=\"header-center\"><small>{6}</small></td>\n</tr>\n", objectArray));
        objectArray = new Object[]{ServerInfo.getServerInfo(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        printWriter.print(MessageFormat.format("<tr>\n <td class=\"row-center\"><small>{0}</small></td>\n <td class=\"row-center\"><small>{1}</small></td>\n <td class=\"row-center\"><small>{2}</small></td>\n <td class=\"row-center\"><small>{3}</small></td>\n <td class=\"row-center\"><small>{4}</small></td>\n <td class=\"row-center\"><small>{5}</small></td>\n</tr>\n</table>\n<br>\n\n", objectArray));
        printWriter.print("<hr size=\"1\" noshade=\"noshade\">\n<center><font size=\"-1\" color=\"#525D76\">\n <em>Copyright &copy; 1999-2023, Apache Software Foundation</em></font></center>\n\n</body>\n</html>");
        printWriter.flush();
        printWriter.close();
    }
}

