/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.CredentialHandler;
import org.apache.catalina.Engine;
import org.apache.catalina.GSSRealm;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.DigestCredentialHandlerBase;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MessageDigestCredentialHandler;
import org.apache.catalina.realm.SecretKeyCredentialHandler;
import org.apache.catalina.realm.X509SubjectDnRetriever;
import org.apache.catalina.realm.X509UsernameRetriever;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.SessionConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public abstract class RealmBase
extends LifecycleMBeanBase
implements GSSRealm {
    private static final Log log = LogFactory.getLog(RealmBase.class);
    protected static final String USER_ATTRIBUTES_DELIMITER = ",";
    protected static final String USER_ATTRIBUTES_WILDCARD = "*";
    private static final List<Class<? extends DigestCredentialHandlerBase>> credentialHandlerClasses = new ArrayList<Class<? extends DigestCredentialHandlerBase>>();
    protected Container container = null;
    protected Log containerLog = null;
    private CredentialHandler credentialHandler;
    protected static final StringManager sm;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected String x509UsernameRetrieverClassName;
    protected X509UsernameRetriever x509UsernameRetriever;
    protected AllRolesMode allRolesMode = AllRolesMode.STRICT_MODE;
    protected boolean stripRealmForGss = true;
    private int transportGuaranteeRedirectStatus = 302;
    protected String userAttributes = null;
    protected List<String> userAttributesList = null;
    protected String realmPath = "/realm0";

    public int getTransportGuaranteeRedirectStatus() {
        return this.transportGuaranteeRedirectStatus;
    }

    public void setTransportGuaranteeRedirectStatus(int n) {
        this.transportGuaranteeRedirectStatus = n;
    }

    @Override
    public CredentialHandler getCredentialHandler() {
        return this.credentialHandler;
    }

    @Override
    public void setCredentialHandler(CredentialHandler credentialHandler) {
        this.credentialHandler = credentialHandler;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public String getAllRolesMode() {
        return this.allRolesMode.toString();
    }

    public void setAllRolesMode(String string) {
        this.allRolesMode = AllRolesMode.toMode(string);
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public String getX509UsernameRetrieverClassName() {
        return this.x509UsernameRetrieverClassName;
    }

    public void setX509UsernameRetrieverClassName(String string) {
        this.x509UsernameRetrieverClassName = string;
    }

    public boolean isStripRealmForGss() {
        return this.stripRealmForGss;
    }

    public void setStripRealmForGss(boolean bl) {
        this.stripRealmForGss = bl;
    }

    public String getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(String string) {
        this.userAttributes = string;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Principal authenticate(String string) {
        if (string == null) {
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", new Object[]{string}));
        }
        return this.getPrincipal(string);
    }

    @Override
    public Principal authenticate(String string, String string2) {
        if (string == null || string2 == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        String string3 = this.getPassword(string);
        if (string3 == null) {
            this.getCredentialHandler().mutate(string2);
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        boolean bl = this.getCredentialHandler().matches(string2, string3);
        if (bl) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", new Object[]{string}));
            }
            return this.getPrincipal(string);
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{string}));
        }
        return null;
    }

    @Override
    @Deprecated
    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return this.authenticate(string, string2, string3, string4, string5, string6, string7, string8, "MD5");
    }

    @Override
    public Principal authenticate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        String string10 = this.getDigest(string, string7, string9);
        if (string10 == null) {
            return null;
        }
        string10 = string10.toLowerCase(Locale.ENGLISH);
        String string11 = string6 == null ? string10 + ":" + string3 + ":" + string8 : string10 + ":" + string3 + ":" + string4 + ":" + string5 + ":" + string6 + ":" + string8;
        byte[] byArray = null;
        try {
            byArray = string11.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        String string12 = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)string9, (byte[][])new byte[][]{byArray}));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest : " + string2 + " Username:" + string + " ClientDigest:" + string2 + " nonce:" + string3 + " nc:" + string4 + " cnonce:" + string5 + " qop:" + string6 + " realm:" + string7 + "digestA2:" + string8 + " Server digest:" + string12));
        }
        if (string12.equals(string2)) {
            return this.getPrincipal(string);
        }
        return null;
    }

    @Override
    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticating client certificate chain");
        }
        if (this.validate) {
            for (X509Certificate x509Certificate : x509CertificateArray) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking validity for '" + x509Certificate.getSubjectX500Principal().toString() + "'"));
                }
                try {
                    x509Certificate.checkValidity();
                }
                catch (Exception exception) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Validity exception", (Throwable)exception);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(x509CertificateArray[0]);
    }

    @Override
    public Principal authenticate(GSSContext gSSContext, boolean bl) {
        if (gSSContext.isEstablished()) {
            GSSName gSSName = null;
            try {
                gSSName = gSSContext.getSrcName();
            }
            catch (GSSException gSSException) {
                log.warn((Object)sm.getString("realmBase.gssNameFail"), (Throwable)gSSException);
            }
            if (gSSName != null) {
                GSSCredential gSSCredential = null;
                if (bl) {
                    if (gSSContext.getCredDelegState()) {
                        try {
                            gSSCredential = gSSContext.getDelegCred();
                        }
                        catch (GSSException gSSException) {
                            log.warn((Object)sm.getString("realmBase.delegatedCredentialFail", new Object[]{gSSName}), (Throwable)gSSException);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("realmBase.credentialNotDelegated", new Object[]{gSSName}));
                    }
                }
                return this.getPrincipal(gSSName, gSSCredential);
            }
        } else {
            log.error((Object)sm.getString("realmBase.gssContextNotEstablished"));
        }
        return null;
    }

    @Override
    public Principal authenticate(GSSName gSSName, GSSCredential gSSCredential) {
        if (gSSName == null) {
            return null;
        }
        return this.getPrincipal(gSSName, gSSCredential);
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        int n;
        SecurityCollection[] securityCollectionArray;
        int n2;
        ArrayList<SecurityConstraint> arrayList = null;
        SecurityConstraint[] securityConstraintArray = context.findConstraints();
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable constraints defined");
            }
            return null;
        }
        String string = request.getRequestPathMB().toString();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        String string2 = request.getMethod();
        boolean bl = false;
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            SecurityCollection[] securityCollectionArray2 = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray2 == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            for (SecurityCollection securityCollection : securityCollectionArray2) {
                String[] stringArray3 = securityCollection.findPatterns();
                if (stringArray3 == null) continue;
                for (String string3 : stringArray3) {
                    if (!string.equals(string3) && (string3.length() != 0 || !string.equals("/"))) continue;
                    bl = true;
                    if (!securityCollection.findMethod(string2)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(securityConstraintArray[n2]);
                }
            }
        }
        if (bl) {
            return this.resultsToArray(arrayList);
        }
        int n3 = -1;
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            securityCollectionArray = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            for (SecurityCollection securityCollection : securityCollectionArray) {
                String[] stringArray = securityCollection.findPatterns();
                if (stringArray == null) continue;
                int n4 = 0;
                n = -1;
                String[] stringArray2 = stringArray;
                int n5 = stringArray2.length;
                for (int i = 0; i < n5; ++i) {
                    String string4 = stringArray2[i];
                    if (!string4.startsWith("/") || !string4.endsWith("/*") || string4.length() < n3) continue;
                    if (string4.length() == 2) {
                        n4 = 1;
                        n = string4.length();
                        continue;
                    }
                    if (!string4.regionMatches(0, string, 0, string4.length() - 1) && (string4.length() - 2 != string.length() || !string4.regionMatches(0, string, 0, string4.length() - 2))) continue;
                    n4 = 1;
                    n = string4.length();
                }
                if (n4 == 0) continue;
                if (n > n3) {
                    bl = false;
                    if (arrayList != null) {
                        arrayList.clear();
                    }
                    n3 = n;
                }
                if (!securityCollection.findMethod(string2)) continue;
                bl = true;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(securityConstraintArray[n2]);
            }
        }
        if (bl) {
            return this.resultsToArray(arrayList);
        }
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            securityCollectionArray = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            boolean bl2 = false;
            int n6 = -1;
            for (int i = 0; i < securityCollectionArray.length; ++i) {
                String[] stringArray = securityCollectionArray[i].findPatterns();
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length && !bl2; ++j) {
                    String string5 = stringArray[j];
                    if (!string5.startsWith("*.")) continue;
                    n = string.lastIndexOf(47);
                    int n7 = string.lastIndexOf(46);
                    if (n < 0 || n7 <= n || n7 == string.length() - 1 || string.length() - n7 != string5.length() - 1 || !string5.regionMatches(1, string, n7, string.length() - n7)) continue;
                    bl2 = true;
                    n6 = i;
                }
            }
            if (!bl2) continue;
            bl = true;
            if (!securityCollectionArray[n6].findMethod(string2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<SecurityConstraint>();
            }
            arrayList.add(securityConstraintArray[n2]);
        }
        if (bl) {
            return this.resultsToArray(arrayList);
        }
        for (n2 = 0; n2 < securityConstraintArray.length; ++n2) {
            securityCollectionArray = securityConstraintArray[n2].findCollections();
            if (securityCollectionArray == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + securityConstraintArray[n2] + "' against " + string2 + " " + string + " --> " + securityConstraintArray[n2].included(string, string2)));
            }
            for (SecurityCollection securityCollection : securityCollectionArray) {
                String[] stringArray = securityCollection.findPatterns();
                if (stringArray == null) continue;
                boolean bl2 = false;
                for (String string6 : stringArray) {
                    if (!string6.equals("/")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(securityConstraintArray[n2]);
            }
        }
        if (arrayList == null && log.isDebugEnabled()) {
            log.debug((Object)"  No applicable constraint located");
        }
        return this.resultsToArray(arrayList);
    }

    private SecurityConstraint[] resultsToArray(ArrayList<SecurityConstraint> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new SecurityConstraint[0]);
    }

    @Override
    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] securityConstraintArray, Context context) throws IOException {
        String[] stringArray;
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            return true;
        }
        Principal principal = request.getPrincipal();
        boolean bl = false;
        boolean bl2 = false;
        for (SecurityConstraint securityConstraint : securityConstraintArray) {
            stringArray = securityConstraint.getAllRoles() ? request.getContext().findSecurityRoles() : securityConstraint.findAuthRoles();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking roles " + principal));
            }
            if (securityConstraint.getAuthenticatedUsers() && principal != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Passing all authenticated users");
                }
                bl = true;
                continue;
            }
            if (stringArray.length == 0 && !securityConstraint.getAllRoles() && !securityConstraint.getAuthenticatedUsers()) {
                if (securityConstraint.getAuthConstraint()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No roles");
                    }
                    bl = false;
                    bl2 = true;
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Passing all access");
                }
                bl = true;
                continue;
            }
            if (principal == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"  No user authenticated, cannot grant access");
                continue;
            }
            for (String string : stringArray) {
                if (this.hasRole(request.getWrapper(), principal, string)) {
                    bl = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Role found:  " + string));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No role found:  " + string));
            }
        }
        if (!bl2 && this.allRolesMode != AllRolesMode.STRICT_MODE && !bl && principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for all roles mode: " + this.allRolesMode));
            }
            for (SecurityConstraint securityConstraint : securityConstraintArray) {
                if (!securityConstraint.getAllRoles()) continue;
                if (this.allRolesMode == AllRolesMode.AUTH_ONLY_MODE) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Granting access for role-name=*, auth-only");
                    }
                    bl = true;
                    break;
                }
                stringArray = request.getContext().findSecurityRoles();
                if (stringArray.length != 0 || this.allRolesMode != AllRolesMode.STRICT_AUTH_ONLY_MODE) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Granting access for role-name=*, strict auth-only");
                }
                bl = true;
                break;
            }
        }
        if (!bl) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return bl;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String string) {
        String string2;
        if (wrapper != null && (string2 = wrapper.findSecurityReference(string)) != null) {
            string = string2;
        }
        if (principal == null || string == null) {
            return false;
        }
        boolean bl = this.hasRoleInternal(principal, string);
        if (log.isDebugEnabled()) {
            String string3 = principal.getName();
            if (bl) {
                log.debug((Object)sm.getString("realmBase.hasRoleSuccess", new Object[]{string3, string}));
            } else {
                log.debug((Object)sm.getString("realmBase.hasRoleFailure", new Object[]{string3, string}));
            }
        }
        return bl;
    }

    protected List<String> parseUserAttributes(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(USER_ATTRIBUTES_DELIMITER)) {
            if ((string2 = string2.trim()).length() == 0) continue;
            if (string2.equals(USER_ATTRIBUTES_WILDCARD)) {
                return Collections.singletonList(USER_ATTRIBUTES_WILDCARD);
            }
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    protected boolean hasRoleInternal(Principal principal, String string) {
        if (!(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal genericPrincipal = (GenericPrincipal)principal;
        return genericPrincipal.hasRole(string);
    }

    @Override
    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] securityConstraintArray) throws IOException {
        String string;
        String string2;
        Object object2;
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable security constraint defined");
            }
            return true;
        }
        for (Object object2 : securityConstraintArray) {
            string2 = object2.getUserConstraint();
            if (string2 == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  No applicable user data constraint defined");
                }
                return true;
            }
            if (!string2.equals(ServletSecurity.TransportGuarantee.NONE.name())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint already satisfied");
            }
            return true;
        }
        int n = request.getConnector().getRedirectPortWithOffset();
        if (n <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  SSL redirect is disabled");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "https";
        object2 = request.getServerName();
        stringBuilder.append(string3).append("://").append((String)object2);
        if (n != 443) {
            stringBuilder.append(':').append(n);
        }
        stringBuilder.append(request.getRequestURI());
        string2 = request.getRequestedSessionId();
        if (string2 != null && request.isRequestedSessionIdFromURL()) {
            stringBuilder.append(';');
            stringBuilder.append(SessionConfig.getSessionUriParamName(request.getContext()));
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
        if ((string = request.getQueryString()) != null) {
            stringBuilder.append('?');
            stringBuilder.append(string);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Redirecting to " + stringBuilder.toString()));
        }
        response.sendRedirect(stringBuilder.toString(), this.transportGuaranteeRedirectStatus);
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.containerLog = this.container.getLogger();
        }
        this.x509UsernameRetriever = RealmBase.createUsernameRetriever(this.x509UsernameRetrieverClassName);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.credentialHandler == null) {
            this.credentialHandler = new MessageDigestCredentialHandler();
        }
        if (this.userAttributes != null) {
            this.userAttributesList = this.parseUserAttributes(this.userAttributes);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Realm[");
        stringBuilder.append(this.getName());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected boolean hasMessageDigest(String string) {
        String string2;
        CredentialHandler credentialHandler = this.credentialHandler;
        if (credentialHandler instanceof MessageDigestCredentialHandler && (string2 = ((MessageDigestCredentialHandler)credentialHandler).getAlgorithm()) != null) {
            if (string2.equals(string)) {
                return true;
            }
            log.debug((Object)sm.getString("relamBase.digestMismatch", new Object[]{string, string2}));
        }
        return false;
    }

    @Deprecated
    protected String getDigest(String string, String string2) {
        return this.getDigest(string, string2, "MD5");
    }

    protected String getDigest(String string, String string2, String string3) {
        if (this.hasMessageDigest(string3)) {
            return this.getPassword(string);
        }
        String string4 = string + ":" + string2 + ":" + this.getPassword(string);
        byte[] byArray = null;
        try {
            byArray = string4.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)unsupportedEncodingException);
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        return HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)string3, (byte[][])new byte[][]{byArray}));
    }

    private String getDigestEncoding() {
        CredentialHandler credentialHandler = this.credentialHandler;
        if (credentialHandler instanceof MessageDigestCredentialHandler) {
            return ((MessageDigestCredentialHandler)credentialHandler).getEncoding();
        }
        return null;
    }

    private Charset getDigestCharset() throws UnsupportedEncodingException {
        String string = this.getDigestEncoding();
        if (string == null) {
            return StandardCharsets.ISO_8859_1;
        }
        return B2CConverter.getCharset((String)string);
    }

    @Deprecated
    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected Principal getPrincipal(X509Certificate x509Certificate) {
        String string = this.x509UsernameRetriever.getUsername(x509Certificate);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("realmBase.gotX509Username", new Object[]{string}));
        }
        return this.getPrincipal(string);
    }

    protected abstract Principal getPrincipal(String var1);

    @Deprecated
    protected Principal getPrincipal(String string, GSSCredential gSSCredential) {
        Principal principal = this.getPrincipal(string);
        if (principal instanceof GenericPrincipal) {
            ((GenericPrincipal)principal).setGssCredential(gSSCredential);
        }
        return principal;
    }

    protected Principal getPrincipal(GSSName gSSName, GSSCredential gSSCredential) {
        Principal principal;
        int n;
        String string = gSSName.toString();
        if (this.isStripRealmForGss() && (n = string.indexOf(64)) > 0) {
            string = string.substring(0, n);
        }
        if ((principal = this.getPrincipal(string)) instanceof GenericPrincipal) {
            ((GenericPrincipal)principal).setGssCredential(gSSCredential);
        }
        return principal;
    }

    protected Server getServer() {
        Service service;
        Container container = this.container;
        if (container instanceof Context) {
            container = container.getParent();
        }
        if (container instanceof Host) {
            container = container.getParent();
        }
        if (container instanceof Engine && (service = ((Engine)container).getService()) != null) {
            return service.getServer();
        }
        return null;
    }

    @Deprecated
    public static final String Digest(String string, String string2, String string3) {
        try {
            MessageDigest messageDigest = (MessageDigest)MessageDigest.getInstance(string2).clone();
            if (string3 == null) {
                messageDigest.update(string.getBytes());
            } else {
                messageDigest.update(string.getBytes(string3));
            }
            return HexUtils.toHexString((byte[])messageDigest.digest());
        }
        catch (Exception exception) {
            log.error((Object)exception);
            return string;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String string = Charset.defaultCharset().name();
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            RealmBase.usage();
            return;
        }
        int n4 = 0;
        while (stringArray.length > n4 + 2 && stringArray[n4].length() == 2 && stringArray[n4].charAt(0) == '-') {
            switch (stringArray[n4].charAt(1)) {
                case 'a': {
                    string2 = stringArray[n4 + 1];
                    break;
                }
                case 'e': {
                    string = stringArray[n4 + 1];
                    break;
                }
                case 'i': {
                    n2 = Integer.parseInt(stringArray[n4 + 1]);
                    break;
                }
                case 's': {
                    n = Integer.parseInt(stringArray[n4 + 1]);
                    break;
                }
                case 'k': {
                    n3 = Integer.parseInt(stringArray[n4 + 1]);
                    break;
                }
                case 'h': {
                    string3 = stringArray[n4 + 1];
                    break;
                }
                default: {
                    RealmBase.usage();
                    return;
                }
            }
            n4 += 2;
        }
        if (string2 == null && string3 == null) {
            string2 = "SHA-512";
        }
        CredentialHandler credentialHandler = null;
        if (string3 == null) {
            for (Class clazz : credentialHandlerClasses) {
                try {
                    credentialHandler = (CredentialHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!IntrospectionUtils.setProperty((Object)credentialHandler, (String)"algorithm", (String)string2)) continue;
                    break;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }
        } else {
            try {
                object = Class.forName(string3);
                credentialHandler = (DigestCredentialHandlerBase)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                IntrospectionUtils.setProperty((Object)credentialHandler, (String)"algorithm", (String)string2);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
        if (credentialHandler == null) {
            throw new RuntimeException(new NoSuchAlgorithmException(string2));
        }
        IntrospectionUtils.setProperty(credentialHandler, (String)"encoding", (String)string);
        if (n2 > 0) {
            IntrospectionUtils.setProperty((Object)credentialHandler, (String)"iterations", (String)Integer.toString(n2));
        }
        if (n > -1) {
            IntrospectionUtils.setProperty((Object)credentialHandler, (String)"saltLength", (String)Integer.toString(n));
        }
        if (n3 > 0) {
            IntrospectionUtils.setProperty((Object)credentialHandler, (String)"keyLength", (String)Integer.toString(n3));
        }
        while (n4 < stringArray.length) {
            object = stringArray[n4];
            System.out.print((String)object + ":");
            System.out.println(credentialHandler.mutate((String)object));
            ++n4;
        }
    }

    private static void usage() {
        System.out.println("Usage: RealmBase [-a <algorithm>] [-e <encoding>] [-i <iterations>] [-s <salt-length>] [-k <key-length>] [-h <handler-class-name>] <credentials>");
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=Realm");
        stringBuilder.append(this.getRealmSuffix());
        stringBuilder.append(this.container.getMBeanKeyProperties());
        return stringBuilder.toString();
    }

    @Override
    public String getDomainInternal() {
        return this.container.getDomain();
    }

    public String getRealmPath() {
        return this.realmPath;
    }

    public void setRealmPath(String string) {
        this.realmPath = string;
    }

    protected String getRealmSuffix() {
        return ",realmPath=" + this.getRealmPath();
    }

    private static X509UsernameRetriever createUsernameRetriever(String string) throws LifecycleException {
        if (null == string || string.trim().isEmpty()) {
            return new X509SubjectDnRetriever();
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (X509UsernameRetriever)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.newInstance", new Object[]{string}), reflectiveOperationException);
        }
        catch (ClassCastException classCastException) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.ClassCastException", new Object[]{string}), classCastException);
        }
    }

    @Override
    public String[] getRoles(Principal principal) {
        if (principal instanceof GenericPrincipal) {
            return ((GenericPrincipal)principal).getRoles();
        }
        String string = principal.getClass().getSimpleName();
        throw new IllegalStateException(sm.getString("realmBase.cannotGetRoles", new Object[]{string}));
    }

    static {
        credentialHandlerClasses.add(MessageDigestCredentialHandler.class);
        credentialHandlerClasses.add(SecretKeyCredentialHandler.class);
        sm = StringManager.getManager(RealmBase.class);
    }

    protected static class AllRolesMode {
        private final String name;
        public static final AllRolesMode STRICT_MODE = new AllRolesMode("strict");
        public static final AllRolesMode AUTH_ONLY_MODE = new AllRolesMode("authOnly");
        public static final AllRolesMode STRICT_AUTH_ONLY_MODE = new AllRolesMode("strictAuthOnly");

        static AllRolesMode toMode(String string) {
            AllRolesMode allRolesMode;
            if (string.equalsIgnoreCase(AllRolesMode.STRICT_MODE.name)) {
                allRolesMode = STRICT_MODE;
            } else if (string.equalsIgnoreCase(AllRolesMode.AUTH_ONLY_MODE.name)) {
                allRolesMode = AUTH_ONLY_MODE;
            } else if (string.equalsIgnoreCase(AllRolesMode.STRICT_AUTH_ONLY_MODE.name)) {
                allRolesMode = STRICT_AUTH_ONLY_MODE;
            } else {
                throw new IllegalStateException("Unknown mode, must be one of: strict, authOnly, strictAuthOnly");
            }
            return allRolesMode;
        }

        private AllRolesMode(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof AllRolesMode) {
                AllRolesMode allRolesMode = (AllRolesMode)object;
                bl = this.name.equals(allRolesMode.name);
            }
            return bl;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

