import type ts from 'typescript/lib/tsserverlibrary';
import { ConfigManager } from './config-manager';
import { SvelteSnapshotManager } from './svelte-snapshots';
import { Logger } from './logger';
export interface TsFilesSpec {
    include?: readonly string[];
    exclude?: readonly string[];
}
export declare class ProjectSvelteFilesManager {
    private readonly typescript;
    private readonly project;
    private readonly serverHost;
    private readonly snapshotManager;
    private readonly logger;
    private parsedCommandLine;
    private projectFileToOriginalCasing;
    private directoryWatchers;
    private static instances;
    static getInstance(projectName: string): ProjectSvelteFilesManager | undefined;
    constructor(typescript: typeof ts, project: ts.server.Project, serverHost: ts.server.ServerHost, snapshotManager: SvelteSnapshotManager, logger: Logger, parsedCommandLine: ts.ParsedCommandLine, configManager: ConfigManager);
    updateProjectConfig(serviceHost: ts.LanguageServiceHost): void;
    getFiles(): string[];
    /**
     * Create directory watcher for include and exclude
     * The watcher in tsserver doesn't support svelte file
     * It won't add new created svelte file to root
     */
    private setupWatchers;
    private watcherCallback;
    private updateProjectSvelteFiles;
    private addFileToProject;
    private readProjectSvelteFilesFromFs;
    private onConfigChanged;
    private removeFileFromProject;
    private disposeWatchers;
    private clearProjectFile;
    dispose(): void;
}
