"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.web = exports.setEnvironment = exports.linuxDesktop = exports.platform = exports.getEnvironment = exports.app = exports.URL_WEBAPP = exports.BackendType = void 0;
const config_1 = require("../settings/config");
const ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
const SettingsType_1 = require("../settings/SettingsType");
var BackendType;
(function (BackendType) {
    BackendType["AVS"] = "AVS";
    BackendType["CUSTOM"] = "CUSTOM";
    BackendType["DEVELOPMENT"] = "DEVELOPMENT";
    BackendType["EDGE"] = "EDGE";
    BackendType["INTERNAL"] = "INTERNAL";
    BackendType["LOCALZINFRA"] = "LOCALZINFRA";
    BackendType["MASTER"] = "MASTER";
    BackendType["PRODUCTION"] = "PRODUCTION";
    BackendType["QA"] = "QA";
})(BackendType = exports.BackendType || (exports.BackendType = {}));
let currentEnvironment;
const URL_ADMIN = {
    PRODUCTION: config_1.config.adminUrl,
    STAGING: 'https://wire-admin-staging.zinfra.io',
};
const URL_WEBSITE = {
    PRODUCTION: config_1.config.websiteUrl,
    STAGING: 'https://wire-website-staging.zinfra.io',
};
exports.URL_WEBAPP = {
    AVS: 'https://wire-webapp-avs.zinfra.io',
    DEVELOPMENT: 'https://wire-webapp-dev.zinfra.io',
    EDGE: 'https://wire-webapp-edge.zinfra.io',
    MASTER: 'https://wire-webapp-master.zinfra.io',
    QA: 'https://wire-webapp-qa.zinfra.io',
    INTERNAL: 'https://wire-webapp-staging.wire.com',
    LOCALZINFRA: 'https://local.zinfra.io:8081',
    PRODUCTION: config_1.config.appBase,
    CUSTOM: ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.CUSTOM_WEBAPP_URL, config_1.config.appBase),
};
exports.app = {
    ENV: config_1.config.environment,
    IS_DEVELOPMENT: config_1.config.environment !== 'production',
    IS_PRODUCTION: config_1.config.environment === 'production',
    UPDATE_URL_WIN: config_1.config.updateUrl,
};
const getEnvironment = () => currentEnvironment || restoreEnvironment();
exports.getEnvironment = getEnvironment;
const isProdEnvironment = () => {
    const env = (0, exports.getEnvironment)();
    return env === BackendType.INTERNAL || env === BackendType.PRODUCTION || env === BackendType.CUSTOM;
};
const isEnvVar = (envVar, value, caseSensitive = false) => {
    let envVarContent = process.env[envVar] || '';
    if (!caseSensitive) {
        envVar = envVar.toLowerCase();
        envVarContent = envVarContent.toLowerCase();
    }
    return envVarContent.includes(value);
};
exports.platform = {
    IS_LINUX: process.platform === 'linux',
    IS_MAC_OS: process.platform === 'darwin',
    IS_WINDOWS: process.platform === 'win32',
};
exports.linuxDesktop = {
    isGnomeX11: isEnvVar('XDG_CURRENT_DESKTOP', 'gnome') && isEnvVar('XDG_SESSION_TYPE', 'x11'),
    isPopOS: isEnvVar('XDG_CURRENT_DESKTOP', 'pop'),
    isUbuntuUnity: isEnvVar('XDG_CURRENT_DESKTOP', 'Unity'),
};
const restoreEnvironment = () => {
    let restoredEnvironment = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.ENV, BackendType.PRODUCTION);
    if (!Object.values(BackendType).includes(restoredEnvironment)) {
        restoredEnvironment = BackendType.PRODUCTION;
        (0, exports.setEnvironment)(restoredEnvironment);
    }
    return restoredEnvironment;
};
const setEnvironment = (env, customURL) => {
    currentEnvironment = env || restoreEnvironment();
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.ENV, currentEnvironment);
    if (customURL) {
        ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.CUSTOM_WEBAPP_URL, customURL);
    }
    ConfigurationPersistence_1.settings.persistToFile();
};
exports.setEnvironment = setEnvironment;
exports.web = {
    getAdminUrl: (path = '') => {
        const baseUrl = isProdEnvironment() ? URL_ADMIN.PRODUCTION : URL_ADMIN.STAGING;
        return `${baseUrl}${path}`;
    },
    getWebappUrl: (env) => {
        if (env) {
            return env;
        }
        const currentEnvironment = (0, exports.getEnvironment)();
        return exports.URL_WEBAPP[currentEnvironment];
    },
    getWebsiteUrl: (path = '') => {
        const baseUrl = isProdEnvironment() ? URL_WEBSITE.PRODUCTION : URL_WEBSITE.STAGING;
        return `${baseUrl}${path}`;
    },
};
//# sourceMappingURL=EnvironmentUtil.js.map