"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ButtonLink = exports.buttonLinkStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _Misc = require("../Misc");

var _Identity = require("../Identity");

var _util = require("../util");

var _Text = require("../Text");

var _Button = require("./Button");

var _excluded = ["children", "showLoading", "loadingColor"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var buttonLinkStyle = function buttonLinkStyle(theme, props) {
  return _objectSpread(_objectSpread({}, (0, _Button.buttonStyle)(theme, props)), {}, {
    display: 'inline-flex !important'
  });
};

exports.buttonLinkStyle = buttonLinkStyle;

var filterButtonLinkProps = function filterButtonLinkProps(props) {
  return (0, _util.filterProps)((0, _Text.filterTextProps)(props), ['backgroundColor', 'disabled', 'noCapital']);
};

var ButtonLink = function ButtonLink(_ref) {
  var children = _ref.children,
      showLoading = _ref.showLoading,
      _ref$loadingColor = _ref.loadingColor,
      loadingColor = _ref$loadingColor === void 0 ? _Identity.COLOR.WHITE : _ref$loadingColor,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return (0, _react.jsx)("a", (0, _extends2["default"])({
    css: function css(theme) {
      return buttonLinkStyle(theme, props);
    }
  }, filterButtonLinkProps(props)), showLoading ? (0, _react.jsx)(_Misc.Loading, {
    size: 30,
    color: loadingColor,
    style: {
      display: 'flex',
      margin: 'auto'
    }
  }) : children);
};

exports.ButtonLink = ButtonLink;
//# sourceMappingURL=ButtonLink.js.map