"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckboxLabel = exports.Checkbox = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _Text = require("../Text");

var _util = require("../util");

var _Input = require("./Input");

var _excluded = ["id", "children", "style", "disabled"],
    _excluded2 = ["color"];

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var filterStyledLabelProps = function filterStyledLabelProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid']);
};

var checkSvg = '<svg width="15" height="13" viewBox="0 0 16 13" xmlns="http://www.w3.org/2000/svg"><path d="M5.65685 12.0711L15.9842 1.62738L14.57 0.213167L5.65685 9.24264L1.41421 5L0 6.41421L5.65685 12.0711Z" fill="white"/></svg>';

var StyledLabel = function StyledLabel(props) {
  var disabled = props.disabled,
      markInvalid = props.markInvalid;
  return (0, _react.jsx)("label", (0, _extends2["default"])({
    css: function css(theme) {
      var _ref;

      return _objectSpread(_objectSpread((0, _defineProperty2["default"])({}, ".".concat(_Input.INPUT_CLASSNAME, ":checked + &::before"), {
        background: "".concat(disabled ? _Identity.COLOR_V2.GRAY_60 : _Identity.COLOR_V2.BLUE, " url('data:image/svg+xml; utf8, ").concat(checkSvg, "') no-repeat center"),
        borderColor: _Identity.COLOR_V2.BLUE
      }), !disabled && (_ref = {}, (0, _defineProperty2["default"])(_ref, ".".concat(_Input.INPUT_CLASSNAME, ":focus + &::before"), {
        borderColor: _Identity.COLOR_V2.BLUE
      }), (0, _defineProperty2["default"])(_ref, ".".concat(_Input.INPUT_CLASSNAME, ":hover + &::before"), {
        borderColor: _Identity.COLOR_V2.BLUE
      }), _ref)), {}, {
        '&::before': _objectSpread(_objectSpread({
          background: disabled ? _Identity.COLOR_V2.GRAY_10 : _Identity.COLOR_V2.GRAY_20
        }, !disabled ? {
          border: markInvalid ? "1.5px solid ".concat(_Identity.COLOR_V2.RED) : "1.5px solid ".concat(_Identity.COLOR_V2.GRAY_80)
        } : {
          border: "1.5px solid ".concat(_Identity.COLOR_V2.GRAY_60)
        }), {}, {
          borderRadius: '3px',
          boxSizing: 'border-box',
          content: '""',
          display: 'inline-block',
          height: '22px',
          lineHeight: '22px',
          margin: '0 8px 0 -16px',
          width: '22px'
        }),
        a: _objectSpread({}, (0, _Text.textLinkStyle)(theme, {})),
        lineHeight: '22px',
        display: 'flex',
        opacity: disabled ? 0.56 : 1
      });
    }
  }, filterStyledLabelProps(props)));
};

var filterCheckboxProps = function filterCheckboxProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid']);
}; // We use Math.random..., because some of apps doesn't migrated to newest version of React.


var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "cz23tk",
  styles: "align-items:center;display:flex;justify-content:flex-start"
} : {
  name: "1uw42d7-Checkbox",
  styles: "align-items:center;display:flex;justify-content:flex-start;label:Checkbox;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var Checkbox = /*#__PURE__*/_react2["default"].forwardRef(function (_ref2, ref) {
  var _ref2$id = _ref2.id,
      id = _ref2$id === void 0 ? Math.random().toString() : _ref2$id,
      children = _ref2.children,
      style = _ref2.style,
      disabled = _ref2.disabled,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);
  return (0, _react.jsx)("div", {
    css: _ref3,
    style: style
  }, (0, _react.jsx)("input", (0, _extends2["default"])({
    type: "checkbox",
    id: id,
    style: {
      height: '22px',
      marginBottom: '0',
      opacity: 0,
      width: '22px'
    },
    disabled: disabled,
    ref: ref,
    className: _Input.INPUT_CLASSNAME
  }, filterCheckboxProps(props))), (0, _react.jsx)(StyledLabel, {
    htmlFor: id,
    disabled: disabled,
    markInvalid: props.markInvalid
  }, children));
});

exports.Checkbox = Checkbox;

var CheckboxLabel = function CheckboxLabel(_ref4) {
  var _ref4$color = _ref4.color,
      color = _ref4$color === void 0 ? _Identity.COLOR.TEXT : _ref4$color,
      props = (0, _objectWithoutProperties2["default"])(_ref4, _excluded2);
  return (0, _react.jsx)(_Text.Text, (0, _extends2["default"])({
    css: function css(theme) {
      return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
        color: color
      }, props))), {}, {
        a: {
          color: _Identity.COLOR.LINK,
          textDecoration: 'none'
        }
      });
    }
  }, props));
};

exports.CheckboxLabel = CheckboxLabel;
//# sourceMappingURL=Checkbox.js.map