"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeInput = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _react2 = _interopRequireWildcard(require("react"));

var _util = require("../util");

var _Input = require("./Input");

var _Identity = require("../Identity");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var _ref = process.env.NODE_ENV === "production" ? {
  name: "zl1inp",
  styles: "display:flex;justify-content:center"
} : {
  name: "tvpiqi-CodeInputWrapper",
  styles: "display:flex;justify-content:center;label:CodeInputWrapper;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var CodeInputWrapper = function CodeInputWrapper(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: _ref
  }, props));
};

var digitInputStyle = function digitInputStyle(theme, props) {
  return _objectSpread(_objectSpread({}, (0, _Input.inputStyle)(theme, props)), {}, {
    '& + &': {
      marginLeft: '19px'
    },
    '&:hover': {
      boxShadow: "0 0 0 1px ".concat(_Identity.COLOR_V2.GRAY_60)
    },
    fontSize: '24px',
    lineHeight: '28px',
    borderRadius: '12px',
    padding: 0,
    textAlign: 'center',
    width: '48px',
    height: '56px'
  });
};

var DigitInput = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)("input", (0, _extends2["default"])({
    ref: ref,
    css: function css(theme) {
      return digitInputStyle(theme, props);
    }
  }, props, {
    type: "tel"
  }));
});

var CodeInput = function CodeInput(_ref2) {
  var style = _ref2.style,
      _ref2$digits = _ref2.digits,
      digits = _ref2$digits === void 0 ? 6 : _ref2$digits,
      _ref2$autoFocus = _ref2.autoFocus,
      autoFocus = _ref2$autoFocus === void 0 ? false : _ref2$autoFocus,
      markInvalid = _ref2.markInvalid,
      _ref2$onCodeComplete = _ref2.onCodeComplete,
      onCodeComplete = _ref2$onCodeComplete === void 0 ? _util.noop : _ref2$onCodeComplete,
      disabled = _ref2.disabled;

  var _useState = (0, _react2.useState)(Array(digits).fill('')),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      values = _useState2[0],
      setValues = _useState2[1];

  var inputs = Array(digits);

  var forceSelection = function forceSelection(event) {
    var target = event.target;
    target.select();
  };

  var forceSelectionPreventDefault = function forceSelectionPreventDefault(event) {
    forceSelection(event);
    event.preventDefault();
  };

  var nextField = function nextField(currentFieldIndex) {
    var nextFieldIndex = currentFieldIndex + 1;

    if (nextFieldIndex < digits) {
      inputs[nextFieldIndex].focus();
    }
  };

  var previousField = function previousField(currentFieldIndex) {
    if (currentFieldIndex > 0) {
      inputs[currentFieldIndex - 1].focus();
    }
  };

  var setValue = function setValue(fieldIndex, value) {
    if (/^[0-9]?$/.test(value)) {
      var valuesCopy = values.slice();
      valuesCopy[fieldIndex] = value;
      setValues(valuesCopy);

      if (value.length) {
        nextField(fieldIndex);
      }
    }
  };

  var handleKeyDown = function handleKeyDown(fieldIndex, _ref3) {
    var key = _ref3.key;

    switch (key) {
      case 'Backspace':
        setValue(fieldIndex, '');
        previousField(fieldIndex);
        break;

      case 'ArrowLeft':
        previousField(fieldIndex);
        break;

      case 'ArrowRight':
        nextField(fieldIndex);
        break;
    }

    if (/^[0-9]$/.test(key)) {
      setValue(fieldIndex, key);
    }
  };

  var handlePaste = function handlePaste(fieldIndex, event) {
    var pastedValue = event.clipboardData.getData('Text');
    var cleanedPaste = pastedValue.replace(/[^0-9]/g, '');

    if (/^[0-9]+$/.test(cleanedPaste)) {
      setValues(values.slice(0, fieldIndex).concat(cleanedPaste.split('')).slice(0, digits));
    }
  };

  (0, _react2.useEffect)(function () {
    var completeCode = values.join('');

    if (completeCode.length === digits) {
      onCodeComplete(completeCode);
    }
  }, [values]);
  return (0, _react.jsx)(CodeInputWrapper, {
    style: style
  }, Array.from({
    length: digits
  }, function (_, index) {
    return (0, _react.jsx)(DigitInput, {
      autoFocus: index === 0 && autoFocus,
      key: index,
      onPaste: function onPaste(event) {
        return handlePaste(index, event);
      },
      onFocus: forceSelection,
      onMouseDown: forceSelectionPreventDefault,
      onTouchStart: forceSelectionPreventDefault,
      onKeyDown: function onKeyDown(event) {
        return handleKeyDown(index, event);
      },
      onKeyUp: forceSelection,
      markInvalid: markInvalid,
      ref: function ref(node) {
        return inputs[index] = node;
      },
      value: values[index],
      onChange: function onChange() {},
      disabled: disabled
    });
  }));
};

exports.CodeInput = CodeInput;
//# sourceMappingURL=CodeInput.js.map