"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMessage = exports.filterErrorMessageProps = exports.errorMessageStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _Identity = require("../Identity");

var _Layout = require("../Layout");

var _Text = require("../Text");

var _util = require("../util");

var _excluded = ["justify", "align"],
    _excluded2 = ["children"];

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var errorMessageStyle = function errorMessageStyle(theme, _ref) {
  var _ref$justify = _ref.justify,
      justify = _ref$justify === void 0 ? 'flex-start' : _ref$justify,
      _ref$align = _ref.align,
      align = _ref$align === void 0 ? 'center' : _ref$align,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  return _objectSpread(_objectSpread({}, (0, _Layout.flexBoxStyle)(_objectSpread({
    align: align,
    justify: justify
  }, props))), {}, {
    a: _objectSpread({}, (0, _Text.linkStyle)(theme, _objectSpread({
      bold: false,
      fontSize: '12px',
      textTransform: 'none'
    }, props))),
    marginBottom: '12px'
  });
};

exports.errorMessageStyle = errorMessageStyle;

var filterErrorMessageProps = function filterErrorMessageProps(props) {
  return (0, _util.filterProps)((0, _Layout.filterFlexBoxProps)(props), []);
};

exports.filterErrorMessageProps = filterErrorMessageProps;

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "mmvz9h",
  styles: "font-weight:400"
} : {
  name: "z4bxhs-ErrorMessage",
  styles: "font-weight:400;label:ErrorMessage;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var ErrorMessage = function ErrorMessage(_ref2) {
  var children = _ref2.children,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded2);
  return (0, _react.jsx)(_Layout.FlexBox, (0, _extends2["default"])({
    css: function css(theme) {
      return errorMessageStyle(theme, props);
    }
  }, props), (0, _react.jsx)(_Text.Text, {
    color: _Identity.COLOR_V2.RED_LIGHT_500,
    fontSize: '12px',
    css: _ref3
  }, children));
};

exports.ErrorMessage = ErrorMessage;
//# sourceMappingURL=ErrorMessage.js.map