"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Input = exports.INPUT_GROUP = exports.INPUT_CLASSNAME = exports.inputStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react2 = _interopRequireWildcard(require("react"));

var _Identity = require("../Identity");

var _util = require("../util");

var _Icon = require("../Icon");

var _InputLabel = _interopRequireDefault(require("./InputLabel"));

var _excluded = ["type", "label", "error", "helperText", "wrapperCSS", "className"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var inputStyle = function inputStyle(theme, _ref) {
  var _ref$markInvalid = _ref.markInvalid,
      markInvalid = _ref$markInvalid === void 0 ? false : _ref$markInvalid,
      _ref$placeholderTextT = _ref.placeholderTextTransform,
      placeholderTextTransform = _ref$placeholderTextT === void 0 ? 'none' : _ref$placeholderTextT,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled;
  var placeholderStyle = {
    color: theme.Input.placeholderColor,
    fontSize: '16px',
    textTransform: placeholderTextTransform
  };
  return {
    '&::-moz-placeholder': _objectSpread(_objectSpread({}, placeholderStyle), {}, {
      opacity: 1
    }),
    '&::-ms-input-placeholder': _objectSpread({}, placeholderStyle),
    '&::-webkit-input-placeholder': _objectSpread({}, placeholderStyle),
    '&:focus': {
      boxShadow: "0 0 0 1px ".concat(_Identity.COLOR_V2.BLUE)
    },
    '&:invalid:not(:focus)': !markInvalid ? {
      boxShadow: "0 0 0 1px ".concat(_Identity.COLOR_V2.GRAY)
    } : {},
    background: disabled ? theme.Input.backgroundColorDisabled : theme.Input.backgroundColor,
    border: 'none',
    borderRadius: '4px',
    boxShadow: markInvalid ? "0 0 0 1px ".concat(_Identity.COLOR_V2.RED) : "0 0 0 1px ".concat(_Identity.COLOR_V2.GRAY_40),
    caretColor: _Identity.COLOR_V2.BLUE,
    color: theme.general.color,
    fontWeight: 300,
    height: '48px',
    lineHeight: '24px',
    outline: 'none',
    padding: '0 16px',
    width: '100%'
  };
};

exports.inputStyle = inputStyle;
var INPUT_CLASSNAME = 'wireinput';
exports.INPUT_CLASSNAME = INPUT_CLASSNAME;
var INPUT_GROUP = 'input-group';
exports.INPUT_GROUP = INPUT_GROUP;

var filterInputProps = function filterInputProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid', 'placeholderTextTransform']);
};

var centerInputAction = {
  position: 'absolute',
  right: '16px',
  top: '50%',
  transform: 'translateY(-50%)'
};

var Input = /*#__PURE__*/_react2["default"].forwardRef(function (_ref2, ref) {
  var type = _ref2.type,
      label = _ref2.label,
      error = _ref2.error,
      helperText = _ref2.helperText,
      _ref2$wrapperCSS = _ref2.wrapperCSS,
      wrapperCSS = _ref2$wrapperCSS === void 0 ? {} : _ref2$wrapperCSS,
      _ref2$className = _ref2.className,
      className = _ref2$className === void 0 ? '' : _ref2$className,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);

  var _useState = (0, _react2.useState)(false),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      togglePassword = _useState2[0],
      setTogglePassword = _useState2[1];

  var hasError = !!error;
  var isPasswordInput = type === 'password';
  var toggledPasswordType = togglePassword ? 'text' : 'password';

  var toggleSetPassword = function toggleSetPassword() {
    return setTogglePassword(function (prevState) {
      return !prevState;
    });
  };

  return (0, _react.jsx)("div", {
    className: INPUT_GROUP,
    css: /*#__PURE__*/(0, _react.css)(_objectSpread({
      marginBottom: hasError ? '2px' : '20px',
      width: '100%',
      '&:focus-within label': {
        color: _Identity.COLOR_V2.BLUE
      }
    }, wrapperCSS), process.env.NODE_ENV === "production" ? "" : ";label:Input;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, label && (0, _react.jsx)(_InputLabel["default"], {
    htmlFor: props.id,
    isRequired: props.required,
    markInvalid: props.markInvalid
  }, label), (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      marginBottom: hasError && '8px',
      position: 'relative'
    }, process.env.NODE_ENV === "production" ? "" : ";label:Input;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, (0, _react.jsx)("input", (0, _extends2["default"])({
    className: INPUT_CLASSNAME,
    css: function css(theme) {
      return inputStyle(theme, props, hasError);
    },
    ref: ref,
    type: isPasswordInput ? toggledPasswordType : type,
    "aria-required": props.required
  }, filterInputProps(props))), hasError && !isPasswordInput && (0, _react.jsx)(_Icon.ErrorIcon, {
    css: centerInputAction,
    width: 16,
    height: 16,
    "aria-hidden": "true"
  }), isPasswordInput && (0, _react.jsx)("button", {
    type: "button",
    css: /*#__PURE__*/(0, _react.css)(_objectSpread(_objectSpread({}, centerInputAction), {}, {
      background: 'transparent',
      border: 'none',
      cursor: 'pointer',
      padding: 0
    }), process.env.NODE_ENV === "production" ? "" : ";label:Input;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"),
    onClick: toggleSetPassword,
    title: "Toggle password visibility",
    "aria-controls": props.id,
    "aria-expanded": togglePassword
  }, togglePassword ? (0, _react.jsx)(_Icon.HideIcon, {
    color: _Identity.COLOR_V2.BLACK
  }) : (0, _react.jsx)(_Icon.ShowIcon, {
    color: _Identity.COLOR_V2.BLACK
  }))), !hasError && helperText && (0, _react.jsx)("p", {
    css: /*#__PURE__*/(0, _react.css)({
      fontSize: '12px',
      fontWeight: 400,
      color: _Identity.COLOR_V2.GRAY_80,
      marginTop: 8
    }, process.env.NODE_ENV === "production" ? "" : ";label:Input;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, helperText), error);
});

exports.Input = Input;
//# sourceMappingURL=Input.js.map