"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShakeBox = void 0;

var _react = require("@emotion/react");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react2 = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var ShakeBox = /*#__PURE__*/_react2["default"].forwardRef(function (_ref, ref) {
  var children = _ref.children,
      _ref$amplitude = _ref.amplitude,
      amplitude = _ref$amplitude === void 0 ? 8 : _ref$amplitude,
      _ref$damping = _ref.damping,
      damping = _ref$damping === void 0 ? 0.75 : _ref$damping,
      _ref$speed = _ref.speed,
      speed = _ref$speed === void 0 ? 4 : _ref$speed,
      _ref$threshold = _ref.threshold,
      threshold = _ref$threshold === void 0 ? 1 : _ref$threshold;

  var _useState = (0, _react2.useState)(0),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      offset = _useState2[0],
      setOffset = _useState2[1];

  var requestAnimationId = 0;

  var shakeLoop = function shakeLoop(targetOffset) {
    var currentOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

    if (targetOffset > 0 && currentOffset < targetOffset) {
      currentOffset += speed;
    } else if (targetOffset < 0 && currentOffset > targetOffset) {
      currentOffset -= speed;
    } else {
      currentOffset = targetOffset - (currentOffset - targetOffset);
      targetOffset *= -damping;
    }

    if (Math.abs(targetOffset) >= threshold) {
      requestAnimationId = requestAnimationFrame(function () {
        return shakeLoop(targetOffset, currentOffset);
      });
    } else {
      currentOffset = 0;
    }

    setOffset(currentOffset);
  };

  (0, _react2.useImperativeHandle)(ref, function () {
    return {
      shake: function shake() {
        cancelAnimationFrame(requestAnimationId);
        shakeLoop(amplitude);
      }
    };
  });
  (0, _react2.useEffect)(function () {
    return function () {
      return cancelAnimationFrame(requestAnimationId);
    };
  }, []);
  return (0, _react.jsx)("div", {
    css: /*#__PURE__*/(0, _react.css)({
      transform: "translateX(".concat(offset, "px)")
    }, process.env.NODE_ENV === "production" ? "" : ";label:ShakeBox;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, children);
});

exports.ShakeBox = ShakeBox;
//# sourceMappingURL=ShakeBox.js.map