"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COLOR_V2 = exports.BASE_DARK_COLOR = exports.BASE_LIGHT_COLOR = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/*
 * Wire
 * Copyright (C) 2022 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var BASE_LIGHT_COLOR = {
  BLUE: '#0667c8',
  GREEN: '#1d7833',
  PETROL: '#01718e',
  PURPLE: '#8944ab',
  RED: '#c20013',
  AMBER: '#a25915'
};
exports.BASE_LIGHT_COLOR = BASE_LIGHT_COLOR;
var BASE_DARK_COLOR = {
  BLUE: '#54a6ff',
  GREEN: '#30db5b',
  PETROL: '#5de6ff',
  PURPLE: '#da8fff',
  RED: '#ff7770',
  AMBER: '#ffd426'
};
exports.BASE_DARK_COLOR = BASE_DARK_COLOR;
var LIGHT_BLUE = {
  BLUE_LIGHT_50: '#e7f0fa',
  BLUE_LIGHT_100: '#cde1f4',
  BLUE_LIGHT_200: '#9bc2e9',
  BLUE_LIGHT_300: '#6aa4de',
  BLUE_LIGHT_400: '#3885d3',
  BLUE_LIGHT_500: BASE_LIGHT_COLOR.BLUE,
  BLUE_LIGHT_600: '#0552a0',
  BLUE_LIGHT_700: '#043e78',
  BLUE_LIGHT_800: '#022950',
  BLUE_LIGHT_900: '#19324d'
};
var DARK_BLUE = {
  BLUE_DARK_50: '#eef7ff',
  BLUE_DARK_100: '#ddedff',
  BLUE_DARK_200: '#bbdbff',
  BLUE_DARK_300: '#98caff',
  BLUE_DARK_400: '#76b8ff',
  BLUE_DARK_500: BASE_DARK_COLOR.BLUE,
  BLUE_DARK_600: '#4385cc',
  BLUE_DARK_700: '#326499',
  BLUE_DARK_800: '#224266',
  BLUE_DARK_900: '#19324d'
};
var LIGHT_GREEN = {
  GREEN_LIGHT_50: '#e8f1ea',
  GREEN_LIGHT_100: '#d2e4d6',
  GREEN_LIGHT_200: '#a5c9ad',
  GREEN_LIGHT_300: '#77ae85',
  GREEN_LIGHT_400: '#4a935c',
  GREEN_LIGHT_500: BASE_LIGHT_COLOR.GREEN,
  GREEN_LIGHT_600: '#176029',
  GREEN_LIGHT_700: '#11481f',
  GREEN_LIGHT_800: '#0c3014',
  GREEN_LIGHT_900: '#0e421b'
};
var DARK_GREEN = {
  GREEN_DARK_50: '#ebfcef',
  GREEN_DARK_100: '#d6f8de',
  GREEN_DARK_200: '#acf1bd',
  GREEN_DARK_300: '#83e99d',
  GREEN_DARK_400: '#59e27c',
  GREEN_DARK_500: BASE_DARK_COLOR.GREEN,
  GREEN_DARK_600: '#26af49',
  GREEN_DARK_700: '#1d8337',
  GREEN_DARK_800: '#135824',
  GREEN_DARK_900: '#0e421b'
};
var LIGHT_PETROL = {
  PETROL_LIGHT_50: '#e5f1f3',
  PETROL_LIGHT_100: '#cce2e7',
  PETROL_LIGHT_200: '#99c6d0',
  PETROL_LIGHT_300: '#67a9b8',
  PETROL_LIGHT_400: '#348da1',
  PETROL_LIGHT_500: BASE_LIGHT_COLOR.PETROL,
  PETROL_LIGHT_600: '#015a6e',
  PETROL_LIGHT_700: '#014352',
  PETROL_LIGHT_800: '#002d37',
  PETROL_LIGHT_900: '#1c454d'
};
var DARK_PETROL = {
  PETROL_DARK_50: '#effdff',
  PETROL_DARK_100: '#dffaff',
  PETROL_DARK_200: '#bef5ff',
  PETROL_DARK_300: '#9ef0ff',
  PETROL_DARK_400: '#7debff',
  PETROL_DARK_500: BASE_DARK_COLOR.PETROL,
  PETROL_DARK_600: '#4Ab8cc',
  PETROL_DARK_700: '#388a99',
  PETROL_DARK_800: '#255c66',
  PETROL_DARK_900: '#1c454d'
};
var LIGHT_PURPLE = {
  PURPLE_LIGHT_50: '#f4edf7',
  PURPLE_LIGHT_100: '#e7daee',
  PURPLE_LIGHT_200: '#d0b4dd',
  PURPLE_LIGHT_300: '#b88fcd',
  PURPLE_LIGHT_400: '#a169bc',
  PURPLE_LIGHT_500: BASE_LIGHT_COLOR.PURPLE,
  PURPLE_LIGHT_600: '#6e3689',
  PURPLE_LIGHT_700: '#522967',
  PURPLE_LIGHT_800: '#371b44',
  PURPLE_LIGHT_900: '#412b4d'
};
var DARK_PURPLE = {
  PURPLE_DARK_50: '#fcf4ff',
  PURPLE_DARK_100: '#f8e9ff',
  PURPLE_DARK_200: '#f0d2ff',
  PURPLE_DARK_300: '#e9bcff',
  PURPLE_DARK_400: '#e1a5ff',
  PURPLE_DARK_500: BASE_DARK_COLOR.PURPLE,
  PURPLE_DARK_600: '#ae72cc',
  PURPLE_DARK_700: '#835699',
  PURPLE_DARK_800: '#573966',
  PURPLE_DARK_900: '#412b4d'
};
var LIGHT_RED = {
  RED_LIGHT_50: '#f9e6e8',
  RED_LIGHT_100: '#f3ccd0',
  RED_LIGHT_200: '#e799a1',
  RED_LIGHT_300: '#da6671',
  RED_LIGHT_400: '#ce3342',
  RED_LIGHT_500: BASE_LIGHT_COLOR.RED,
  RED_LIGHT_600: '#9b000f',
  RED_LIGHT_700: '#74000b',
  RED_LIGHT_800: '#4e0008',
  RED_LIGHT_900: '#4d2422'
};
var DARK_RED = {
  RED_DARK_50: '#fff2f1',
  RED_DARK_100: '#ffe4e2',
  RED_DARK_200: '#ffc9c6',
  RED_DARK_300: '#ffada9',
  RED_DARK_400: '#ff928d',
  RED_DARK_500: BASE_DARK_COLOR.RED,
  RED_DARK_600: '#cc5f5a',
  RED_DARK_700: '#994743',
  RED_DARK_800: '#66302d',
  RED_DARK_900: '#4d2422'
};
var LIGHT_AMBER = {
  AMBER_LIGHT_50: '#f6eee8',
  AMBER_LIGHT_100: '#ecded0',
  AMBER_LIGHT_200: '#dabda1',
  AMBER_LIGHT_300: '#c79b73',
  AMBER_LIGHT_400: '#b57A44',
  AMBER_LIGHT_500: BASE_LIGHT_COLOR.AMBER,
  AMBER_LIGHT_600: '#824711',
  AMBER_LIGHT_700: '#61350d',
  AMBER_LIGHT_800: '#412408',
  AMBER_LIGHT_900: '#201204'
};
var DARK_AMBER = {
  AMBER_DARK_50: '#fffbea',
  AMBER_DARK_100: '#fff6d4',
  AMBER_DARK_200: '#ffeea8',
  AMBER_DARK_300: '#ffe57d',
  AMBER_DARK_400: '#ffdd51',
  AMBER_DARK_500: BASE_DARK_COLOR.AMBER,
  AMBER_DARK_600: '#ccaa1e',
  AMBER_DARK_700: '#997f17',
  AMBER_DARK_800: '#66550f',
  AMBER_DARK_900: '#4d400b'
};

var DARK = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, DARK_BLUE), DARK_GREEN), DARK_PETROL), DARK_PURPLE), DARK_RED), DARK_AMBER);

var LIGHT = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, LIGHT_BLUE), LIGHT_GREEN), LIGHT_PETROL), LIGHT_PURPLE), LIGHT_RED), LIGHT_AMBER);

var GRAYS = {
  GRAY_10: '#fafafa',
  GRAY_20: '#edeff0',
  GRAY_30: '#e5e8ea',
  GRAY_40: '#dce0e3',
  GRAY_50: '#cbced1',
  GRAY_60: '#9fa1a7',
  GRAY_70: '#676b71',
  GRAY_80: '#54585f',
  GRAY_90: '#34373d',
  GRAY_95: '#26272c',
  GRAY_100: '#17181a'
};

var COLOR_V2 = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, BASE_DARK_COLOR), BASE_LIGHT_COLOR), DARK), LIGHT), GRAYS), {}, {
  BLACK: '#000',
  WHITE: '#fff'
});

exports.COLOR_V2 = COLOR_V2;
//# sourceMappingURL=colors-v2.js.map