"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContainerXXS = exports.ContainerXS = exports.ContainerSM = exports.ContainerMD = exports.ContainerLG = exports.Container = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _mediaQueries = require("../mediaQueries");

var _util = require("../util");

var _sizes = require("./sizes");

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var LEVEL = {
  lg: _sizes.WIDTH.DESKTOP_MAX,
  md: _sizes.WIDTH.TABLET_MAX,
  sm: _sizes.WIDTH.TABLET_MIN,
  xs: _sizes.WIDTH.MOBILE,
  xxs: _sizes.WIDTH.TINY
};

var containerStyle = function containerStyle(_ref) {
  var _ref$centerText = _ref.centerText,
      centerText = _ref$centerText === void 0 ? false : _ref$centerText,
      _ref$level = _ref.level,
      level = _ref$level === void 0 ? undefined : _ref$level,
      _ref$verticalCenter = _ref.verticalCenter,
      verticalCenter = _ref$verticalCenter === void 0 ? false : _ref$verticalCenter;
  return (0, _defineProperty2["default"])({
    margin: verticalCenter ? 'auto' : '0 auto',
    maxWidth: level ? "".concat(LEVEL[level], "px") : undefined,
    position: 'relative',
    textAlign: centerText ? 'center' : 'left',
    width: '100%'
  }, _mediaQueries.media[_mediaQueries.QueryKeys.DESKTOP], level ? undefined : {
    padding: 0,
    width: "".concat(_sizes.WIDTH.DESKTOP_MIN - _sizes.GUTTER * 2, "px")
  });
};

var filterContainerProps = function filterContainerProps(props) {
  return (0, _util.filterProps)(props, ['centerText', 'level', 'verticalCenter']);
};

var Container = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    ref: ref,
    css: containerStyle(props)
  }, filterContainerProps(props)));
});

exports.Container = Container;

var ContainerLG = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Container, (0, _extends2["default"])({
    ref: ref,
    level: 'lg'
  }, props));
});

exports.ContainerLG = ContainerLG;

var ContainerMD = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Container, (0, _extends2["default"])({
    ref: ref,
    level: 'md'
  }, props));
});

exports.ContainerMD = ContainerMD;

var ContainerSM = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Container, (0, _extends2["default"])({
    ref: ref,
    level: 'sm'
  }, props));
});

exports.ContainerSM = ContainerSM;

var ContainerXS = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Container, (0, _extends2["default"])({
    ref: ref,
    level: 'xs'
  }, props));
});

exports.ContainerXS = ContainerXS;

var ContainerXXS = /*#__PURE__*/_react2["default"].forwardRef(function (props, ref) {
  return (0, _react.jsx)(Container, (0, _extends2["default"])({
    ref: ref,
    level: 'xxs'
  }, props));
});

exports.ContainerXXS = ContainerXXS;
//# sourceMappingURL=Container.js.map