"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledApp = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@emotion/react");

var _GlobalStyle = require("../GlobalStyle");

var _util = require("../util");

var _Theme = require("./Theme");

var _excluded = ["themeId", "children"];

var styledAppContainerStyle = function styledAppContainerStyle(theme, _ref) {
  var _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === void 0 ? theme.general.backgroundColor : _ref$backgroundColor;
  return {
    background: backgroundColor,
    transition: 'background 0.15s'
  };
};

var filterStyledAppContainerProps = function filterStyledAppContainerProps(props) {
  return (0, _util.filterProps)(props, ['backgroundColor', 'themeId']);
};

var StyledAppContainer = function StyledAppContainer(props) {
  return (0, _react2.jsx)("div", (0, _extends2["default"])({
    css: function css(theme) {
      return styledAppContainerStyle(theme, props);
    }
  }, filterStyledAppContainerProps(props)));
};

var StyledApp = function StyledApp(_ref2) {
  var _ref2$themeId = _ref2.themeId,
      themeId = _ref2$themeId === void 0 ? _Theme.THEME_ID.LIGHT : _ref2$themeId,
      children = _ref2.children,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);
  return (0, _react2.jsx)(_Theme.ThemeProvider, {
    themeId: themeId
  }, (0, _react2.jsx)(StyledAppContainer, props, (0, _react2.jsx)(_GlobalStyle.GlobalStyle, null), children));
};

exports.StyledApp = StyledApp;
//# sourceMappingURL=StyledApp.js.map