"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemeProvider = exports.themes = exports.THEME_ID = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _colors = require("../Identity/colors");

var _colorsV = require("../Identity/colors-v2");

var _util = require("../util");

var _themes;

var THEME_ID;
exports.THEME_ID = THEME_ID;

(function (THEME_ID) {
  THEME_ID["DARK"] = "THEME_DARK";
  THEME_ID["LIGHT"] = "THEME_LIGHT";
})(THEME_ID || (exports.THEME_ID = THEME_ID = {}));

var themes = (_themes = {}, (0, _defineProperty2["default"])(_themes, THEME_ID.LIGHT, {
  Input: {
    backgroundColor: _colors.COLOR.WHITE,
    backgroundColorDisabled: _colorsV.COLOR_V2.GRAY_20,
    placeholderColor: _colors.COLOR.GRAY_DARKEN_24
  },
  general: {
    backgroundColor: _colors.COLOR.GRAY_LIGHTEN_88,
    color: _colors.COLOR.TEXT
  }
}), (0, _defineProperty2["default"])(_themes, THEME_ID.DARK, {
  Input: {
    backgroundColor: _colors.COLOR.BLACK_LIGHTEN_24,
    backgroundColorDisabled: _colors.COLOR.DISABLED,
    placeholderColor: _colors.COLOR.GRAY_LIGHTEN_88
  },
  general: {
    backgroundColor: _colors.COLOR.BLACK,
    color: _colors.COLOR.WHITE
  }
}), _themes);
exports.themes = themes;

var filterThemeProps = function filterThemeProps(props) {
  return (0, _util.filterProps)(props, ['themeId']);
};

var ThemeProvider = function ThemeProvider(props) {
  return (0, _react.jsx)(_react.ThemeProvider, (0, _extends2["default"])({
    theme: themes[props.themeId]
  }, filterThemeProps(props)));
};

exports.ThemeProvider = ThemeProvider;
//# sourceMappingURL=Theme.js.map