"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderSubMenu = exports.MobileStyledHeaderSubMenu = exports.DesktopStyledHeaderSubMenu = exports.DESKTOP_HEADER_SUB_MENU_CLASSNAME = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../../Identity");

var _motions = require("../../Identity/motions");

var _mediaQueries = require("../../mediaQueries");

var _MenuSubLink = require("./MenuSubLink");

var _MenuLink = require("./MenuLink");

var _excluded = ["caption", "isOpen", "children"];

var desktopStyledHeaderSubMenuStyle = function desktopStyledHeaderSubMenuStyle(theme, props) {
  return (0, _defineProperty2["default"])({
    alignItems: 'left',
    backgroundColor: _Identity.COLOR.tint(theme.general.backgroundColor, 0.16),
    borderRadius: '8px',
    boxShadow: '0 8px 24px 0 rgba(0, 0, 0, 0.16)',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    minWidth: '200px',
    padding: '8px 8px',
    span: {
      '&:hover': {
        backgroundColor: theme.general.backgroundColor,
        borderRadius: '4px'
      },
      alignItems: 'center',
      display: 'flex',
      height: '30px',
      margin: 0,
      paddingLeft: '10px !important',
      paddingRight: '10px !important',
      whiteSpace: 'nowrap'
    }
  }, ".".concat(_MenuLink.MENU_LINK_CLASSNAME, ":nth-of-type(n+2)"), {
    marginTop: '8px'
  });
};

var DESKTOP_HEADER_SUB_MENU_CLASSNAME = 'desktopStyledHeaderSubMenu';
exports.DESKTOP_HEADER_SUB_MENU_CLASSNAME = DESKTOP_HEADER_SUB_MENU_CLASSNAME;

var DesktopStyledHeaderSubMenu = function DesktopStyledHeaderSubMenu(props) {
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    className: DESKTOP_HEADER_SUB_MENU_CLASSNAME,
    css: function css(theme) {
      return desktopStyledHeaderSubMenuStyle(theme, props);
    }
  }, props));
};

exports.DesktopStyledHeaderSubMenu = DesktopStyledHeaderSubMenu;

var mobileStyledHeaderSubMenuStyle = function mobileStyledHeaderSubMenuStyle(props) {
  return {
    '*': {
      fontWeight: 200
    },
    alignItems: 'center',
    borderTop: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72),
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    marginTop: '16px',
    paddingTop: '8px'
  };
};

var MobileStyledHeaderSubMenu = function MobileStyledHeaderSubMenu(props) {
  return (0, _react.jsx)("span", (0, _extends2["default"])({
    css: mobileStyledHeaderSubMenuStyle(props)
  }, props));
};

exports.MobileStyledHeaderSubMenu = MobileStyledHeaderSubMenu;

var HeaderSubMenu = function HeaderSubMenu(_ref2) {
  var caption = _ref2.caption,
      isOpen = _ref2.isOpen,
      children = _ref2.children,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);
  var isDesktop = typeof window !== 'undefined' && window.matchMedia("(".concat(_mediaQueries.QUERY.desktop, ")")).matches;
  return (0, _react.jsx)(_MenuSubLink.MenuSubLink, (0, _extends2["default"])({}, props, {
    style: {
      cursor: 'pointer',
      display: 'inline-block',
      position: 'relative',
      textAlign: 'center'
    }
  }), (0, _react.jsx)("span", null, caption), (0, _react.jsx)(_Identity.Opacity, {
    "in": isOpen && isDesktop,
    timeout: _motions.DURATION.DEFAULT,
    style: {
      display: 'inline-block',
      left: -18,
      marginTop: 10,
      paddingTop: 20,
      position: 'absolute',
      zIndex: 1
    },
    mountOnEnter: false,
    unmountOnExit: false
  }, (0, _react.jsx)(_Identity.YAxisMovement, {
    "in": isOpen && isDesktop,
    startValue: '-30px',
    endValue: '0px',
    style: {
      display: 'inline-block'
    },
    timeout: _motions.DURATION.DEFAULT,
    mountOnEnter: false,
    unmountOnExit: true
  }, (0, _react.jsx)(DesktopStyledHeaderSubMenu, null, children))), (0, _react.jsx)(_Identity.Opacity, {
    "in": isOpen && !isDesktop,
    timeout: _motions.DURATION.DEFAULT,
    mountOnEnter: false,
    unmountOnExit: false,
    style: {
      display: 'block',
      position: 'relative'
    }
  }, (0, _react.jsx)(_Identity.Slide, {
    "in": isOpen && !isDesktop,
    startValue: '-56%',
    endValue: '0',
    timeout: _motions.DURATION.DEFAULT,
    mountOnEnter: false,
    unmountOnExit: true
  }, (0, _react.jsx)(MobileStyledHeaderSubMenu, null, children))));
};

exports.HeaderSubMenu = HeaderSubMenu;
//# sourceMappingURL=HeaderSubMenu.js.map