"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItems = exports.menuItemsStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@emotion/react");

var _mediaQueries = require("../../mediaQueries");

var _util = require("../../util");

/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */

/** @jsx jsx */
var menuItemsStyle = function menuItemsStyle(theme, props) {
  return (0, _defineProperty2["default"])({
    alignSelf: 'center',
    display: 'flex',
    justifySelf: 'end'
  }, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
    backgroundColor: theme.general.backgroundColor,
    bottom: 0,
    left: 0,
    overflowY: 'auto',
    position: 'fixed',
    right: 0,
    top: 0,
    transform: props.open ? 'translateX(0)' : 'translateX(110%)',
    transition: 'transform 0.25s ease',
    zIndex: 1
  });
};

exports.menuItemsStyle = menuItemsStyle;

var filterMenuItemProps = function filterMenuItemProps(props) {
  return (0, _util.filterProps)(props, ['open']);
};

var MenuItems = function MenuItems(props) {
  return (0, _react2.jsx)("div", (0, _extends2["default"])({
    css: function css(theme) {
      return menuItemsStyle(theme, props);
    }
  }, filterMenuItemProps(props)));
};

exports.MenuItems = MenuItems;
//# sourceMappingURL=MenuItems.js.map