"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabBarItem = exports.TabBar = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _objectDestructuringEmpty2 = _interopRequireDefault(require("@babel/runtime/helpers/objectDestructuringEmpty"));

var _react = require("@emotion/react");

var _react2 = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _Text = require("../Text");

var _util = require("../util");

var _excluded = ["children"],
    _excluded2 = ["block", "center", "color", "bold", "active", "fontSize", "textTransform"],
    _excluded3 = ["children"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var tabBarStyle = function tabBarStyle(_ref) {
  (0, _objectDestructuringEmpty2["default"])(_ref);
  return {
    display: 'flex',
    width: '100%'
  };
};

var filteredTabBarProps = function filteredTabBarProps(props) {
  return (0, _util.filterProps)(props, []);
};

var TabBar = function TabBar(_ref2) {
  var _ref2$children = _ref2.children,
      children = _ref2$children === void 0 ? null : _ref2$children,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    css: tabBarStyle(props)
  }, filteredTabBarProps(props)), children);
};

exports.TabBar = TabBar;

var tabBarItemStyle = function tabBarItemStyle(theme, _ref3) {
  var _ref3$block = _ref3.block,
      block = _ref3$block === void 0 ? true : _ref3$block,
      _ref3$center = _ref3.center,
      center = _ref3$center === void 0 ? true : _ref3$center,
      _ref3$color = _ref3.color,
      color = _ref3$color === void 0 ? theme.general.color : _ref3$color,
      _ref3$bold = _ref3.bold,
      bold = _ref3$bold === void 0 ? true : _ref3$bold,
      _ref3$active = _ref3.active,
      active = _ref3$active === void 0 ? false : _ref3$active,
      _ref3$fontSize = _ref3.fontSize,
      fontSize = _ref3$fontSize === void 0 ? '11px' : _ref3$fontSize,
      _ref3$textTransform = _ref3.textTransform,
      textTransform = _ref3$textTransform === void 0 ? 'uppercase' : _ref3$textTransform,
      props = (0, _objectWithoutProperties2["default"])(_ref3, _excluded2);
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    bold: bold,
    center: center,
    color: color,
    fontSize: fontSize,
    textTransform: textTransform
  }, props))), {}, {
    borderBottom: active ? "1px solid ".concat(_Identity.COLOR.GRAY_DARKEN_48) : "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_40),
    cursor: 'pointer',
    display: 'flex',
    flexGrow: 1,
    justifyContent: 'center',
    opacity: active ? 1 : 0.56,
    padding: '8px 0'
  });
};

var TabBarItem = function TabBarItem(_ref4) {
  var _ref4$children = _ref4.children,
      children = _ref4$children === void 0 ? null : _ref4$children,
      props = (0, _objectWithoutProperties2["default"])(_ref4, _excluded3);
  return (0, _react.jsx)("span", (0, _extends2["default"])({
    css: function css(theme) {
      return tabBarItemStyle(theme, props);
    }
  }, props), children);
};

exports.TabBarItem = TabBarItem;
//# sourceMappingURL=TabBar.js.map