"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ButtonGroup = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = require("@emotion/react");

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _Identity = require("../Identity");

var _excluded = ["children", "icon"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var buttonGroupStyle = function buttonGroupStyle() {
  return {
    display: 'flex',
    alignItems: 'center'
  };
};

var buttonStyle = function buttonStyle(theme, _ref) {
  var _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled;
  return _objectSpread({
    height: '32px',
    borderRadius: '12px',
    padding: '0 12px',
    background: _Identity.COLOR_V2.WHITE,
    border: "1px solid ".concat(_Identity.COLOR_V2.GRAY_40),
    cursor: 'pointer',
    display: 'flex',
    alignItems: 'center',
    backgroundColor: disabled ? _Identity.COLOR_V2.GRAY_20 : _Identity.COLOR_V2.WHITE,
    svg: {
      fill: disabled ? _Identity.COLOR_V2.GRAY_70 : _Identity.COLOR_V2.BLACK
    },
    '&:not(:last-child)': {
      borderTopRightRadius: '0',
      borderBottomRightRadius: '0'
    },
    '&:not(:first-child)': {
      borderTopLeftRadius: '0',
      borderBottomLeftRadius: '0'
    },
    '&:first-child:last-child': {
      borderRadius: '0'
    }
  }, !disabled && {
    '&:hover, &:focus': {
      backgroundColor: _Identity.COLOR_V2.GRAY_20
    },
    '&:hover': {
      borderColor: _Identity.COLOR_V2.GRAY_50
    },
    '&:focus': {
      borderColor: _Identity.COLOR_V2.GRAY_60
    },
    '&:active': {
      backgroundColor: _Identity.COLOR_V2.BLUE_LIGHT_50,
      borderColor: _Identity.COLOR_V2.BLUE_LIGHT_300,
      svg: {
        fill: _Identity.COLOR_V2.BLUE
      }
    }
  });
};

var ButtonGroup = function ButtonGroup(_ref2) {
  var children = _ref2.children;
  return (0, _react.jsx)("div", {
    css: function css(theme) {
      return buttonGroupStyle(theme);
    },
    role: "group",
    "aria-label": "Button Group"
  }, children);
};

exports.ButtonGroup = ButtonGroup;

var Button = function Button(_ref3) {
  var children = _ref3.children,
      icon = _ref3.icon,
      props = (0, _objectWithoutProperties2["default"])(_ref3, _excluded);
  return (0, _react.jsx)("button", (0, _extends2["default"])({
    css: function css(theme) {
      return buttonStyle(theme, props);
    }
  }, props), icon, children && (0, _react.jsx)("span", {
    css: /*#__PURE__*/(0, _react.css)({
      marginLeft: !!icon && '6px',
      fontSize: '12px',
      fontWeight: 'bold',
      lineHeight: '14px',
      letterSpacing: '0.25px'
    }, process.env.NODE_ENV === "production" ? "" : ";label:Button;", process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */")
  }, children));
};

ButtonGroup.Button = Button;
//# sourceMappingURL=ButtonGroup.js.map