"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconButton = exports.iconButtonStyle = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _Identity = require("../Identity");

var _motions = require("../Identity/motions");

var _Text = require("../Text");

var _util = require("../util");

var _excluded = ["children"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var IconButtonVariant;

(function (IconButtonVariant) {
  IconButtonVariant["PRIMARY"] = "primary";
  IconButtonVariant["SECONDARY"] = "secondary";
})(IconButtonVariant || (IconButtonVariant = {}));

var iconButtonStyle = function iconButtonStyle(theme, _ref) {
  var _ref$variant = _ref.variant,
      variant = _ref$variant === void 0 ? IconButtonVariant.PRIMARY : _ref$variant,
      backgroundColor = _ref.backgroundColor,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled;
  return _objectSpread(_objectSpread({
    border: 0,
    borderRadius: '12px',
    cursor: disabled ? 'default' : 'pointer',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    marginBottom: '16px',
    padding: 0,
    outline: 'none',
    textDecoration: 'none',
    touchAction: 'manipulation',
    transition: _motions.defaultTransition,
    width: '40px',
    height: '32px',
    '&:hover, &:focus': {
      textDecoration: 'none'
    }
  }, variant === IconButtonVariant.PRIMARY && _objectSpread({
    backgroundColor: disabled ? _Identity.COLOR_V2.GRAY_20 : backgroundColor || _Identity.COLOR_V2.WHITE,
    border: "1px solid ".concat(_Identity.COLOR_V2.GRAY_40),
    svg: {
      fill: disabled ? _Identity.COLOR_V2.GRAY_70 : _Identity.COLOR_V2.BLACK
    }
  }, !disabled && {
    '&:hover, &:focus': {
      backgroundColor: _Identity.COLOR_V2.GRAY_20
    },
    '&:hover': {
      borderColor: _Identity.COLOR_V2.GRAY_50
    },
    '&:focus': {
      borderColor: _Identity.COLOR_V2.GRAY_60
    },
    '&:active': {
      backgroundColor: _Identity.COLOR_V2.BLUE_LIGHT_50,
      borderColor: _Identity.COLOR_V2.BLUE_LIGHT_300,
      svg: {
        fill: _Identity.COLOR_V2.BLUE
      }
    }
  })), variant === IconButtonVariant.SECONDARY && _objectSpread({
    svg: {
      fill: disabled ? _Identity.COLOR_V2.GRAY_60 : _Identity.COLOR_V2.BLACK
    }
  }, !disabled && {
    '&:hover, &:focus, &:active': {
      svg: {
        fill: _Identity.COLOR_V2.BLUE
      }
    },
    '&:focus': {
      border: "1px solid ".concat(_Identity.COLOR_V2.BLUE_LIGHT_300)
    },
    '&:active': {
      backgroundColor: _Identity.COLOR_V2.GRAY_10
    }
  }));
};

exports.iconButtonStyle = iconButtonStyle;

var IconButton = function IconButton(_ref2) {
  var children = _ref2.children,
      props = (0, _objectWithoutProperties2["default"])(_ref2, _excluded);
  return (0, _react.jsx)("button", (0, _extends2["default"])({
    css: function css(theme) {
      return iconButtonStyle(theme, props);
    }
  }, filterButtonProps(props)), children);
};

exports.IconButton = IconButton;

var filterButtonProps = function filterButtonProps(props) {
  return (0, _util.filterProps)((0, _Text.filterTextProps)(props), ['backgroundColor']);
};
//# sourceMappingURL=IconButton.js.map