"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsInViewport = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = require("@emotion/react");

var _react2 = _interopRequireWildcard(require("react"));

var _excluded = ["onEnterViewport", "disabled", "checkViewportOnce"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var IsInViewport = function IsInViewport(_ref) {
  var onEnterViewport = _ref.onEnterViewport,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$checkViewportOnc = _ref.checkViewportOnce,
      checkViewportOnce = _ref$checkViewportOnc === void 0 ? false : _ref$checkViewportOnc,
      props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var element = (0, _react2.useRef)();
  (0, _react2.useEffect)(function () {
    var observer = undefined;

    if (onEnterViewport && !disabled) {
      observer = new IntersectionObserver(function (_ref2) {
        var _ref3 = (0, _slicedToArray2["default"])(_ref2, 1),
            isIntersecting = _ref3[0].isIntersecting;

        if (isIntersecting) {
          if (checkViewportOnce) {
            observer.disconnect();
          }

          if (onEnterViewport && !disabled) {
            onEnterViewport();
          }
        }
      });
      observer.observe(element.current);
    }

    return function () {
      if (observer) {
        observer.disconnect();
      }
    };
  }, [onEnterViewport]);
  return (0, _react.jsx)("div", (0, _extends2["default"])({
    ref: element
  }, props));
};

exports.IsInViewport = IsInViewport;
//# sourceMappingURL=IsInViewport.js.map