"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLongTouch = void 0;

var _react = require("react");

var _useTimeout2 = require("./useTimeout");

/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var useLongTouch = function useLongTouch(element, onLongTouch) {
  var touchDuration = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 800;

  var _useTimeout = (0, _useTimeout2.useTimeout)(onLongTouch, touchDuration),
      startTimeout = _useTimeout.startTimeout,
      removeTimeout = _useTimeout.removeTimeout;

  (0, _react.useEffect)(function () {
    if (!element) {
      return function () {};
    }

    var onTouchStart = function onTouchStart(event) {
      startTimeout();
    };

    var onTouchEnd = function onTouchEnd(event) {
      removeTimeout();
    };

    element.addEventListener('touchstart', onTouchStart, false);
    element.addEventListener('touchend', onTouchEnd, false);
    return function () {
      element.removeEventListener('touchstart', onTouchStart);
      element.removeEventListener('touchend', onTouchEnd);
    };
  }, [onLongTouch, touchDuration]);
};

exports.useLongTouch = useLongTouch;
//# sourceMappingURL=useLongTouch.js.map